/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.common.loader;

import fr.tathan.exoconfig.common.infos.ConfigInfos;
import fr.tathan.exoconfig.common.loader.ConfigLoader;
import fr.tathan.exoconfig.common.post_validation.PostValidationUtils;
import fr.tathan.exoconfig.common.utils.ConfigHolder;
import fr.tathan.exoconfig.common.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public class ConfigsRegistry {
    private static final ConfigsRegistry INSTANCE = new ConfigsRegistry();
    private final Map<String, ConfigHolder<?>> configs = new HashMap();

    public static ConfigsRegistry getInstance() {
        return INSTANCE;
    }

    private ConfigsRegistry() {
    }

    public <T> T registerConfig(T config, T configInstance) {
        ConfigInfos configInfos = Utils.getConfigInfos(config.getClass());
        if (configInfos == null) {
            throw new IllegalArgumentException("Config class must be annotated with @ConfigInfos");
        }
        if (this.configs.containsKey(configInfos.name())) {
            this.configs.replace(configInfos.name(), new ConfigHolder<T>(config, configInfos, configInstance));
        } else {
            this.configs.put(configInfos.name(), new ConfigHolder<T>(config, configInfos, configInstance));
        }
        Object loadedConfig = ConfigLoader.loadOrGenerateDefaults(config);
        PostValidationUtils.postValidate(loadedConfig);
        return loadedConfig;
    }

    public ConfigHolder<?> getConfig(String name) {
        return this.configs.get(name);
    }

    public Map<String, ConfigHolder<?>> getConfigs() {
        return this.configs;
    }
}

