/*
 * Decompiled with CFR 0.152.
 */
package alfheim.api.crafting.recipe;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.RecipePetals;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rBG\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0011J\u001c\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020\u0007H\u0016J\u0013\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "Lvazkii/botania/api/recipe/RecipePetals;", "manaUsage", "", "output", "Lnet/minecraft/item/ItemStack;", "outTileId", "", "core", "inputs", "", "", "<init>", "(ILnet/minecraft/item/ItemStack;Ljava/lang/String;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "mana", "out", "throttle", "(ILnet/minecraft/item/ItemStack;Ljava/lang/String;Lnet/minecraft/item/ItemStack;I[Ljava/lang/Object;)V", "getManaUsage", "()I", "getOutTileId", "()Ljava/lang/String;", "getCore", "()Lnet/minecraft/item/ItemStack;", "getThrottle", "setThrottle", "(I)V", "matches", "", "items", "", "mid", "toString", "equals", "other", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nRecipeTreeCrafting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeTreeCrafting.kt\nalfheim/api/crafting/recipe/RecipeTreeCrafting\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class RecipeTreeCrafting
extends RecipePetals {
    private final int manaUsage;
    @Nullable
    private final String outTileId;
    @NotNull
    private final ItemStack core;
    private int throttle;

    public RecipeTreeCrafting(int manaUsage, @NotNull ItemStack output, @Nullable String outTileId, @NotNull ItemStack core, Object ... inputs) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        super(output, Arrays.copyOf(inputs, inputs.length));
        this.manaUsage = manaUsage;
        this.outTileId = outTileId;
        this.core = core;
        this.throttle = -1;
        if (!(inputs.length <= 8)) {
            boolean $i$a$-require-RecipeTreeCrafting$32 = false;
            String $i$a$-require-RecipeTreeCrafting$32 = "Tree suffusion recipe has " + inputs.length + " inputs, max is 8!";
            throw new IllegalArgumentException($i$a$-require-RecipeTreeCrafting$32.toString());
        }
        if (!(ExtensionsKt.getBlock((ItemStack)output) != Blocks.field_150350_a)) {
            boolean bl = false;
            String string = "Block from output stack '" + output + "' must not be air!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getManaUsage() {
        return this.manaUsage;
    }

    @Nullable
    public final String getOutTileId() {
        return this.outTileId;
    }

    @NotNull
    public final ItemStack getCore() {
        return this.core;
    }

    public final int getThrottle() {
        return this.throttle;
    }

    public final void setThrottle(int n) {
        this.throttle = n;
    }

    public RecipeTreeCrafting(int mana, @NotNull ItemStack out, @Nullable String outTileId, @NotNull ItemStack core, int throttle, Object ... inputs) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        this(mana, out, outTileId, core, Arrays.copyOf(inputs, inputs.length));
        this.throttle = throttle;
    }

    public final boolean matches(@NotNull List<ItemStack> items, @NotNull ItemStack mid) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)mid, (String)"mid");
        if (!ASJUtilities.isItemStackEqualCrafting((ItemStack)this.core, (ItemStack)mid)) {
            return false;
        }
        List inputsMissing = this.getInputs();
        block0: for (ItemStack i2 : items) {
            int n = ((Collection)inputsMissing).size();
            for (int j = 0; j < n; ++j) {
                Object inp = inputsMissing.get(j);
                if (inp instanceof ItemStack && ExtensionsKt.getMeta((ItemStack)((ItemStack)inp)) == Short.MAX_VALUE) {
                    ExtensionsKt.setMeta((ItemStack)((ItemStack)inp), (int)ExtensionsKt.getMeta((ItemStack)i2));
                }
                Intrinsics.checkNotNull(inp);
                if (!ExtensionsKt.itemEquals((ItemStack)i2, inp)) continue;
                inputsMissing.remove(j);
                continue block0;
            }
        }
        return inputsMissing.isEmpty();
    }

    @NotNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Object ing : this.getInputs()) {
            s.append(ing + " + ");
        }
        return "Recipe: (" + s + " + mana*" + this.manaUsage + ") -> " + this.core + " => " + this.getOutput();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RecipeTreeCrafting)) return false;
        if (((RecipeTreeCrafting)((Object)other)).manaUsage != this.manaUsage) return false;
        if (!ItemStack.func_77989_b((ItemStack)this.getOutput(), (ItemStack)((RecipeTreeCrafting)((Object)other)).getOutput())) return false;
        List list = this.getInputs();
        List list2 = ((RecipeTreeCrafting)((Object)other)).getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInputs(...)");
        if (!list.containsAll(list2)) return false;
        List list3 = ((RecipeTreeCrafting)((Object)other)).getInputs();
        List list4 = this.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getInputs(...)");
        if (!list3.containsAll(list4)) return false;
        return true;
    }
}

