/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.mana;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alexsocol.patcher.event.EntityUpdateEvent;
import alfheim.api.lib.LibRenderIDs;
import alfheim.common.block.base.BlockContainerMod;
import alfheim.common.block.tile.TileManaReflector;
import alfheim.common.item.block.ItemBlockManaReflector;
import alfheim.common.lexicon.AlfheimLexiconData;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.entity.EntityManaBurst;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001$B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J>\u0010\u0010\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\rH\u0016\u00a8\u0006%"}, d2={"Lalfheim/common/block/mana/BlockManaReflector;", "Lalfheim/common/block/base/BlockContainerMod;", "Lvazkii/botania/api/mana/IManaTrigger;", "Lvazkii/botania/api/lexicon/ILexiconable;", "<init>", "()V", "onBurstCollision", "", "burst", "Lvazkii/botania/api/internal/IManaBurst;", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "getEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "lexicon", "Lnet/minecraft/item/ItemStack;", "registerBlockIcons", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "getIcon", "Lnet/minecraft/util/IIcon;", "side", "meta", "createNewTileEntity", "Lalfheim/common/block/tile/TileManaReflector;", "shouldRegisterInNameSet", "", "isOpaqueCube", "renderAsNormalBlock", "getRenderType", "Companion", "Alfheim"})
public final class BlockManaReflector
extends BlockContainerMod
implements IManaTrigger,
ILexiconable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG_REFLECTOR = "reflector";
    @NotNull
    private static final Vector3[] normals;

    public BlockManaReflector() {
        Material material = Material.field_151575_d;
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"wood");
        super(material);
        this.func_149663_c("ManaReflector");
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(BlockContainer.field_149766_f);
        GameRegistry.registerBlock((Block)((Block)this), ItemBlockManaReflector.class, (String)"ManaReflector");
    }

    public void onBurstCollision(@NotNull IManaBurst burst, @NotNull World world, int x, int y, int z) {
        Vector3 n;
        Intrinsics.checkNotNullParameter((Object)burst, (String)"burst");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        EntityManaBurst cfr_ignored_0 = (EntityManaBurst)burst;
        if (BlockManaReflector.Companion.isInReflector(burst, x, y, z)) {
            return;
        }
        Vector3 v = new Vector3((Number)((EntityManaBurst)burst).field_70159_w, (Number)((EntityManaBurst)burst).field_70181_x, (Number)((EntityManaBurst)burst).field_70179_y);
        if (!BlockManaReflector.Companion.isRayValid(v, n = BlockManaReflector.normals[world.func_72805_g(x, y, z)].copy())) {
            ((EntityManaBurst)burst).func_70106_y();
            return;
        }
        Vector3 p = Vector3.Companion.fromEntity((Entity)burst);
        Vector3 vector3 = BlockManaReflector.Companion.intersectLineWithPlane(p, v, n.copy().negate(), Vector3.add$default((Vector3)new Vector3((Number)x, (Number)y, (Number)z), (Number)0.5, null, null, (int)6, null));
        if (vector3 == null) {
            return;
        }
        Vector3 i2 = vector3;
        ((EntityManaBurst)burst).func_70107_b(i2.getX(), i2.getY(), i2.getZ());
        ((EntityManaBurst)burst).particles();
        ((EntityManaBurst)burst).field_70169_q = i2.getX();
        ((EntityManaBurst)burst).field_70167_r = i2.getY();
        ((EntityManaBurst)burst).field_70166_s = i2.getZ();
        Vector3 vector32 = BlockManaReflector.Companion.reflect(v, n);
        double rX = vector32.component1();
        double rY = vector32.component2();
        double rZ = vector32.component3();
        ((EntityManaBurst)burst).setMotion(rX, rY, rZ);
        BlockManaReflector.Companion.setInReflector(burst, x, y, z);
    }

    @NotNull
    public LexiconEntry getEntry(@Nullable World world, int x, int y, int z, @Nullable EntityPlayer player, @Nullable ItemStack lexicon) {
        return AlfheimLexiconData.INSTANCE.getManaReflector();
    }

    @Override
    public void func_149651_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
    }

    @NotNull
    public IIcon func_149691_a(int side, int meta) {
        IIcon iIcon = ModBlocks.dreamwood.func_149691_a(0, 0);
        Intrinsics.checkNotNull((Object)iIcon);
        return iIcon;
    }

    @NotNull
    public TileManaReflector createNewTileEntity(@Nullable World world, int meta) {
        return new TileManaReflector();
    }

    @Override
    public boolean shouldRegisterInNameSet() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return LibRenderIDs.INSTANCE.getIdManaReflector();
    }

    static {
        Vector3[] vector3Array = new Vector3[]{new Vector3((Number)0, (Number)1, (Number)1).normalize().negate(), new Vector3((Number)-1, (Number)1, (Number)0).normalize().negate(), new Vector3((Number)0, (Number)1, (Number)-1).normalize().negate(), new Vector3((Number)1, (Number)1, (Number)0).normalize().negate(), new Vector3((Number)0, (Number)-1, (Number)1).normalize().negate(), new Vector3((Number)-1, (Number)-1, (Number)0).normalize().negate(), new Vector3((Number)0, (Number)-1, (Number)-1).normalize().negate(), new Vector3((Number)1, (Number)-1, (Number)0).normalize().negate(), new Vector3((Number)-1, (Number)0, (Number)1).normalize().negate(), new Vector3((Number)-1, (Number)0, (Number)-1).normalize().negate(), new Vector3((Number)1, (Number)0, (Number)-1).normalize().negate(), new Vector3((Number)1, (Number)0, (Number)1).normalize().negate()};
        normals = vector3Array;
        ExtensionsKt.eventForge((Object)Companion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0082\u0004J\u0015\u0010\u0017\u001a\u00020\b*\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0082\u0002J\u0015\u0010\u0018\u001a\u00020\b*\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0082\u0002J\u0015\u0010\u0019\u001a\u00020\b*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0082\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J$\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002J$\u0010$\u001a\u00020\u001c*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lalfheim/common/block/mana/BlockManaReflector$Companion;", "", "<init>", "()V", "TAG_REFLECTOR", "", "normals", "", "Lalexsocol/asjlib/math/Vector3;", "getNormals", "()[Lalexsocol/asjlib/math/Vector3;", "[Lalexsocol/asjlib/math/Vector3;", "intersectLineWithPlane", "p", "v", "n", "a", "reflect", "incident", "normal", "dot", "", "other", "plus", "minus", "times", "scalar", "isRayValid", "", "setInReflector", "", "Lvazkii/botania/api/internal/IManaBurst;", "x", "", "y", "z", "isInReflector", "clearMirrorData", "e", "Lalexsocol/patcher/event/EntityUpdateEvent;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3[] getNormals() {
            return normals;
        }

        private final Vector3 intersectLineWithPlane(Vector3 p, Vector3 v, Vector3 n, Vector3 a) {
            double denominator = this.dot(n, v);
            if (denominator == 0.0) {
                return null;
            }
            double numerator = this.dot(n, this.minus(a, p));
            double t = numerator / denominator;
            return this.plus(p, this.times(v, t));
        }

        private final Vector3 reflect(Vector3 incident, Vector3 normal) {
            double dotProduct = this.dot(incident, normal);
            return this.minus(incident, this.times(normal, (double)2 * dotProduct));
        }

        private final double dot(Vector3 $this$dot, Vector3 other) {
            return $this$dot.getX() * other.getX() + $this$dot.getY() * other.getY() + $this$dot.getZ() * other.getZ();
        }

        private final Vector3 plus(Vector3 $this$plus, Vector3 other) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
            return new Vector3((Number)($this$plus.getX() + other.getX()), (Number)($this$plus.getY() + other.getY()), (Number)($this$plus.getZ() + other.getZ()));
        }

        private final Vector3 minus(Vector3 $this$minus, Vector3 other) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
            return new Vector3((Number)($this$minus.getX() - other.getX()), (Number)($this$minus.getY() - other.getY()), (Number)($this$minus.getZ() - other.getZ()));
        }

        private final Vector3 times(Vector3 $this$times, double scalar) {
            Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
            return new Vector3((Number)($this$times.getX() * scalar), (Number)($this$times.getY() * scalar), (Number)($this$times.getZ() * scalar));
        }

        private final boolean isRayValid(Vector3 incident, Vector3 normal) {
            return this.dot(incident, normal) > 0.0;
        }

        private final void setInReflector(IManaBurst $this$setInReflector, int x, int y, int z) {
            Intrinsics.checkNotNull((Object)$this$setInReflector, (String)"null cannot be cast to non-null type net.minecraft.entity.projectile.EntityThrowable");
            EntityThrowable cfr_ignored_0 = (EntityThrowable)$this$setInReflector;
            NBTTagCompound nBTTagCompound = ((Entity)$this$setInReflector).getEntityData();
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"getEntityData(...)");
            ExtensionsKt.setChunkCoords((NBTTagCompound)nBTTagCompound, (String)BlockManaReflector.TAG_REFLECTOR, (ChunkCoordinates)new ChunkCoordinates(x, y, z));
        }

        private final boolean isInReflector(IManaBurst $this$isInReflector, int x, int y, int z) {
            Intrinsics.checkNotNull((Object)$this$isInReflector, (String)"null cannot be cast to non-null type net.minecraft.entity.projectile.EntityThrowable");
            EntityThrowable cfr_ignored_0 = (EntityThrowable)$this$isInReflector;
            NBTTagCompound nBTTagCompound = ((Entity)$this$isInReflector).getEntityData();
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"getEntityData(...)");
            ChunkCoordinates mirror = ExtensionsKt.getChunkCoords((NBTTagCompound)nBTTagCompound, (String)BlockManaReflector.TAG_REFLECTOR);
            return Intrinsics.areEqual((Object)mirror, (Object)new ChunkCoordinates(x, y, z));
        }

        @SubscribeEvent
        public final void clearMirrorData(@NotNull EntityUpdateEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Entity entity = e.getEntity();
            IManaBurst iManaBurst = entity instanceof IManaBurst ? (IManaBurst)entity : null;
            if (iManaBurst == null) {
                return;
            }
            IManaBurst burst = iManaBurst;
            if (!(burst instanceof EntityThrowable)) {
                return;
            }
            if (!((Entity)burst).getEntityData().func_74764_b(BlockManaReflector.TAG_REFLECTOR)) {
                return;
            }
            Integer[] integerArray = Vector3.Companion.fromEntity((Entity)burst).mf();
            int x = ((Number)integerArray[0]).intValue();
            int y = ((Number)integerArray[1]).intValue();
            int z = ((Number)integerArray[2]).intValue();
            ChunkCoordinates pos = new ChunkCoordinates(x, y, z);
            NBTTagCompound nBTTagCompound = ((Entity)burst).getEntityData();
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"getEntityData(...)");
            ChunkCoordinates mirror = ExtensionsKt.getChunkCoords((NBTTagCompound)nBTTagCompound, (String)BlockManaReflector.TAG_REFLECTOR);
            if (!Intrinsics.areEqual((Object)pos, (Object)mirror)) {
                ((Entity)burst).getEntityData().func_82580_o(BlockManaReflector.TAG_REFLECTOR);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

