/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.ASJTile;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.core.asm.hook.extender.SparkExtender;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.Botania;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020+J\b\u00107\u001a\u000208H\u0016J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u000208J\u0010\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u0002082\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010B\u001a\u00020\fH\u0016J\b\u0010C\u001a\u00020\u0006H\u0016J\u0010\u0010D\u001a\u0002082\u0006\u0010E\u001a\u00020\fH\u0016J\b\u0010F\u001a\u00020\u0006H\u0016J\u0012\u0010G\u001a\u00020\u00062\b\u0010H\u001a\u0004\u0018\u00010IH\u0016J\u0012\u0010J\u001a\u0002082\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\n\u0010M\u001a\u0004\u0018\u00010LH\u0016J\b\u0010N\u001a\u00020\fH\u0016J\b\u0010O\u001a\u00020\u0006H\u0016J\u000e\u0010P\u001a\u0002082\u0006\u0010Q\u001a\u00020RR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R\u001a\u0010 \u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R*\u0010)\u001a\u0012\u0012\u0004\u0012\u00020+0*j\b\u0012\u0004\u0012\u00020+`,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020+04\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010@\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000e\u00a8\u0006S"}, d2={"Lalfheim/common/block/tile/TileAnomalyHarvester;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "Lvazkii/botania/api/mana/spark/ISparkAttachable;", "<init>", "()V", "creative", "", "getCreative", "()Z", "setCreative", "(Z)V", "animationTicks", "", "getAnimationTicks", "()I", "setAnimationTicks", "(I)V", "prevAnimationTicks", "getPrevAnimationTicks", "setPrevAnimationTicks", "mana", "getMana", "setMana", "offset", "Lalexsocol/asjlib/math/Vector3;", "getOffset", "()Lalexsocol/asjlib/math/Vector3;", "setOffset", "(Lalexsocol/asjlib/math/Vector3;)V", "power", "getPower", "setPower", "radius", "getRadius", "setRadius", "tick", "", "getTick", "()J", "setTick", "(J)V", "subTiles", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getSubTiles", "()Ljava/util/HashSet;", "setSubTiles", "(Ljava/util/HashSet;)V", "addSubTile", "sub", "tunnels", "", "getTunnels", "()Ljava/util/Set;", "updateEntity", "", "getAoE", "Lnet/minecraft/util/AxisAlignedBB;", "renderBoundBox", "writeCustomNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readCustomNBT", "maxMana", "getMaxMana", "getCurrentMana", "isFull", "recieveMana", "add", "canRecieveManaFromBursts", "canAttachSpark", "stack", "Lnet/minecraft/item/ItemStack;", "attachSpark", "entity", "Lvazkii/botania/api/mana/spark/ISparkEntity;", "getAttachedSpark", "getAvailableSpaceForMana", "areIncomingTranfersDone", "renderHUD", "res", "Lnet/minecraft/client/gui/ScaledResolution;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nTileAnomalyHarvester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileAnomalyHarvester.kt\nalfheim/common/block/tile/TileAnomalyHarvester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,497:1\n1878#2,3:498\n*S KotlinDebug\n*F\n+ 1 TileAnomalyHarvester.kt\nalfheim/common/block/tile/TileAnomalyHarvester\n*L\n209#1:498,3\n*E\n"})
public final class TileAnomalyHarvester
extends ASJTile
implements ISparkAttachable {
    private boolean creative;
    private int animationTicks;
    private int prevAnimationTicks;
    private int mana;
    @NotNull
    private Vector3 offset = new Vector3(null, null, null, 7, null);
    private int power = 1;
    @NotNull
    private Vector3 radius = new Vector3((Number)1.0, null, null, 6, null);
    private long tick = -1L;
    @NotNull
    private HashSet<String> subTiles = new HashSet();
    @NotNull
    private final Set<String> tunnels;

    public TileAnomalyHarvester() {
        Object[] objectArray = new String[]{"Antigrav", "Gravity"};
        this.tunnels = SetsKt.setOf((Object[])objectArray);
    }

    public final boolean getCreative() {
        return this.creative;
    }

    public final void setCreative(boolean bl) {
        this.creative = bl;
    }

    public final int getAnimationTicks() {
        return this.animationTicks;
    }

    public final void setAnimationTicks(int n) {
        this.animationTicks = n;
    }

    public final int getPrevAnimationTicks() {
        return this.prevAnimationTicks;
    }

    public final void setPrevAnimationTicks(int n) {
        this.prevAnimationTicks = n;
    }

    public final int getMana() {
        return this.mana;
    }

    public final void setMana(int n) {
        this.mana = n;
    }

    @NotNull
    public final Vector3 getOffset() {
        return this.offset;
    }

    public final void setOffset(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.offset = vector3;
    }

    public final int getPower() {
        return this.power;
    }

    public final void setPower(int n) {
        this.power = n;
    }

    @NotNull
    public final Vector3 getRadius() {
        return this.radius;
    }

    public final void setRadius(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.radius = vector3;
    }

    public final long getTick() {
        return this.tick;
    }

    public final void setTick(long l) {
        this.tick = l;
    }

    @NotNull
    public final HashSet<String> getSubTiles() {
        return this.subTiles;
    }

    public final void setSubTiles(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.subTiles = hashSet;
    }

    public final boolean addSubTile(@NotNull String sub) {
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        return this.subTiles.add(sub);
    }

    @NotNull
    public final Set<String> getTunnels() {
        return this.tunnels;
    }

    public void func_145845_h() {
        if (this.field_145850_b.func_82737_E() == this.tick) {
            return;
        }
        this.tick = this.field_145850_b.func_82737_E();
        this.prevAnimationTicks = this.animationTicks;
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        if (ExtensionsKt.isBlockDirectlyGettingPowered((World)world, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e) || this.power <= 0) {
            return;
        }
        if (this.creative) {
            this.mana = this.getMaxMana();
        } else {
            ISparkEntity spark = this.getAttachedSpark();
            if (spark != null) {
                List sparkEntities = SparkHelper.getSparksAround((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
                for (ISparkEntity otherSpark : sparkEntities) {
                    if (spark == otherSpark || otherSpark.getAttachedTile() == null || !(otherSpark.getAttachedTile() instanceof IManaPool)) continue;
                    otherSpark.registerTransfer(spark);
                }
            }
        }
        boolean did = false;
        if (this.subTiles.contains("ManaTornado")) {
            this.recieveMana(this.field_145850_b.field_73012_v.nextInt(5) == 0 ? 2 : 1);
            did = true;
        }
        if (this.mana > 0 || this.creative) {
            AxisAlignedBB aoe = this.getAoE();
            int volume = ExtensionsKt.getI((Number)Math.ceil((aoe.field_72336_d - aoe.field_72340_a) * (aoe.field_72337_e - aoe.field_72338_b) * (aoe.field_72334_f - aoe.field_72339_c)));
            boolean tunnel = this.subTiles.containsAll((Collection)this.tunnels);
            if (tunnel) {
                AlfheimAPI.AnomalyBehavior anomalyBehavior = AlfheimAPI.INSTANCE.getAnomalyBehaviors().get("Tunnel");
                Intrinsics.checkNotNull((Object)anomalyBehavior);
                AlfheimAPI.AnomalyBehavior effect = anomalyBehavior;
                int cost = 0;
                cost += ((Number)effect.getEffect().invoke((Object)this)).intValue() * effect.getCostPerApplication();
                cost += effect.getCostPerBlock() * volume;
                if (!this.creative) {
                    this.mana -= cost;
                }
                did = true;
            }
            Iterator<String> iterator = this.subTiles.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                AlfheimAPI.AnomalyBehavior effect;
                String st = iterator2.next();
                if (this.mana <= 0 && !this.creative) {
                    return;
                }
                if (tunnel && this.tunnels.contains(st) || AlfheimAPI.INSTANCE.getAnomalyBehaviors().get(st) == null) continue;
                int cost = 0;
                cost += ((Number)effect.getEffect().invoke((Object)this)).intValue() * effect.getCostPerApplication();
                cost += effect.getCostPerBlock() * volume;
                if (!this.creative) {
                    this.mana -= cost;
                }
                did = true;
            }
        }
        if (this.subTiles.contains("ManaVoid") || did) {
            this.animationTicks += this.power;
        }
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.renderBoundBox();
        }
    }

    @NotNull
    public final AxisAlignedBB getAoE() {
        AxisAlignedBB axisAlignedBB = ExtensionsKt.getBoundingBox((Number)this.field_145851_c, (Number)this.field_145848_d, (Number)this.field_145849_e).func_72314_b(this.radius.getX() / (double)2, this.radius.getY() / (double)2, this.radius.getZ() / (double)2).func_72325_c(this.offset.getX() + 0.5, this.offset.getY() + 0.5, this.offset.getZ() + 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"getOffsetBoundingBox(...)");
        return axisAlignedBB;
    }

    public final void renderBoundBox() {
        double i2 = 0.0;
        AxisAlignedBB aabb = this.getAoE();
        for (i2 = aabb.field_72340_a; i2 <= aabb.field_72336_d; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i2, aabb.field_72338_b, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72340_a; i2 <= aabb.field_72336_d; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i2, aabb.field_72337_e, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72340_a; i2 <= aabb.field_72336_d; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i2, aabb.field_72337_e, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72340_a; i2 <= aabb.field_72336_d; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i2, aabb.field_72338_b, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72338_b; i2 <= aabb.field_72337_e; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, i2, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72338_b; i2 <= aabb.field_72337_e; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, i2, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72338_b; i2 <= aabb.field_72337_e; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, i2, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72338_b; i2 <= aabb.field_72337_e; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, i2, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72339_c; i2 <= aabb.field_72334_f; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, aabb.field_72338_b, i2, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72339_c; i2 <= aabb.field_72334_f; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, aabb.field_72337_e, i2, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72339_c; i2 <= aabb.field_72334_f; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, aabb.field_72338_b, i2, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i2 = aabb.field_72339_c; i2 <= aabb.field_72334_f; i2 += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, aabb.field_72337_e, i2, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a("subtiles", this.subTiles.size());
        Iterable $this$forEachIndexed$iv = this.subTiles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i2 = n;
            boolean bl = false;
            nbt.func_74778_a("subtile" + i2, (String)s);
        }
        nbt.func_74780_a("rX", this.radius.getX());
        nbt.func_74780_a("rY", this.radius.getY());
        nbt.func_74780_a("rZ", this.radius.getZ());
        nbt.func_74780_a("oX", this.offset.getX());
        nbt.func_74780_a("oY", this.offset.getY());
        nbt.func_74780_a("oZ", this.offset.getZ());
        nbt.func_74768_a("mana", this.mana);
        nbt.func_74768_a("power", this.power);
        nbt.func_74757_a("creative", this.creative);
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        int size = nbt.func_74762_e("subtiles");
        this.subTiles.clear();
        for (int i2 = 0; i2 < size; ++i2) {
            this.subTiles.add(nbt.func_74779_i("subtile" + i2));
        }
        this.radius.set((Number)nbt.func_74769_h("rX"), (Number)nbt.func_74769_h("rY"), (Number)nbt.func_74769_h("rZ"));
        this.offset.set((Number)nbt.func_74769_h("oX"), (Number)nbt.func_74769_h("oY"), (Number)nbt.func_74769_h("oZ"));
        this.mana = nbt.func_74762_e("mana");
        this.power = nbt.func_74762_e("power");
        this.creative = nbt.func_74767_n("creative");
    }

    public final int getMaxMana() {
        return this.subTiles.contains("ManaVoid") ? 1000000 : 10000;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.getCurrentMana() >= this.getMaxMana();
    }

    public void recieveMana(int add) {
        this.mana = Math.max(0, Math.min(this.mana + add, this.getMaxMana()));
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public boolean canAttachSpark(@Nullable ItemStack stack) {
        return true;
    }

    public void attachSpark(@Nullable ISparkEntity entity) {
        SparkExtender.INSTANCE.attachTile(entity, this);
    }

    @Nullable
    public ISparkEntity getAttachedSpark() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        return (ISparkEntity)CollectionsKt.firstOrNull((List)ExtensionsKt.getEntitiesWithinAABB((World)world, ISparkEntity.class, (AxisAlignedBB)ExtensionsKt.offset((AxisAlignedBB)ExtensionsKt.boundingBox$default((TileEntity)((TileEntity)this), null, (int)1, null), (Number)0, (Number)1, (Number)0)));
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.getMaxMana() - this.mana);
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public final void renderHUD(@NotNull ScaledResolution res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        String name = new ItemStack(AlfheimBlocks.INSTANCE.getAnomalyHarvester()).func_82833_r();
        int color = new Color(16750080).getRGB();
        HUDHandler.drawSimpleManaHUD((int)color, (int)this.mana, (int)this.getMaxMana(), (String)name, (ScaledResolution)res);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

