/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.TileItemContainer;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.core.handler.AlfheimConfigHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.Botania;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u001a\u0010&\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00062\b\u0010'\u001a\u0004\u0018\u00010!H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010-\u001a\u00020\u000fH\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\u0018\u0010/\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010'\u001a\u00020!H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0006H\u0016J \u00103\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010'\u001a\u00020!2\u0006\u00102\u001a\u00020\u0006H\u0016J \u00104\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010'\u001a\u00020!2\u0006\u00102\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u00066"}, d2={"Lalfheim/common/block/tile/TileAnyavil;", "Lalexsocol/asjlib/extendables/block/TileItemContainer;", "Lnet/minecraft/inventory/ISidedInventory;", "<init>", "()V", "pinkCharge", "", "getPinkCharge", "()I", "setPinkCharge", "(I)V", "knownMana", "getKnownMana", "setKnownMana", "onBurstCollision", "", "burst", "Lvazkii/botania/api/internal/IManaBurst;", "world", "Lnet/minecraft/world/World;", "onWanded", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "renderHUD", "res", "Lnet/minecraft/client/gui/ScaledResolution;", "writeCustomNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readCustomNBT", "getSizeInventory", "getStackInSlot", "Lnet/minecraft/item/ItemStack;", "slot", "decrStackSize", "amount", "getStackInSlotOnClosing", "setInventorySlotContents", "stack", "getInventoryName", "", "hasCustomInventoryName", "getInventoryStackLimit", "isUseableByPlayer", "openInventory", "closeInventory", "isItemValidForSlot", "getAccessibleSlotsFromSide", "", "side", "canInsertItem", "canExtractItem", "Companion", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nTileAnyavil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileAnyavil.kt\nalfheim/common/block/tile/TileAnyavil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1869#2,2:192\n*S KotlinDebug\n*F\n+ 1 TileAnyavil.kt\nalfheim/common/block/tile/TileAnyavil\n*L\n38#1:192,2\n*E\n"})
public final class TileAnyavil
extends TileItemContainer
implements ISidedInventory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pinkCharge;
    private int knownMana = -1;
    public static final int MAX_PINK_CHARGE = 10000;
    @NotNull
    public static final String TAG_MANA = "mana";
    @NotNull
    public static final String TAG_MANA_CAP = "manaCap";
    @NotNull
    public static final String TAG_METADATA = "metadata";
    @NotNull
    public static final String TAG_KNOWN_MANA = "knownMana";

    public final int getPinkCharge() {
        return this.pinkCharge;
    }

    public final void setPinkCharge(int n) {
        this.pinkCharge = n;
    }

    public final int getKnownMana() {
        return this.knownMana;
    }

    public final void setKnownMana(int n) {
        this.knownMana = n;
    }

    public final void onBurstCollision(@NotNull IManaBurst burst, @NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)burst, (String)"burst");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        ItemStack item = this.getItem();
        if (burst.isFake()) {
            return;
        }
        if (item == null || !item.func_77973_b().isRepairable()) {
            return;
        }
        GameRegistry.UniqueIdentifier uniqueIdentifier = GameRegistry.findUniqueIdentifierFor((Item)item.func_77973_b());
        if (ArraysKt.contains((Object[])AlfheimConfigHandler.INSTANCE.getRepairBlackList(), (Object)(uniqueIdentifier != null ? uniqueIdentifier.toString() : null))) {
            return;
        }
        if (burst.getColor() != -884570) {
            return;
        }
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityItem.class, (AxisAlignedBB)ExtensionsKt.boundingBox((TileEntity)((TileEntity)this), (Number)3));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityItem it = (EntityItem)element$iv;
            boolean bl = false;
            if (it.field_70128_L) continue;
            ItemStack stack = it.func_92059_d();
            Intrinsics.checkNotNull((Object)stack);
            int pinkness = AlfheimAPI.INSTANCE.getPinkness(stack);
            if (pinkness <= 0) continue;
            this.pinkCharge += pinkness * stack.field_77994_a;
            it.func_70106_y();
        }
        int extraPink = Math.max(0, this.pinkCharge - 10000);
        float[] col = EntitySheep.field_70898_d[6];
        if (extraPink > 0) {
            this.pinkCharge = 10000;
            Vector3 m = new Vector3(null, null, null, 7, null);
            for (extraPink = Math.min(extraPink, 4000); extraPink > 0; --extraPink) {
                Vector3.mul$default((Vector3)m.set((Number)(Math.random() - 0.5), (Number)(Math.random() - 0.5), (Number)(Math.random() - 0.5)).normalize(), (Number)0.1, null, null, (int)6, null);
                Botania.proxy.wispFX(world, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, col[0], col[1], col[2], 0.25f, ExtensionsKt.getF((Number)m.getX()), ExtensionsKt.getF((Number)m.getY()), ExtensionsKt.getF((Number)m.getZ()));
            }
        }
        int needed = ExtensionsKt.getMeta((ItemStack)item);
        int transfer = Math.max(0, Math.min(needed, this.pinkCharge));
        this.pinkCharge -= transfer;
        ExtensionsKt.setMeta((ItemStack)item, (int)(ExtensionsKt.getMeta((ItemStack)item) - transfer));
        for (int i2 = 0; i2 < 24; ++i2) {
            Botania.proxy.wispFX(world, ExtensionsKt.getD((Number)this.field_145851_c) + 0.5 + ExtensionsKt.getD((Number)Float.valueOf(this.field_145850_b.field_73012_v.nextFloat() / 5.0f - 0.1f)), (double)this.field_145848_d + 1.5, ExtensionsKt.getD((Number)this.field_145849_e) + 0.5 + ExtensionsKt.getD((Number)Float.valueOf(this.field_145850_b.field_73012_v.nextFloat() / 5.0f - 0.1f)), col[0], col[1], col[2], 0.25f, 0.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f - 0.1f, 0.0f);
        }
    }

    public final boolean onWanded(@Nullable EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writeCustomNBT(nbttagcompound);
            nbttagcompound.func_74768_a(TAG_KNOWN_MANA, this.pinkCharge);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound));
            }
        }
        ExtensionsKt.playSoundAtEntity((Entity)((Entity)player), (String)"botania:ding", (float)0.11f, (float)1.0f);
        return true;
    }

    public final void renderHUD(@NotNull ScaledResolution res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        String name = new ItemStack(AlfheimBlocks.INSTANCE.getAnyavil()).func_82833_r();
        float[] col = EntitySheep.field_70898_d[6];
        int color = new Color(col[0], col[1], col[2]).getRGB();
        HUDHandler.drawSimpleManaHUD((int)color, (int)this.knownMana, (int)10000, (String)name, (ScaledResolution)res);
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.writeCustomNBT(nbt);
        nbt.func_74768_a(TAG_MANA, this.pinkCharge);
        nbt.func_74768_a(TAG_MANA_CAP, 10000);
        nbt.func_74768_a(TAG_METADATA, this.field_145847_g);
        nbt.func_74768_a(TAG_KNOWN_MANA, this.knownMana);
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readCustomNBT(nbt);
        this.pinkCharge = nbt.func_74762_e(TAG_MANA);
        this.field_145847_g = nbt.func_74762_e(TAG_METADATA);
        if (nbt.func_74764_b(TAG_KNOWN_MANA)) {
            this.knownMana = nbt.func_74762_e(TAG_KNOWN_MANA);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    @Nullable
    public ItemStack func_70301_a(int slot) {
        return this.getItem();
    }

    @Nullable
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.func_70301_a(slot) != null) {
            ItemStack itemStack;
            ItemStack itemstack = null;
            ItemStack itemStack2 = this.func_70301_a(slot);
            Intrinsics.checkNotNull((Object)itemStack2);
            if (itemStack2.field_77994_a <= amount) {
                itemstack = this.func_70301_a(slot);
                this.func_70299_a(slot, null);
                itemStack = itemstack;
            } else {
                ItemStack itemStack3 = this.func_70301_a(slot);
                Intrinsics.checkNotNull((Object)itemStack3);
                itemstack = itemStack3.func_77979_a(amount);
                ItemStack itemStack4 = this.func_70301_a(slot);
                Intrinsics.checkNotNull((Object)itemStack4);
                if (itemStack4.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
                itemStack = itemstack;
            }
            return itemStack;
        }
        return null;
    }

    @Nullable
    public ItemStack func_70304_b(int slot) {
        if (this.func_70301_a(slot) != null) {
            ItemStack itemstack = this.func_70301_a(slot);
            this.func_70299_a(slot, null);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, @Nullable ItemStack stack) {
        this.setItem(stack);
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @NotNull
    public String func_145825_b() {
        return "container.anyavil";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        GameRegistry.UniqueIdentifier uniqueIdentifier = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        if (ArraysKt.contains((Object[])AlfheimConfigHandler.INSTANCE.getRepairBlackList(), (Object)(uniqueIdentifier != null ? uniqueIdentifier.toString() : null))) {
            return false;
        }
        return stack.field_77994_a == 1 && stack.func_77973_b().isRepairable();
    }

    @NotNull
    public int[] func_94128_d(int side) {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public boolean func_102007_a(int slot, @NotNull ItemStack stack, int side) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return side == 1 && this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, @NotNull ItemStack stack, int side) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return side == 0 && slot == 0 && !stack.func_77951_h();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lalfheim/common/block/tile/TileAnyavil$Companion;", "", "<init>", "()V", "MAX_PINK_CHARGE", "", "TAG_MANA", "", "TAG_MANA_CAP", "TAG_METADATA", "TAG_KNOWN_MANA", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

