/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.ASJTile;
import alexsocol.asjlib.math.Vector3;
import java.awt.Color;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.Botania;
import vazkii.botania.common.integration.coloredlights.ColoredLightHelper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010&\u001a\u00020\u0016J\b\u0010'\u001a\u00020\"H\u0016J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010)\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001cJ\u0016\u0010+\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u001cJ.\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00064"}, d2={"Lalfheim/common/block/tile/TileCracklingStar;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "<init>", "()V", "value", "Lalexsocol/asjlib/math/Vector3;", "posAbsolute", "getPosAbsolute", "()Lalexsocol/asjlib/math/Vector3;", "setPosAbsolute", "(Lalexsocol/asjlib/math/Vector3;)V", "posRelative", "getPosRelative", "setPosRelative", "rand", "Ljava/util/Random;", "getRand", "()Ljava/util/Random;", "TAG_COLOR", "", "TAG_SIZE", "color", "", "getColor", "()I", "setColor", "(I)V", "size", "", "getSize", "()F", "setSize", "(F)V", "writeCustomNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readCustomNBT", "getLightColor", "updateEntity", "colorFromInt", "colorFromIntAndPos", "pos", "rainbow", "saturation", "wispLine", "start", "line", "stepsPerBlock", "", "time", "Companion", "Alfheim"})
public final class TileCracklingStar
extends ASJTile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vector3 posAbsolute = vecUnbound.copy();
    @NotNull
    private Vector3 posRelative = new Vector3(null, null, null, 7, null);
    @NotNull
    private final Random rand = new Random();
    @NotNull
    private final String TAG_COLOR;
    @NotNull
    private final String TAG_SIZE;
    private int color = -1;
    private float size = 0.05f;
    @NotNull
    private static final Vector3 vecUnbound = new Vector3((Number)0, (Number)1, (Number)0);

    public TileCracklingStar() {
        this.TAG_COLOR = "color";
        this.TAG_SIZE = "size";
    }

    @NotNull
    public final Vector3 getPosAbsolute() {
        return this.posAbsolute;
    }

    public final void setPosAbsolute(@NotNull Vector3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.posAbsolute = value;
        this.posRelative = value.copy().sub((Number)this.field_145851_c, (Number)this.field_145848_d, (Number)this.field_145849_e);
    }

    @NotNull
    public final Vector3 getPosRelative() {
        return this.posRelative;
    }

    public final void setPosRelative(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.posRelative = vector3;
    }

    @NotNull
    public final Random getRand() {
        return this.rand;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final float getSize() {
        return this.size;
    }

    public final void setSize(float f) {
        this.size = f;
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a(this.TAG_COLOR, this.color);
        nbt.func_74776_a(this.TAG_SIZE, this.size);
        nbt.func_74780_a("relX", this.posRelative.getX());
        nbt.func_74780_a("relY", this.posRelative.getY());
        nbt.func_74780_a("relZ", this.posRelative.getZ());
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.color = nbt.func_74762_e(this.TAG_COLOR);
        this.size = nbt.func_74760_g(this.TAG_SIZE);
        this.posRelative = new Vector3((Number)nbt.func_74769_h("relX"), (Number)nbt.func_74769_h("relY"), (Number)nbt.func_74769_h("relZ"));
        this.setPosAbsolute(this.posRelative.copy().add((Number)this.field_145851_c, (Number)this.field_145848_d, (Number)this.field_145849_e));
    }

    public final int getLightColor() {
        float[] fArray = new Color(this.color).getRGBColorComponents(null);
        Intrinsics.checkNotNull((Object)fArray);
        float r = fArray[0];
        float g = fArray[1];
        float b = fArray[2];
        return ColoredLightHelper.makeRGBLightValue((float)r, (float)g, (float)b, (float)1.0f);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            Vector3 cur = Vector3.Companion.fromTileEntity((TileEntity)this);
            if (!Intrinsics.areEqual((Object)this.posAbsolute, (Object)vecUnbound) && !Intrinsics.areEqual((Object)this.posAbsolute, (Object)cur)) {
                Vector3 vec = this.posAbsolute.copy().sub(Vector3.Companion.fromTileEntity((TileEntity)this));
                this.wispLine(Vector3.Companion.fromTileEntity((TileEntity)this).add((Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05)), vec, this.colorFromInt(this.color), Math.random() * 6.0, 10);
                this.wispLine(this.posAbsolute.copy().add((Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05)), vec.negate(), this.colorFromInt(this.color), Math.random() * 6.0, 10);
            } else {
                Color c = new Color(this.colorFromIntAndPos(this.color, cur));
                Botania.proxy.wispFX(this.field_145850_b, cur.getX() + 0.5, cur.getY() + 0.5, cur.getZ() + 0.5, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 0.25f);
            }
        } else {
            TileCracklingStar other;
            TileEntity tileEntity = this.field_145850_b.func_147438_o(ExtensionsKt.mfloor((double)this.posAbsolute.getX()), ExtensionsKt.mfloor((double)this.posAbsolute.getY()), ExtensionsKt.mfloor((double)this.posAbsolute.getZ()));
            TileCracklingStar tileCracklingStar = other = tileEntity instanceof TileCracklingStar ? (TileCracklingStar)tileEntity : null;
            if (other == null) {
                this.setPosAbsolute(vecUnbound.copy());
                ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)this);
            }
        }
    }

    public final int colorFromInt(int color) {
        return color == -1 ? this.rainbow(1.0f) : color;
    }

    public final int colorFromIntAndPos(int color, @NotNull Vector3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return color == -1 ? this.rainbow(pos, 1.0f) : color;
    }

    public final int rainbow(float saturation) {
        return Color.HSBtoRGB(ExtensionsKt.getF((Number)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L)) / 360.0f, saturation, 1.0f);
    }

    public final int rainbow(@NotNull Vector3 pos, float saturation) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        float ticks = ExtensionsKt.getF((Number)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L)) / 360.0f;
        float seed = (float)((ExtensionsKt.mfloor((double)pos.getX()) ^ ExtensionsKt.mfloor((double)pos.getY()) ^ ExtensionsKt.mfloor((double)pos.getZ())) * 255 ^ pos.hashCode()) % 360.0f / 360.0f;
        return Color.HSBtoRGB(seed + ticks, saturation, 1.0f);
    }

    public final void wispLine(@NotNull Vector3 start, @NotNull Vector3 line, int color, double stepsPerBlock, int time) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        double len = line.length();
        Vector3 ray = Vector3.mul$default((Vector3)line.copy(), (Number)(1.0 / len), null, null, (int)6, null);
        int steps = ExtensionsKt.getI((Number)(len * stepsPerBlock));
        for (int i2 = 0; i2 < steps; ++i2) {
            Vector3 extended = Vector3.mul$default((Vector3)ray.copy(), (Number)((double)i2 / stepsPerBlock), null, null, (int)6, null);
            double x = start.getX() + extended.getX();
            double y = start.getY() + extended.getY();
            double z = start.getZ() + extended.getZ();
            Color c = new Color(color);
            float r = ExtensionsKt.getF((Number)c.getRed()) / 255.0f;
            float g = ExtensionsKt.getF((Number)c.getGreen()) / 255.0f;
            float b = ExtensionsKt.getF((Number)c.getBlue()) / 255.0f;
            Botania.proxy.wispFX(this.field_145850_b, x, y, z, r, g, b, (float)time * 0.0125f);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lalfheim/common/block/tile/TileCracklingStar$Companion;", "", "<init>", "()V", "vecUnbound", "Lalexsocol/asjlib/math/Vector3;", "getVecUnbound", "()Lalexsocol/asjlib/math/Vector3;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3 getVecUnbound() {
            return vecUnbound;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

