/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.ASJTile;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.item.ItemPaperRace;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.MessageRaceInfo;
import alfheim.common.network.packet.MessageSkinInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\t2\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0012R$\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012R\u0014\u0010%\u001a\u00020&X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020&X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010(\u00a8\u00061"}, d2={"Lalfheim/common/block/tile/TileRaceSelector;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "<init>", "()V", "giveRaceAndReset", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "selectRace", "", "race", "Lalfheim/api/entity/EnumRace;", "teleport", "timer", "", "getTimer", "()I", "setTimer", "(I)V", "female", "getFemale", "()Z", "setFemale", "(Z)V", "custom", "getCustom", "setCustom", "activeRotation", "getActiveRotation", "setActiveRotation", "value", "rotation", "getRotation", "setRotation", "updateEntity", "getRenderBoundingBox", "Lnet/minecraft/util/AxisAlignedBB;", "TAG_TIMER", "", "getTAG_TIMER", "()Ljava/lang/String;", "TAG_GENDER", "getTAG_GENDER", "TAG_ROTATION", "getTAG_ROTATION", "writeCustomNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readCustomNBT", "Alfheim"})
public final class TileRaceSelector
extends ASJTile {
    private int timer;
    private boolean female;
    private boolean custom;
    private int activeRotation;
    private int rotation;
    @NotNull
    private final String TAG_TIMER;
    @NotNull
    private final String TAG_GENDER;
    @NotNull
    private final String TAG_ROTATION;

    public TileRaceSelector() {
        this.TAG_TIMER = "timer";
        this.TAG_GENDER = "gender";
        this.TAG_ROTATION = "rotation";
    }

    public final boolean giveRaceAndReset(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            return false;
        }
        if (EnumRaceKt.getRace(player) != EnumRace.HUMAN) {
            return false;
        }
        EnumRace race = EnumRace.Companion.get(this.rotation + 1);
        this.selectRace(player, race);
        if (ASJUtilities.isServer()) {
            CardinalSystem.ElvenStoryModeSystem.INSTANCE.setGender(player, this.female);
            CardinalSystem.ElvenStoryModeSystem.INSTANCE.setCustomSkin(player, this.custom);
            String string = player.func_70005_c_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandSenderName(...)");
            NetworkService.INSTANCE.sendToAll(new MessageRaceInfo(string, this.rotation + 1));
            String string2 = player.func_70005_c_();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandSenderName(...)");
            NetworkService.INSTANCE.sendToAll(new MessageSkinInfo(string2, this.female, this.custom));
            ItemPaperRace.Companion.give(player, player.field_70170_p.func_82737_E());
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        this.female = false;
        this.custom = false;
        this.activeRotation = 0;
        this.setRotation(0);
        return true;
    }

    public final void selectRace(@NotNull EntityPlayer player, @NotNull EnumRace race) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)race), (String)"race");
        EnumRaceKt.setRace(player, race);
        player.field_71075_bZ.field_75101_c = true;
        player.func_71016_p();
        this.teleport(player);
    }

    public final void teleport(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int id = EnumRaceKt.getRace(player).ordinal() - 1;
        if (!(0 <= id ? id < AlfheimConfigHandler.INSTANCE.getZones().length : false)) {
            return;
        }
        Integer[] integerArray = AlfheimConfigHandler.INSTANCE.getZones()[id].getI();
        int x = ((Number)integerArray[0]).intValue();
        int y = ((Number)integerArray[1]).intValue();
        int z = ((Number)integerArray[2]).intValue();
        player.setSpawnChunk(new ChunkCoordinates(x, y, z), true, AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim());
        ASJUtilities.sendToDimensionWithoutPortal((Entity)((Entity)player), (int)AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim(), (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
    }

    public final int getTimer() {
        return this.timer;
    }

    public final void setTimer(int n) {
        this.timer = n;
    }

    public final boolean getFemale() {
        return this.female;
    }

    public final void setFemale(boolean bl) {
        this.female = bl;
    }

    public final boolean getCustom() {
        return this.custom;
    }

    public final void setCustom(boolean bl) {
        this.custom = bl;
    }

    public final int getActiveRotation() {
        return this.activeRotation;
    }

    public final void setActiveRotation(int n) {
        this.activeRotation = n;
    }

    public final int getRotation() {
        return this.rotation;
    }

    public final void setRotation(int value) {
        this.rotation = value < 0 ? 8 : (value > 8 ? 0 : value);
    }

    public void func_145845_h() {
        if (this.activeRotation != 0) {
            int n;
            if (this.activeRotation > 0) {
                this.activeRotation += -1;
                n = this.activeRotation;
            } else {
                n = ++this.activeRotation;
            }
        }
        this.timer += -1;
        if (this.timer == 0) {
            this.female = false;
            this.custom = false;
            this.activeRotation = 0;
            this.setRotation(0);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return ExtensionsKt.getBoundingBox((Number)(this.field_145851_c - 3), (Number)this.field_145848_d, (Number)(this.field_145849_e - 6), (Number)(this.field_145851_c + 4), (Number)(this.field_145848_d + 2), (Number)(this.field_145849_e + 1));
    }

    @NotNull
    public final String getTAG_TIMER() {
        return this.TAG_TIMER;
    }

    @NotNull
    public final String getTAG_GENDER() {
        return this.TAG_GENDER;
    }

    @NotNull
    public final String getTAG_ROTATION() {
        return this.TAG_ROTATION;
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.writeCustomNBT(nbt);
        nbt.func_74768_a(this.TAG_TIMER, this.timer);
        nbt.func_74757_a(this.TAG_GENDER, this.female);
        nbt.func_74768_a(this.TAG_ROTATION, this.rotation);
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readCustomNBT(nbt);
        this.timer = nbt.func_74762_e(this.TAG_TIMER);
        this.female = nbt.func_74767_n(this.TAG_GENDER);
        this.setRotation(nbt.func_74762_e(this.TAG_ROTATION));
    }
}

