/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.ASJTile;
import alfheim.api.AlfheimAPI;
import alfheim.api.crafting.recipe.RecipeTreeCrafting;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.tile.TileItemDisplay;
import alfheim.common.core.asm.hook.extender.SparkExtender;
import alfheim.common.lexicon.MultiblockComponentRainbow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0002BCB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0019J\u0018\u0010\u001a\u001a\u00020\u0011*\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ)\u0010\u001e\u001a\u00020\u00112!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00110\u0019J\u0016\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u00140*j\b\u0012\u0004\u0012\u00020\u0014`+J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u00100\u001a\u00020\u0011J\u0006\u00101\u001a\u00020\u0011J\u000e\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0016J\u000e\u00104\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0016J\u0012\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u00108\u001a\u000206H\u0016J\b\u00109\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u000206H\u0016J\b\u0010;\u001a\u000206H\u0016J\b\u0010<\u001a\u00020\u0006H\u0016J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010>\u001a\u00020\u00112\b\u0010?\u001a\u0004\u0018\u00010@H\u0016J\n\u0010A\u001a\u0004\u0018\u00010@H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006D"}, d2={"Lalfheim/common/block/tile/TileTreeCrafter;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "Lvazkii/botania/api/mana/spark/ISparkAttachable;", "<init>", "()V", "ticksAlive", "", "mana", "manaRequired", "stage", "stageTicks", "signal", "getSignal", "()I", "setSignal", "(I)V", "updateEntity", "", "workingFanciness", "getCore", "Lnet/minecraft/item/ItemStack;", "getRecipe", "Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "forRecipe", "action", "Lkotlin/Function1;", "tickDelay", "lambda", "Lkotlin/Function0;", "", "itemDisplays", "do_this", "Lalfheim/common/block/tile/TileItemDisplay;", "Lkotlin/ParameterName;", "name", "display", "renderHUD", "mc", "Lnet/minecraft/client/Minecraft;", "res", "Lnet/minecraft/client/gui/ScaledResolution;", "getRecipeInputs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "writeCustomNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readCustomNBT", "advanceStage", "sync", "craftingFanciness", "recipe", "tryToLoadTile", "canAttachSpark", "", "p0", "areIncomingTranfersDone", "getAvailableSpaceForMana", "isFull", "canRecieveManaFromBursts", "getCurrentMana", "recieveMana", "attachSpark", "entity", "Lvazkii/botania/api/mana/spark/ISparkEntity;", "getAttachedSpark", "Companion", "Pos", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nTileTreeCrafter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileTreeCrafter.kt\nalfheim/common/block/tile/TileTreeCrafter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n1#2:421\n295#3,2:422\n*S KotlinDebug\n*F\n+ 1 TileTreeCrafter.kt\nalfheim/common/block/tile/TileTreeCrafter\n*L\n244#1:422,2\n*E\n"})
public final class TileTreeCrafter
extends ASJTile
implements ISparkAttachable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int ticksAlive;
    private int mana;
    private int manaRequired;
    private int stage;
    private int stageTicks;
    private int signal;
    @NotNull
    private static final Pos[] ITEMDISPLAY_LOCATIONS;
    @NotNull
    private static final Pos[] COLOREDWOOD_LOCATIONS;
    @NotNull
    private static final Pos[] OBSIDIAN_LOCATIONS;

    public final int getSignal() {
        return this.signal;
    }

    public final void setSignal(int n) {
        this.signal = n;
    }

    public void func_145845_h() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        if (!Companion.canEnchanterExist(world, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (block == AlfheimBlocks.INSTANCE.getTreeCrafterBlock()) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, AlfheimBlocks.INSTANCE.getIrisPlanks(), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 3);
            } else if (block == AlfheimBlocks.INSTANCE.getTreeCrafterBlockRB()) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, AlfheimBlocks.INSTANCE.getRainbowPlanks(), 0, 3);
            } else if (block == AlfheimBlocks.INSTANCE.getTreeCrafterBlockAU()) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, AlfheimBlocks.INSTANCE.getAuroraPlanks(), 0, 3);
            }
            for (int var11 = 0; var11 < 50; ++var11) {
                float var13 = ExtensionsKt.getF((Number)Math.random());
                float var16 = ExtensionsKt.getF((Number)Math.random());
                float var19 = ExtensionsKt.getF((Number)Math.random());
                Botania.proxy.wispFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, var13, var16, var19, ExtensionsKt.getF((Number)Math.random()) * 0.15f + 0.15f, ExtensionsKt.getF((Number)(Math.random() - 0.5)) * 0.25f, ExtensionsKt.getF((Number)(Math.random() - 0.5)) * 0.25f, ExtensionsKt.getF((Number)(Math.random() - 0.5)) * 0.25f);
            }
            this.field_145850_b.func_72908_a(ExtensionsKt.getD((Number)this.field_145851_c), ExtensionsKt.getD((Number)this.field_145848_d), ExtensionsKt.getD((Number)this.field_145849_e), "botania:enchanterBlock", 0.5f, 10.0f);
            return;
        }
        RecipeTreeCrafting recipe = this.getRecipe();
        Ref.ObjectRef recipeItems = new Ref.ObjectRef();
        recipeItems.element = new ArrayList();
        if (recipe != null) {
            recipeItems.element = new ArrayList(recipe.getInputs());
        }
        this.itemDisplays((Function1<? super TileItemDisplay, Unit>)((Function1)arg_0 -> TileTreeCrafter.updateEntity$lambda$0(recipeItems, this, arg_0)));
        if (this.getRecipe() == null) {
            this.stage = 0;
        }
        if (this.stage == 0) {
            this.manaRequired = 0;
            this.mana = 0;
        }
        switch (this.stage) {
            case 0: {
                this.signal = 0;
                this.forRecipe((Function1<? super RecipeTreeCrafting, Unit>)((Function1)arg_0 -> TileTreeCrafter.updateEntity$lambda$1(this, arg_0)));
                break;
            }
            case 1: {
                List sparks;
                int var16 = this.stageTicks;
                this.stageTicks = var16 + 1;
                this.signal = 1;
                this.workingFanciness();
                if (this.mana >= this.manaRequired) {
                    this.manaRequired = 0;
                    this.advanceStage();
                    break;
                }
                if (this.getAttachedSpark() == null || (sparks = SparkHelper.getSparksAround((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5))) == null) break;
                for (ISparkEntity spark : sparks) {
                    if (spark == null || this.getAttachedSpark() == spark || spark.getAttachedTile() == null || !(spark.getAttachedTile() instanceof IManaPool)) continue;
                    spark.registerTransfer(this.getAttachedSpark());
                }
                break;
            }
            case 2: {
                this.forRecipe((Function1<? super RecipeTreeCrafting, Unit>)((Function1)arg_0 -> TileTreeCrafter.updateEntity$lambda$2(this, arg_0)));
                break;
            }
            default: {
                this.stage = 0;
            }
        }
        int n = this.ticksAlive;
        this.ticksAlive = n + 1;
    }

    public final void workingFanciness() {
        this.tickDelay(10, (Function0<? extends Object>)((Function0)() -> TileTreeCrafter.workingFanciness$lambda$3(this)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ItemStack getCore() {
        void it;
        NBTTagCompound nBTTagCompound;
        Block core = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e);
        if (core == Blocks.field_150350_a) {
            return null;
        }
        ItemStack stack = new ItemStack(core, 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e));
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e);
        if (tileEntity == null) {
            return stack;
        }
        TileEntity tile = tileEntity;
        NBTTagCompound nBTTagCompound2 = nBTTagCompound = new NBTTagCompound();
        ItemStack itemStack = stack;
        boolean bl = false;
        tile.func_145841_b((NBTTagCompound)it);
        it.func_82580_o("x");
        it.func_82580_o("y");
        it.func_82580_o("z");
        itemStack.func_77982_d(nBTTagCompound);
        return stack;
    }

    @Nullable
    public final RecipeTreeCrafting getRecipe() {
        RecipeTreeCrafting recipeTreeCrafting;
        ItemStack itemStack = this.getCore();
        if (itemStack != null) {
            Object v1;
            block3: {
                ItemStack core = itemStack;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = AlfheimAPI.INSTANCE.getTreeRecipes();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RecipeTreeCrafting it = (RecipeTreeCrafting)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it.matches((List<ItemStack>)this.getRecipeInputs(), core)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            recipeTreeCrafting = v1;
        } else {
            recipeTreeCrafting = null;
        }
        return recipeTreeCrafting;
    }

    public final void forRecipe(@NotNull Function1<? super RecipeTreeCrafting, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        RecipeTreeCrafting recipe = this.getRecipe();
        if (recipe != null) {
            action.invoke((Object)recipe);
        }
    }

    public final void tickDelay(int $this$tickDelay, @NotNull Function0<? extends Object> lambda) {
        Intrinsics.checkNotNullParameter(lambda, (String)"lambda");
        if (this.ticksAlive % $this$tickDelay == 0) {
            lambda.invoke();
        }
    }

    public final void itemDisplays(@NotNull Function1<? super TileItemDisplay, Unit> do_this) {
        Intrinsics.checkNotNullParameter(do_this, (String)"do_this");
        for (Pos i2 : ITEMDISPLAY_LOCATIONS) {
            TileEntity block = this.field_145850_b.func_147438_o(i2.getX() + this.field_145851_c, i2.getY() + this.field_145848_d - 4, i2.getZ() + this.field_145849_e);
            if (!(block instanceof TileItemDisplay)) continue;
            do_this.invoke((Object)block);
        }
    }

    public final void renderHUD(@NotNull Minecraft mc, @NotNull ScaledResolution res) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        int xc = res.func_78326_a() / 2;
        int yc = res.func_78328_b() / 2;
        float angle = -90.0f;
        int radius = 24;
        RecipeTreeCrafting recipe = this.getRecipe();
        ArrayList<ItemStack> items = this.getRecipeInputs();
        if (recipe != null && (this.mana == 0 || this.manaRequired > 0)) {
            GL11.glEnable((int)3042);
            GL11.glEnable((int)32826);
            GL11.glBlendFunc((int)770, (int)771);
            float progress = ExtensionsKt.getF((Number)this.mana) / ExtensionsKt.getF((Number)this.manaRequired);
            mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.drawTexturedModalRect((int)(xc + radius + 9), (int)(yc - 8), (float)0.0f, (int)0, (int)8, (int)22, (int)15);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            RenderItem.getInstance().func_77015_a(mc.field_71466_p, mc.field_71446_o, recipe.getCore(), xc + radius + 16, yc + 8);
            RenderHelper.renderProgressPie((int)(xc + radius + 32), (int)(yc - 8), (float)progress, (ItemStack)recipe.getOutput());
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            mc.field_71466_p.func_78261_a("+", xc + radius + 14, yc + 12, 0xFFFFFF);
        }
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        float anglePer = 360.0f / (float)items.size();
        Iterator<ItemStack> iterator = items.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ItemStack> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack i2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - (double)8;
            double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - (double)8;
            GL11.glTranslated((double)xPos, (double)yPos, (double)0.0);
            RenderItem.getInstance().func_77015_a(mc.field_71466_p, mc.field_71446_o, i2, 0, 0);
            GL11.glTranslated((double)(-xPos), (double)(-yPos), (double)0.0);
            angle += anglePer;
        }
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }

    @NotNull
    public final ArrayList<ItemStack> getRecipeInputs() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Pos i2 : ITEMDISPLAY_LOCATIONS) {
            ItemStack item;
            TileEntity block = this.field_145850_b.func_147438_o(i2.getX() + this.field_145851_c, i2.getY() + this.field_145848_d - 4, i2.getZ() + this.field_145849_e);
            if (!(block instanceof TileItemDisplay) || (item = ExtensionsKt.get((IInventory)((IInventory)block), (int)0)) == null) continue;
            items.add(item);
        }
        return items;
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a("mana", this.mana);
        nbt.func_74768_a("manaRequired", this.manaRequired);
        nbt.func_74768_a("stage", this.stage);
        nbt.func_74768_a("stageTicks", this.stageTicks);
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.mana = nbt.func_74762_e("mana");
        this.manaRequired = nbt.func_74762_e("manaRequired");
        this.stage = nbt.func_74762_e("stage");
        this.stageTicks = nbt.func_74762_e("stageTicks");
    }

    public final void advanceStage() {
        ++this.stage;
        this.stageTicks = 0;
        this.sync();
    }

    public final void sync() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers(world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public final void craftingFanciness(@NotNull RecipeTreeCrafting recipe) {
        Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
        this.stage = 0;
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e);
        ItemStack itemStack = recipe.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOutput(...)");
        Block block = ExtensionsKt.getBlock((ItemStack)itemStack);
        ItemStack itemStack2 = recipe.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getOutput(...)");
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, block, ExtensionsKt.getMeta((ItemStack)itemStack2), 3);
        this.tryToLoadTile(recipe);
        this.field_145850_b.func_72908_a(ExtensionsKt.getD((Number)this.field_145851_c), ExtensionsKt.getD((Number)this.field_145848_d), ExtensionsKt.getD((Number)this.field_145849_e), "botania:enchanterEnchant", 1.0f, 1.0f);
        for (int i2 = 0; i2 < 25; ++i2) {
            float red = ExtensionsKt.getF((Number)Math.random());
            float green = ExtensionsKt.getF((Number)Math.random());
            float blue = ExtensionsKt.getF((Number)Math.random());
            Botania.proxy.sparkleFX(this.field_145850_b, (double)this.field_145851_c + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, ExtensionsKt.getF((Number)Math.random()), 10);
        }
        ArrayList recipeItems = new ArrayList(recipe.getInputs());
        this.itemDisplays((Function1<? super TileItemDisplay, Unit>)((Function1)arg_0 -> TileTreeCrafter.craftingFanciness$lambda$7(recipeItems, arg_0)));
    }

    public final void tryToLoadTile(@NotNull RecipeTreeCrafting recipe) {
        Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
        if (recipe.getOutTileId() == null) {
            return;
        }
        ItemStack copy = recipe.getOutput().func_77946_l();
        copy.func_77978_p().func_74778_a("id", recipe.getOutTileId());
        TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)copy.func_77978_p());
        if (tileEntity == null) {
            return;
        }
        TileEntity tile = tileEntity;
        tile.field_145851_c = this.field_145851_c;
        tile.field_145848_d = this.field_145848_d - 3;
        tile.field_145849_e = this.field_145849_e;
        this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, tile);
    }

    public boolean canAttachSpark(@Nullable ItemStack p0) {
        return true;
    }

    public boolean areIncomingTranfersDone() {
        return this.stage != 1;
    }

    public int getAvailableSpaceForMana() {
        RecipeTreeCrafting recipe = this.getRecipe();
        int space = Math.max(0, this.manaRequired - this.mana);
        if (recipe != null && recipe.getThrottle() > 0) {
            return Math.min(recipe.getThrottle(), space);
        }
        return space;
    }

    public boolean isFull() {
        return this.mana >= this.manaRequired;
    }

    public boolean canRecieveManaFromBursts() {
        return this.manaRequired > 0;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(this.manaRequired, this.mana + mana);
    }

    public void attachSpark(@Nullable ISparkEntity entity) {
        SparkExtender.INSTANCE.attachTile(entity, this);
    }

    @Nullable
    public ISparkEntity getAttachedSpark() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        AxisAlignedBB axisAlignedBB = ExtensionsKt.boundingBox$default((TileEntity)((TileEntity)this), null, (int)1, null).func_72317_d(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"offset(...)");
        return (ISparkEntity)CollectionsKt.firstOrNull((List)ExtensionsKt.getEntitiesWithinAABB((World)world, ISparkEntity.class, (AxisAlignedBB)axisAlignedBB));
    }

    private static final Unit updateEntity$lambda$0(Ref.ObjectRef $recipeItems, TileTreeCrafter this$0, TileItemDisplay it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        ItemStack stack = ExtensionsKt.get((IInventory)((IInventory)it), (int)0);
        if (stack != null) {
            float s = 0.2f + ExtensionsKt.getF((Number)Math.random()) * 0.1f;
            float m = 0.03f + ExtensionsKt.getF((Number)Math.random()) * 0.015f;
            Iterator iterator = ((ArrayList)$recipeItems.element).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object rItem = iterator2.next();
                if (rItem == null || !ExtensionsKt.itemEquals((ItemStack)stack, rItem)) continue;
                if (this$0.mana > 0) {
                    if (stack.func_77973_b() instanceof ItemBlock) {
                        World world = this$0.field_145850_b;
                        StringBuilder stringBuilder = new StringBuilder().append("blockcrack_");
                        Item item = stack.func_77973_b();
                        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                        world.func_72869_a(stringBuilder.append(ExtensionsKt.getId((Item)item)).append('_').append(ExtensionsKt.getMeta((ItemStack)stack)).toString(), (double)it.field_145851_c + 0.5, (double)it.field_145848_d + 1.0, (double)it.field_145849_e + 0.5, (double)(this$0.field_145851_c - it.field_145851_c) * 8.0, 0.1, (double)(this$0.field_145849_e - it.field_145849_e) * 8.0);
                    } else {
                        World world = this$0.field_145850_b;
                        StringBuilder stringBuilder = new StringBuilder().append("iconcrack_");
                        Item item = stack.func_77973_b();
                        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                        world.func_72869_a(stringBuilder.append(ExtensionsKt.getId((Item)item)).append('_').append(ExtensionsKt.getMeta((ItemStack)stack)).toString(), (double)it.field_145851_c + 0.5, (double)it.field_145848_d + 1.0, (double)it.field_145849_e + 0.5, (double)(this$0.field_145851_c - it.field_145851_c) / 8.0, 0.1, (double)(this$0.field_145849_e - it.field_145849_e) / 8.0);
                    }
                    Botania.proxy.wispFX(this$0.field_145850_b, (double)it.field_145851_c + 0.5, (double)it.field_145848_d + 3.5, (double)it.field_145849_e + 0.5, 1.0f, 1.0f, 1.0f, s, -m);
                }
                ((ArrayList)$recipeItems.element).remove(rItem);
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateEntity$lambda$1(TileTreeCrafter this$0, RecipeTreeCrafting it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.mana = 0;
        this$0.manaRequired = it.getManaUsage();
        this$0.advanceStage();
        return Unit.INSTANCE;
    }

    private static final Unit updateEntity$lambda$2(TileTreeCrafter this$0, RecipeTreeCrafting it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.craftingFanciness(it);
        return Unit.INSTANCE;
    }

    private static final Unit workingFanciness$lambda$3(TileTreeCrafter this$0) {
        for (int i2 = 0; i2 < 360; ++i2) {
            double radian = Math.toRadians(ExtensionsKt.getD((Number)i2));
            double xp = (double)this$0.field_145851_c + Math.cos(radian) * (double)3;
            double zp = (double)this$0.field_145849_e + Math.sin(radian) * (double)3;
            Botania.proxy.wispFX(this$0.field_145850_b, xp + 0.5, (double)this$0.field_145848_d - 3.0, zp + 0.5, 0.0f, 1.0f, 1.0f, 0.3f, -0.01f);
        }
        return Unit.INSTANCE;
    }

    private static final Unit craftingFanciness$lambda$7(ArrayList $recipeItems, TileItemDisplay it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Iterator iterator = $recipeItems.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object rItem = iterator2.next();
            if (rItem == null) continue;
            ItemStack itemStack = ExtensionsKt.get((IInventory)((IInventory)it), (int)0);
            boolean bl = itemStack != null ? ExtensionsKt.itemEquals((ItemStack)itemStack, rItem) : false;
            if (!bl) continue;
            ExtensionsKt.set((IInventory)((IInventory)it), (int)0, null);
            $recipeItems.remove(rItem);
            ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)it);
            break;
        }
        return Unit.INSTANCE;
    }

    static {
        Pos[] posArray = new Pos[]{new Pos(-3, 1, 3), new Pos(-4, 1, 0), new Pos(0, 1, 4), new Pos(-3, 1, -3), new Pos(0, 1, -4), new Pos(3, 1, -3), new Pos(4, 1, 0), new Pos(3, 1, 3)};
        ITEMDISPLAY_LOCATIONS = posArray;
        posArray = new Pos[]{new Pos(2, 0, 2), new Pos(2, 0, 1), new Pos(2, 0, -1), new Pos(2, 0, -2), new Pos(1, 0, 2), new Pos(1, 0, -2), new Pos(-1, 0, 2), new Pos(-1, 0, -2), new Pos(-2, 0, 2), new Pos(-2, 0, 1), new Pos(-2, 0, -1), new Pos(-2, 0, -2)};
        COLOREDWOOD_LOCATIONS = posArray;
        posArray = new Pos[]{new Pos(3, 0, 2), new Pos(3, 0, 1), new Pos(3, 0, 0), new Pos(3, 0, -1), new Pos(3, 0, -2), new Pos(2, 0, 3), new Pos(2, 0, 0), new Pos(2, 0, -3), new Pos(1, 0, 3), new Pos(1, 0, 0), new Pos(1, 0, -3), new Pos(0, 0, 3), new Pos(0, 0, 2), new Pos(0, 0, 1), new Pos(0, 0, -1), new Pos(0, 0, -2), new Pos(0, 0, -3), new Pos(-1, 0, 3), new Pos(-1, 0, 0), new Pos(-1, 0, -3), new Pos(-2, 0, 3), new Pos(-2, 0, 0), new Pos(-2, 0, -3), new Pos(-3, 0, 2), new Pos(-3, 0, 1), new Pos(-3, 0, 0), new Pos(-3, 0, -1), new Pos(-3, 0, -2), new Pos(1, 0, 1), new Pos(1, 0, -1), new Pos(-1, 0, 1), new Pos(-1, 0, -1)};
        OBSIDIAN_LOCATIONS = posArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0018"}, d2={"Lalfheim/common/block/tile/TileTreeCrafter$Companion;", "", "<init>", "()V", "ITEMDISPLAY_LOCATIONS", "", "Lalfheim/common/block/tile/TileTreeCrafter$Pos;", "getITEMDISPLAY_LOCATIONS", "()[Lalfheim/common/block/tile/TileTreeCrafter$Pos;", "[Lalfheim/common/block/tile/TileTreeCrafter$Pos;", "COLOREDWOOD_LOCATIONS", "getCOLOREDWOOD_LOCATIONS", "OBSIDIAN_LOCATIONS", "getOBSIDIAN_LOCATIONS", "makeMultiblockSet", "Lvazkii/botania/api/lexicon/multiblock/MultiblockSet;", "canEnchanterExist", "", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pos[] getITEMDISPLAY_LOCATIONS() {
            return ITEMDISPLAY_LOCATIONS;
        }

        @NotNull
        public final Pos[] getCOLOREDWOOD_LOCATIONS() {
            return COLOREDWOOD_LOCATIONS;
        }

        @NotNull
        public final Pos[] getOBSIDIAN_LOCATIONS() {
            return OBSIDIAN_LOCATIONS;
        }

        @NotNull
        public final MultiblockSet makeMultiblockSet() {
            Multiblock mb = new Multiblock();
            for (Pos i2 : this.getITEMDISPLAY_LOCATIONS()) {
                mb.addComponent(i2.getX(), i2.getY() + 2, i2.getZ(), ModBlocks.pylon, 0);
                mb.addComponent((MultiblockComponent)new MultiblockComponentRainbow(new ChunkCoordinates(i2.getX(), i2.getY(), i2.getZ()), AlfheimBlocks.INSTANCE.getItemDisplay(), new Block[0]));
            }
            for (Pos i2 : this.getOBSIDIAN_LOCATIONS()) {
                mb.addComponent(i2.getX(), i2.getY(), i2.getZ(), Blocks.field_150343_Z, 0);
            }
            for (Pos i2 : this.getCOLOREDWOOD_LOCATIONS()) {
                Block[] blockArray = new Block[]{AlfheimBlocks.INSTANCE.getRainbowPlanks(), AlfheimBlocks.INSTANCE.getAuroraPlanks()};
                mb.addComponent((MultiblockComponent)new MultiblockComponentRainbow(new ChunkCoordinates(i2.getX(), i2.getY(), i2.getZ()), AlfheimBlocks.INSTANCE.getIrisPlanks(), blockArray));
            }
            Pos[] posArray = new Block[]{AlfheimBlocks.INSTANCE.getRainbowDirt(), AlfheimBlocks.INSTANCE.getAuroraDirt()};
            mb.addComponent((MultiblockComponent)new MultiblockComponentRainbow(new ChunkCoordinates(0, 0, 0), AlfheimBlocks.INSTANCE.getIrisDirt(), (Block[])posArray));
            posArray = new Block[]{AlfheimBlocks.INSTANCE.getRainbowPlanks(), AlfheimBlocks.INSTANCE.getAuroraPlanks()};
            mb.addComponent((MultiblockComponent)new MultiblockComponentRainbow(new ChunkCoordinates(0, 4, 0), AlfheimBlocks.INSTANCE.getIrisPlanks(), (Block[])posArray));
            MultiblockSet multiblockSet = mb.makeSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiblockSet, (String)"makeSet(...)");
            return multiblockSet;
        }

        public final boolean canEnchanterExist(@NotNull World world, int x, int y, int z) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            int y0 = y - 4;
            for (Pos i2 : this.getITEMDISPLAY_LOCATIONS()) {
                Block block = ModBlocks.pylon;
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"pylon");
                if (!i2.isBlock(world, block, x, y0 + 2, z)) {
                    return false;
                }
                if (i2.isBlock(world, AlfheimBlocks.INSTANCE.getItemDisplay(), x, y0, z)) continue;
                return false;
            }
            for (Pos i2 : this.getOBSIDIAN_LOCATIONS()) {
                Block block = Blocks.field_150343_Z;
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"obsidian");
                if (i2.isBlock(world, block, x, y0, z)) continue;
                return false;
            }
            for (Pos i2 : this.getCOLOREDWOOD_LOCATIONS()) {
                if (i2.isBlock(world, AlfheimBlocks.INSTANCE.getIrisPlanks(), x, y0, z) || i2.isBlock(world, AlfheimBlocks.INSTANCE.getRainbowPlanks(), x, y0, z) || i2.isBlock(world, AlfheimBlocks.INSTANCE.getAuroraPlanks(), x, y0, z)) continue;
                return false;
            }
            if (world.func_147439_a(x, y0 + 4, z) != AlfheimBlocks.INSTANCE.getTreeCrafterBlock() && world.func_147439_a(x, y0 + 4, z) != AlfheimBlocks.INSTANCE.getTreeCrafterBlockRB() && world.func_147439_a(x, y0 + 4, z) != AlfheimBlocks.INSTANCE.getTreeCrafterBlockAU() && world.func_147439_a(x, y0 + 4, z) != AlfheimBlocks.INSTANCE.getIrisPlanks() && world.func_147439_a(x, y0 + 4, z) != AlfheimBlocks.INSTANCE.getRainbowPlanks() && world.func_147439_a(x, y0 + 4, z) != AlfheimBlocks.INSTANCE.getAuroraPlanks()) {
                return false;
            }
            return world.func_147439_a(x, y0, z) == AlfheimBlocks.INSTANCE.getIrisDirt() || world.func_147439_a(x, y0, z) == AlfheimBlocks.INSTANCE.getRainbowDirt() || world.func_147439_a(x, y0, z) == AlfheimBlocks.INSTANCE.getAuroraDirt();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0003J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lalfheim/common/block/tile/TileTreeCrafter$Pos;", "", "x", "", "y", "z", "<init>", "(III)V", "getX", "()I", "getY", "getZ", "getBlock", "Lnet/minecraft/block/Block;", "world", "Lnet/minecraft/world/World;", "x0", "y0", "z0", "isBlock", "", "block", "toString", "", "Alfheim"})
    public static final class Pos {
        private final int x;
        private final int y;
        private final int z;

        public Pos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getZ() {
            return this.z;
        }

        @NotNull
        public final Block getBlock(@NotNull World world, int x0, int y0, int z0) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Block block = world.func_147439_a(this.x + x0, this.y + y0, this.z + z0);
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            return block;
        }

        public static /* synthetic */ Block getBlock$default(Pos pos, World world, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n = 0;
            }
            if ((n4 & 4) != 0) {
                n2 = 0;
            }
            if ((n4 & 8) != 0) {
                n3 = 0;
            }
            return pos.getBlock(world, n, n2, n3);
        }

        public final boolean isBlock(@NotNull World world, @NotNull Block block, int x0, int y0, int z0) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return world.func_147439_a(this.x + x0, this.y + y0, this.z + z0) == block;
        }

        public static /* synthetic */ boolean isBlock$default(Pos pos, World world, Block block, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n = 0;
            }
            if ((n4 & 8) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x10) != 0) {
                n3 = 0;
            }
            return pos.isBlock(world, block, n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "X: " + this.x + " Y: " + this.y + " Z: " + this.z;
        }
    }
}

