/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.asm.hook.integration;

import alfheim.common.item.rod.RedstoneSignal;
import alfheim.common.item.rod.RedstoneSignalHandler;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\f\u001a\u00020\u0005H\u0007J:\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\f\u001a\u00020\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lalfheim/common/core/asm/hook/integration/RedstoneRodHookHandler;", "", "<init>", "()V", "isBlockProvidingPowerTo", "", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "direction", "result", "getIndirectPowerLevelTo", "Alfheim"})
public final class RedstoneRodHookHandler {
    @NotNull
    public static final RedstoneRodHookHandler INSTANCE = new RedstoneRodHookHandler();

    private RedstoneRodHookHandler() {
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS, injectOnExit=true)
    public static final int isBlockProvidingPowerTo(@NotNull World world, int x, int y, int z, int direction, @Hook.ReturnValue int result) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        ForgeDirection d = ((ForgeDirection)EntriesMappings.entries$0.get(direction)).getOpposite();
        Pair<Integer, RedstoneSignal.EnumRedstoneType> power = RedstoneSignalHandler.Companion.get().getPower(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ);
        return power.getSecond() == RedstoneSignal.EnumRedstoneType.STRONG ? Math.max(((Number)power.getFirst()).intValue(), result) : result;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS, injectOnExit=true)
    public static final int getIndirectPowerLevelTo(@NotNull World world, int x, int y, int z, int direction, @Hook.ReturnValue int result) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        ForgeDirection d = ((ForgeDirection)EntriesMappings.entries$0.get(direction)).getOpposite();
        int power = ((Number)RedstoneSignalHandler.Companion.get().getPower(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ).getFirst()).intValue();
        return Math.max(power, result);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ForgeDirection> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ForgeDirection.values()));
        }
    }
}

