/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.patcher.event.ServerStoppedEvent;
import alfheim.AlfheimCore;
import alfheim.common.core.handler.AlfheimTicket;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\u001e\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016RM\u0010\u0004\u001a>\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lalfheim/common/core/handler/ChunkLoadingHandler;", "Lnet/minecraftforge/common/ForgeChunkManager$LoadingCallback;", "<init>", "()V", "ticketsStore", "Ljava/util/HashMap;", "", "Ljava/util/LinkedHashSet;", "Lalfheim/common/core/handler/AlfheimTicket;", "Lkotlin/collections/LinkedHashSet;", "Lkotlin/collections/HashMap;", "getTicketsStore", "()Ljava/util/HashMap;", "TAG_CHUNKS", "", "requestChunkLoad", "", "world", "Lnet/minecraft/world/World;", "chunkX", "chunkZ", "onServerTick", "", "e", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "onServerStopped", "Lalexsocol/patcher/event/ServerStoppedEvent;", "ticketsLoaded", "tickets", "", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nChunkLoadingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLoadingHandler.kt\nalfheim/common/core/handler/ChunkLoadingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,123:1\n295#2,2:124\n295#2,2:126\n2746#2,3:128\n1869#2,2:132\n1869#2:135\n1869#2,2:136\n1870#2:138\n216#3:131\n217#3:134\n*S KotlinDebug\n*F\n+ 1 ChunkLoadingHandler.kt\nalfheim/common/core/handler/ChunkLoadingHandler\n*L\n33#1:124,2\n35#1:126,2\n56#1:128,3\n98#1:132,2\n114#1:135\n115#1:136,2\n114#1:138\n74#1:131\n74#1:134\n*E\n"})
public final class ChunkLoadingHandler
implements ForgeChunkManager.LoadingCallback {
    @NotNull
    public static final ChunkLoadingHandler INSTANCE = new ChunkLoadingHandler();
    @NotNull
    private static final HashMap<Integer, LinkedHashSet<AlfheimTicket>> ticketsStore = new HashMap();
    @NotNull
    public static final String TAG_CHUNKS = "chunks";

    private ChunkLoadingHandler() {
    }

    @NotNull
    public final HashMap<Integer, LinkedHashSet<AlfheimTicket>> getTicketsStore() {
        return ticketsStore;
    }

    public final boolean requestChunkLoad(@NotNull World world, int chunkX, int chunkZ) {
        AlfheimTicket alfheimTicket;
        Object v1;
        AlfheimTicket it;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        LinkedHashSet ticketsForDim;
        ChunkCoordIntPair chunk;
        block12: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            if (ASJUtilities.isClient()) {
                return false;
            }
            chunk = new ChunkCoordIntPair(chunkX, chunkZ);
            LinkedHashSet linkedHashSet = ticketsStore.computeIfAbsent(world.field_73011_w.field_76574_g, arg_0 -> ChunkLoadingHandler.requestChunkLoad$lambda$1(ChunkLoadingHandler::requestChunkLoad$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"computeIfAbsent(...)");
            ticketsForDim = linkedHashSet;
            $this$firstOrNull$iv = ticketsForDim;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (AlfheimTicket)element$iv;
                boolean bl = false;
                if (!it.getTicket().getChunkList().contains((Object)chunk)) continue;
                v1 = element$iv;
                break block12;
            }
            v1 = null;
        }
        if ((alfheimTicket = (AlfheimTicket)v1) == null) {
            Object v3;
            block13: {
                $this$firstOrNull$iv = ticketsForDim;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (AlfheimTicket)element$iv;
                    boolean bl = false;
                    if (!(it.getTicket().getChunkListDepth() <= 0 || it.getTicket().getChunkList().size() < it.getTicket().getChunkListDepth())) continue;
                    v3 = element$iv;
                    break block13;
                }
                v3 = null;
            }
            alfheimTicket = v3;
        }
        AlfheimTicket ticket = alfheimTicket;
        boolean newTicket = false;
        if (ticket == null) {
            ForgeChunkManager.Ticket ticket2 = ForgeChunkManager.requestTicket((Object)AlfheimCore.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket2 == null) {
                ChunkLoadingHandler $this$requestChunkLoad_u24lambda_u244 = this;
                boolean bl = false;
                FMLLog.bigWarning((String)"Unable to allocate new chunkloading ticket for [alfheim]! Please, expand the limit in FML configs or remove extra", (Object[])new Object[0]);
                return false;
            }
            ForgeChunkManager.Ticket fTicket = ticket2;
            ticket = new AlfheimTicket(fTicket, new LinkedHashMap<ChunkCoordIntPair, Integer>());
            newTicket = true;
        }
        if (!ForgeChunkManager.getPersistentChunksFor((World)world).containsKey((Object)chunk)) {
            boolean bl;
            NBTTagList tagList;
            NBTTagCompound nbt;
            block14: {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket.getTicket(), (ChunkCoordIntPair)chunk);
                nbt = ticket.getTicket().getModData();
                tagList = nbt.func_150295_c(TAG_CHUNKS, 11);
                List list = tagList.field_74747_a;
                Intrinsics.checkNotNull((Object)list);
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$none$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it2 = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(it2 instanceof NBTTagIntArray && ((NBTTagIntArray)it2).func_150302_c()[0] == chunk.field_77276_a && ((NBTTagIntArray)it2).func_150302_c()[1] == chunk.field_77275_b)) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (bl) {
                int[] nArray = new int[]{chunk.field_77276_a, chunk.field_77275_b};
                tagList.func_74742_a((NBTBase)new NBTTagIntArray(nArray));
            }
            nbt.func_74782_a(TAG_CHUNKS, (NBTBase)tagList);
        }
        ((Map)ticket.getRequestedChunkTimers()).put(chunk, 100);
        if (newTicket) {
            ((Collection)ticketsForDim).add(ticket);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onServerTick(@NotNull TickEvent.ServerTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Map $this$forEach$iv = ticketsStore;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iTicket;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            LinkedHashSet alfheimTicketsPerDim = (LinkedHashSet)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(alfheimTicketsPerDim.iterator(), (String)"iterator(...)");
            while (iTicket.hasNext()) {
                void $this$forEach$iv2;
                Object e2 = iTicket.next();
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                AlfheimTicket ticket = (AlfheimTicket)e2;
                Set toRemove = new LinkedHashSet();
                Object object = ticket.getRequestedChunkTimers().keySet().iterator();
                while (object.hasNext()) {
                    ChunkCoordIntPair key;
                    Intrinsics.checkNotNullExpressionValue((Object)object.next(), (String)"next(...)");
                    Integer n = ticket.getRequestedChunkTimers().get(key);
                    Intrinsics.checkNotNull((Object)n);
                    int timer = ((Number)n).intValue() - 1;
                    Integer n2 = timer;
                    ((Map)ticket.getRequestedChunkTimers()).put(key, n2);
                    if (timer > 0) continue;
                    ((Collection)toRemove).add(key);
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket.getTicket(), (ChunkCoordIntPair)key);
                    NBTTagCompound nbt = ticket.getTicket().getModData();
                    NBTTagList tagList = nbt.func_150295_c(TAG_CHUNKS, 11);
                    List list = tagList.field_74747_a;
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tagList");
                    CollectionsKt.removeAll((List)list, arg_0 -> ChunkLoadingHandler.onServerTick$lambda$7$lambda$6(key, arg_0));
                    nbt.func_74782_a(TAG_CHUNKS, (NBTBase)tagList);
                }
                object = toRemove;
                LinkedHashMap<ChunkCoordIntPair, Integer> linkedHashMap = ticket.getRequestedChunkTimers();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ChunkCoordIntPair p0 = (ChunkCoordIntPair)element$iv2;
                    boolean bl2 = false;
                    linkedHashMap.remove(p0);
                }
                if (!ticket.getTicket().getChunkList().isEmpty()) continue;
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket.getTicket());
                iTicket.remove();
            }
        }
    }

    @SubscribeEvent
    public final void onServerStopped(@NotNull ServerStoppedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ticketsStore.clear();
    }

    public void ticketsLoaded(@NotNull List<ForgeChunkManager.Ticket> tickets, @NotNull World world) {
        Intrinsics.checkNotNullParameter(tickets, (String)"tickets");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Iterable $this$forEach$iv = tickets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)element$iv;
            boolean bl = false;
            List list = ticket.getModData().func_150295_c((String)TAG_CHUNKS, (int)11).field_74747_a;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tagList");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv2;
                Object it = element$iv2 = iterator.next();
                boolean bl2 = false;
                if (!(it instanceof NBTTagIntArray)) continue;
                INSTANCE.requestChunkLoad(world, ((NBTTagIntArray)it).func_150302_c()[0], ((NBTTagIntArray)it).func_150302_c()[1]);
            }
        }
    }

    private static final LinkedHashSet requestChunkLoad$lambda$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final LinkedHashSet requestChunkLoad$lambda$1(Function1 $tmp0, Object p0) {
        return (LinkedHashSet)$tmp0.invoke(p0);
    }

    private static final boolean onServerTick$lambda$7$lambda$6(ChunkCoordIntPair $key, Object it) {
        if (!(it instanceof NBTTagIntArray)) {
            return false;
        }
        return ((NBTTagIntArray)it).func_150302_c()[0] == $key.field_77276_a && ((NBTTagIntArray)it).func_150302_c()[1] == $key.field_77275_b;
    }

    static {
        ExtensionsKt.eventForge((Object)ExtensionsKt.eventFML((Object)INSTANCE));
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)AlfheimCore.INSTANCE, (ForgeChunkManager.LoadingCallback)INSTANCE);
    }
}

