/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.AlfheimAPI;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.api.spell.SpellBase;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.core.helper.ContributorsPrivacyHelper;
import alfheim.common.core.helper.ElvenFlightHelper;
import alfheim.common.item.AlfheimItems;
import alfheim.common.network.M2d;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.Message2d;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lalfheim/common/core/handler/KeyBindingHandler;", "", "<init>", "()V", "enableFlight", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "boost", "", "toggleESMAbility", "cast", "hotSpell", "id", "", "unCast", "select", "team", "secret", "Alfheim"})
public final class KeyBindingHandler {
    @NotNull
    public static final KeyBindingHandler INSTANCE = new KeyBindingHandler();

    private KeyBindingHandler() {
    }

    public final void enableFlight(@NotNull EntityPlayerMP player, boolean boost) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (ArraysKt.contains((int[])AlfheimConfigHandler.INSTANCE.getWingsBlackList(), (int)player.field_70170_p.field_73011_w.field_76574_g)) {
            ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"mes.flight.unavailable", (Object[])new Object[0]);
        } else {
            boolean isntFlying;
            if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory() || EnumRaceKt.getRace((EntityPlayer)player) == EnumRace.HUMAN && !player.field_71075_bZ.field_75098_d || player.field_71075_bZ.field_75098_d && boost) {
                return;
            }
            CardinalSystem.PlayerSegment segment = CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player);
            if (!segment.getEsmAbility()) {
                return;
            }
            boolean bl = isntFlying = !player.field_71075_bZ.field_75100_b;
            if (segment.getFlightEnableCooldown() > 0 && isntFlying) {
                return;
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = isntFlying;
            player.func_71016_p();
            if (boost) {
                ElvenFlightHelper.INSTANCE.sub((EntityPlayer)player, 300);
            }
        }
    }

    public final void toggleESMAbility(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CardinalSystem.PlayerSegment seg = CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player);
        seg.toggleESMAbility();
        if (!seg.getEsmAbility() && !player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75100_b = false;
            player.field_71075_bZ.field_75101_c = false;
            player.func_71016_p();
        }
    }

    public final void cast(@NotNull EntityPlayerMP player, boolean hotSpell, int id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int ids = hotSpell ? CardinalSystem.HotSpellsSystem.INSTANCE.getHotSpellID((EntityPlayer)player, id) : id;
        CardinalSystem.PlayerSegment seg = CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player);
        SpellBase spell = AlfheimAPI.INSTANCE.getSpellByIDs(ids >> 28 & 0xF, ids & 0xFFFFFFF);
        if (spell == null) {
            NetworkService.INSTANCE.sendTo(new Message2d(M2d.COOLDOWN, ExtensionsKt.getD((Number)ids), ExtensionsKt.getD((Number)(-SpellBase.SpellCastResult.DESYNC.ordinal())), 0, 8, null), player);
        } else {
            seg.setIds(ids);
            seg.setInit(player.field_71075_bZ.field_75098_d ? 1 : spell.getCastTime());
            seg.setCastableSpell(spell);
        }
    }

    public final void unCast(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CardinalSystem.PlayerSegment seg = CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player);
        seg.setIds(0);
        seg.setInit(0);
        seg.setCastableSpell(null);
    }

    public final void select(@NotNull EntityPlayerMP player, boolean team, int id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (team) {
            EntityLivingBase mr = CardinalSystem.PartySystem.INSTANCE.getParty((EntityPlayer)player).get(id);
            if (mr != null) {
                CardinalSystem.TargetingSystem.INSTANCE.setTarget((EntityPlayer)player, mr, true, id);
            }
        } else if (id != -1) {
            Entity e = player.field_70170_p.func_73045_a(id);
            if (e instanceof EntityLivingBase) {
                CardinalSystem.TargetingSystem.setTarget$default(CardinalSystem.TargetingSystem.INSTANCE, (EntityPlayer)player, (EntityLivingBase)e, false, 0, 8, null);
            }
        } else {
            CardinalSystem.TargetingSystem.setTarget$default(CardinalSystem.TargetingSystem.INSTANCE, (EntityPlayer)player, null, false, 0, 8, null);
        }
    }

    public final void secret(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (ContributorsPrivacyHelper.INSTANCE.isCorrect((EntityPlayer)player, "AlexSocol")) {
            ItemStack itemStack = player.func_71045_bC();
            if ((itemStack != null ? itemStack.func_77973_b() : null) == Items.field_151055_y) {
                ItemStack itemStack2 = player.func_71045_bC();
                boolean bl = itemStack2 != null ? itemStack2.field_77994_a == 9 : false;
                if (bl) {
                    player.func_70062_b(0, new ItemStack(AlfheimItems.INSTANCE.getRoyalStaff()));
                }
            }
        }
    }
}

