/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import alfheim.api.entity.IMuspelheimEntity;
import alfheim.api.entity.INiflheimEntity;
import alfheim.api.event.PlayerInteractAdequateEvent;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.util.DamageSourceSpell;
import alfheim.common.item.equipment.bauble.ItemPendant;
import alfheim.common.network.M1d;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.Message1d;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.tile.TileAltar;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020'H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u00020\u0007*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006)"}, d2={"Lalfheim/common/core/handler/SheerColdHandler;", "", "<init>", "()V", "TAG_SHEER_COLD", "", "value", "", "cold", "Lnet/minecraft/entity/EntityLivingBase;", "getCold", "(Lnet/minecraft/entity/EntityLivingBase;)F", "setCold", "(Lnet/minecraft/entity/EntityLivingBase;F)V", "onLivingUpdate", "", "e", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "canProtect", "", "target", "type", "Lalfheim/common/item/equipment/bauble/ItemPendant$Companion$EnumPrimalWorldType;", "cost", "", "neutralSounds", "", "getNeutralSounds", "()[Ljava/lang/String;", "[Ljava/lang/String;", "hostileSounds", "getHostileSounds", "resetCold", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "onPlayerOvercold", "onPlayerOverheat", "weakHands", "Lalfheim/api/event/PlayerInteractAdequateEvent;", "blockTemperatureInfo", "Lnet/minecraftforge/event/entity/player/ItemTooltipEvent;", "SheerColdTickEvent", "Alfheim"})
public final class SheerColdHandler {
    @NotNull
    public static final SheerColdHandler INSTANCE = new SheerColdHandler();
    @NotNull
    public static final String TAG_SHEER_COLD = "alfheim.SheerCold";
    @NotNull
    private static final String[] neutralSounds;
    @NotNull
    private static final String[] hostileSounds;

    private SheerColdHandler() {
    }

    public final float getCold(@NotNull EntityLivingBase $this$cold) {
        Intrinsics.checkNotNullParameter((Object)$this$cold, (String)"<this>");
        return $this$cold.getEntityData().func_74760_g(TAG_SHEER_COLD);
    }

    public final void setCold(@NotNull EntityLivingBase $this$cold, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$cold, (String)"<this>");
        float prev = $this$cold.getEntityData().func_74760_g(TAG_SHEER_COLD);
        $this$cold.getEntityData().func_74776_a(TAG_SHEER_COLD, value);
        if (!(prev == value) && $this$cold instanceof EntityPlayerMP) {
            NetworkService.INSTANCE.sendTo(new Message1d(M1d.COLD, ExtensionsKt.getD((Number)Float.valueOf(value)), 0, 4, null), (EntityPlayerMP)$this$cold);
        }
    }

    @SubscribeEvent
    public final void onLivingUpdate(@NotNull LivingEvent.LivingUpdateEvent e) {
        float delta;
        float defaultDelta;
        SheerColdTickEvent event;
        EntityLivingBase target;
        block28: {
            int n;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            target = e.entityLiving;
            if (!AlfheimConfigHandler.INSTANCE.getMobTemperature() && !(target instanceof EntityPlayer)) {
                return;
            }
            if (target.field_70170_p.field_72995_K || !target.func_70089_S()) {
                return;
            }
            if (target instanceof EntityPlayerMP && ((EntityPlayerMP)target).field_71075_bZ.field_75098_d) {
                this.setCold(target, 0.0f);
                return;
            }
            Intrinsics.checkNotNull((Object)target);
            event = new SheerColdTickEvent(target, null, 2, null);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            defaultDelta = 0.0f;
            defaultDelta = this.getCold(target) == 0.0f ? 0.0f : 0.5f * Math.signum(this.getCold(target)) * (float)-1;
            if (defaultDelta == 0.0f) break block28;
            SheerColdHandler $this$onLivingUpdate_u24lambda_u242 = this;
            boolean bl = false;
            Integer[] integerArray = Vector3.Companion.fromEntity((Entity)target).mf();
            int x = ((Number)integerArray[0]).intValue();
            int y = ((Number)integerArray[1]).intValue();
            int z = ((Number)integerArray[2]).intValue();
            IntRange intRange = ExtensionsKt.bidiRange((int)x, (int)2);
            int i2 = intRange.getFirst();
            if (i2 > (n = intRange.getLast())) break block28;
            block0: while (true) {
                block29: {
                    int n2;
                    IntRange intRange2;
                    int j;
                    if ((j = (intRange2 = ExtensionsKt.bidiRange((int)y, (int)2)).getFirst()) > (n2 = intRange2.getLast())) break block29;
                    while (true) {
                        block30: {
                            int n3;
                            IntRange intRange3;
                            int k;
                            if ((k = (intRange3 = ExtensionsKt.bidiRange((int)z, (int)2)).getFirst()) > (n3 = intRange3.getLast())) break block30;
                            while (true) {
                                block32: {
                                    float f;
                                    block34: {
                                        TileEntity tileEntity;
                                        block33: {
                                            block31: {
                                                TileAltar $this$onLivingUpdate_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                                                SheerColdHandler $this$onLivingUpdate_u24lambda_u242_u24lambda_u241 = $this$onLivingUpdate_u24lambda_u242;
                                                boolean bl2 = false;
                                                tileEntity = target.field_70170_p.func_147438_o(i2, j, k);
                                                if ((tileEntity instanceof TileAltar ? (TileAltar)tileEntity : null) == null) break block31;
                                                $this$onLivingUpdate_u24lambda_u242_u24lambda_u241_u24lambda_u240 = $this$onLivingUpdate_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                                                boolean bl3 = false;
                                                if ($this$onLivingUpdate_u24lambda_u242_u24lambda_u241_u24lambda_u240.hasLava && !(defaultDelta >= 0.0f)) {
                                                    defaultDelta = -1.0f;
                                                    break block0;
                                                }
                                                break block32;
                                            }
                                            Block near = target.field_70170_p.func_147439_a(i2, j, k);
                                            tileEntity = near;
                                            if (!AlfheimAPI.INSTANCE.getColdBlocks().contains(tileEntity)) break block33;
                                            if (!(defaultDelta > 0.0f)) break block32;
                                            f = 1.0f;
                                            break block34;
                                        }
                                        if (!AlfheimAPI.INSTANCE.getWarmBlocks().contains(tileEntity) || !(defaultDelta < 0.0f)) break block32;
                                        f = -1.0f;
                                    }
                                    defaultDelta = f;
                                    break block0;
                                }
                                if (k == n3) break;
                                ++k;
                            }
                        }
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        Float f = event.getDelta();
        float f2 = f != null ? f.floatValue() : (delta = this.getCold(target) > 0.0f ? Math.max(-this.getCold(target), defaultDelta) : Math.min(-this.getCold(target), defaultDelta));
        if (Float.isNaN(delta)) {
            delta = 0.0f;
        }
        if (event.getDelta() != null) {
            Float f3 = event.getDelta();
            Intrinsics.checkNotNull((Object)f3);
            if ((f3.floatValue() > 0.0f || this.getCold(target) > 0.0f) && defaultDelta == -1.0f) {
                delta = Math.max(defaultDelta + delta, -this.getCold(target));
            }
        }
        if (event.getDelta() != null) {
            Float f4 = event.getDelta();
            Intrinsics.checkNotNull((Object)f4);
            if ((f4.floatValue() < 0.0f || this.getCold(target) < 0.0f) && defaultDelta == 1.0f) {
                delta = Math.min(defaultDelta + delta, -this.getCold(target));
            }
        }
        delta = MathHelper.func_76131_a((float)delta, (float)-100.0f, (float)100.0f);
        this.setCold(target, MathHelper.func_76131_a((float)(this.getCold(target) + delta), (float)-100.0f, (float)100.0f));
        if (ArraysKt.contains((Object[])AlfheimConfigHandler.INSTANCE.getOvercoldBlacklist(), (Object)EntityList.func_75621_b((Entity)((Entity)target))) || target instanceof INiflheimEntity) {
            this.setCold(target, Math.min(0.0f, this.getCold(target)));
        }
        if (ArraysKt.contains((Object[])AlfheimConfigHandler.INSTANCE.getOverheatBlacklist(), (Object)EntityList.func_75621_b((Entity)((Entity)target))) || target instanceof IMuspelheimEntity) {
            this.setCold(target, Math.max(0.0f, this.getCold(target)));
        }
        float cold = this.getCold(target);
        if (AlfheimConfigHandler.INSTANCE.getPotionIDOvercold() != -1) {
            if (cold >= 25.0f) {
                target.func_70690_d(ExtensionsKt.PotionEffectU$default((int)AlfheimConfigHandler.INSTANCE.getPotionIDOvercold(), (int)10, (int)(ExtensionsKt.getI((Number)Float.valueOf(cold / (float)25)) - 1), (boolean)false, (int)8, null));
            } else {
                target.func_82170_o(AlfheimConfigHandler.INSTANCE.getPotionIDOvercold());
            }
        }
        if (AlfheimConfigHandler.INSTANCE.getPotionIDOverheat() != -1) {
            if (cold <= -25.0f) {
                target.func_70690_d(ExtensionsKt.PotionEffectU$default((int)AlfheimConfigHandler.INSTANCE.getPotionIDOverheat(), (int)10, (int)(cold <= -90.0f ? 2 : (cold <= -50.0f ? 1 : 0)), (boolean)false, (int)8, null));
            } else {
                target.func_82170_o(AlfheimConfigHandler.INSTANCE.getPotionIDOverheat());
            }
        }
        if (target.field_70173_aa % 50 != 0) {
            return;
        }
        if (cold >= 100.0f && !SheerColdHandler.canProtect$default(this, target, ItemPendant.Companion.EnumPrimalWorldType.NIFLHEIM, 0, 4, null)) {
            target.func_70097_a(DamageSourceSpell.Companion.getNifleice(), target.func_110138_aP() * 0.01f + 0.15f);
        }
        if (cold <= -100.0f && !SheerColdHandler.canProtect$default(this, target, ItemPendant.Companion.EnumPrimalWorldType.MUSPELHEIM, 0, 4, null)) {
            target.func_70097_a(DamageSourceSpell.Companion.getSoulburn(), target.func_110138_aP() * 0.01f + 0.15f);
        }
    }

    private final boolean canProtect(EntityLivingBase target, ItemPendant.Companion.EnumPrimalWorldType type2, int cost) {
        if (!(target instanceof EntityPlayer)) {
            return false;
        }
        return ItemPendant.Companion.canProtect((EntityPlayer)target, type2, cost);
    }

    static /* synthetic */ boolean canProtect$default(SheerColdHandler sheerColdHandler, EntityLivingBase entityLivingBase, ItemPendant.Companion.EnumPrimalWorldType enumPrimalWorldType, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 50;
        }
        return sheerColdHandler.canProtect(entityLivingBase, enumPrimalWorldType, n);
    }

    @NotNull
    public final String[] getNeutralSounds() {
        return neutralSounds;
    }

    @NotNull
    public final String[] getHostileSounds() {
        return hostileSounds;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void resetCold(@NotNull LivingDeathEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityLivingBase entityLivingBase = e.entityLiving;
        Intrinsics.checkNotNullExpressionValue((Object)entityLivingBase, (String)"entityLiving");
        this.setCold(entityLivingBase, 0.0f);
    }

    @SubscribeEvent
    public final void onPlayerOvercold(@NotNull LivingEvent.LivingUpdateEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityLivingBase target = e.entityLiving;
        if (target instanceof INiflheimEntity) {
            return;
        }
        Intrinsics.checkNotNull((Object)target);
        float cold = this.getCold(target);
        if (cold >= 25.0f && !this.canProtect(target, ItemPendant.Companion.EnumPrimalWorldType.NIFLHEIM, 0)) {
            target.func_70690_d(ExtensionsKt.PotionEffectU$default((int)Potion.field_76421_d.field_76415_H, (int)100, (int)(ExtensionsKt.getI((Number)Float.valueOf(cold / (float)25)) - 1), (boolean)false, (int)8, null));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public final void onPlayerOverheat(@NotNull LivingEvent.LivingUpdateEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityClientPlayerMP player = ExtensionsClientKt.getMc().field_71439_g;
        if (player != e.entityLiving) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        if (ItemPendant.Companion.canProtect((EntityPlayer)player, ItemPendant.Companion.EnumPrimalWorldType.MUSPELHEIM, 0)) {
            return;
        }
        float heat = -this.getCold((EntityLivingBase)player);
        if (heat < 25.0f) {
            return;
        }
        if (player.func_70681_au().nextInt(1000) == 0) {
            ExtensionsKt.playSoundAtEntity((Entity)((Entity)player), (String)("mob." + (String)ArraysKt.random((Object[])(ASJUtilities.chance((Number)Float.valueOf((heat + (float)50) * (float)2)) ? hostileSounds : neutralSounds), (kotlin.random.Random)((kotlin.random.Random)kotlin.random.Random.Default))), (float)1.0f, (float)1.0f);
            return;
        }
        if (heat < 50.0f) {
            return;
        }
        if (player.func_70681_au().nextInt(3000) == 0) {
            Entity entity = null;
            if (ASJUtilities.chance((Number)25)) {
                while (!(entity instanceof EntityLivingBase)) {
                    Collection collection = EntityList.field_75625_b.keySet();
                    Random random = player.func_70681_au();
                    Intrinsics.checkNotNullExpressionValue((Object)random, (String)"getRNG(...)");
                    Object object = ExtensionsKt.random((Collection)collection, (Random)random);
                    Intrinsics.checkNotNull((Object)object);
                    entity = EntityList.func_75620_a((String)object.toString(), (World)((World)ExtensionsClientKt.getMc().field_71441_e));
                }
            } else {
                RegistryNamespaced registryNamespaced = Item.field_150901_e;
                Intrinsics.checkNotNullExpressionValue((Object)registryNamespaced, (String)"itemRegistry");
                Collection collection = CollectionsKt.toList((Iterable)((Iterable)registryNamespaced));
                Random random = player.func_70681_au();
                Intrinsics.checkNotNullExpressionValue((Object)random, (String)"getRNG(...)");
                Object object = ExtensionsKt.random((Collection)collection, (Random)random);
                Item item = object instanceof Item ? (Item)object : null;
                if (item == null) {
                    return;
                }
                Item item2 = item;
                entity = (Entity)new EntityItem((World)ExtensionsClientKt.getMc().field_71441_e, 0.0, 0.0, 0.0, new ItemStack(item2));
            }
            int tries = 50;
            do {
                Vector3 vector3 = Vector3.mul$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)64, null, null, (int)6, null).add((Entity)player);
                double x = vector3.component1();
                double z = vector3.component3();
                entity.func_70107_b(x, (double)ExtensionsClientKt.getMc().field_71441_e.func_72825_h(ExtensionsKt.getI((Number)x), ExtensionsKt.getI((Number)z)) + 1.0, z);
            } while (!ASJUtilities.isNotInFieldOfVision((Entity)entity, (EntityLivingBase)((EntityLivingBase)player)) && --tries > 0);
            ExtensionsKt.spawn$default((Entity)entity, null, (int)1, null);
        }
    }

    @SubscribeEvent
    public final void weakHands(@NotNull PlayerInteractAdequateEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        if (Math.abs(this.getCold((EntityLivingBase)e.getPlayer())) < 90.0f) {
            return;
        }
        if (this.getCold((EntityLivingBase)e.getPlayer()) > 0.0f && ItemPendant.Companion.canProtect(e.getPlayer(), ItemPendant.Companion.EnumPrimalWorldType.NIFLHEIM, 0)) {
            return;
        }
        if (this.getCold((EntityLivingBase)e.getPlayer()) < 0.0f && ItemPendant.Companion.canProtect(e.getPlayer(), ItemPendant.Companion.EnumPrimalWorldType.MUSPELHEIM, 0)) {
            return;
        }
        if (ASJUtilities.chance((Number)0.5)) {
            e.getPlayer().func_71040_bB(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public final void blockTemperatureInfo(@NotNull ItemTooltipEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ItemStack itemStack = e.itemStack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
        Block block = ExtensionsKt.getBlock((ItemStack)itemStack);
        if (AlfheimAPI.INSTANCE.getColdBlocks().contains(block)) {
            List list = e.toolTip;
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any?>");
            ExtensionsKt.addStringToTooltip((List)TypeIntrinsics.asMutableList((Object)list), (String)"alfheimmisc.blockcold", (String[])new String[0]);
        } else if (AlfheimAPI.INSTANCE.getWarmBlocks().contains(block)) {
            List list = e.toolTip;
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any?>");
            ExtensionsKt.addStringToTooltip((List)TypeIntrinsics.asMutableList((Object)list), (String)"alfheimmisc.blockwarm", (String[])new String[0]);
        }
    }

    static {
        String[] stringArray = new String[]{"bat.idle", "cat.meow", "chicken.say", "cow.say", "pig.say", "sheep.say", "wolf.bark"};
        neutralSounds = stringArray;
        stringArray = new String[]{"blaze.breathe", "creeper.say", "enderdragon.growl", "enderdragon.wings", "endermen.idle", "endermen.scream", "ghast.moan", "ghast.scream", "magmacube.big", "silverfish.say", "skeleton.say", "slime.big", "spider.say", "wither.idle", "wolf.growl", "zombie.say", "zombiepig.zpig"};
        hostileSounds = stringArray;
    }

    @Cancelable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lalfheim/common/core/handler/SheerColdHandler$SheerColdTickEvent;", "Lnet/minecraftforge/event/entity/living/LivingEvent;", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "delta", "", "<init>", "(Lnet/minecraft/entity/EntityLivingBase;Ljava/lang/Float;)V", "getDelta", "()Ljava/lang/Float;", "setDelta", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "Alfheim"})
    public static final class SheerColdTickEvent
    extends LivingEvent {
        @Nullable
        private Float delta;

        public SheerColdTickEvent(@NotNull EntityLivingBase entity, @Nullable Float delta) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super(entity);
            this.delta = delta;
        }

        public /* synthetic */ SheerColdTickEvent(EntityLivingBase entityLivingBase, Float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f = null;
            }
            this(entityLivingBase, f);
        }

        @Nullable
        public final Float getDelta() {
            return this.delta;
        }

        public final void setDelta(@Nullable Float f) {
            this.delta = f;
        }
    }
}

