/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity.spell;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.spell.ITimeStopSpecific;
import alfheim.api.spell.SpellBase;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.core.util.DamageSourceSpell;
import alfheim.common.spell.tech.SpellGravityTrap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B;\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ8\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006$"}, d2={"Lalfheim/common/entity/spell/EntitySpellGravityTrap;", "Lnet/minecraft/entity/Entity;", "Lalfheim/api/spell/ITimeStopSpecific;", "world", "Lnet/minecraft/world/World;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "x", "", "y", "z", "<init>", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;DDD)V", "getCaster", "()Lnet/minecraft/entity/EntityLivingBase;", "setCaster", "(Lnet/minecraft/entity/EntityLivingBase;)V", "isImmune", "", "()Z", "setPositionAndRotation2", "", "yaw", "", "pitch", "nope", "", "onEntityUpdate", "affectedBy", "uuid", "Ljava/util/UUID;", "entityInit", "readEntityFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeEntityToNBT", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nEntitySpellGravityTrap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitySpellGravityTrap.kt\nalfheim/common/entity/spell/EntitySpellGravityTrap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 EntitySpellGravityTrap.kt\nalfheim/common/entity/spell/EntitySpellGravityTrap\n*L\n42#1:83,2\n*E\n"})
public final class EntitySpellGravityTrap
extends Entity
implements ITimeStopSpecific {
    @Nullable
    private EntityLivingBase caster;
    private final boolean isImmune;

    @JvmOverloads
    public EntitySpellGravityTrap(@NotNull World world, @Nullable EntityLivingBase caster, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.caster = caster;
        this.func_70107_b(x, y, z);
        this.func_70105_a(ExtensionsKt.getF((Number)SpellGravityTrap.INSTANCE.getRadius()) * (float)2, 0.01f);
    }

    public /* synthetic */ EntitySpellGravityTrap(World world, EntityLivingBase entityLivingBase, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            entityLivingBase = null;
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        this(world, entityLivingBase, d, d2, d3);
    }

    @Nullable
    public final EntityLivingBase getCaster() {
        return this.caster;
    }

    public final void setCaster(@Nullable EntityLivingBase entityLivingBase) {
        this.caster = entityLivingBase;
    }

    @Override
    public boolean isImmune() {
        return this.isImmune;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int nope) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70030_z() {
        if (!AlfheimConfigHandler.INSTANCE.getEnableMMO() || this.field_70173_aa > SpellGravityTrap.INSTANCE.getDuration()) {
            this.func_70106_y();
            return;
        }
        if (this.field_70128_L || this.field_70173_aa < 20 || ASJUtilities.isClient() || this.caster == null) {
            return;
        }
        World world = this.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        AxisAlignedBB axisAlignedBB = ExtensionsKt.getBoundingBox((Number)this.field_70165_t, (Number)(this.field_70163_u + (double)8), (Number)this.field_70161_v, (Number)this.field_70165_t, (Number)(this.field_70163_u + (double)8), (Number)this.field_70161_v).func_72314_b(SpellGravityTrap.INSTANCE.getRadius(), 9.0, SpellGravityTrap.INSTANCE.getRadius());
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"expand(...)");
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)axisAlignedBB);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            if (it == this || it == this.caster || it instanceof EntityLivingBase && CardinalSystem.PartySystem.INSTANCE.mobsSameParty(this.caster, (EntityLivingBase)it) && !AlfheimConfigHandler.INSTANCE.getFriendlyFire() || it instanceof EntityPlayer && ((EntityPlayer)it).field_71075_bZ.field_75098_d || !(Vector3.Companion.entityDistancePlane(it, (Entity)this) <= SpellGravityTrap.INSTANCE.getRadius())) continue;
            EntitySpellGravityTrap $this$onEntityUpdate_u24lambda_u241_u24lambda_u240 = this;
            boolean bl2 = false;
            if ($this$onEntityUpdate_u24lambda_u241_u24lambda_u240.field_70173_aa % 10 == 0) {
                int prevHrt = it.field_70172_ad;
                it.field_70172_ad = 0;
                it.func_70097_a(DamageSourceSpell.Companion.gravity($this$onEntityUpdate_u24lambda_u241_u24lambda_u240, $this$onEntityUpdate_u24lambda_u241_u24lambda_u240.caster), SpellBase.Companion.over($this$onEntityUpdate_u24lambda_u241_u24lambda_u240.caster, SpellGravityTrap.INSTANCE.getDamage()));
                it.field_70172_ad = prevHrt;
            }
            Vector3 dist = Vector3.Companion.fromEntity(it).sub((Entity)$this$onEntityUpdate_u24lambda_u241_u24lambda_u240);
            it.field_70181_x -= 1.0;
            it.field_70159_w -= dist.getX() / (double)5;
            it.field_70179_y -= dist.getZ() / (double)5;
        }
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            Vector3 p = Vector3.mul$default((Vector3)Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null).normalize(), (Number)(Math.random() * (double)4), null, null, (int)6, null).add((Entity)this);
            Vector3 m = Vector3.mul$default((Vector3)Vector3.Companion.fromEntity((Entity)this).sub(p), (Number)0.05, null, null, (int)6, null);
            Object object = new double[6];
            object[0] = p.getX();
            object[1] = p.getY();
            object[2] = p.getZ();
            object[3] = m.getX();
            object[4] = m.getY();
            object[5] = m.getZ();
            VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.GRAVITY, this.field_71093_bK, (double[])object);
        }
    }

    @Override
    public boolean affectedBy(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        EntityLivingBase entityLivingBase = this.caster;
        Intrinsics.checkNotNull((Object)entityLivingBase);
        return !Intrinsics.areEqual((Object)entityLivingBase.func_110124_au(), (Object)uuid);
    }

    public void func_70088_a() {
    }

    public void func_70037_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (nbt.func_74764_b("castername")) {
            this.caster = (EntityLivingBase)this.field_70170_p.func_72924_a(nbt.func_74779_i("castername"));
        } else {
            this.func_70106_y();
        }
        if (this.caster == null) {
            this.func_70106_y();
        }
        this.field_70173_aa = nbt.func_74762_e("ticksExisted");
    }

    public void func_70014_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (this.caster instanceof EntityPlayer) {
            EntityLivingBase entityLivingBase = this.caster;
            Intrinsics.checkNotNull((Object)entityLivingBase);
            nbt.func_74778_a("castername", entityLivingBase.func_70005_c_());
        }
        nbt.func_74768_a("ticksExisted", this.field_70173_aa);
    }

    @JvmOverloads
    public EntitySpellGravityTrap(@NotNull World world, @Nullable EntityLivingBase caster, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, caster, x, y, 0.0, 16, null);
    }

    @JvmOverloads
    public EntitySpellGravityTrap(@NotNull World world, @Nullable EntityLivingBase caster, double x) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, caster, x, 0.0, 0.0, 24, null);
    }

    @JvmOverloads
    public EntitySpellGravityTrap(@NotNull World world, @Nullable EntityLivingBase caster) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, caster, 0.0, 0.0, 0.0, 28, null);
    }

    @JvmOverloads
    public EntitySpellGravityTrap(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, null, 0.0, 0.0, 0.0, 30, null);
    }
}

