/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.minetweaker;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.AlfheimAPI;
import alfheim.common.integration.minetweaker.MinetweakerAlfheimConfig;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.alfheim.General")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u00a8\u0006\u0016"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerGeneral;", "", "<init>", "()V", "addColdBlock", "", "iblock", "Lminetweaker/api/item/IItemStack;", "addWarmBlock", "banRetrade", "output", "pinkify", "input", "pinkness", "", "registerPetroniaFuel", "name", "", "burnTime", "manaPerTick", "Pinkifier", "Register", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nMTHandlerGeneral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MTHandlerGeneral.kt\nalfheim/common/integration/minetweaker/MTHandlerGeneral\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class MTHandlerGeneral {
    @NotNull
    public static final MTHandlerGeneral INSTANCE = new MTHandlerGeneral();

    private MTHandlerGeneral() {
    }

    @ZenMethod
    @JvmStatic
    public static final void addColdBlock(@NotNull IItemStack iblock) {
        Intrinsics.checkNotNullParameter((Object)iblock, (String)"iblock");
        Block block = ExtensionsKt.getBlock((ItemStack)MinetweakerAlfheimConfig.INSTANCE.getStack(iblock));
        if (!(block != Blocks.field_150350_a)) {
            boolean bl = false;
            String string = "Can't add " + iblock + " to list of cold blocks";
            throw new IllegalArgumentException(string.toString());
        }
        ((Collection)AlfheimAPI.INSTANCE.getColdBlocks()).add(block);
    }

    @ZenMethod
    @JvmStatic
    public static final void addWarmBlock(@NotNull IItemStack iblock) {
        Intrinsics.checkNotNullParameter((Object)iblock, (String)"iblock");
        Block block = ExtensionsKt.getBlock((ItemStack)MinetweakerAlfheimConfig.INSTANCE.getStack(iblock));
        if (!(block != Blocks.field_150350_a)) {
            boolean bl = false;
            String string = "Can't add " + iblock + " to list of warm blocks";
            throw new IllegalArgumentException(string.toString());
        }
        ((Collection)AlfheimAPI.INSTANCE.getWarmBlocks()).add(block);
    }

    @ZenMethod
    @JvmStatic
    public static final void banRetrade(@NotNull IItemStack output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        AlfheimAPI.INSTANCE.banRetrade(MinetweakerAlfheimConfig.INSTANCE.getStack(output));
    }

    @ZenMethod
    @JvmStatic
    public static final void pinkify(@NotNull IItemStack input, int pinkness) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MineTweakerAPI.apply((IUndoableAction)new Pinkifier(MinetweakerAlfheimConfig.INSTANCE.getStack(input), pinkness));
    }

    @ZenMethod
    @JvmStatic
    public static final void registerPetroniaFuel(@NotNull String name, int burnTime, int manaPerTick) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MineTweakerAPI.apply((IUndoableAction)new Register(name, burnTime, manaPerTick));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerGeneral$Pinkifier;", "Lminetweaker/IUndoableAction;", "output", "Lnet/minecraft/item/ItemStack;", "pinkness", "", "<init>", "(Lnet/minecraft/item/ItemStack;I)V", "old", "getOld", "()I", "setOld", "(I)V", "apply", "", "canUndo", "", "undo", "describe", "", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class Pinkifier
    implements IUndoableAction {
        @NotNull
        private final ItemStack output;
        private final int pinkness;
        private int old;

        public Pinkifier(@NotNull ItemStack output, int pinkness) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.output = output;
            this.pinkness = pinkness;
        }

        public final int getOld() {
            return this.old;
        }

        public final void setOld(int n) {
            this.old = n;
        }

        public void apply() {
            Integer i2 = AlfheimAPI.INSTANCE.addPink(this.output, this.pinkness);
            if (i2 != null) {
                this.old = i2;
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ((Map)AlfheimAPI.INSTANCE.getPinkness()).put(this.output, this.old);
        }

        @NotNull
        public String describe() {
            return "Mapping new (" + this.pinkness + ") pinkness weight for " + this.output.func_77977_a();
        }

        @NotNull
        public String describeUndo() {
            return "Mapping previous (" + this.old + ") pinkness weight for " + this.output.func_77977_a();
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerGeneral$Register;", "Lminetweaker/IUndoableAction;", "name", "", "burnTime", "", "manaPerTick", "<init>", "(Ljava/lang/String;II)V", "getName", "()Ljava/lang/String;", "getBurnTime", "()I", "getManaPerTick", "prev", "Lkotlin/Pair;", "getPrev", "()Lkotlin/Pair;", "setPrev", "(Lkotlin/Pair;)V", "apply", "", "canUndo", "", "undo", "describe", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class Register
    implements IUndoableAction {
        @NotNull
        private final String name;
        private final int burnTime;
        private final int manaPerTick;
        @Nullable
        private Pair<Integer, Integer> prev;

        public Register(@NotNull String name, int burnTime, int manaPerTick) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.burnTime = burnTime;
            this.manaPerTick = manaPerTick;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getBurnTime() {
            return this.burnTime;
        }

        public final int getManaPerTick() {
            return this.manaPerTick;
        }

        @Nullable
        public final Pair<Integer, Integer> getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Pair<Integer, Integer> pair) {
            this.prev = pair;
        }

        public void apply() {
            this.prev = AlfheimAPI.INSTANCE.getFuelMap().remove(this.name);
            AlfheimAPI.INSTANCE.registerFuel(this.name, this.burnTime, this.manaPerTick);
        }

        public boolean canUndo() {
            return this.prev != null;
        }

        public void undo() {
            Map map = AlfheimAPI.INSTANCE.getFuelMap();
            Pair<Integer, Integer> pair = this.prev;
            Intrinsics.checkNotNull(pair);
            map.put(this.name, pair);
        }

        @NotNull
        public String describe() {
            return "Setting fuel values for " + this.name;
        }

        @NotNull
        public String describeUndo() {
            return "Reverting fuel values for " + this.name;
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }
}

