/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.material;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alfheim.client.core.helper.IconHelper;
import alfheim.client.core.helper.InterpolatedIconHelper;
import alfheim.common.core.util.AlfheimTab;
import alfheim.common.item.ItemMod;
import alfheim.common.item.material.EventResourcesMetas;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 H\u0016J\u001e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00172\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170 R\u001b\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lalfheim/common/item/material/ItemEventResource;", "Lalfheim/common/item/ItemMod;", "<init>", "()V", "texture", "", "Lnet/minecraft/util/IIcon;", "getTexture", "()[Lnet/minecraft/util/IIcon;", "[Lnet/minecraft/util/IIcon;", "isInterpolated", "", "meta", "", "registerIcons", "", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "getIconFromDamage", "loadTextures", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "getUnlocalizedName", "", "stack", "Lnet/minecraft/item/ItemStack;", "getSubItems", "item", "Lnet/minecraft/item/Item;", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "list", "", "", "addStringToTooltip", "s", "tooltip", "Companion", "Alfheim"})
public final class ItemEventResource
extends ItemMod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IIcon[] texture = new IIcon[subItems.length];
    @NotNull
    private static final String[] subItems;

    public ItemEventResource() {
        super("EventResource");
        this.func_77627_a(true);
        this.func_77637_a(AlfheimTab.INSTANCE);
        if (ASJUtilities.isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @NotNull
    public final IIcon[] getTexture() {
        return this.texture;
    }

    public final boolean isInterpolated(int meta) {
        return meta == EventResourcesMetas.INSTANCE.getLavaMelon();
    }

    @Override
    public void func_94581_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
        int n = subItems.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.isInterpolated(i2)) continue;
            this.texture[i2] = IconHelper.INSTANCE.forName(reg, subItems[i2], "materials");
        }
    }

    @Nullable
    public IIcon func_77617_a(int meta) {
        return this.texture[Math.max(0, Math.min(meta, this.texture.length - 1))];
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void loadTextures(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.map.func_130086_a() == 1) {
            int n = subItems.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (!this.isInterpolated(i2)) continue;
                TextureMap textureMap = event.map;
                Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
                this.texture[i2] = InterpolatedIconHelper.INSTANCE.forName(textureMap, subItems[i2], "materials");
            }
        }
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return "item." + subItems[Math.max(0, Math.min(ExtensionsKt.getMeta((ItemStack)stack), subItems.length - 1))];
    }

    public void func_150895_a(@NotNull Item item, @Nullable CreativeTabs tab, @NotNull List<Object> list) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        int n = subItems.length;
        for (int i2 = 0; i2 < n; ++i2) {
            list.add(new ItemStack(item, 1, i2));
        }
    }

    public final void addStringToTooltip(@NotNull String s, @NotNull List<String> tooltip) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        CharSequence charSequence = s;
        Regex regex = new Regex("&");
        String string = "\u00a7";
        tooltip.add(regex.replace(charSequence, string));
    }

    static {
        String[] stringArray = new String[]{"SnowRelic", "VolcanoRelic", "LavaMelon"};
        subItems = stringArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lalfheim/common/item/material/ItemEventResource$Companion;", "", "<init>", "()V", "subItems", "", "", "getSubItems", "()[Ljava/lang/String;", "[Ljava/lang/String;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getSubItems() {
            return subItems;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

