/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.lexicon;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001 B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lalfheim/common/lexicon/MultiblockComponentRainbow;", "Lvazkii/botania/api/lexicon/multiblock/component/MultiblockComponent;", "relPos", "Lnet/minecraft/util/ChunkCoordinates;", "default", "Lnet/minecraft/block/Block;", "blocks", "", "<init>", "(Lnet/minecraft/util/ChunkCoordinates;Lnet/minecraft/block/Block;[Lnet/minecraft/block/Block;)V", "blockpairs", "", "Lalfheim/common/lexicon/MultiblockComponentRainbow$BlockPair;", "secondaryBlocks", "getSecondaryBlocks", "()[Lnet/minecraft/block/Block;", "[Lnet/minecraft/block/Block;", "populatePairs", "", "block", "pairs", "getMeta", "", "getBlock", "matches", "", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "copy", "BlockPair", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nMultiblockComponentRainbow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockComponentRainbow.kt\nalfheim/common/lexicon/MultiblockComponentRainbow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1761#2,3:47\n*S KotlinDebug\n*F\n+ 1 MultiblockComponentRainbow.kt\nalfheim/common/lexicon/MultiblockComponentRainbow\n*L\n39#1:47,3\n*E\n"})
public final class MultiblockComponentRainbow
extends MultiblockComponent {
    @NotNull
    private final List<BlockPair> blockpairs;
    @NotNull
    private final Block[] secondaryBlocks;

    public MultiblockComponentRainbow(@NotNull ChunkCoordinates relPos, @NotNull Block block, Block ... blocks) {
        Intrinsics.checkNotNullParameter((Object)relPos, (String)"relPos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"default");
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        super(relPos, block, -1);
        this.blockpairs = new ArrayList();
        this.secondaryBlocks = blocks;
        this.populatePairs(block, this.blockpairs);
        for (Block block2 : blocks) {
            this.populatePairs(block2, this.blockpairs);
        }
    }

    @NotNull
    public final Block[] getSecondaryBlocks() {
        return this.secondaryBlocks;
    }

    private final void populatePairs(Block block, List<BlockPair> pairs) {
        if (ASJUtilities.isServer()) {
            return;
        }
        ArrayList stacks = new ArrayList();
        Item item = ExtensionsKt.toItem((Block)block);
        block.func_149666_a(item, block.func_149708_J(), (List)stacks);
        Iterator iterator = stacks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            ItemStack stack = (ItemStack)e;
            if (!Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)item)) continue;
            pairs.add(new BlockPair(block, ExtensionsKt.getMeta((ItemStack)stack)));
        }
    }

    public int getMeta() {
        return this.blockpairs.get(ExtensionsKt.getI((Number)(BotaniaAPI.internalHandler.getWorldElapsedTicks() / (long)20 % (long)this.blockpairs.size()))).getMeta();
    }

    @NotNull
    public Block getBlock() {
        return this.blockpairs.get(ExtensionsKt.getI((Number)(BotaniaAPI.internalHandler.getWorldElapsedTicks() / (long)20 % (long)this.blockpairs.size()))).getBlock();
    }

    public boolean matches(@NotNull World world, int x, int y, int z) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Iterable $this$any$iv = this.blockpairs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockPair it = (BlockPair)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)world.func_147439_a(x, y, z), (Object)it.getBlock())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public MultiblockComponentRainbow copy() {
        ChunkCoordinates chunkCoordinates = this.relPos;
        Intrinsics.checkNotNullExpressionValue((Object)chunkCoordinates, (String)"relPos");
        Block block = this.block;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
        Block[] blockArray = this.secondaryBlocks;
        return new MultiblockComponentRainbow(chunkCoordinates, block, Arrays.copyOf(blockArray, blockArray.length));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lalfheim/common/lexicon/MultiblockComponentRainbow$BlockPair;", "", "block", "Lnet/minecraft/block/Block;", "meta", "", "<init>", "(Lnet/minecraft/block/Block;I)V", "getBlock", "()Lnet/minecraft/block/Block;", "getMeta", "()I", "Alfheim"})
    private static final class BlockPair {
        @NotNull
        private final Block block;
        private final int meta;

        public BlockPair(@NotNull Block block, int meta) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.meta = meta;
        }

        @NotNull
        public final Block getBlock() {
            return this.block;
        }

        public final int getMeta() {
            return this.meta;
        }
    }
}

