/*
 * Decompiled with CFR 0.152.
 */
package alfheim.api.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import alfheim.api.lib.LibResourceLocations;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 H2\u00020\u0001:\u0002GHB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0016\u0010 \u001a\u00020\u001f2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\"J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0001H&J:\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J\u000e\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016J\u000e\u00103\u001a\u00020\u001f2\u0006\u00100\u001a\u000201J\u0010\u00104\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016J\u0010\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>J,\u0010@\u001a\b\u0012\u0004\u0012\u0002HB0A\"\b\b\u0000\u0010B*\u00020\u00012\f\u0010C\u001a\b\u0012\u0004\u0012\u0002HB0D2\u0006\u0010=\u001a\u00020>J\u0006\u0010E\u001a\u00020\u0015J\b\u0010F\u001a\u00020\u001fH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u00105\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u0010,\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0011R\u0011\u0010-\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0011R\u0011\u0010.\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0011\u00a8\u0006I"}, d2={"Lalfheim/api/block/tile/SubTileAnomalyBase;", "", "<init>", "()V", "rand", "Ljava/util/Random;", "getRand", "()Ljava/util/Random;", "superTile", "Lnet/minecraft/tileentity/TileEntity;", "getSuperTile", "()Lnet/minecraft/tileentity/TileEntity;", "setSuperTile", "(Lnet/minecraft/tileentity/TileEntity;)V", "ticks", "", "getTicks", "()I", "setTicks", "(I)V", "worldGen", "", "getWorldGen", "()Z", "setWorldGen", "(Z)V", "targets", "", "getTargets", "()Ljava/util/List;", "update", "", "updateEntity", "l", "", "performEffect", "target", "onActivated", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "writeToNBT", "cmp", "Lnet/minecraft/nbt/NBTTagCompound;", "writeCustomNBT", "readFromNBT", "readCustomNBT", "worldObj", "getWorldObj", "()Lnet/minecraft/world/World;", "getX", "getY", "getZ", "findNearestVulnerableEntity", "Lnet/minecraft/entity/EntityLivingBase;", "radius", "", "findNearestEntity", "allAround", "Ljava/util/ArrayList;", "E", "clazz", "Ljava/lang/Class;", "inWG", "bindTexture", "EnumAnomalyRarity", "Companion", "Alfheim"})
public abstract class SubTileAnomalyBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Random rand = new Random();
    @Nullable
    private TileEntity superTile;
    private int ticks;
    private boolean worldGen;
    @NotNull
    public static final String TAG_TICKS = "ticks";

    @NotNull
    public final Random getRand() {
        return this.rand;
    }

    @Nullable
    public final TileEntity getSuperTile() {
        return this.superTile;
    }

    public final void setSuperTile(@Nullable TileEntity tileEntity) {
        this.superTile = tileEntity;
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final void setTicks(int n) {
        this.ticks = n;
    }

    public final boolean getWorldGen() {
        return this.worldGen;
    }

    public final void setWorldGen(boolean bl) {
        this.worldGen = bl;
    }

    @NotNull
    public abstract List<Object> getTargets();

    protected void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateEntity(@Nullable List<Object> l) {
        this.update();
        try {
            Collection collection = l;
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (Object e : l) {
                this.performEffect(e);
            }
        }
        finally {
            int n = this.ticks;
            this.ticks = n + 1;
        }
    }

    public abstract void performEffect(@NotNull Object var1);

    public boolean onActivated(@Nullable ItemStack stack, @NotNull EntityPlayer player, @NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return false;
    }

    public final void writeToNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        cmp.func_74768_a(TAG_TICKS, this.ticks);
        this.writeCustomNBT(cmp);
    }

    public void writeCustomNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
    }

    public final void readFromNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        this.ticks = cmp.func_74762_e(TAG_TICKS);
        this.readCustomNBT(cmp);
    }

    public void readCustomNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
    }

    @NotNull
    public final World getWorldObj() {
        TileEntity tileEntity = this.superTile;
        Intrinsics.checkNotNull((Object)tileEntity);
        World world = tileEntity.func_145831_w();
        Intrinsics.checkNotNull((Object)world);
        return world;
    }

    public final int getX() {
        TileEntity tileEntity = this.superTile;
        Intrinsics.checkNotNull((Object)tileEntity);
        return tileEntity.field_145851_c;
    }

    public final int getY() {
        TileEntity tileEntity = this.superTile;
        Intrinsics.checkNotNull((Object)tileEntity);
        return tileEntity.field_145848_d;
    }

    public final int getZ() {
        TileEntity tileEntity = this.superTile;
        Intrinsics.checkNotNull((Object)tileEntity);
        return tileEntity.field_145849_e;
    }

    @Nullable
    public final EntityLivingBase findNearestVulnerableEntity(double radius) {
        ArrayList<EntityLivingBase> list = this.allAround(EntityLivingBase.class, radius);
        EntityLivingBase entity1 = null;
        double d0 = Double.MAX_VALUE;
        Iterator<EntityLivingBase> iterator = list.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EntityLivingBase> iterator2 = iterator;
        while (iterator2.hasNext()) {
            EntityLivingBase entity2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (entity2.func_85032_ar() || entity2 instanceof EntityPlayer && ((EntityPlayer)entity2).field_71075_bZ.field_75102_a) continue;
            Entity entity = (Entity)entity2;
            TileEntity tileEntity = this.superTile;
            Intrinsics.checkNotNull((Object)tileEntity);
            double d1 = Vector3.Companion.entityTileDistance(entity, tileEntity);
            if (!(d1 <= d0)) continue;
            entity1 = entity2;
            d0 = d1;
        }
        return entity1;
    }

    @Nullable
    public final EntityLivingBase findNearestEntity(double radius) {
        ArrayList<EntityLivingBase> list = this.allAround(EntityLivingBase.class, radius);
        EntityLivingBase entity1 = null;
        double d0 = Double.MAX_VALUE;
        Iterator<EntityLivingBase> iterator = list.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EntityLivingBase> iterator2 = iterator;
        while (iterator2.hasNext()) {
            EntityLivingBase entity2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Entity entity = (Entity)entity2;
            TileEntity tileEntity = this.superTile;
            Intrinsics.checkNotNull((Object)tileEntity);
            double d1 = Vector3.Companion.entityTileDistance(entity, tileEntity);
            if (!(d1 <= d0)) continue;
            entity1 = entity2;
            d0 = d1;
        }
        return entity1;
    }

    @NotNull
    public final <E> ArrayList<E> allAround(@NotNull Class<E> clazz, double radius) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        World world = this.getWorldObj();
        AxisAlignedBB axisAlignedBB = ExtensionsKt.getBoundingBox((Number)this.getX(), (Number)this.getY(), (Number)this.getZ(), (Number)(this.getX() + 1), (Number)(this.getY() + 1), (Number)(this.getZ() + 1)).func_72314_b(radius, radius, radius);
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"expand(...)");
        return ExtensionsKt.getEntitiesWithinAABB((World)world, clazz, (AxisAlignedBB)axisAlignedBB);
    }

    public final boolean inWG() {
        return this.worldGen;
    }

    @SideOnly(value=Side.CLIENT)
    public final void bindTexture() {
        ExtensionsClientKt.getMc().field_71446_o.func_110577_a((ResourceLocation)LibResourceLocations.INSTANCE.getAnomalies());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lalfheim/api/block/tile/SubTileAnomalyBase$Companion;", "", "<init>", "()V", "TAG_TICKS", "", "forName", "Lalfheim/api/block/tile/SubTileAnomalyBase;", "name", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SubTileAnomalyBase forName(@NotNull String name) {
            SubTileAnomalyBase subTileAnomalyBase;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                subTileAnomalyBase = AlfheimAPI.INSTANCE.getAnomaly(name).getSubtileClass().newInstance();
            }
            catch (Exception e) {
                ASJUtilities.error((String)("Error while getting '" + name + "' anomaly subtile"), (Throwable)e);
                subTileAnomalyBase = null;
            }
            return subTileAnomalyBase;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalyRarity;", "", "<init>", "(Ljava/lang/String;I)V", "COMMON", "RARE", "EPIC", "Alfheim"})
    public static final class EnumAnomalyRarity
    extends Enum<EnumAnomalyRarity> {
        public static final /* enum */ EnumAnomalyRarity COMMON = new EnumAnomalyRarity();
        public static final /* enum */ EnumAnomalyRarity RARE = new EnumAnomalyRarity();
        public static final /* enum */ EnumAnomalyRarity EPIC = new EnumAnomalyRarity();
        private static final /* synthetic */ EnumAnomalyRarity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EnumAnomalyRarity[] values() {
            return (EnumAnomalyRarity[])$VALUES.clone();
        }

        public static EnumAnomalyRarity valueOf(String value) {
            return Enum.valueOf(EnumAnomalyRarity.class, value);
        }

        @NotNull
        public static EnumEntries<EnumAnomalyRarity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = enumAnomalyRarityArray = new EnumAnomalyRarity[]{EnumAnomalyRarity.COMMON, EnumAnomalyRarity.RARE, EnumAnomalyRarity.EPIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

