/*
 * Decompiled with CFR 0.152.
 */
package alfheim.client.render.tile;

import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alexsocol.asjlib.render.ASJRenderHelper;
import alfheim.api.lib.LibResourceLocations;
import alfheim.common.block.tile.TileFloodLight;
import alfheim.common.core.handler.AlfheimConfigHandler;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lalfheim/client/render/tile/RenderTileFloodLight;", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "<init>", "()V", "model", "Lnet/minecraftforge/client/model/IModelCustom;", "getModel", "()Lnet/minecraftforge/client/model/IModelCustom;", "renderTileEntityAt", "", "tile", "Lnet/minecraft/tileentity/TileEntity;", "x", "", "y", "z", "partialTicks", "", "Alfheim"})
public final class RenderTileFloodLight
extends TileEntitySpecialRenderer {
    @NotNull
    public static final RenderTileFloodLight INSTANCE = new RenderTileFloodLight();
    @NotNull
    private static final IModelCustom model;

    private RenderTileFloodLight() {
    }

    @NotNull
    public final IModelCustom getModel() {
        return model;
    }

    public void func_147500_a(@NotNull TileEntity tile, double x, double y, double z, float partialTicks) {
        double d;
        Vector3 tp;
        Vector3 vector3;
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        if (!(tile instanceof TileFloodLight)) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-1.0f, (float)0.5f);
        ExtensionsClientKt.getMc().field_71446_o.func_110577_a((ResourceLocation)LibResourceLocations.INSTANCE.getFloodlight());
        model.renderAll();
        GL11.glPopMatrix();
        if (!((TileFloodLight)tile).getRedstone()) {
            return;
        }
        World world = ((TileFloodLight)tile).func_145831_w();
        if (world == null) {
            WorldClient worldClient = ExtensionsClientKt.getMc().field_71441_e;
            if (worldClient != null) {
                world = (World)worldClient;
            } else {
                return;
            }
        }
        World world2 = world;
        Block block = world2.func_147439_a(tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e);
        boolean bl = block != null ? block.func_149662_c() : false;
        if (bl) {
            return;
        }
        GL11.glPushMatrix();
        EntityLivingBase entityLivingBase = ExtensionsClientKt.getMc().field_71451_h;
        Intrinsics.checkNotNullExpressionValue((Object)entityLivingBase, (String)"renderViewEntity");
        ASJRenderHelper.interpolatedTranslationReverse((Entity)((Entity)entityLivingBase));
        ASJRenderHelper.setGlow();
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78371_b(6);
        float[] fArray = new Color(0xFFFFCC).getRGBColorComponents(null);
        Intrinsics.checkNotNull((Object)fArray);
        float r = fArray[0];
        float g = fArray[1];
        float b = fArray[2];
        tes.func_78369_a(r, g, b, 0.2f);
        EntityLivingBase target = ((TileFloodLight)tile).getTarget();
        Vector3 pos = Vector3.Companion.fromTileEntity(tile).add((Number)0.5, (Number)-0.1, (Number)0.5);
        EntityLivingBase entityLivingBase2 = target;
        if (entityLivingBase2 != null) {
            EntityLivingBase it = entityLivingBase2;
            boolean bl2 = false;
            double i2 = ASJRenderHelper.interpolate((double)it.field_70169_q, (double)it.field_70165_t);
            double j = ASJRenderHelper.interpolate((double)(it.field_70167_r - (ExtensionsClientKt.getMc().field_71439_g == it ? 1.62 : 0.0)), (double)(it.field_70163_u - (ExtensionsClientKt.getMc().field_71439_g == it ? 1.62 : 0.0)));
            double k = ASJRenderHelper.interpolate((double)it.field_70166_s, (double)it.field_70161_v);
            vector3 = new Vector3((Number)i2, (Number)j, (Number)k);
        } else {
            vector3 = tp = null;
        }
        if (target != null) {
            Vector3 vector32 = tp;
            Intrinsics.checkNotNull(vector32);
            double dist = Vector3.Companion.vecDistance(pos, vector32);
            if (dist > 160.0 || tp.getY() > pos.getY()) {
                target = null;
                tp = null;
                d = 12.0;
            } else {
                d = Math.cbrt(dist) / (double)2;
            }
        } else {
            d = 12.0;
        }
        double radius = d;
        int step = AlfheimConfigHandler.INSTANCE.getFloodLightQuality();
        tes.func_78377_a(pos.getX(), pos.getY() + 0.5, pos.getZ());
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + '.');
        }
        int deg = 0;
        int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)360, (int)step);
        if (deg <= n) {
            while (true) {
                MovingObjectPosition movingObjectPosition;
                double angle = Math.toRadians(ExtensionsKt.getD((Number)deg));
                double i3 = Math.cos(angle) * radius;
                Vector3 vector33 = tp;
                double j = vector33 != null ? vector33.getY() - pos.getY() : -160.0;
                double k = Math.sin(angle) * radius;
                Vector3 dest = pos.copy().add((Number)i3, (Number)j, (Number)k);
                if (tp != null) {
                    dest.add(new Vector3((Number)tp.getX(), (Number)0, (Number)tp.getZ()).sub((Number)pos.getX(), (Number)0, (Number)pos.getZ()));
                }
                if ((movingObjectPosition = world2.func_147447_a(pos.toVec3(), dest.toVec3(), false, false, target == null)) == null || (movingObjectPosition = movingObjectPosition.field_72307_f) == null) {
                    movingObjectPosition = dest.toVec3();
                }
                MovingObjectPosition hit = movingObjectPosition;
                tes.func_78377_a(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c);
                if (deg == n) break;
                deg += step;
            }
        }
        tes.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        ASJRenderHelper.discard();
        GL11.glPopMatrix();
    }

    static {
        IModelCustom iModelCustom = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("alfheim", "model/Floodlight.obj"));
        Intrinsics.checkNotNull((Object)iModelCustom);
        model = iModelCustom;
    }
}

