/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.colored;

import alexsocol.asjlib.ASJUtilities;
import alfheim.client.core.helper.InterpolatedIconHelper;
import alfheim.common.block.base.BlockMod;
import alfheim.common.lexicon.AlfheimLexiconData;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J0\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J:\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010$\u001a\u00020\u0011H\u0016J(\u0010$\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J(\u0010'\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0017J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011J>\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\b\u00100\u001a\u0004\u0018\u00010\"2\b\u00101\u001a\u0004\u0018\u00010\u001eH\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u00062"}, d2={"Lalfheim/common/block/colored/BlockColoredLamp;", "Lalfheim/common/block/base/BlockMod;", "Lvazkii/botania/api/lexicon/ILexiconable;", "<init>", "()V", "rainbowIcon", "Lnet/minecraft/util/IIcon;", "getRainbowIcon", "()Lnet/minecraft/util/IIcon;", "setRainbowIcon", "(Lnet/minecraft/util/IIcon;)V", "loadTextures", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "getIcon", "side", "", "meta", "onNeighborBlockChange", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "block", "Lnet/minecraft/block/Block;", "onBlockAdded", "damageDropped", "getPickBlock", "Lnet/minecraft/item/ItemStack;", "target", "Lnet/minecraft/util/MovingObjectPosition;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createStackedBlock", "getLightValue", "Lnet/minecraft/world/IBlockAccess;", "getRenderColor", "colorMultiplier", "powerColor", "power", "getEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "p0", "p1", "p2", "p3", "p4", "p5", "Alfheim"})
public final class BlockColoredLamp
extends BlockMod
implements ILexiconable {
    @Nullable
    private IIcon rainbowIcon;

    public BlockColoredLamp() {
        Material material = Material.field_151591_t;
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"redstoneLight");
        super(material);
        this.func_149663_c("irisLamp");
        this.func_149672_a(Block.field_149778_k);
        this.func_149711_c(0.3f);
        if (ASJUtilities.isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Nullable
    public final IIcon getRainbowIcon() {
        return this.rainbowIcon;
    }

    public final void setRainbowIcon(@Nullable IIcon iIcon) {
        this.rainbowIcon = iIcon;
    }

    @Override
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.map.func_130086_a() == 0) {
            TextureMap textureMap = event.map;
            Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
            this.rainbowIcon = InterpolatedIconHelper.INSTANCE.forBlock(textureMap, (Block)this, "RB");
        }
    }

    @Nullable
    public IIcon func_149691_a(int side, int meta) {
        return meta > 14 ? this.rainbowIcon : this.field_149761_L;
    }

    public void func_149695_a(@NotNull World world, int x, int y, int z, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super.func_149695_a(world, x, y, z, block);
        int lvl = world.func_94572_D(x, y, z);
        if (world.func_72805_g(x, y, z) != lvl) {
            world.func_72921_c(x, y, z, lvl, 3);
        }
    }

    public void func_149726_b(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super.func_149726_b(world, x, y, z);
        int lvl = world.func_94572_D(x, y, z);
        if (world.func_72805_g(x, y, z) != lvl) {
            world.func_72921_c(x, y, z, lvl, 3);
        }
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    @NotNull
    public ItemStack getPickBlock(@Nullable MovingObjectPosition target, @NotNull World world, int x, int y, int z, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new ItemStack((Block)this, 1, 0);
    }

    @NotNull
    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this);
    }

    public int func_149750_m() {
        return 0;
    }

    public int getLightValue(@NotNull IBlockAccess world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        int lvl = world.func_72805_g(x, y, z);
        if (Loader.isModLoaded((String)"easycoloredlights")) {
            return lvl == 15 ? 0xFFFFFF : this.powerColor(lvl);
        }
        return lvl > 0 ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.powerColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(@NotNull IBlockAccess world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.func_149741_i(world.func_72805_g(x, y, z));
    }

    public final int powerColor(int power) {
        switch (power) {
            case 0: {
                return 0x161616;
            }
            case 15: {
                return 0xFFFFFF;
            }
        }
        return Color.HSBtoRGB((float)(power - 1) / 16.0f, 1.0f, 1.0f);
    }

    @NotNull
    public LexiconEntry getEntry(@Nullable World p0, int p1, int p2, int p3, @Nullable EntityPlayer p4, @Nullable ItemStack p5) {
        return AlfheimLexiconData.INSTANCE.getLamp();
    }
}

