/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.fluid;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.event.PlayerInteractAdequateEvent;
import alfheim.common.block.AlfheimBlocks;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ModItems;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017J4\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0017\u00a8\u0006\u001b"}, d2={"Lalfheim/common/block/fluid/BlockManaFluid;", "Lnet/minecraftforge/fluids/BlockFluidClassic;", "<init>", "()V", "setBlockName", "Lnet/minecraft/block/Block;", "name", "", "registerBlockIcons", "", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "getIcon", "Lnet/minecraft/util/IIcon;", "side", "", "meta", "randomDisplayTick", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "random", "Ljava/util/Random;", "Companion", "ManaFluid", "Alfheim"})
public final class BlockManaFluid
extends BlockFluidClassic {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BlockManaFluid() {
        super((Fluid)ManaFluid.INSTANCE, Material.field_151586_h);
        this.func_149663_c("manaFluid");
        this.func_149711_c(2000.0f);
        this.func_149715_a((float)ManaFluid.INSTANCE.getLuminosity() / 15.0f);
        this.func_149713_g(2);
        this.setQuantaPerBlock(13);
    }

    @NotNull
    public Block func_149663_c(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        GameRegistry.registerBlock((Block)((Block)this), (String)name);
        Block block = super.func_149663_c(name);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"setBlockName(...)");
        return block;
    }

    public void func_149651_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public IIcon func_149691_a(int side, int meta) {
        return side < 2 ? this.definedFluid.getStillIcon() : this.definedFluid.getFlowingIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(@Nullable World world, int x, int y, int z, @Nullable Random random) {
        if (!ASJUtilities.chance((Number)20)) {
            return;
        }
        float[] fArray = new Color(50943).getRGBColorComponents(null);
        Intrinsics.checkNotNull((Object)fArray);
        float r = fArray[0];
        float g = fArray[1];
        float b = fArray[2];
        Botania.proxy.wispFX(world, (double)x + Math.random(), (double)y + Math.random() * 0.25, (double)z + Math.random(), r, g, b, ExtensionsKt.getF((Number)Math.random()) / 3.0f, -ExtensionsKt.getF((Number)Math.random()) / 25.0f, 2.0f);
    }

    static {
        ExtensionsKt.eventForge((Object)Companion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lalfheim/common/block/fluid/BlockManaFluid$Companion;", "", "<init>", "()V", "onPlayerInteract", "", "e", "Lalfheim/api/event/PlayerInteractAdequateEvent$RightClick;", "preventDraining", "Lnet/minecraftforge/event/entity/player/FillBucketEvent;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @SubscribeEvent
        public final void onPlayerInteract(@NotNull PlayerInteractAdequateEvent.RightClick e) {
            Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
            if (e.getAction() != PlayerInteractAdequateEvent.RightClick.Action.RIGHT_CLICK_LIQUID) {
                return;
            }
            EntityPlayer player = e.getPlayer();
            ItemStack itemStack = player.func_70694_bm();
            if (itemStack == null) {
                return;
            }
            ItemStack stack = itemStack;
            if (stack.func_77973_b() != Items.field_151069_bo || stack.field_77994_a < 1) {
                return;
            }
            World world = player.field_70170_p;
            Block block = world.func_147439_a(e.getX(), e.getY(), e.getZ());
            BlockFluidBase blockFluidBase = block instanceof BlockFluidBase ? (BlockFluidBase)block : null;
            if (blockFluidBase == null) {
                return;
            }
            BlockFluidBase block2 = blockFluidBase;
            if (!Intrinsics.areEqual((Object)block2.getFluid().getName(), (Object)"mana")) {
                return;
            }
            if (world.func_72805_g(e.getX(), e.getY(), e.getZ()) != 0) {
                return;
            }
            world.func_147468_f(e.getX(), e.getY(), e.getZ());
            ItemStack bottle = new ItemStack(ModItems.manaBottle);
            int n = stack.field_77994_a;
            stack.field_77994_a = n + -1;
            if (stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, bottle);
            } else if (!player.field_71071_by.func_70441_a(bottle)) {
                player.func_71019_a(bottle, true);
            }
            if (world.field_72995_K) {
                player.func_71038_i();
            }
        }

        @SubscribeEvent
        public final void preventDraining(@NotNull FillBucketEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ItemStack itemStack = e.current;
            if ((itemStack != null ? itemStack.func_77973_b() : null) == Items.field_151133_ar && Intrinsics.areEqual((Object)e.world.func_147439_a(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d), (Object)AlfheimBlocks.INSTANCE.getManaFluidBlock())) {
                e.setCanceled(!e.entityPlayer.field_71075_bZ.field_75098_d);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lalfheim/common/block/fluid/BlockManaFluid$ManaFluid;", "Lnet/minecraftforge/fluids/Fluid;", "<init>", "()V", "getFlowingIcon", "Lnet/minecraft/util/IIcon;", "getStillIcon", "Alfheim"})
    public static final class ManaFluid
    extends Fluid {
        @NotNull
        public static final ManaFluid INSTANCE = new ManaFluid();

        private ManaFluid() {
            super("mana");
        }

        @Nullable
        public IIcon getFlowingIcon() {
            return FluidRegistry.WATER.getFlowingIcon();
        }

        @Nullable
        public IIcon getStillIcon() {
            return FluidRegistry.WATER.getStillIcon();
        }

        static {
            INSTANCE.setLuminosity(4);
            INSTANCE.setDensity(600);
            INSTANCE.setViscosity(600);
            INSTANCE.setRarity(EnumRarity.uncommon);
            FluidRegistry.registerFluid((Fluid)INSTANCE);
        }
    }
}

