/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.SchemaUtils;
import alexsocol.asjlib.extendables.block.TileImmobile;
import alexsocol.asjlib.math.Vector3;
import alexsocol.asjlib.render.ASJRenderHelper;
import alfheim.api.AlfheimAPI;
import alfheim.api.world.domain.Domain;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.core.asm.hook.AlfheimHookHandler;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.ItemIridescent;
import alfheim.common.item.material.ElvenResourcesMetas;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.Botania;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001c\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006$"}, d2={"Lalfheim/common/block/tile/TileDomainLobby;", "Lalexsocol/asjlib/extendables/block/TileImmobile;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "countdown", "", "getCountdown", "()I", "setCountdown", "(I)V", "cooldown", "getCooldown", "setCooldown", "updateEntity", "", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getPlayerBack", "findFreeDomain", "forcePlayer", "doParticles", "writeCustomNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readCustomNBT", "getRenderBoundingBox", "Lnet/minecraft/util/AxisAlignedBB;", "Companion", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nTileDomainLobby.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileDomainLobby.kt\nalfheim/common/block/tile/TileDomainLobby\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1869#2,2:188\n1869#2,2:190\n*S KotlinDebug\n*F\n+ 1 TileDomainLobby.kt\nalfheim/common/block/tile/TileDomainLobby\n*L\n101#1:188,2\n131#1:190,2\n*E\n"})
public final class TileDomainLobby
extends TileImmobile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    private int countdown;
    private int cooldown;
    @NotNull
    public static final String TAG_COOLDOWN = "Cooldown";
    @NotNull
    public static final String TAG_COUNTDOWN = "Countdown";
    @NotNull
    public static final String TAG_DOMAIN_NAME = "DomainName";
    @NotNull
    public static final String TAG_DOMAIN_ENTRANCE = "alfheim.DomainEntranceCoords";

    public TileDomainLobby() {
        block1: {
            this.name = "";
            if (!ASJUtilities.isServer()) break block1;
            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
            if (minecraftServer != null && (minecraftServer = minecraftServer.func_71218_a(AlfheimConfigHandler.INSTANCE.getDimensionIDDomains())) != null) {
                minecraftServer.func_147439_a(0, 0, 0);
            }
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final int getCountdown() {
        return this.countdown;
    }

    public final void setCountdown(int n) {
        this.countdown = n;
    }

    public final int getCooldown() {
        return this.cooldown;
    }

    public final void setCooldown(int n) {
        this.cooldown = n;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDDomains()) {
            super.func_145845_h();
        }
        this.cooldown += -1;
        this.countdown += -1;
        if (this.countdown == 0) {
            this.findFreeDomain(null);
        }
        this.doParticles();
    }

    public final boolean onBlockActivated(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.getPlayerBack(player)) {
            return true;
        }
        Domain domain = AlfheimAPI.INSTANCE.getDomains().get(this.name);
        if (domain == null) {
            return false;
        }
        Domain domain2 = domain;
        ItemStack itemStack = player.func_70694_bm();
        if (Intrinsics.areEqual((Object)(itemStack != null ? itemStack.func_77973_b() : null), (Object)AlfheimItems.INSTANCE.getElvenResource())) {
            ItemStack itemStack2 = player.func_70694_bm();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getHeldItem(...)");
            if (ExtensionsKt.getMeta((ItemStack)itemStack2) == ElvenResourcesMetas.DomainKey.getI()) {
                this.findFreeDomain(player);
                return true;
            }
        }
        if (this.cooldown > 0 || this.countdown > 0) {
            return false;
        }
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        if (domain2.isLocked(world)) {
            ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"alfheimmisc.ragnarok.domain.locked", (Object[])new Object[0]);
            return false;
        }
        this.countdown = 200;
        ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)this);
        return true;
    }

    public final boolean getPlayerBack(@NotNull EntityPlayer player) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.field_71093_bK != AlfheimConfigHandler.INSTANCE.getDimensionIDDomains()) {
            return false;
        }
        NBTTagCompound $this$getPlayerBack_u24lambda_u240 = nBTTagCompound = ExtensionsKt.getPersistentData((EntityPlayer)player);
        boolean bl = false;
        if ($this$getPlayerBack_u24lambda_u240.func_74764_b(TAG_DOMAIN_ENTRANCE)) {
            int[] nArray = $this$getPlayerBack_u24lambda_u240.func_74759_k(TAG_DOMAIN_ENTRANCE);
            Intrinsics.checkNotNull((Object)nArray);
            int x = nArray[0];
            int y = nArray[1];
            int z = nArray[2];
            int d = nArray[3];
            $this$getPlayerBack_u24lambda_u240.func_82580_o(TAG_DOMAIN_ENTRANCE);
            ASJUtilities.sendToDimensionWithoutPortal((Entity)((Entity)player), (int)d, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
            return true;
        }
        ChunkCoordinates chunkCoordinates = player.getBedLocation(0);
        if (chunkCoordinates == null && (chunkCoordinates = MinecraftServer.func_71276_C().func_71218_a(0).func_72861_E()) == null) {
            chunkCoordinates = new ChunkCoordinates(0, 64, 0);
        }
        nBTTagCompound = chunkCoordinates;
        int x = ExtensionsKt.component1((ChunkCoordinates)nBTTagCompound);
        int y = ExtensionsKt.component2((ChunkCoordinates)nBTTagCompound);
        int z = ExtensionsKt.component3((ChunkCoordinates)nBTTagCompound);
        ASJUtilities.sendToDimensionWithoutPortal((Entity)((Entity)player), (int)0, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
        return true;
    }

    public final void findFreeDomain(@Nullable EntityPlayer forcePlayer) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Vector3 center = Vector3.Companion.fromTileEntityCenter((TileEntity)this).add((Number)0, (Number)-3, (Number)-7);
        AxisAlignedBB bb = ExtensionsKt.expand((AxisAlignedBB)ExtensionsKt.getBoundingBox((Number)center.getX(), (Number)center.getY(), (Number)center.getZ()), (Number)5, (Number)0.5, (Number)5);
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        ArrayList players = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityPlayer.class, (AxisAlignedBB)bb);
        CollectionsKt.removeAll((List)players, arg_0 -> TileDomainLobby.findFreeDomain$lambda$1(center, arg_0));
        if (forcePlayer != null) {
            Object[] objectArray = new EntityPlayer[]{forcePlayer};
            players = CollectionsKt.arrayListOf((Object[])objectArray);
        }
        if (players.isEmpty()) {
            return;
        }
        Domain domain = AlfheimAPI.INSTANCE.getDomains().get(this.name);
        if (domain == null) {
            return;
        }
        Domain domain2 = domain;
        if (forcePlayer == null) {
            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            if (ExtensionsKt.isMultiPlayer((MinecraftServer)minecraftServer) && players.size() < domain2.getMinPlayers()) {
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EntityPlayer it = (EntityPlayer)element$iv;
                    boolean bl = false;
                    ASJUtilities.say((ICommandSender)((ICommandSender)it), (String)"alfheimmisc.ragnarok.domain.notEnoughParticipants", (Object[])new Object[0]);
                }
                this.cooldown = 300;
                return;
            }
        }
        if (forcePlayer == null && !domain2.canEnter(players)) {
            this.cooldown = 300;
            return;
        }
        World domainWorld = null;
        try {
            domainWorld = (World)MinecraftServer.func_71276_C().func_71218_a(AlfheimConfigHandler.INSTANCE.getDimensionIDDomains());
        }
        catch (RuntimeException e) {
            ASJUtilities.error((String)("Cannot load world for domains dimension: " + e.getMessage()), (Throwable)e);
            return;
        }
        int x = domain2.getId() * AlfheimConfigHandler.INSTANCE.getDomainDistance() + AlfheimConfigHandler.INSTANCE.getDomainStartX();
        int n = AlfheimConfigHandler.INSTANCE.getDomainMaxCount();
        for (int c = 0; c < n; ++c) {
            int z = c * AlfheimConfigHandler.INSTANCE.getDomainDistance() + AlfheimConfigHandler.INSTANCE.getDomainStartZ();
            if (((WorldServer)domainWorld).func_147437_c(x, 0, z)) {
                ChunkCoordinates bl = domain2.getGenOffset();
                int i2 = ExtensionsKt.component1((ChunkCoordinates)bl);
                int j = ExtensionsKt.component2((ChunkCoordinates)bl);
                int k = ExtensionsKt.component3((ChunkCoordinates)bl);
                SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)domainWorld, (int)(x + i2), (int)(64 + j), (int)(z + k), (String)domain2.getSchema(), (boolean)true, (boolean)false, (boolean)false, (int)0, (int)448, null);
                ((WorldServer)domainWorld).func_147449_b(x, 0, z, AlfheimBlocks.INSTANCE.getBarrier());
            } else {
                AxisAlignedBB axisAlignedBB = domain2.getBoundBox().func_72329_c().func_72317_d(ExtensionsKt.getD((Number)x), 64.0, ExtensionsKt.getD((Number)z));
                Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"offset(...)");
                if (!((Collection)ExtensionsKt.getEntitiesWithinAABB((World)domainWorld, EntityPlayer.class, (AxisAlignedBB)axisAlignedBB)).isEmpty()) continue;
            }
            Iterable $this$forEach$iv = players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityPlayer it = (EntityPlayer)element$iv;
                boolean bl = false;
                ExtensionsKt.getPersistentData((EntityPlayer)it).func_74783_a(TAG_DOMAIN_ENTRANCE, ArraysKt.plus((int[])ArraysKt.toIntArray((Integer[])center.mf()), (int)it.field_71093_bK));
                AlfheimHookHandler.INSTANCE.setAllowtp(true);
                ASJUtilities.sendToDimensionWithoutPortal((Entity)((Entity)it), (int)AlfheimConfigHandler.INSTANCE.getDimensionIDDomains(), (double)((double)x + 0.5), (double)65.0, (double)((double)z + 0.5));
            }
            domain2.restart(domainWorld, x, 64, z, players);
            return;
        }
        this.cooldown = 600;
        ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public final void doParticles() {
        if (this.countdown < 0) {
            return;
        }
        Vector3 center = Vector3.Companion.fromTileEntityCenter((TileEntity)this).add((Number)0, (Number)-3, (Number)-7);
        Vector3 rotator = Vector3.mul$default((Vector3)Vector3.Companion.getOZ().copy(), (Number)5, null, null, (int)6, null);
        for (int c = 0; c < 360; ++c) {
            Vector3 vector3 = rotator.add(center);
            double x = vector3.component1();
            double y = vector3.component2();
            double z = vector3.component3();
            Vec3 vec3 = ASJRenderHelper.INSTANCE.toVec3(new Color(ItemIridescent.Companion.rainbowColor()));
            double r = ExtensionsKt.component1((Vec3)vec3);
            double g = ExtensionsKt.component2((Vec3)vec3);
            double b = ExtensionsKt.component3((Vec3)vec3);
            Botania.proxy.wispFX(this.field_145850_b, x, y, z, ExtensionsKt.getF((Number)r), ExtensionsKt.getF((Number)g), ExtensionsKt.getF((Number)b), 0.5f);
            rotator.sub(center).rotateOY((Number)1);
        }
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.writeCustomNBT(nbt);
        nbt.func_74778_a(TAG_DOMAIN_NAME, this.name);
        nbt.func_74768_a(TAG_COOLDOWN, this.cooldown);
        nbt.func_74768_a(TAG_COUNTDOWN, this.countdown);
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readCustomNBT(nbt);
        String string = nbt.func_74779_i(TAG_DOMAIN_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.name = string;
        this.cooldown = nbt.func_74762_e(TAG_COOLDOWN);
        this.countdown = nbt.func_74762_e(TAG_COUNTDOWN);
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return ExtensionsKt.expand((AxisAlignedBB)ExtensionsKt.boundingBox$default((TileEntity)((TileEntity)this), null, (int)1, null), (Number)2, (Number)2, (Number)0);
    }

    private static final boolean findFreeDomain$lambda$1(Vector3 $center, EntityPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Vector3 vector3 = Vector3.Companion.fromEntity((Entity)it);
        double px = vector3.component1();
        double pz = vector3.component3();
        double cx = $center.component1();
        double cz = $center.component3();
        return Vector3.Companion.pointDistancePlane((Number)cx, (Number)cz, (Number)px, (Number)pz) > 5.0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lalfheim/common/block/tile/TileDomainLobby$Companion;", "", "<init>", "()V", "TAG_COOLDOWN", "", "TAG_COUNTDOWN", "TAG_DOMAIN_NAME", "TAG_DOMAIN_ENTRANCE", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

