/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile.sub.flower;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.block.tile.sub.flower.HashableItemStack;
import alfheim.common.block.tile.sub.flower.LimitedHashQueueArray;
import alfheim.common.block.tile.sub.flower.SubTileGourmaryllisUltraKt;
import alfheim.common.core.handler.VisualEffectHandler;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.lexicon.LexiconData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lalfheim/common/block/tile/sub/flower/SubTileGourmaryllisUltra;", "Lvazkii/botania/api/subtile/SubTileGenerating;", "<init>", "()V", "cooldown", "", "storedMana", "lastFood", "Lalfheim/common/block/tile/sub/flower/LimitedHashQueueArray;", "Lalfheim/common/block/tile/sub/flower/HashableItemStack;", "lastFoodIndex", "worldObj", "Lnet/minecraft/world/World;", "getWorldObj", "()Lnet/minecraft/world/World;", "onUpdate", "", "writeToPacketNBT", "cmp", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromPacketNBT", "getRadius", "Lvazkii/botania/api/subtile/RadiusDescriptor$Square;", "getMaxMana", "getColor", "getEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "Companion", "Alfheim"})
public final class SubTileGourmaryllisUltra
extends SubTileGenerating {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int cooldown;
    private int storedMana;
    @NotNull
    private LimitedHashQueueArray<HashableItemStack> lastFood = new LimitedHashQueueArray(0, 1, null);
    private int lastFoodIndex = -1;
    @NotNull
    private static final String TAG_COOLDOWN = "cooldown";
    @NotNull
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    @NotNull
    private static final String TAG_LAST_FOOD = "lastFood";
    @NotNull
    private static final String TAG_LAST_FOOD_INDEX = "lastFoodIndex";
    @NotNull
    private static final String TAG_LAST_FOOD_SIZE = "lastFoodSize";
    private static final int RANGE = 1;

    @NotNull
    public final World getWorldObj() {
        World world = this.supertile.func_145831_w();
        Intrinsics.checkNotNull((Object)world);
        return world;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.getWorldObj().field_72995_K) {
            return;
        }
        if (this.cooldown > -1) {
            int n = this.cooldown;
            this.cooldown = n + -1;
        }
        TileEntity tileEntity = this.supertile;
        Intrinsics.checkNotNullExpressionValue((Object)tileEntity, (String)"supertile");
        Vector3 vector3 = Vector3.Companion.fromTileEntityCenter(tileEntity);
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        if (this.storedMana != 0) {
            ItemStack lastFood = this.lastFood.get((HashableItemStack)this.lastFoodIndex).getStack();
            int lastFoodCount = lastFood.field_77994_a;
            int munchInterval = Math.max(2 + 2 * lastFoodCount, 4);
            if (this.cooldown == 0) {
                this.mana = Math.min(this.getMaxMana(), this.mana + this.storedMana);
                this.storedMana = 0;
                float burpPitch = 1.0f - (float)(lastFoodCount - 1) * 0.05f;
                this.getWorldObj().func_72908_a(x, y, z, "random.burp", 1.0f, burpPitch);
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.getWorldObj().func_72908_a(x, y, z, "random.eat", 0.5f, 1.0f);
                int id = Item.func_150891_b((Item)lastFood.func_77973_b());
                int meta = lastFood.func_77981_g() ? lastFood.func_77960_j() : -1;
                double[] dArray = new double[]{x, y, z, ExtensionsKt.getD((Number)id), ExtensionsKt.getD((Number)meta)};
                VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ICONCRACK, this.getWorldObj().field_73011_w.field_76574_g, dArray);
            }
        }
        if (this.cooldown > 0) {
            return;
        }
        int slowdown = this.getSlowdownFactor();
        World world = this.getWorldObj();
        TileEntity tileEntity2 = this.supertile;
        Intrinsics.checkNotNullExpressionValue((Object)tileEntity2, (String)"supertile");
        ArrayList items = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityItem.class, (AxisAlignedBB)ExtensionsKt.boundingBox((TileEntity)tileEntity2, (Number)1));
        Iterator iterator = items.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack stack;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            EntityItem item = (EntityItem)e;
            if (item.func_92059_d() == null || !(stack.func_77973_b() instanceof ItemFood) || stack.field_77994_a <= 0 || item.field_70128_L || item.field_70292_b < slowdown) continue;
            ItemStack itemStack = stack.func_77946_l();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            HashableItemStack hash = SubTileGourmaryllisUltraKt.access$getHash(itemStack);
            HashableItemStack cached = this.lastFood.get(hash);
            int lastFoodCount = 0;
            if (cached != null) {
                ItemStack itemStack2 = cached.getStack();
                ++itemStack2.field_77994_a;
                lastFoodCount = itemStack2.field_77994_a;
                this.lastFoodIndex = this.lastFood.indexOf(cached);
            } else {
                this.lastFoodIndex = this.lastFood.push(hash);
                lastFoodCount = 1;
            }
            Item item2 = stack.func_77973_b();
            Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type net.minecraft.item.ItemFood");
            int heal = ((ItemFood)item2).func_150905_g(stack);
            this.storedMana = Math.max(0, ExtensionsKt.getI((Number)((double)(heal * heal * 64) * ((double)(1.0f - (float)lastFoodCount / 8.0f) + 0.125))));
            this.cooldown = heal * 10;
            item.func_85030_a("random.eat", 0.2f, 0.6f);
            this.sync();
            int id = Item.func_150891_b((Item)stack.func_77973_b());
            int meta = stack.func_77981_g() ? stack.func_77960_j() : -1;
            double[] dArray = new double[]{x, y, z, ExtensionsKt.getD((Number)id), ExtensionsKt.getD((Number)meta)};
            VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ICONCRACK, this.getWorldObj().field_73011_w.field_76574_g, dArray);
            stack.field_77994_a += -1;
            if (stack.field_77994_a > 0) break;
            item.func_70106_y();
            break;
        }
    }

    public void writeToPacketNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74768_a(TAG_DIGESTING_MANA, this.storedMana);
        cmp.func_74768_a(TAG_LAST_FOOD_INDEX, this.lastFoodIndex);
        cmp.func_74768_a(TAG_LAST_FOOD_SIZE, this.lastFood.getSize());
        int n = this.lastFood.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            cmp.func_74782_a(TAG_LAST_FOOD + i2, (NBTBase)this.lastFood.get((HashableItemStack)i2).getStack().func_77955_b(new NBTTagCompound()));
        }
    }

    public void readFromPacketNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
        this.storedMana = cmp.func_74762_e(TAG_DIGESTING_MANA);
        this.lastFoodIndex = cmp.func_74762_e(TAG_LAST_FOOD_INDEX);
        int n = cmp.func_74762_e(TAG_LAST_FOOD_SIZE);
        for (int i2 = 0; i2 < n; ++i2) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)cmp.func_74775_l(TAG_LAST_FOOD + i2));
            Intrinsics.checkNotNull((Object)stack);
            this.lastFood.push(new HashableItemStack(stack, 0, 2, null));
        }
    }

    @NotNull
    public RadiusDescriptor.Square getRadius() {
        return new RadiusDescriptor.Square(this.toChunkCoordinates(), 1);
    }

    public int getMaxMana() {
        return 9000;
    }

    public int getColor() {
        return 13882884;
    }

    @NotNull
    public LexiconEntry getEntry() {
        LexiconEntry lexiconEntry = LexiconData.gourmaryllis;
        Intrinsics.checkNotNull((Object)lexiconEntry);
        return lexiconEntry;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lalfheim/common/block/tile/sub/flower/SubTileGourmaryllisUltra$Companion;", "", "<init>", "()V", "TAG_COOLDOWN", "", "TAG_DIGESTING_MANA", "TAG_LAST_FOOD", "TAG_LAST_FOOD_INDEX", "TAG_LAST_FOOD_SIZE", "RANGE", "", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

