/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.api.network.AlfheimPacket;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.core.handler.ESMHandler;
import alfheim.common.core.helper.ElvenFlightHelper;
import alfheim.common.core.helper.ElvenFlightHelperKt;
import alfheim.common.network.M2d;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.Message2d;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lalfheim/common/core/handler/ElvenFlightHandler;", "", "<init>", "()V", "onEntityConstructing", "", "e", "Lnet/minecraftforge/event/entity/EntityEvent$EntityConstructing;", "onClonePlayer", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onPlayerRespawn", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPlayerChangeDimension", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerUpdate", "Lcpw/mods/fml/common/gameevent/TickEvent$PlayerTickEvent;", "onPlayerSlept", "Lnet/minecraftforge/event/entity/player/PlayerWakeUpEvent;", "Alfheim"})
public final class ElvenFlightHandler {
    @NotNull
    public static final ElvenFlightHandler INSTANCE = new ElvenFlightHandler();

    private ElvenFlightHandler() {
    }

    @SubscribeEvent
    public final void onEntityConstructing(@NotNull EntityEvent.EntityConstructing e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            return;
        }
        if (!(e.entity instanceof EntityPlayer)) {
            return;
        }
        Entity entity = e.entity;
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
        ElvenFlightHelper.INSTANCE.ensureExistence((EntityPlayer)entity);
    }

    @SubscribeEvent
    public final void onClonePlayer(@NotNull PlayerEvent.Clone e) {
        double d;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            return;
        }
        EntityPlayer entityPlayer = e.entityPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"entityPlayer");
        if (e.wasDeath) {
            d = 0.0;
        } else {
            EntityPlayer entityPlayer2 = e.original;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"original");
            d = ElvenFlightHelperKt.getFlight(entityPlayer2);
        }
        ElvenFlightHelperKt.setFlight(entityPlayer, d);
    }

    @SubscribeEvent
    public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            return;
        }
        if (ArraysKt.contains((int[])AlfheimConfigHandler.INSTANCE.getWingsBlackList(), (int)e.player.field_70170_p.field_73011_w.field_76574_g)) {
            return;
        }
        PlayerCapabilities playerCapabilities = e.player.field_71075_bZ;
        EntityPlayer entityPlayer = e.player;
        Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"player");
        playerCapabilities.field_75101_c = EnumRaceKt.getRace(entityPlayer) != EnumRace.HUMAN;
    }

    @SubscribeEvent
    public final void onPlayerChangeDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            return;
        }
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayer entityPlayer = e.player;
        Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"player");
        AlfheimPacket alfheimPacket = new Message2d(M2d.ATTRIBUTE, 1.0, ElvenFlightHelperKt.getFlight(entityPlayer), 0, 8, null);
        EntityPlayer entityPlayer2 = e.player;
        Intrinsics.checkNotNull((Object)entityPlayer2, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        NetworkService.INSTANCE.sendTo(alfheimPacket, (EntityPlayerMP)entityPlayer2);
    }

    @SubscribeEvent
    public final void onPlayerUpdate(@NotNull TickEvent.PlayerTickEvent e) {
        EntityPlayer player;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.phase == TickEvent.Phase.START) {
                    return;
                }
                player = e.player;
                if (player instanceof EntityPlayerMP) {
                    CardinalSystem.PlayerSegment playerSegment = CardinalSystem.INSTANCE.forPlayer(player);
                    int n = playerSegment.getFlightEnableCooldown();
                    playerSegment.setFlightEnableCooldown(n + -1);
                }
                if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) break block12;
                Intrinsics.checkNotNull((Object)player);
                if (EnumRaceKt.getRace(player) != EnumRace.HUMAN && !ESMHandler.INSTANCE.isAbilityDisabled(player) && !ArraysKt.contains((int[])AlfheimConfigHandler.INSTANCE.getWingsBlackList(), (int)player.field_70170_p.field_73011_w.field_76574_g)) break block13;
            }
            return;
        }
        Item item = ModItems.flightTiara;
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type vazkii.botania.common.item.equipment.bauble.ItemFlightTiara");
        if (((ItemFlightTiara)item).shouldPlayerHaveFlight(player)) {
            ElvenFlightHelper.INSTANCE.regen(player, player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && player.field_70122_E && player.func_70093_af() ? 2 : 1);
            return;
        }
        if (ElvenFlightHelperKt.getFlight(player) >= 0.0 && ElvenFlightHelperKt.getFlight(player) <= ElvenFlightHelper.INSTANCE.getMax()) {
            if (player.field_71075_bZ.field_75100_b) {
                if (player.func_70051_ag()) {
                    player.func_70060_a(0.0f, 1.0f, 0.00625f);
                }
                ElvenFlightHelper.INSTANCE.sub(player, player.func_70051_ag() ? 3 : (Math.abs(player.field_70159_w) > (double)1.0E-4f || player.field_70181_x > (double)1.0E-4f || Math.abs(player.field_70179_y) > (double)1.0E-4f ? 2 : 1));
            } else {
                ElvenFlightHelper.INSTANCE.regen(player, player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && player.field_70122_E && player.func_70093_af() ? 2 : 1);
            }
        }
        if (ElvenFlightHelperKt.getFlight(player) <= 0.0) {
            player.field_71075_bZ.field_75100_b = false;
            if (player instanceof EntityPlayerMP) {
                CardinalSystem.INSTANCE.forPlayer(player).setFlightEnableCooldown(ExtensionsKt.getI((Number)(ElvenFlightHelper.INSTANCE.getMax() / (double)10)) + 1);
            }
        }
    }

    @SubscribeEvent
    public final void onPlayerSlept(@NotNull PlayerWakeUpEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            return;
        }
        EntityPlayer entityPlayer = e.entityPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"entityPlayer");
        ElvenFlightHelperKt.setFlight(entityPlayer, ElvenFlightHelper.INSTANCE.getMax());
    }
}

