/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity.ai.elf;

import alfheim.common.entity.EntityElf;
import alfheim.common.entity.ai.elf.DialogPattern;
import alfheim.common.entity.ai.elf.EntityElfDialogLogicKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lalfheim/common/entity/ai/elf/Dialog;", "", "pattern", "Lalfheim/common/entity/ai/elf/DialogPattern;", "elf", "Lalfheim/common/entity/EntityElf;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "<init>", "(Lalfheim/common/entity/ai/elf/DialogPattern;Lalfheim/common/entity/EntityElf;Lnet/minecraft/entity/player/EntityPlayer;)V", "getPattern", "()Lalfheim/common/entity/ai/elf/DialogPattern;", "getElf", "()Lalfheim/common/entity/EntityElf;", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayer;", "start", "onInteract", "", "end", "Alfheim"})
public class Dialog {
    @NotNull
    private final DialogPattern pattern;
    @NotNull
    private final EntityElf elf;
    @NotNull
    private final EntityPlayer player;

    public Dialog(@NotNull DialogPattern pattern, @NotNull EntityElf elf, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)elf, (String)"elf");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.pattern = pattern;
        this.elf = elf;
        this.player = player;
    }

    @NotNull
    public final DialogPattern getPattern() {
        return this.pattern;
    }

    @NotNull
    public final EntityElf getElf() {
        return this.elf;
    }

    @NotNull
    public final EntityPlayer getPlayer() {
        return this.player;
    }

    @Nullable
    public Dialog start() {
        this.pattern.greet(this.elf, this.player);
        if (this.pattern.getStartingLines().length == 0) {
            this.pattern.goodbye(this.elf, this.player);
            return null;
        }
        EntityElfDialogLogicKt.access$addDialogOptions(this.player, this.pattern.getStartingLines());
        return this;
    }

    public void onInteract(@NotNull EntityElf elf, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)elf, (String)"elf");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    public void end() {
        this.pattern.goodbye(this.elf, this.player);
        this.elf.setDialog(null);
        this.elf.setInteractor(null);
    }
}

