/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity.ai.elf;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.entity.EnumRace;
import alfheim.api.network.AlfheimPacket;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.entity.EntityElf;
import alfheim.common.entity.ai.elf.Dialog;
import alfheim.common.entity.ai.elf.DialogPattern;
import alfheim.common.entity.ai.elf.EntityElfDialogLogicKt;
import alfheim.common.entity.ai.elf.JunkmanDialog;
import alfheim.common.entity.ai.elf.Response;
import alfheim.common.network.M1d;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.Message1d;
import com.google.gson.Gson;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0007J1\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u001c\u0010#\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0005\u00a2\u0006\u0002\u0010$R)\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR)\u0010\f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\nR)\u0010\u000e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lalfheim/common/entity/ai/elf/EntityElfDialogLogic;", "", "<init>", "()V", "commonDialogs", "", "Ljava/util/ArrayList;", "Lalfheim/common/entity/ai/elf/DialogPattern;", "Lkotlin/collections/ArrayList;", "getCommonDialogs", "()[Ljava/util/ArrayList;", "[Ljava/util/ArrayList;", "merchantDialogs", "getMerchantDialogs", "guardDialogs", "getGuardDialogs", "launchDialog", "Lalfheim/common/entity/ai/elf/Dialog;", "elf", "Lalfheim/common/entity/EntityElf;", "speaker", "Lnet/minecraft/entity/player/EntityPlayer;", "endDialogIfPlayerLeft", "", "e", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "chat", "Lnet/minecraftforge/event/ServerChatEvent;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "registerDialog", "file", "Ljava/io/File;", "dialogs", "(Ljava/io/File;[Ljava/util/ArrayList;)V", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nEntityElfDialogLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityElfDialogLogic.kt\nalfheim/common/entity/ai/elf/EntityElfDialogLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,184:1\n295#2,2:185\n13472#3,2:187\n13472#3,2:189\n13537#3,3:191\n*S KotlinDebug\n*F\n+ 1 EntityElfDialogLogic.kt\nalfheim/common/entity/ai/elf/EntityElfDialogLogic\n*L\n67#1:185,2\n77#1:187,2\n122#1:189,2\n125#1:191,3\n*E\n"})
public final class EntityElfDialogLogic {
    @NotNull
    public static final EntityElfDialogLogic INSTANCE;
    @NotNull
    private static final ArrayList<DialogPattern>[] commonDialogs;
    @NotNull
    private static final ArrayList<DialogPattern>[] merchantDialogs;
    @NotNull
    private static final ArrayList<DialogPattern>[] guardDialogs;
    @NotNull
    private static final Gson gson;

    private EntityElfDialogLogic() {
    }

    @NotNull
    public final ArrayList<DialogPattern>[] getCommonDialogs() {
        return commonDialogs;
    }

    @NotNull
    public final ArrayList<DialogPattern>[] getMerchantDialogs() {
        return merchantDialogs;
    }

    @NotNull
    public final ArrayList<DialogPattern>[] getGuardDialogs() {
        return guardDialogs;
    }

    @Nullable
    public final Dialog launchDialog(@NotNull EntityElf elf, @NotNull EntityPlayer speaker) {
        DialogPattern dialogPattern;
        Intrinsics.checkNotNullParameter((Object)elf, (String)"elf");
        Intrinsics.checkNotNullParameter((Object)speaker, (String)"speaker");
        int lvl = CardinalSystem.ElvenReputationSystem.INSTANCE.getReputationLevel(speaker, elf.getRace());
        if (lvl < -1) {
            ASJUtilities.say((ICommandSender)((ICommandSender)speaker), (String)("dialog.nodialog" + lvl), (Object[])new Object[0]);
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[elf.getJob().ordinal()]) {
            case 1: {
                Collection collection = commonDialogs[0];
                Random random = elf.func_70681_au();
                Intrinsics.checkNotNullExpressionValue((Object)random, (String)"getRNG(...)");
                dialogPattern = (DialogPattern)ExtensionsKt.random((Collection)collection, (Random)random);
                break;
            }
            case 2: {
                Collection collection = commonDialogs[elf.getRace().ordinal()];
                Random random = elf.func_70681_au();
                Intrinsics.checkNotNullExpressionValue((Object)random, (String)"getRNG(...)");
                dialogPattern = (DialogPattern)ExtensionsKt.random((Collection)collection, (Random)random);
                break;
            }
            case 3: {
                if (elf.getJobSubrole() == 0) {
                    return new JunkmanDialog(elf, speaker);
                }
                Collection collection = merchantDialogs[elf.getRace().ordinal() - 1];
                Random random = elf.func_70681_au();
                Intrinsics.checkNotNullExpressionValue((Object)random, (String)"getRNG(...)");
                dialogPattern = (DialogPattern)ExtensionsKt.random((Collection)collection, (Random)random);
                break;
            }
            case 4: {
                Collection collection = guardDialogs[elf.getRace().ordinal() - 1];
                Random random = elf.func_70681_au();
                Intrinsics.checkNotNullExpressionValue((Object)random, (String)"getRNG(...)");
                dialogPattern = (DialogPattern)ExtensionsKt.random((Collection)collection, (Random)random);
                break;
            }
            case 5: {
                throw new NotImplementedError(null, 1, null);
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (dialogPattern == null) {
            return null;
        }
        DialogPattern pattern = dialogPattern;
        return new Dialog(pattern, elf, speaker).start();
    }

    @SubscribeEvent
    public final void endDialogIfPlayerLeft(@NotNull LivingEvent.LivingUpdateEvent e) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EntityLivingBase entityLivingBase = e.entityLiving;
            EntityElf entityElf = entityLivingBase instanceof EntityElf ? (EntityElf)entityLivingBase : null;
            if (entityElf == null) {
                return;
            }
            EntityElf elf = entityElf;
            EntityPlayer entityPlayer = elf.getInteractor();
            if (entityPlayer == null) {
                return;
            }
            EntityPlayer player = entityPlayer;
            if (Vector3.Companion.entityDistance((Entity)elf, (Entity)player) < 5.0) {
                return;
            }
            if (player instanceof EntityPlayerMP) {
                NetworkService.INSTANCE.sendTo(new Message1d(M1d.RLCM, 0.0, 0, 4, null), (EntityPlayerMP)player);
            }
            Dialog dialog = elf.getDialog();
            if (dialog == null) break block4;
            dialog.end();
        }
    }

    @SubscribeEvent
    public final void chat(@NotNull ServerChatEvent e) {
        boolean wontEnd;
        Object v2;
        block8: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EntityPlayerMP entityPlayerMP = e.player;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayerMP, (String)"player");
            Vector3 vector3 = Vector3.Companion.fromEntity((Entity)entityPlayerMP);
            double x = vector3.component1();
            double y = vector3.component2();
            double z = vector3.component3();
            World world = e.player.field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
            ArrayList list = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityElf.class, (AxisAlignedBB)ExtensionsKt.expand((AxisAlignedBB)ExtensionsKt.getBoundingBox((Number)x, (Number)y, (Number)z), (Number)5));
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityElf it = (EntityElf)element$iv;
                boolean bl = false;
                if (!(it.getDialog() != null && it.getInteractor() == e.player)) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        EntityElf entityElf = v2;
        if (entityElf == null) {
            return;
        }
        EntityElf chattingWith = entityElf;
        Dialog dialog = chattingWith.getDialog();
        Intrinsics.checkNotNull((Object)dialog);
        Response response = dialog.getPattern().getConversations().get(e.message);
        if (response == null) {
            return;
        }
        Response response2 = response;
        AlfheimPacket alfheimPacket = new Message1d(M1d.RLCM, 1.0, 0, 4, null);
        EntityPlayerMP entityPlayerMP = e.player;
        Intrinsics.checkNotNullExpressionValue((Object)entityPlayerMP, (String)"player");
        NetworkService.INSTANCE.sendTo(alfheimPacket, entityPlayerMP);
        boolean bl = wontEnd = !(response2.getContinuation().length == 0);
        if (wontEnd) {
            ASJUtilities.say((ICommandSender)((ICommandSender)e.player), (String)("\u00a7b\u00a7m" + StringsKt.repeat((CharSequence)" ", (int)64)), (Object[])new Object[0]);
        }
        String[] $this$forEach$iv = response2.getAnswerlines();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            ASJUtilities.say((ICommandSender)((ICommandSender)e.player), (String)it, (Object[])new Object[0]);
        }
        if (!(response2.getAnswerlines().length == 0)) {
            ASJUtilities.say((ICommandSender)((ICommandSender)e.player), (String)"", (Object[])new Object[0]);
        }
        if (wontEnd) {
            EntityPlayerMP entityPlayerMP2 = e.player;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayerMP2, (String)"player");
            EntityElfDialogLogicKt.access$addDialogOptions((EntityPlayer)entityPlayerMP2, response2.getContinuation());
        } else {
            Dialog dialog2 = chattingWith.getDialog();
            Intrinsics.checkNotNull((Object)dialog2);
            dialog2.end();
        }
        e.setCanceled(true);
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerDialog(@NotNull File file, @NotNull ArrayList<DialogPattern>[] dialogs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(dialogs, (String)"dialogs");
        DialogPattern pattern = (DialogPattern)gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), DialogPattern.class);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((CharSequence)string, (char)'A', (boolean)false, (int)2, null)) {
            ArrayList<DialogPattern>[] $this$forEach$iv = dialogs;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                ArrayList<DialogPattern> element$iv;
                ArrayList<DialogPattern> it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                ((Collection)it).add(pattern);
            }
            return;
        }
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (StringsKt.startsWith$default((CharSequence)string2, (char)'E', (boolean)false, (int)2, null)) {
            ArrayList<DialogPattern>[] $this$forEachIndexed$iv = dialogs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ArrayList<DialogPattern> item$iv : $this$forEachIndexed$iv) {
                void it;
                int n = index$iv++;
                ArrayList<DialogPattern> bl = item$iv;
                int id = n;
                boolean bl2 = false;
                if (id == 0) continue;
                ((Collection)it).add(pattern);
            }
            return;
        }
        dialogs[file.getName().charAt(0)].add(pattern);
    }

    static {
        Path path;
        int n;
        INSTANCE = new EntityElfDialogLogic();
        int n2 = 0;
        int n3 = EnumRace.getEntries().size() - 1;
        ArrayList[] arrayListArray = new ArrayList[n3];
        while (n2 < n3) {
            n = n2++;
            arrayListArray[n] = new ArrayList();
        }
        commonDialogs = arrayListArray;
        n2 = 0;
        n3 = EnumRace.getEntries().size() - 2;
        arrayListArray = new ArrayList[n3];
        while (n2 < n3) {
            n = n2++;
            arrayListArray[n] = new ArrayList();
        }
        merchantDialogs = arrayListArray;
        n2 = 0;
        n3 = EnumRace.getEntries().size() - 2;
        arrayListArray = new ArrayList[n3];
        while (n2 < n3) {
            n = n2++;
            arrayListArray[n] = new ArrayList();
        }
        guardDialogs = arrayListArray;
        gson = new Gson();
        ExtensionsKt.eventForge((Object)INSTANCE);
        URL uRL = INSTANCE.getClass().getResource("/assets/alfheim/dialogs/");
        Intrinsics.checkNotNull((Object)uRL);
        URI uri = uRL.toURI();
        if (uri.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(...)");
            FileSystem fileSystem2 = fileSystem;
            path = fileSystem2.getPath("/assets/alfheim/dialogs/", new String[0]);
        } else {
            path = Paths.get(uri);
        }
        Path root = path;
        Stream<Path> stream = Files.walk(root, 1, new FileVisitOption[0]);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(...)");
        Stream<Path> walk = stream;
        Iterator iterator = walk.iterator();
        while (iterator.hasNext()) {
            File[] files;
            Path dir = (Path)iterator.next();
            if (dir.toFile().listFiles() == null) continue;
            block14: for (File file : files) {
                String string;
                if (!file.isFile() || (string = file.getParentFile().getName()) == null) continue;
                int n4 = -1;
                switch (string.hashCode()) {
                    case -1354814997: {
                        if (string.equals("common")) {
                            n4 = 1;
                        }
                        break;
                    }
                    case 98705061: {
                        if (string.equals("guard")) {
                            n4 = 2;
                        }
                        break;
                    }
                    case -505296440: {
                        if (string.equals("merchant")) {
                            n4 = 3;
                        }
                        break;
                    }
                }
                switch (n4) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)file);
                        INSTANCE.registerDialog(file, commonDialogs);
                        continue block14;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)file);
                        INSTANCE.registerDialog(file, guardDialogs);
                        continue block14;
                    }
                    case 3: {
                        Intrinsics.checkNotNull((Object)file);
                        INSTANCE.registerDialog(file, merchantDialogs);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityElf.EnumElfJob.values().length];
            try {
                nArray[EntityElf.EnumElfJob.WILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityElf.EnumElfJob.CITIZEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityElf.EnumElfJob.MERCHANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityElf.EnumElfJob.GUARD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityElf.EnumElfJob.PRAETOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityElf.EnumElfJob.PRIEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

