/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.floatingisland;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.BlockElement;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.LocationElement;
import alfheim.common.floatingisland.EntityFloatingIsland;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.MessageFIBlock;
import alfheim.common.world.dim.alfheim.biome.BiomeField;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001XB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJP\u0010)\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010** \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\"\u0012\u0004\u0012\u0002H*0+2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0082\u0002\u00a2\u0006\u0002\u0010/JX\u00100\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010** \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\"\u0012\u0004\u0012\u0002H*0!2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u00101\u001a\u0002H*H\u0082\u0002\u00a2\u0006\u0002\u00102J\b\u00107\u001a\u000208H\u0002J(\u00109\u001a\u0002082\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010:\u001a\u00020\fH\u0002J\u0006\u0010;\u001a\u000208J\u0006\u0010<\u001a\u00020=J\f\u0010>\u001a\u00020?*\u00020@H\u0002JF\u0010A\u001a\u0002082\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020\f2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010F\u001a\u00020GJ \u0010H\u001a\u00020C2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0016J \u0010I\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0016J\"\u0010J\u001a\u0004\u0018\u00010'2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0016J \u0010K\u001a\u00020G2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0016J(\u0010L\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010M\u001a\u00020\fH\u0016J(\u0010N\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010O\u001a\u00020\fH\u0016J\u0018\u0010P\u001a\u00020Q2\u0006\u0010,\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0016J\b\u0010R\u001a\u00020\fH\u0016J\b\u0010S\u001a\u00020GH\u0016J0\u0010T\u001a\u00020G2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010O\u001a\u00020U2\u0006\u0010V\u001a\u00020GH\u0016J\b\u0010W\u001a\u000208H\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R/\u0010 \u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\"\u0012\u0004\u0012\u00020#0!\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R/\u0010&\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\"\u0012\u0004\u0012\u00020'0!\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u000106X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lalfheim/common/floatingisland/FloatingIslandBlockAccess;", "Lnet/minecraft/world/IBlockAccess;", "blocks", "", "Lalexsocol/asjlib/BlockElement;", "host", "Lalfheim/common/floatingisland/EntityFloatingIsland;", "<init>", "(Ljava/util/List;Lalfheim/common/floatingisland/EntityFloatingIsland;)V", "getHost", "()Lalfheim/common/floatingisland/EntityFloatingIsland;", "startX", "", "getStartX", "()I", "setStartX", "(I)V", "startY", "getStartY", "setStartY", "startZ", "getStartZ", "setStartZ", "endX", "getEndX", "setEndX", "endY", "getEndY", "setEndY", "endZ", "getEndZ", "setEndZ", "blockMap", "", "Lkotlin/Triple;", "Lalfheim/common/floatingisland/FloatingIslandBlockAccess$BlockData;", "getBlockMap", "()Ljava/util/Map;", "tileList", "Lnet/minecraft/tileentity/TileEntity;", "getTileList", "get", "T", "", "x", "y", "z", "(Ljava/util/Map;III)Ljava/lang/Object;", "set", "bd", "(Ljava/util/Map;IIILjava/lang/Object;)Ljava/lang/Object;", "executor", "Ljava/util/concurrent/ExecutorService;", "future", "Ljava/util/concurrent/Future;", "recalculateLight", "", "spreadLight", "lightValue", "tickLight", "toSchema", "", "getJson", "Lcom/google/gson/JsonObject;", "Lalexsocol/asjlib/LocationElement;", "setBlock", "block", "Lnet/minecraft/block/Block;", "meta", "tile", "sync", "", "getBlock", "getBlockMetadata", "getTileEntity", "isAirBlock", "getLightBrightnessForSkyBlocks", "blockMin", "isBlockProvidingPowerTo", "side", "getBiomeGenForCoords", "Lnet/minecraft/world/biome/BiomeGenBase;", "getHeight", "extendedLevelsInChunkCache", "isSideSolid", "Lnet/minecraftforge/common/util/ForgeDirection;", "default", "finalize", "BlockData", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nFloatingIslandBlockAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingIslandBlockAccess.kt\nalfheim/common/floatingisland/FloatingIslandBlockAccess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,232:1\n1869#2:233\n1869#2:234\n1870#2:236\n1870#2:237\n1#3:235\n216#4,2:238\n216#4,2:240\n216#4,2:242\n*S KotlinDebug\n*F\n+ 1 FloatingIslandBlockAccess.kt\nalfheim/common/floatingisland/FloatingIslandBlockAccess\n*L\n38#1:233\n43#1:234\n43#1:236\n38#1:237\n76#1:238,2\n84#1:240,2\n124#1:242,2\n*E\n"})
public final class FloatingIslandBlockAccess
implements IBlockAccess {
    @NotNull
    private final EntityFloatingIsland host;
    private int startX;
    private int startY;
    private int startZ;
    private int endX;
    private int endY;
    private int endZ;
    @NotNull
    private final Map<Triple<Integer, Integer, Integer>, BlockData> blockMap;
    @NotNull
    private final Map<Triple<Integer, Integer, Integer>, TileEntity> tileList;
    @Nullable
    private final ExecutorService executor;
    @Nullable
    private final Future<?> future;

    public FloatingIslandBlockAccess(@NotNull List<BlockElement> blocks, @NotNull EntityFloatingIsland host) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.startX = Integer.MAX_VALUE;
        this.startY = Integer.MAX_VALUE;
        this.startZ = Integer.MAX_VALUE;
        this.endX = Integer.MIN_VALUE;
        this.endY = Integer.MIN_VALUE;
        this.endZ = Integer.MIN_VALUE;
        this.blockMap = new ConcurrentHashMap();
        this.tileList = new HashMap();
        Iterable $this$forEach$iv = blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block;
            BlockElement e = (BlockElement)element$iv;
            boolean bl = false;
            if (e.getBlock() == null || block == Blocks.field_150350_a) continue;
            Iterable $this$forEach$iv2 = e.getLocation();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TileEntity tileEntity;
                LocationElement l = (LocationElement)element$iv2;
                boolean bl2 = false;
                if (l.getNbt() != null) {
                    String it;
                    boolean bl3 = false;
                    NBTBase nBTBase = JsonToNBT.func_150315_a((String)it);
                    Intrinsics.checkNotNull((Object)nBTBase, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
                    if (TileEntity.func_145827_c((NBTTagCompound)((NBTTagCompound)nBTBase)) != null) {
                        TileEntity tileEntity2;
                        TileEntity $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240 = tileEntity2;
                        boolean bl4 = false;
                        $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.field_145851_c = l.getX();
                        $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.field_145848_d = l.getY();
                        $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.field_145849_e = l.getZ();
                        $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.field_145854_h = block;
                        $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.field_145847_g = l.getMeta();
                        this.set(this.tileList, l.getX(), l.getY(), l.getZ(), $this$lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240);
                        tileEntity = tileEntity2;
                    } else {
                        tileEntity = null;
                    }
                } else {
                    tileEntity = null;
                }
                TileEntity tile = tileEntity;
                this.set(this.blockMap, l.getX(), l.getY(), l.getZ(), new BlockData(block, l.getMeta(), tile, -1, block.func_149750_m()));
                this.startX = Math.min(this.startX, l.getX());
                this.startY = Math.min(this.startY, l.getY());
                this.startZ = Math.min(this.startZ, l.getZ());
                this.endX = Math.max(this.endX, l.getX());
                this.endY = Math.max(this.endY, l.getY());
                this.endZ = Math.max(this.endZ, l.getZ());
            }
        }
        if (ASJUtilities.isClient()) {
            this.executor = Executors.newSingleThreadExecutor();
            this.future = this.executor.submit(() -> FloatingIslandBlockAccess._init_$lambda$4(this));
        } else {
            this.executor = null;
            this.future = null;
        }
    }

    @NotNull
    public final EntityFloatingIsland getHost() {
        return this.host;
    }

    public final int getStartX() {
        return this.startX;
    }

    public final void setStartX(int n) {
        this.startX = n;
    }

    public final int getStartY() {
        return this.startY;
    }

    public final void setStartY(int n) {
        this.startY = n;
    }

    public final int getStartZ() {
        return this.startZ;
    }

    public final void setStartZ(int n) {
        this.startZ = n;
    }

    public final int getEndX() {
        return this.endX;
    }

    public final void setEndX(int n) {
        this.endX = n;
    }

    public final int getEndY() {
        return this.endY;
    }

    public final void setEndY(int n) {
        this.endY = n;
    }

    public final int getEndZ() {
        return this.endZ;
    }

    public final void setEndZ(int n) {
        this.endZ = n;
    }

    @NotNull
    public final Map<Triple<Integer, Integer, Integer>, BlockData> getBlockMap() {
        return this.blockMap;
    }

    @NotNull
    public final Map<Triple<Integer, Integer, Integer>, TileEntity> getTileList() {
        return this.tileList;
    }

    private final <T> T get(Map<Triple<Integer, Integer, Integer>, ? extends T> $this$get, int x, int y, int z) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        return $this$get.get(ExtensionsKt.with((Pair)TuplesKt.to((Object)x, (Object)y), (Object)z));
    }

    private final <T> T set(Map<Triple<Integer, Integer, Integer>, T> $this$set, int x, int y, int z, T bd) {
        Intrinsics.checkNotNullParameter($this$set, (String)"<this>");
        return $this$set.put((Triple<Integer, Integer, Integer>)ExtensionsKt.with((Pair)TuplesKt.to((Object)x, (Object)y), (Object)z), bd);
    }

    private final void recalculateLight() {
        int z;
        int y;
        int x;
        Triple<Integer, Integer, Integer> coords;
        Map.Entry<Triple<Integer, Integer, Integer>, BlockData> entry;
        Map.Entry<Object, BlockData> element$iv;
        HashMap glowingBlocks = new HashMap();
        Map $this$forEach$iv = this.blockMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Object, BlockData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            coords = entry.getKey();
            BlockData data = entry.getValue();
            x = ((Number)coords.component1()).intValue();
            y = ((Number)coords.component2()).intValue();
            z = ((Number)coords.component3()).intValue();
            data.setPreLightValue(data.getBlock().getLightValue((IBlockAccess)this, x, y, z));
            if (data.getPreLightValue() <= 0) continue;
            ((Map)glowingBlocks).put(coords, data.getPreLightValue());
        }
        $this$forEach$iv = glowingBlocks;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            coords = entry.getKey();
            int light = ((Number)((Object)entry.getValue())).intValue();
            x = ((Number)coords.component1()).intValue();
            y = ((Number)coords.component2()).intValue();
            z = ((Number)coords.component3()).intValue();
            this.spreadLight(x, y, z, light);
        }
    }

    private final void spreadLight(int x, int y, int z, int lightValue) {
        if (lightValue <= 0) {
            return;
        }
        BlockData blockData = this.get(this.blockMap, x, y, z);
        if (blockData == null) {
            Block block = Blocks.field_150350_a;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"air");
            blockData = new BlockData(block, 0, null, -1, 0);
        }
        BlockData data = blockData;
        int newLight = lightValue - data.getBlock().getLightOpacity((IBlockAccess)this, x, y, z) / 17;
        if (data.getLightValue() > newLight) {
            return;
        }
        data.setLightValue(Math.max(data.getPreLightValue(), newLight));
        this.set(this.blockMap, x, y, z, data);
        this.spreadLight(x - 1, y, z, data.getLightValue() - 1);
        this.spreadLight(x + 1, y, z, data.getLightValue() - 1);
        this.spreadLight(x, y - 1, z, data.getLightValue() - 1);
        this.spreadLight(x, y + 1, z, data.getLightValue() - 1);
        this.spreadLight(x, y, z - 1, data.getLightValue() - 1);
        this.spreadLight(x, y, z + 1, data.getLightValue() - 1);
    }

    public final void tickLight() {
        block2: {
            ExecutorService executorService = this.executor;
            boolean bl = executorService != null ? executorService.isTerminated() : false;
            if (bl) {
                return;
            }
            Future<?> future = this.future;
            if (!(future != null ? future.isDone() : false)) {
                return;
            }
            this.host.setGlCallList(-1);
            ExecutorService executorService2 = this.executor;
            if (executorService2 == null) break block2;
            executorService2.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toSchema() {
        JsonArray jsonArray;
        Block block;
        BlockData blockdata;
        if (this.blockMap.isEmpty()) {
            return "";
        }
        HashMap<Object, List> elements = new HashMap<Object, List>();
        Map<Triple<Integer, Integer, Integer>, BlockData> $this$forEach$iv = this.blockMap;
        boolean $i$f$forEach = false;
        for (Map.Entry<Triple<Integer, Integer, Integer>, BlockData> element$iv : $this$forEach$iv.entrySet()) {
            String string;
            Map.Entry<Triple<Integer, Integer, Integer>, BlockData> entry = element$iv;
            boolean bl = false;
            Triple<Integer, Integer, Integer> coords = entry.getKey();
            blockdata = entry.getValue();
            int x = ((Number)coords.component1()).intValue();
            int y = ((Number)coords.component2()).intValue();
            int z = ((Number)coords.component3()).intValue();
            block = blockdata.component1();
            int meta = blockdata.component2();
            TileEntity tile = blockdata.component3();
            if (block == Blocks.field_150350_a) continue;
            if (tile != null) {
                NBTTagCompound nBTTagCompound;
                NBTTagCompound it = nBTTagCompound = new NBTTagCompound();
                boolean bl2 = false;
                tile.func_145841_b(it);
                string = nBTTagCompound.toString();
            } else {
                string = null;
            }
            String nbt = string;
            elements.computeIfAbsent(GameRegistry.findUniqueIdentifierFor((Block)block).toString(), arg_0 -> FloatingIslandBlockAccess.toSchema$lambda$10$lambda$9(FloatingIslandBlockAccess::toSchema$lambda$10$lambda$8, arg_0)).add(new LocationElement(x, y, z, meta, nbt));
        }
        JsonArray $this$toSchema_u24lambda_u2413 = jsonArray = new JsonArray();
        boolean bl = false;
        for (String block2 : elements.keySet()) {
            void $this$toSchema_u24lambda_u2413_u24lambda_u2412;
            JsonObject jsonObject = new JsonObject();
            blockdata = jsonObject;
            JsonArray jsonArray2 = $this$toSchema_u24lambda_u2413;
            boolean bl3 = false;
            $this$toSchema_u24lambda_u2413_u24lambda_u2412.addProperty("block", block2);
            JsonArray jsonArray3 = new JsonArray();
            block = jsonArray3;
            String string = "location";
            void var15_21 = $this$toSchema_u24lambda_u2413_u24lambda_u2412;
            boolean bl4 = false;
            List list = (List)elements.get(block2);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (LocationElement v : list) {
                void $this$toSchema_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411;
                $this$toSchema_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.add((JsonElement)this.getJson(v));
            }
            Unit unit = Unit.INSTANCE;
            var15_21.add(string, (JsonElement)jsonArray3);
            jsonArray2.add((JsonElement)jsonObject);
        }
        String string = jsonArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final JsonObject getJson(LocationElement $this$getJson) {
        JsonObject jsonObject;
        JsonObject $this$getJson_u24lambda_u2414 = jsonObject = new JsonObject();
        boolean bl = false;
        if ($this$getJson.getX() != 0) {
            $this$getJson_u24lambda_u2414.addProperty("x", (Number)$this$getJson.getX());
        }
        if ($this$getJson.getY() != 0) {
            $this$getJson_u24lambda_u2414.addProperty("y", (Number)$this$getJson.getY());
        }
        if ($this$getJson.getZ() != 0) {
            $this$getJson_u24lambda_u2414.addProperty("z", (Number)$this$getJson.getZ());
        }
        if ($this$getJson.getMeta() != 0) {
            $this$getJson_u24lambda_u2414.addProperty("meta", (Number)$this$getJson.getMeta());
        }
        if ($this$getJson.getNbt() != null) {
            $this$getJson_u24lambda_u2414.addProperty("nbt", String.valueOf($this$getJson.getNbt()));
        }
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBlock(int x, int y, int z, @NotNull Block block, int meta, @Nullable TileEntity tile, boolean sync) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (sync && ASJUtilities.isServer()) {
            NBTTagCompound nBTTagCompound;
            int n = this.host.func_145782_y();
            String string = GameRegistry.findUniqueIdentifierFor((Block)block).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            NBTTagCompound nBTTagCompound2 = nBTTagCompound = new NBTTagCompound();
            int n2 = meta;
            String string2 = string;
            int n3 = z;
            int n4 = y;
            int n5 = x;
            int n6 = n;
            NetworkService networkService = NetworkService.INSTANCE;
            boolean bl = false;
            TileEntity tileEntity = tile;
            if (tileEntity != null) {
                void $this$setBlock_u24lambda_u2415;
                tileEntity.func_145841_b((NBTTagCompound)$this$setBlock_u24lambda_u2415);
            }
            Unit unit = Unit.INSTANCE;
            String string3 = nBTTagCompound.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String string4 = string3;
            int n7 = n2;
            String string5 = string2;
            int n8 = n3;
            int n9 = n4;
            int n10 = n5;
            int n11 = n6;
            networkService.sendToDim(new MessageFIBlock(n11, n10, n9, n8, string5, n7, string4), this.host.field_70170_p.field_73011_w.field_76574_g);
        }
        if (block == Blocks.field_150350_a) {
            this.blockMap.remove(ExtensionsKt.with((Pair)TuplesKt.to((Object)x, (Object)y), (Object)z));
            return;
        }
        BlockData blockData = this.get(this.blockMap, x, y, z);
        int oldLight = blockData != null ? blockData.getLightValue() : 0;
        this.set(this.blockMap, x, y, z, new BlockData(block, meta, tile, oldLight, oldLight));
        if (tile == null) {
            this.tileList.remove(ExtensionsKt.with((Pair)TuplesKt.to((Object)x, (Object)y), (Object)z));
        } else {
            this.set(this.tileList, x, y, z, tile);
        }
        this.startX = Math.min(this.startX, x);
        this.startY = Math.min(this.startY, y);
        this.startZ = Math.min(this.startZ, z);
        this.endX = Math.max(this.endX, x);
        this.endY = Math.max(this.endY, y);
        this.endZ = Math.max(this.endZ, z);
    }

    public static /* synthetic */ void setBlock$default(FloatingIslandBlockAccess floatingIslandBlockAccess, int n, int n2, int n3, Block block, int n4, TileEntity tileEntity, boolean bl, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n5 & 0x20) != 0) {
            tileEntity = null;
        }
        if ((n5 & 0x40) != 0) {
            bl = false;
        }
        floatingIslandBlockAccess.setBlock(n, n2, n3, block, n4, tileEntity, bl);
    }

    @NotNull
    public Block func_147439_a(int x, int y, int z) {
        BlockData blockData = this.get(this.blockMap, x, y, z);
        if (blockData == null || (blockData = blockData.getBlock()) == null) {
            Block block = Blocks.field_150350_a;
            blockData = block;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"air");
        }
        return blockData;
    }

    public int func_72805_g(int x, int y, int z) {
        BlockData blockData = this.get(this.blockMap, x, y, z);
        return blockData != null ? blockData.getMeta() : 0;
    }

    @Nullable
    public TileEntity func_147438_o(int x, int y, int z) {
        BlockData blockData = this.get(this.blockMap, x, y, z);
        return blockData != null ? blockData.getTile() : null;
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public int func_72802_i(int x, int y, int z, int blockMin) {
        int i1 = EnumSkyBlock.Sky.field_77198_c;
        BlockData blockData = this.get(this.blockMap, x, y, z);
        int j1 = blockData != null ? blockData.getLightValue() : 0;
        BlockData blockData2 = this.get(this.blockMap, x, y, z);
        boolean bl = blockData2 != null && (blockData2 = blockData2.getBlock()) != null ? blockData2.func_149710_n() : false;
        if (bl) {
            Integer[] integerArray = new Integer[6];
            BlockData blockData3 = this.get(this.blockMap, x - 1, y, z);
            integerArray[0] = blockData3 != null ? blockData3.getLightValue() : 0;
            BlockData blockData4 = this.get(this.blockMap, x + 1, y, z);
            integerArray[1] = blockData4 != null ? blockData4.getLightValue() : 0;
            BlockData blockData5 = this.get(this.blockMap, x, y - 1, z);
            integerArray[2] = blockData5 != null ? blockData5.getLightValue() : 0;
            BlockData blockData6 = this.get(this.blockMap, x, y + 1, z);
            integerArray[3] = blockData6 != null ? blockData6.getLightValue() : 0;
            BlockData blockData7 = this.get(this.blockMap, x, y, z - 1);
            integerArray[4] = blockData7 != null ? blockData7.getLightValue() : 0;
            BlockData blockData8 = this.get(this.blockMap, x, y, z + 1);
            integerArray[5] = blockData8 != null ? blockData8.getLightValue() : 0;
            int nb = ((Number)((Object)ArraysKt.maxOrThrow((Comparable[])integerArray))).intValue() - 1;
            j1 = Math.max(j1, nb);
        }
        j1 = Math.max(blockMin, j1);
        return i1 << 20 | j1 << 4;
    }

    public int func_72879_k(int x, int y, int z, int side) {
        return this.func_147439_a(x, y, z).func_149748_c((IBlockAccess)this, x, y, z, side);
    }

    @NotNull
    public BiomeGenBase func_72807_a(int x, int z) {
        return (BiomeGenBase)BiomeField.INSTANCE;
    }

    public int func_72800_K() {
        return this.endY - this.startY;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, @NotNull ForgeDirection side, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    protected final void finalize() {
        block0: {
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            executorService.shutdownNow();
        }
    }

    private static final void _init_$lambda$4(FloatingIslandBlockAccess this$0) {
        this$0.recalculateLight();
    }

    private static final List toSchema$lambda$10$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List toSchema$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J=\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006("}, d2={"Lalfheim/common/floatingisland/FloatingIslandBlockAccess$BlockData;", "", "block", "Lnet/minecraft/block/Block;", "meta", "", "tile", "Lnet/minecraft/tileentity/TileEntity;", "lightValue", "preLightValue", "<init>", "(Lnet/minecraft/block/Block;ILnet/minecraft/tileentity/TileEntity;II)V", "getBlock", "()Lnet/minecraft/block/Block;", "setBlock", "(Lnet/minecraft/block/Block;)V", "getMeta", "()I", "setMeta", "(I)V", "getTile", "()Lnet/minecraft/tileentity/TileEntity;", "setTile", "(Lnet/minecraft/tileentity/TileEntity;)V", "getLightValue", "setLightValue", "getPreLightValue", "setPreLightValue", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "Alfheim"})
    public static final class BlockData {
        @NotNull
        private Block block;
        private int meta;
        @Nullable
        private TileEntity tile;
        private int lightValue;
        private int preLightValue;

        public BlockData(@NotNull Block block, int meta, @Nullable TileEntity tile, int lightValue, int preLightValue) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.meta = meta;
            this.tile = tile;
            this.lightValue = lightValue;
            this.preLightValue = preLightValue;
        }

        @NotNull
        public final Block getBlock() {
            return this.block;
        }

        public final void setBlock(@NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"<set-?>");
            this.block = block;
        }

        public final int getMeta() {
            return this.meta;
        }

        public final void setMeta(int n) {
            this.meta = n;
        }

        @Nullable
        public final TileEntity getTile() {
            return this.tile;
        }

        public final void setTile(@Nullable TileEntity tileEntity) {
            this.tile = tileEntity;
        }

        public final int getLightValue() {
            return this.lightValue;
        }

        public final void setLightValue(int n) {
            this.lightValue = n;
        }

        public final int getPreLightValue() {
            return this.preLightValue;
        }

        public final void setPreLightValue(int n) {
            this.preLightValue = n;
        }

        @NotNull
        public final Block component1() {
            return this.block;
        }

        public final int component2() {
            return this.meta;
        }

        @Nullable
        public final TileEntity component3() {
            return this.tile;
        }

        public final int component4() {
            return this.lightValue;
        }

        public final int component5() {
            return this.preLightValue;
        }

        @NotNull
        public final BlockData copy(@NotNull Block block, int meta, @Nullable TileEntity tile, int lightValue, int preLightValue) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return new BlockData(block, meta, tile, lightValue, preLightValue);
        }

        public static /* synthetic */ BlockData copy$default(BlockData blockData, Block block, int n, TileEntity tileEntity, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                block = blockData.block;
            }
            if ((n4 & 2) != 0) {
                n = blockData.meta;
            }
            if ((n4 & 4) != 0) {
                tileEntity = blockData.tile;
            }
            if ((n4 & 8) != 0) {
                n2 = blockData.lightValue;
            }
            if ((n4 & 0x10) != 0) {
                n3 = blockData.preLightValue;
            }
            return blockData.copy(block, n, tileEntity, n2, n3);
        }

        @NotNull
        public String toString() {
            return "BlockData(block=" + this.block + ", meta=" + this.meta + ", tile=" + this.tile + ", lightValue=" + this.lightValue + ", preLightValue=" + this.preLightValue + ')';
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = result * 31 + Integer.hashCode(this.meta);
            result = result * 31 + (this.tile == null ? 0 : this.tile.hashCode());
            result = result * 31 + Integer.hashCode(this.lightValue);
            result = result * 31 + Integer.hashCode(this.preLightValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockData)) {
                return false;
            }
            BlockData blockData = (BlockData)other;
            if (!Intrinsics.areEqual((Object)this.block, (Object)blockData.block)) {
                return false;
            }
            if (this.meta != blockData.meta) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tile, (Object)blockData.tile)) {
                return false;
            }
            if (this.lightValue != blockData.lightValue) {
                return false;
            }
            return this.preLightValue == blockData.preLightValue;
        }
    }
}

