/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.minetweaker;

import alfheim.api.AlfheimAPI;
import alfheim.api.spell.SpellBase;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.alfheim.Spells")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J0\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a8\u0006\u001d"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells;", "", "<init>", "()V", "setManaCost", "", "name", "", "mana", "", "setCooldown", "cd", "setCastTime", "time", "setSpecial", "isSpecial", "", "setParams", "damage", "", "duration", "efficiency", "", "radius", "ManaCost", "Cooldown", "CastTime", "Params", "Special", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nMTHandlerSpells.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MTHandlerSpells.kt\nalfheim/common/integration/minetweaker/MTHandlerSpells\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class MTHandlerSpells {
    @NotNull
    public static final MTHandlerSpells INSTANCE = new MTHandlerSpells();

    private MTHandlerSpells() {
    }

    @ZenMethod
    @JvmStatic
    public static final void setManaCost(@NotNull String name, int mana) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(mana >= 0)) {
            boolean bl = false;
            String string = "Manacost for " + name + " spell must not be negative";
            throw new IllegalArgumentException(string.toString());
        }
        MineTweakerAPI.apply((IUndoableAction)new ManaCost(name, mana));
    }

    @ZenMethod
    @JvmStatic
    public static final void setCooldown(@NotNull String name, int cd) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(cd >= 0)) {
            boolean bl = false;
            String string = "Cooldown for " + name + " spell must not be negative";
            throw new IllegalArgumentException(string.toString());
        }
        MineTweakerAPI.apply((IUndoableAction)new Cooldown(name, cd));
    }

    @ZenMethod
    @JvmStatic
    public static final void setCastTime(@NotNull String name, int time) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(time >= 0)) {
            boolean bl = false;
            String string = "Cast time for " + name + " spell must not be negative";
            throw new IllegalArgumentException(string.toString());
        }
        MineTweakerAPI.apply((IUndoableAction)new CastTime(name, time));
    }

    @ZenMethod
    @JvmStatic
    public static final void setSpecial(@NotNull String name, boolean isSpecial) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MineTweakerAPI.apply((IUndoableAction)new Special(name, isSpecial));
    }

    @ZenMethod
    @JvmStatic
    public static final void setParams(@NotNull String name, float damage, int duration, double efficiency, double radius) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(damage >= 0.0f && duration >= 0 && efficiency >= 0.0 && radius >= 0.0)) {
            boolean bl = false;
            String string = "Params for " + name + " spell must not be negative";
            throw new IllegalArgumentException(string.toString());
        }
        MineTweakerAPI.apply((IUndoableAction)new Params(name, damage, duration, efficiency, radius));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$CastTime;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "<init>", "(Ljava/lang/String;I)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "oldVal", "getOldVal", "()I", "setOldVal", "(I)V", "apply", "", "canUndo", "", "undo", "describe", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class CastTime
    implements IUndoableAction {
        private final int newVal;
        @NotNull
        private final SpellBase spell;
        private int oldVal;

        public CastTime(@NotNull String name, int newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
        }

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final int getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(int n) {
            this.oldVal = n;
        }

        public void apply() {
            this.oldVal = this.spell.setCastTime(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setCastTime(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting cast time to " + this.newVal + " for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting cast time for " + this.spell.getName() + " to old value (" + this.oldVal + ')';
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$Cooldown;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "<init>", "(Ljava/lang/String;I)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "oldVal", "getOldVal", "()I", "setOldVal", "(I)V", "apply", "", "canUndo", "", "undo", "describe", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class Cooldown
    implements IUndoableAction {
        private final int newVal;
        @NotNull
        private final SpellBase spell;
        private int oldVal;

        public Cooldown(@NotNull String name, int newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
        }

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final int getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(int n) {
            this.oldVal = n;
        }

        public void apply() {
            this.oldVal = this.spell.setCooldown(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setCooldown(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting cooldown to " + this.newVal + " for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting cooldown for " + this.spell.getName() + " to old value (oldVal)";
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$ManaCost;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "<init>", "(Ljava/lang/String;I)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "setSpell", "(Lalfheim/api/spell/SpellBase;)V", "oldVal", "getOldVal", "()I", "setOldVal", "(I)V", "apply", "", "canUndo", "", "undo", "describe", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class ManaCost
    implements IUndoableAction {
        private final int newVal;
        @NotNull
        private SpellBase spell;
        private int oldVal;

        public ManaCost(@NotNull String name, int newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
        }

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final void setSpell(@NotNull SpellBase spellBase) {
            Intrinsics.checkNotNullParameter((Object)spellBase, (String)"<set-?>");
            this.spell = spellBase;
        }

        public final int getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(int n) {
            this.oldVal = n;
        }

        public void apply() {
            this.oldVal = this.spell.setManaCost(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setManaCost(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting manacost to " + this.newVal + " for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting manacost for " + this.spell.getName() + " to old value (" + this.oldVal + ')';
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$Params;", "Lminetweaker/IUndoableAction;", "name", "", "damage", "", "duration", "", "efficiency", "", "radius", "<init>", "(Ljava/lang/String;FIDD)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "oldVals", "", "", "getOldVals", "()[Ljava/lang/Object;", "setOldVals", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "apply", "", "canUndo", "", "undo", "describe", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class Params
    implements IUndoableAction {
        private final float damage;
        private final int duration;
        private final double efficiency;
        private final double radius;
        @NotNull
        private final SpellBase spell;
        @NotNull
        private Object[] oldVals;

        public Params(@NotNull String name, float damage, int duration, double efficiency, double radius) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.damage = damage;
            this.duration = duration;
            this.efficiency = efficiency;
            this.radius = radius;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
            Object[] objectArray = new Object[]{Float.valueOf(0.0f), 0, 0.0, 0.0};
            this.oldVals = objectArray;
        }

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        @NotNull
        public final Object[] getOldVals() {
            return this.oldVals;
        }

        public final void setOldVals(@NotNull Object[] objectArray) {
            Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
            this.oldVals = objectArray;
        }

        public void apply() {
            Object[] objectArray = new Object[]{Float.valueOf(this.spell.getDamage()), this.spell.getDuration(), this.spell.getEfficiency(), this.spell.getRadius()};
            this.oldVals = objectArray;
            this.spell.setDamage(this.damage);
            this.spell.setDuration(this.duration);
            this.spell.setEfficiency(this.efficiency);
            this.spell.setRadius(this.radius);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Object object = this.oldVals[0];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            this.spell.setDamage(((Float)object).floatValue());
            Object object2 = this.oldVals[1];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
            this.spell.setDuration((Integer)object2);
            Object object3 = this.oldVals[2];
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Double");
            this.spell.setEfficiency((Double)object3);
            Object object4 = this.oldVals[3];
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Double");
            this.spell.setRadius((Double)object4);
        }

        @NotNull
        public String describe() {
            return "Setting damage [" + this.damage + "], duration [" + this.duration + "], efficiency [" + this.efficiency + "], radius [" + this.radius + "] for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            StringBuilder stringBuilder = new StringBuilder().append("Resetting damage, duration, efficiency, radius for ").append(this.spell.getName()).append(" to old values (");
            String string = Arrays.toString(this.oldVals);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return stringBuilder.append(string).append(')').toString();
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$Special;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "<init>", "(Ljava/lang/String;Z)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "oldVal", "getOldVal", "()Z", "setOldVal", "(Z)V", "apply", "", "canUndo", "undo", "describe", "describeUndo", "getOverrideKey", "", "Alfheim"})
    private static final class Special
    implements IUndoableAction {
        private final boolean newVal;
        @NotNull
        private final SpellBase spell;
        private boolean oldVal;

        public Special(@NotNull String name, boolean newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
            this.oldVal = this.spell.getHard();
        }

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final boolean getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(boolean bl) {
            this.oldVal = bl;
        }

        public void apply() {
            this.spell.setHard(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setHard(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting Special status '" + this.newVal + "' for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting Special status for " + this.spell.getName() + " to old value (" + this.oldVal + ')';
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }
    }
}

