/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.travellersgear;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.AlfheimCore;
import baubles.api.BaubleType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import travellersgear.api.ITravellersGear;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a8\u0006\f"}, d2={"Lalfheim/common/integration/travellersgear/TravellerBaubleTooltipHandler;", "", "<init>", "()V", "addHiddenTooltip", "", "bauble", "Lvazkii/botania/common/item/equipment/bauble/ItemBauble;", "stack", "Lnet/minecraft/item/ItemStack;", "tooltip", "", "Alfheim"})
public final class TravellerBaubleTooltipHandler {
    @NotNull
    public static final TravellerBaubleTooltipHandler INSTANCE = new TravellerBaubleTooltipHandler();

    private TravellerBaubleTooltipHandler() {
    }

    public final void addHiddenTooltip(@NotNull ItemBauble bauble, @NotNull ItemStack stack, @NotNull List<Object> tooltip) {
        ItemStack cosmetic;
        Object object;
        Intrinsics.checkNotNullParameter((Object)bauble, (String)"bauble");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        if (AlfheimCore.INSTANCE.getTravellersGearLoaded()) {
            ITravellersGear iTravellersGear = bauble instanceof ITravellersGear ? (ITravellersGear)bauble : null;
            int slot = iTravellersGear != null ? iTravellersGear.getSlot(stack) : 0;
            ExtensionsKt.addStringToTooltip(tooltip, (String)("TG.desc.gearSlot.tg." + slot), (String[])new String[0]);
            String key = RenderHelper.getKeyDisplayString((String)"TG.keybind.openInv");
            if (key != null) {
                object = new String[]{key};
                ExtensionsKt.addStringToTooltip(tooltip, (String)"alfheimmisc.tgtooltip", (String[])object);
            }
        } else {
            BaubleType type2 = bauble.getBaubleType(stack);
            StringBuilder stringBuilder = new StringBuilder().append("botania.baubletype.");
            String string = type2.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            ExtensionsKt.addStringToTooltip(tooltip, (String)stringBuilder.append(string).toString(), (String[])new String[0]);
            String key = RenderHelper.getKeyDisplayString((String)"Baubles Inventory");
            if (key != null) {
                String string2 = StatCollector.func_74838_a((String)"botania.baubletooltip");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"translateToLocal(...)");
                object = string2;
                ExtensionsKt.addStringToTooltip(tooltip, (String)new Regex("%key%").replace((CharSequence)object, key), (String[])new String[0]);
            }
        }
        if ((cosmetic = bauble.getCosmeticItem(stack)) != null) {
            String string = StatCollector.func_74838_a((String)"botaniamisc.hasCosmetic");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translateToLocal(...)");
            object = string;
            Object[] objectArray = new Object[]{cosmetic.func_82833_r()};
            String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            ExtensionsKt.addStringToTooltip(tooltip, (String)string3, (String[])new String[0]);
        }
        if (bauble.hasPhantomInk(stack)) {
            String string = StatCollector.func_74838_a((String)"botaniamisc.hasPhantomInk");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translateToLocal(...)");
            ExtensionsKt.addStringToTooltip(tooltip, (String)string, (String[])new String[0]);
        }
    }
}

