/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.creator;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.core.helper.ElementalDamage;
import alfheim.common.core.helper.ElementalDamageHelperKt;
import alfheim.common.item.creator.ItemTrisDagger;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lalfheim/common/item/creator/DaggerEventHandler;", "", "<init>", "()V", "dealOculusDamage", "Lnet/minecraft/util/DamageSource;", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "getHeadOrientation", "Lvazkii/botania/common/core/helper/Vector3;", "onLivingAttacked", "", "e", "Lnet/minecraftforge/event/entity/living/LivingAttackEvent;", "Alfheim"})
public final class DaggerEventHandler {
    @NotNull
    public static final DaggerEventHandler INSTANCE = new DaggerEventHandler();

    private DaggerEventHandler() {
    }

    @NotNull
    public final DamageSource dealOculusDamage(@NotNull EntityLivingBase entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        DamageSource damageSource = new EntityDamageSource("alfheim.oculus", (Entity)entity).func_76348_h().func_82726_p();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"setMagicDamage(...)");
        return ElementalDamageHelperKt.setTo(damageSource, ElementalDamage.LIGHTNESS);
    }

    @NotNull
    public final Vector3 getHeadOrientation(@NotNull EntityLivingBase entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        float f1 = MathHelper.func_76134_b((float)(-entity.field_70177_z * ((float)Math.PI / 180) - ExtensionsKt.getF((Number)Math.PI)));
        float f2 = MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180) - ExtensionsKt.getF((Number)Math.PI)));
        float f3 = -MathHelper.func_76134_b((float)(-(entity.field_70125_A - (float)90) * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-(entity.field_70125_A - (float)90) * ((float)Math.PI / 180)));
        return new Vector3(ExtensionsKt.getD((Number)Float.valueOf(f2 * f3)), ExtensionsKt.getD((Number)Float.valueOf(f4)), ExtensionsKt.getD((Number)Float.valueOf(f1 * f3)));
    }

    @SubscribeEvent
    public final void onLivingAttacked(@NotNull LivingAttackEvent e) {
        Vector3 targetVec;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityLivingBase player = e.entityLiving;
        DamageSource damage = e.source;
        if (!(player instanceof EntityPlayer) || !(damage instanceof EntityDamageSource) || !((EntityPlayer)player).func_71039_bw() || Intrinsics.areEqual((Object)((EntityDamageSource)damage).field_76373_n, (Object)"alfheim.oculus")) {
            return;
        }
        Entity enemyEntity = ((EntityDamageSource)damage).func_76346_g();
        if (!(enemyEntity instanceof EntityLivingBase) || Intrinsics.areEqual((Object)enemyEntity, (Object)player)) {
            return;
        }
        ItemStack itemInUse = ((EntityPlayer)player).field_71074_e;
        int itemInUseCount = ((EntityPlayer)player).field_71074_e.func_77988_m() - ((EntityPlayer)player).field_71072_f;
        if (!(itemInUse.func_77973_b() instanceof ItemTrisDagger) || itemInUseCount > 10 || itemInUseCount < 0) {
            return;
        }
        Vector3 lookVec = new Vector3(((EntityPlayer)player).func_70040_Z());
        double epsilon = lookVec.dotProduct(targetVec = Vector3.fromEntityCenter((Entity)enemyEntity).sub(Vector3.fromEntityCenter((Entity)((Entity)player)))) / (lookVec.mag() * targetVec.mag());
        if (epsilon <= 0.75) {
            return;
        }
        e.setCanceled(true);
        ((EntityPlayer)player).func_71034_by();
        if (!((EntityPlayer)player).field_70170_p.field_72995_K) {
            if (damage instanceof EntityDamageSourceIndirect) {
                return;
            }
            ((EntityLivingBase)enemyEntity).func_70097_a(this.dealOculusDamage(player), e.ammount * 2.0f);
            ExtensionsKt.playSoundAtEntity((Entity)enemyEntity, (String)"random.anvil_land", (float)1.0f, (float)(0.9f + 0.1f * ExtensionsKt.getF((Number)Math.random())));
            if (enemyEntity instanceof EntityPlayer && ((EntityPlayer)enemyEntity).func_71045_bC() != null) {
                ((EntityPlayer)enemyEntity).func_71045_bC().func_77972_a(30, (EntityLivingBase)enemyEntity);
            }
            ExtensionsKt.knockback((Entity)enemyEntity, (Entity)((Entity)player), (float)1.0f);
            ((EntityLivingBase)enemyEntity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 1));
            ((EntityLivingBase)enemyEntity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 2));
        } else {
            Vector3 mainVec = Vector3.fromEntityCenter((Entity)((Entity)player)).add(lookVec);
            Vector3 baseVec = this.getHeadOrientation(player).crossProduct(lookVec).normalize();
            int i2 = 0;
            int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)360, (int)15);
            if (i2 <= n) {
                while (true) {
                    Vector3 rotVec = baseVec.copy().rotate((double)(i2 * 180) / Math.PI, lookVec);
                    Vector3 endVec = mainVec.copy().add(rotVec);
                    Botania.proxy.lightningFX(((EntityPlayer)player).field_70170_p, mainVec, endVec, 3.0f, 16749729, 16493237);
                    if (i2 == n) break;
                    i2 += 15;
                }
            }
        }
    }

    static {
        ExtensionsKt.eventForge((Object)INSTANCE);
    }
}

