/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.rod;

import alfheim.common.item.rod.NoNetFakePlayer;
import cpw.mods.fml.common.eventhandler.Event;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ*\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\b\b\u0002\u0010#\u001a\u00020\u001cH\u0002J\u001e\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eJ6\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eJ\u001e\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-JX\u0010.\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u00032\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0019\u0010\u001a\u00a8\u00063"}, d2={"Lalfheim/common/item/rod/NoNetItemInWorldManager;", "", "theWorld", "Lnet/minecraft/world/World;", "thisPlayerMP", "Lalfheim/common/item/rod/NoNetFakePlayer;", "<init>", "(Lnet/minecraft/world/World;Lalfheim/common/item/rod/NoNetFakePlayer;)V", "getTheWorld", "()Lnet/minecraft/world/World;", "setTheWorld", "(Lnet/minecraft/world/World;)V", "getThisPlayerMP", "()Lalfheim/common/item/rod/NoNetFakePlayer;", "setThisPlayerMP", "(Lalfheim/common/item/rod/NoNetFakePlayer;)V", "blockReachDistance", "", "getBlockReachDistance", "()D", "setBlockReachDistance", "(D)V", "value", "Lnet/minecraft/world/WorldSettings$GameType;", "gameType", "setGameType", "(Lnet/minecraft/world/WorldSettings$GameType;)V", "onBlockClicked", "", "x", "", "y", "z", "side", "removeBlock", "canHarvest", "tryHarvestBlock", "onBlockBreakEvent", "Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;", "world", "entityPlayer", "tryUseItem", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "stack", "Lnet/minecraft/item/ItemStack;", "activateBlockOrUseItem", "hitX", "", "hitY", "hitZ", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nItemRodClicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemRodClicker.kt\nalfheim/common/item/rod/NoNetItemInWorldManager\n+ 2 Extensions.kt\nalexsocol/asjlib/ExtensionsKt\n*L\n1#1,482:1\n103#2,4:483\n*S KotlinDebug\n*F\n+ 1 ItemRodClicker.kt\nalfheim/common/item/rod/NoNetItemInWorldManager\n*L\n318#1:483,4\n*E\n"})
public final class NoNetItemInWorldManager {
    @NotNull
    private World theWorld;
    @NotNull
    private NoNetFakePlayer thisPlayerMP;
    private double blockReachDistance;
    @NotNull
    private WorldSettings.GameType gameType;

    public NoNetItemInWorldManager(@NotNull World theWorld, @NotNull NoNetFakePlayer thisPlayerMP) {
        Intrinsics.checkNotNullParameter((Object)theWorld, (String)"theWorld");
        Intrinsics.checkNotNullParameter((Object)((Object)thisPlayerMP), (String)"thisPlayerMP");
        this.theWorld = theWorld;
        this.thisPlayerMP = thisPlayerMP;
        this.blockReachDistance = 5.0;
        this.gameType = WorldSettings.GameType.NOT_SET;
    }

    @NotNull
    public final World getTheWorld() {
        return this.theWorld;
    }

    public final void setTheWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"<set-?>");
        this.theWorld = world;
    }

    @NotNull
    public final NoNetFakePlayer getThisPlayerMP() {
        return this.thisPlayerMP;
    }

    public final void setThisPlayerMP(@NotNull NoNetFakePlayer noNetFakePlayer) {
        Intrinsics.checkNotNullParameter((Object)((Object)noNetFakePlayer), (String)"<set-?>");
        this.thisPlayerMP = noNetFakePlayer;
    }

    public final double getBlockReachDistance() {
        return this.blockReachDistance;
    }

    public final void setBlockReachDistance(double d) {
        this.blockReachDistance = d;
    }

    private final void setGameType(WorldSettings.GameType value) {
        this.gameType = value;
        value.func_77147_a(this.thisPlayerMP.field_71075_bZ);
    }

    public final boolean onBlockClicked(int x, int y, int z, int side) {
        if (this.gameType.func_82752_c() && !this.thisPlayerMP.func_82246_f(x, y, z)) {
            return false;
        }
        PlayerInteractEvent event = null;
        boolean $i$f$try_ = false;
        try {
            boolean bl = false;
            event = ForgeEventFactory.onPlayerInteract((EntityPlayer)this.thisPlayerMP, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)this.theWorld);
        }
        catch (Throwable throwable) {
        }
        PlayerInteractEvent playerInteractEvent = event;
        boolean bl = playerInteractEvent != null ? playerInteractEvent.isCanceled() : false;
        if (bl) {
            return false;
        }
        float hardness = 1.0f;
        Block block = this.theWorld.func_147439_a(x, y, z);
        boolean clicked = false;
        if (!block.isAir((IBlockAccess)this.theWorld, x, y, z)) {
            PlayerInteractEvent playerInteractEvent2 = event;
            if ((playerInteractEvent2 != null ? playerInteractEvent2.useBlock : null) != Event.Result.DENY) {
                block.func_149699_a(this.theWorld, x, y, z, (EntityPlayer)this.thisPlayerMP);
                this.theWorld.func_72886_a((EntityPlayer)this.thisPlayerMP, x, y, z, side);
                clicked = true;
            }
            hardness = block.func_149737_a((EntityPlayer)this.thisPlayerMP, this.thisPlayerMP.field_70170_p, x, y, z);
        }
        PlayerInteractEvent playerInteractEvent3 = event;
        if ((playerInteractEvent3 != null ? playerInteractEvent3.useItem : null) == Event.Result.DENY) {
            return clicked;
        }
        if (!block.isAir((IBlockAccess)this.theWorld, x, y, z) && hardness >= 1.0f) {
            return this.tryHarvestBlock(x, y, z) || clicked;
        }
        return clicked;
    }

    private final boolean removeBlock(int x, int y, int z, boolean canHarvest) {
        Block block = this.theWorld.func_147439_a(x, y, z);
        int l = this.theWorld.func_72805_g(x, y, z);
        block.func_149681_a(this.theWorld, x, y, z, l, (EntityPlayer)this.thisPlayerMP);
        boolean flag = block.removedByPlayer(this.theWorld, (EntityPlayer)this.thisPlayerMP, x, y, z, canHarvest);
        if (flag) {
            block.func_149664_b(this.theWorld, x, y, z, l);
        }
        return flag;
    }

    static /* synthetic */ boolean removeBlock$default(NoNetItemInWorldManager noNetItemInWorldManager, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 8) != 0) {
            bl = false;
        }
        return noNetItemInWorldManager.removeBlock(n, n2, n3, bl);
    }

    public final boolean tryHarvestBlock(int x, int y, int z) {
        BlockEvent.BreakEvent event = this.onBlockBreakEvent(this.theWorld, this.gameType, this.thisPlayerMP, x, y, z);
        if (event.isCanceled()) {
            return false;
        }
        ItemStack stack = this.thisPlayerMP.func_71045_bC();
        if (stack != null && stack.func_77973_b().onBlockStartBreak(stack, x, y, z, (EntityPlayer)this.thisPlayerMP)) {
            return false;
        }
        Block block = this.theWorld.func_147439_a(x, y, z);
        int l = this.theWorld.func_72805_g(x, y, z);
        this.theWorld.func_72889_a((EntityPlayer)this.thisPlayerMP, 2001, x, y, z, Block.func_149682_b((Block)block) + (this.theWorld.func_72805_g(x, y, z) << 12));
        boolean flag = false;
        ItemStack itemstack = this.thisPlayerMP.func_71045_bC();
        boolean flag1 = block.canHarvestBlock((EntityPlayer)this.thisPlayerMP, l);
        if (itemstack != null) {
            itemstack.func_150999_a(this.theWorld, block, x, y, z, (EntityPlayer)this.thisPlayerMP);
            if (itemstack.field_77994_a == 0) {
                this.thisPlayerMP.func_71028_bD();
            }
        }
        if ((flag = this.removeBlock(x, y, z, flag1)) && flag1) {
            block.func_149636_a(this.theWorld, (EntityPlayer)this.thisPlayerMP, x, y, z, l);
        }
        if (flag) {
            block.func_149657_c(this.theWorld, x, y, z, event.getExpToDrop());
        }
        return flag;
    }

    @NotNull
    public final BlockEvent.BreakEvent onBlockBreakEvent(@NotNull World world, @NotNull WorldSettings.GameType gameType, @NotNull NoNetFakePlayer entityPlayer, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)gameType, (String)"gameType");
        Intrinsics.checkNotNullParameter((Object)((Object)entityPlayer), (String)"entityPlayer");
        boolean preCancelEvent = false;
        if (gameType.func_82752_c() && !entityPlayer.func_82246_f(x, y, z)) {
            preCancelEvent = true;
        } else if (gameType.func_77145_d() && entityPlayer.func_70694_bm() != null && entityPlayer.func_70694_bm().func_77973_b() instanceof ItemSword) {
            preCancelEvent = true;
        }
        Block block = world.func_147439_a(x, y, z);
        int blockMetadata = world.func_72805_g(x, y, z);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, world, block, blockMetadata, (EntityPlayer)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public final boolean tryUseItem(@NotNull EntityPlayer player, @NotNull World world, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int size = stack.field_77994_a;
        int damage = stack.func_77960_j();
        ItemStack result = stack.func_77957_a(world, player);
        if (Intrinsics.areEqual((Object)result, (Object)stack) && result.field_77994_a == size && result.func_77988_m() <= 0 && result.func_77960_j() == damage) {
            return false;
        }
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = result;
        if (result.field_77994_a == 0) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((EntityPlayer)this.thisPlayerMP, result));
        }
        return true;
    }

    public final boolean activateBlockOrUseItem(@NotNull EntityPlayer player, @NotNull World world, @Nullable ItemStack stack, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean useBlock;
        PlayerInteractEvent playerInteractEvent;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        try {
            playerInteractEvent = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)world);
        }
        catch (Throwable e) {
            playerInteractEvent = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, x, y, z, side, world);
        }
        PlayerInteractEvent event = playerInteractEvent;
        if (event.isCanceled()) {
            return false;
        }
        if (stack != null && stack.func_77973_b().onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ)) {
            if (stack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.thisPlayerMP, (ItemStack)stack);
            }
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        boolean bl = useBlock = !player.func_70093_af() || player.func_70694_bm() == null;
        if (!useBlock) {
            useBlock = player.func_70694_bm().func_77973_b().doesSneakBypassUse(world, x, y, z, player);
        }
        boolean result = false;
        if (useBlock) {
            boolean bl2 = event.useBlock != Event.Result.DENY ? block.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ) : (result = event.useItem != Event.Result.ALLOW);
        }
        if (stack != null && !result && event.useItem != Event.Result.DENY) {
            result = stack.func_77943_a(player, world, x, y, z, side, hitX, hitY, hitZ);
            if (stack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.thisPlayerMP, (ItemStack)stack);
            }
        }
        return result;
    }
}

