/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.niflheim;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.world.dim.niflheim.biome.BiomeGenIce;
import alfheim.common.world.dim.niflheim.biome.BiomeGenPoison;
import alfheim.common.world.dim.niflheim.biome.BiomeGenSnow;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016JG\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001cJG\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001cJO\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 J0\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$H\u0016J8\u0010&\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lalfheim/common/world/dim/niflheim/ChunkManagerNiflheim;", "Lnet/minecraft/world/biome/WorldChunkManager;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "genLayerRiverMix", "Lnet/minecraft/world/gen/layer/GenLayer;", "genLayerVoronoiZoom", "biomeCache", "Lnet/minecraft/world/biome/BiomeCache;", "biomeList", "", "Lnet/minecraft/world/biome/BiomeGenBase;", "getBiomesToSpawnIn", "getBiomeGenAt", "x", "", "y", "getRainfall", "", "downfalls", "z", "width", "height", "getBiomesForGeneration", "", "biomes", "([Lnet/minecraft/world/biome/BiomeGenBase;IIII)[Lnet/minecraft/world/biome/BiomeGenBase;", "loadBlockGeneratorData", "cacheFlag", "", "([Lnet/minecraft/world/biome/BiomeGenBase;IIIIZ)[Lnet/minecraft/world/biome/BiomeGenBase;", "areBiomesViable", "offset", "list", "", "", "findBiomePosition", "Lnet/minecraft/world/ChunkPosition;", "random", "Ljava/util/Random;", "cleanupCache", "", "Alfheim"})
public final class ChunkManagerNiflheim
extends WorldChunkManager {
    @NotNull
    private GenLayer genLayerRiverMix;
    @NotNull
    private GenLayer genLayerVoronoiZoom;
    @NotNull
    private final BiomeCache biomeCache;
    @NotNull
    private final List<BiomeGenBase> biomeList;

    public ChunkManagerNiflheim(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        GenLayer[] layers = GenLayer.func_75901_a((long)world.func_72905_C(), (WorldType)new WorldType("largeBiomes"));
        GenLayer genLayer = layers[0];
        Intrinsics.checkNotNullExpressionValue((Object)genLayer, (String)"get(...)");
        this.genLayerRiverMix = genLayer;
        GenLayer genLayer2 = layers[1];
        Intrinsics.checkNotNullExpressionValue((Object)genLayer2, (String)"get(...)");
        this.genLayerVoronoiZoom = genLayer2;
        this.biomeCache = new BiomeCache((WorldChunkManager)this);
        Object[] objectArray = new BiomeGenBase[]{BiomeGenIce.INSTANCE, BiomeGenSnow.INSTANCE, BiomeGenPoison.INSTANCE};
        this.biomeList = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public List<BiomeGenBase> func_76932_a() {
        return this.biomeList;
    }

    @NotNull
    public BiomeGenBase func_76935_a(int x, int y) {
        BiomeGenBase biomeGenBase = this.biomeCache.func_76837_b(x, y);
        Intrinsics.checkNotNullExpressionValue((Object)biomeGenBase, (String)"getBiomeGenAt(...)");
        return biomeGenBase;
    }

    @NotNull
    public float[] func_76936_a(@NotNull float[] downfalls, int x, int z, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)downfalls, (String)"downfalls");
        IntCache.func_76446_a();
        int[] ints = this.genLayerVoronoiZoom.func_75904_a(x, z, width, height);
        int n = width * height;
        for (int i2 = 0; i2 < n; ++i2) {
            float rainfall;
            Intrinsics.checkNotNull((Object)ints);
            Integer n2 = ArraysKt.getOrNull((int[])ints, (int)i2);
            BiomeGenBase biomeGenBase = (BiomeGenBase)CollectionsKt.getOrNull(this.biomeList, (int)((n2 != null ? n2 : 0) % this.biomeList.size()));
            if (biomeGenBase == null) {
                biomeGenBase = BiomeGenIce.INSTANCE;
            }
            if ((rainfall = ExtensionsKt.getF((Number)biomeGenBase.func_76744_g()) / 65536.0f) > 1.0f) {
                rainfall = 1.0f;
            }
            downfalls[i2] = rainfall;
        }
        return downfalls;
    }

    @NotNull
    public BiomeGenBase[] func_76937_a(@Nullable BiomeGenBase[] biomes, int x, int y, int width, int height) {
        BiomeGenBase[] list = biomes;
        IntCache.func_76446_a();
        if (list == null || list.length < width * height) {
            list = new BiomeGenBase[width * height];
        }
        int[] ints = this.genLayerRiverMix.func_75904_a(x, y, width, height);
        int n = width * height;
        for (int i2 = 0; i2 < n; ++i2) {
            Intrinsics.checkNotNull((Object)ints);
            Integer n2 = ArraysKt.getOrNull((int[])ints, (int)i2);
            BiomeGenBase biomeGenBase = (BiomeGenBase)CollectionsKt.getOrNull(this.biomeList, (int)((n2 != null ? n2 : 0) % this.biomeList.size()));
            if (biomeGenBase == null) {
                biomeGenBase = BiomeGenIce.INSTANCE;
            }
            list[i2] = biomeGenBase;
        }
        return list;
    }

    @NotNull
    public BiomeGenBase[] func_76933_b(@Nullable BiomeGenBase[] biomes, int x, int z, int width, int height) {
        return this.func_76931_a(biomes, x, z, width, height, true);
    }

    @NotNull
    public BiomeGenBase[] func_76931_a(@Nullable BiomeGenBase[] biomes, int x, int z, int width, int height, boolean cacheFlag) {
        BiomeGenBase[] list = biomes;
        IntCache.func_76446_a();
        if (list == null || list.length < width * height) {
            list = new BiomeGenBase[width * height];
        }
        if (cacheFlag && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] cache = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(cache, 0, list, 0, width * height);
        } else {
            int[] nArray = this.genLayerVoronoiZoom.func_75904_a(x, z, width, height);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getInts(...)");
            Object[] ints = ArraysKt.toTypedArray((int[])nArray);
            int n = width * height;
            for (int i2 = 0; i2 < n; ++i2) {
                Integer n2 = (Integer)ArraysKt.getOrNull((Object[])ints, (int)i2);
                BiomeGenBase biomeGenBase = (BiomeGenBase)CollectionsKt.getOrNull(this.biomeList, (int)((n2 != null ? n2 : 0) % this.biomeList.size()));
                if (biomeGenBase == null) {
                    biomeGenBase = BiomeGenIce.INSTANCE;
                }
                list[i2] = biomeGenBase;
            }
        }
        return list;
    }

    public boolean func_76940_a(int x, int z, int offset, @NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        IntCache.func_76446_a();
        int i2 = x - offset >> 2;
        int k = z - offset >> 2;
        int width = (x + offset >> 2) - i2 + 1;
        int height = (z + offset >> 2) - k + 1;
        int[] ints = this.genLayerRiverMix.func_75904_a(i2, k, width, height);
        int n = width * height;
        for (int j = 0; j < n; ++j) {
            BiomeGenBase biome;
            Intrinsics.checkNotNull((Object)ints);
            Integer n2 = ArraysKt.getOrNull((int[])ints, (int)j);
            BiomeGenBase biomeGenBase = (BiomeGenBase)CollectionsKt.getOrNull(this.biomeList, (int)((n2 != null ? n2 : 0) % this.biomeList.size()));
            if (biomeGenBase == null) {
                biomeGenBase = BiomeGenIce.INSTANCE;
            }
            if (list.contains(biome = biomeGenBase)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ChunkPosition func_150795_a(int x, int z, int offset, @NotNull List<? extends Object> biomes, @NotNull Random random) {
        Intrinsics.checkNotNullParameter(biomes, (String)"biomes");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        IntCache.func_76446_a();
        int i2 = x - offset >> 2;
        int k = z - offset >> 2;
        int width = (x + offset >> 2) - i2 + 1;
        int height = (z + offset >> 2) - k + 1;
        int[] ints = this.genLayerRiverMix.func_75904_a(i2, k, width, height);
        ChunkPosition pos = null;
        int size = 0;
        int n = width * height;
        for (int j = 0; j < n; ++j) {
            BiomeGenBase biome;
            int a = i2 + j % width << 2;
            int c = k + j / width << 2;
            Intrinsics.checkNotNull((Object)ints);
            Integer n2 = ArraysKt.getOrNull((int[])ints, (int)j);
            BiomeGenBase biomeGenBase = (BiomeGenBase)CollectionsKt.getOrNull(this.biomeList, (int)((n2 != null ? n2 : 0) % this.biomeList.size()));
            if (biomeGenBase == null) {
                biomeGenBase = BiomeGenIce.INSTANCE;
            }
            if (!biomes.contains(biome = biomeGenBase) || pos != null && random.nextInt(size + 1) != 0) continue;
            pos = new ChunkPosition(a, 0, c);
            ++size;
        }
        ChunkPosition chunkPosition = pos;
        if (chunkPosition == null) {
            chunkPosition = new ChunkPosition(0, 0, 0);
        }
        return chunkPosition;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

