/*
 * Decompiled with CFR 0.152.
 */
package net.deathcoinmod;

import java.util.List;
import net.deathcoinmod.Config;
import net.deathcoinmod.DeathCoinHolder;
import net.deathcoinmod.DeathCoinMod;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DeathCoinItem
extends Item {
    public DeathCoinItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        Inventory inventory = player.getInventory();
        ItemStack itemStack = player.getItemInHand(usedHand);
        DeathCoinHolder deathToken = (DeathCoinHolder)itemStack.get(DeathCoinMod.TEST);
        if (deathToken != null) {
            DeathCoinMod.LOGGER.info(deathToken.items.toString());
            for (ItemStack item : deathToken.items) {
                if (inventory.add(item)) continue;
                player.drop(item, true);
            }
            player.giveExperienceLevels(deathToken.xp);
            inventory.removeItem(itemStack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        DeathCoinHolder deathTokenHolder = (DeathCoinHolder)itemStack.get(DeathCoinMod.TEST);
        if (deathTokenHolder != null) {
            tooltipComponents.add((Component)Component.literal((String)("\u00a77Level: \u00a78" + String.valueOf(deathTokenHolder.xp))));
            int i = 0;
            for (ItemStack itemStack1 : deathTokenHolder.items) {
                String count = String.valueOf(itemStack1.getCount());
                Component key = itemStack1.getHoverName();
                MutableComponent name = Component.translatable((String)key.getString());
                tooltipComponents.add((Component)Component.literal((String)("\u00a77x\u00a78" + count + "\u00a77 " + name.getString())));
                if (Screen.hasShiftDown() || ++i < Config.listLength) continue;
                tooltipComponents.add((Component)Component.literal((String)"\u00a77..."));
                break;
            }
        }
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
    }
}

