/*
 * Decompiled with CFR 0.152.
 */
package net.deathcoinmod;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.deathcoinmod.Config;
import net.deathcoinmod.DeathCoinHolder;
import net.deathcoinmod.DeathCoinItem;
import net.deathcoinmod.DeathEventHandler;
import net.deathcoinmod.RespawnEvenHandler;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="deathcoinmod")
public class DeathCoinMod {
    public static final String MODID = "deathcoinmod";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"deathcoinmod");
    public static final DeferredItem<Item> DEATH_COIN = ITEMS.register("death_coin", () -> new DeathCoinItem(new Item.Properties().stacksTo(1)));
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"deathcoinmod");
    public static final Codec<DeathCoinHolder> DEATH_COIN_HOLDER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.listOf().fieldOf("items").forGetter(o -> o.items), (App)Codec.INT.fieldOf("xp").forGetter(o -> o.xp)).apply((Applicative)instance, (items, xp) -> new DeathCoinHolder((List<ItemStack>)items, (int)xp)));
    public static final Supplier<AttachmentType<DeathCoinHolder>> DEATH_COIN_HOLDER = ATTACHMENT_TYPES.register("death_items", () -> AttachmentType.builder(() -> new DeathCoinHolder(new ArrayList<ItemStack>(), 0)).serialize(DEATH_COIN_HOLDER_CODEC).copyOnDeath().build());
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((String)"deathcoinmod");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DeathCoinHolder>> TEST = DeathCoinMod.register("basic", builder -> builder.persistent(DEATH_COIN_HOLDER_CODEC));

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public DeathCoinMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        ATTACHMENT_TYPES.register(modEventBus);
        DATA_COMPONENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new DeathEventHandler());
        NeoForge.EVENT_BUS.register((Object)new RespawnEvenHandler());
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Loaded Death Coin Mod.");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Starting up with Death Coin Mod.");
    }
}

