/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.WesterosCreativeModeTabs;
import com.westerosblocks.block.custom.BlockBuilder;
import com.westerosblocks.block.custom.WCCropBlock;
import com.westerosblocks.block.custom.WCCuboid16WayBlock;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWBlock;
import com.westerosblocks.block.custom.WCWallFanBlock;
import com.westerosblocks.block.custom.WCWallTorchBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.data.BlockDefinitionRegistry;
import com.westerosblocks.sound.ModSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModBlocks {
    private static final Map<String, class_2248> AUTO_REGISTERED_BLOCKS = new HashMap<String, class_2248>();
    public static final class_2248 OAK_TABLE;
    public static final class_2248 OAK_BRANCH;
    public static final class_2248 BIRCH_BRANCH;
    public static final class_2248 OAK_CHAIR;
    public static final class_2248 ARBOR_BRICK_ARROW_SLIT;
    public static final class_2248 CLOVER;

    private static void registerBlocksFromDefinitions() {
        try {
            BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
            if (!registry.isInitialized()) {
                WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry not initialized - skipping automatic registration");
                return;
            }
            WesterosBlocks.LOGGER.info("Starting automatic block registration from JSON definitions...");
            int registeredCount = 0;
            int skippedCount = 0;
            for (BlockDefinition definition : registry.getAllDefinitions()) {
                try {
                    class_2248 block = ModBlocks.createBlockFromDefinition(definition);
                    if (block != null) {
                        class_2248 registeredBlock = ModBlocks.registerBlock(definition.getBlockName(), block);
                        AUTO_REGISTERED_BLOCKS.put(definition.getBlockName(), registeredBlock);
                        ++registeredCount;
                        WesterosBlocks.LOGGER.debug("Auto-registered block: {} ({})", (Object)definition.getBlockName(), (Object)definition.getBlockType());
                        continue;
                    }
                    ++skippedCount;
                    WesterosBlocks.LOGGER.warn("Skipped unsupported block type '{}' for block '{}'", (Object)definition.getBlockType(), (Object)definition.getBlockName());
                }
                catch (Exception e) {
                    ++skippedCount;
                    WesterosBlocks.LOGGER.error("Failed to register block '{}': {}", (Object)definition.getBlockName(), (Object)e.getMessage());
                }
            }
            WesterosBlocks.LOGGER.info("Automatic block registration complete: {} registered, {} skipped", (Object)registeredCount, (Object)skippedCount);
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error during automatic block registration", (Throwable)e);
        }
    }

    private static class_2248 createBlockFromDefinition(BlockDefinition definition) {
        String blockType = definition.getBlockType();
        class_2498 soundGroup = ModSounds.getSoundGroupFromString(definition.getSoundGroup());
        try {
            switch (blockType.toLowerCase()) {
                case "solid": {
                    return BlockBuilder.solid().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(definition.isNonOpaque()).noCollision(definition.hasNoCollision()).states(definition.hasStates() ? definition.getStates().size() : 0).build(definition);
                }
                case "door": {
                    return BlockBuilder.door().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).woodType(ModBlocks.getWoodTypeFromDefinition(definition)).locked(definition.isLocked()).allowUnsupported(definition.isAllowUnsupported()).build();
                }
                case "log": {
                    return BlockBuilder.log().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).build();
                }
                case "plant": {
                    return BlockBuilder.plant().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).nonOpaque().noCollision().layerSensitive(definition.isLayerSensitive()).build();
                }
                case "flowerpot": {
                    return BlockBuilder.flowerPot().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).nonOpaque(definition.isNonOpaque()).build();
                }
                case "web": {
                    return BlockBuilder.web().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).nonOpaque(definition.isNonOpaque()).noCollision(definition.hasNoCollision()).build();
                }
                case "slab": {
                    return BlockBuilder.slab().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).build();
                }
                case "halfdoor": {
                    return BlockBuilder.halfDoor().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).locked(definition.isLocked()).allowUnsupported(definition.isAllowUnsupported()).build();
                }
                case "fire": {
                    return BlockBuilder.fire().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).luminance(state -> definition.getLuminance()).noCollision(definition.hasNoCollision()).breakInstantly().nonOpaque(definition.isNonOpaque()).build();
                }
                case "ladder": {
                    return BlockBuilder.ladder().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(definition.isNonOpaque()).allowUnsupported(definition.isAllowUnsupported()).build();
                }
                case "vines": {
                    return BlockBuilder.vines().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).nonOpaque(true).allowUnsupported(definition.isAllowUnsupported()).noClimb().canGrowDownward().noCollision(definition.hasNoCollision()).build();
                }
                case "pane": {
                    return BlockBuilder.pane().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(definition.isNonOpaque()).legacyModel(definition.isLegacyModel()).unconnect(definition.isUnconnect()).build();
                }
                case "fence": {
                    return BlockBuilder.fence().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).build();
                }
                case "fencegate": {
                    return BlockBuilder.fenceGate().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).woodType(ModBlocks.getWoodTypeFromDefinition(definition)).locked(definition.isLocked()).build();
                }
                case "trapdoor": {
                    return BlockBuilder.trapdoor().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).woodType(ModBlocks.getWoodTypeFromDefinition(definition)).locked(definition.isLocked()).build();
                }
                case "leaves": {
                    return BlockBuilder.leaves().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque().noDecay().build();
                }
                case "bed": {
                    return BlockBuilder.bed().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque().build();
                }
                case "crop": {
                    List<String> stateValues;
                    BlockBuilder<WCCropBlock> cropBuilder = BlockBuilder.crop().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).toggleOnUse(definition.toggleOnUse()).layerSensitive(definition.isLayerSensitive()).nonOpaque().noCollision();
                    if (definition.hasStates() && (stateValues = definition.getStateValues()) != null && !stateValues.isEmpty()) {
                        cropBuilder.stateValues(stateValues);
                    }
                    return cropBuilder.build(definition);
                }
                case "torch": {
                    String wallTorchName = "wall_" + definition.getBlockName();
                    WCWallTorchBlock wallTorchBlock = BlockBuilder.wallTorch().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).luminance(state -> definition.getLuminance()).nonOpaque(definition.isNonOpaque()).noCollision(definition.hasNoCollision()).allowUnsupported(definition.isAllowUnsupported()).noParticle(definition.isNoParticle()).build();
                    ModBlocks.registerBlockWithoutBlockItem(wallTorchName, (class_2248)wallTorchBlock);
                    return BlockBuilder.torch().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).luminance(state -> definition.getLuminance()).nonOpaque(definition.isNonOpaque()).noCollision(definition.hasNoCollision()).wallBlock((class_2248)wallTorchBlock).allowUnsupported(definition.isAllowUnsupported()).noParticle(definition.isNoParticle()).build();
                }
                case "fan": {
                    String wallFanName = "wall_" + definition.getBlockName();
                    WCWallFanBlock wallFanBlock = BlockBuilder.wallFan().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).nonOpaque(definition.isNonOpaque()).noCollision(definition.hasNoCollision()).allowUnsupported(definition.isAllowUnsupported()).build();
                    ModBlocks.registerBlockWithoutBlockItem(wallFanName, wallFanBlock);
                    return BlockBuilder.fan().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).wallBlock(wallFanBlock).allowUnsupported(definition.isAllowUnsupported()).nonOpaque(definition.isNonOpaque()).noCollision(definition.hasNoCollision()).build();
                }
                case "rail": {
                    return BlockBuilder.rail().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).allowUnsupported(definition.isAllowUnsupported()).nonOpaque(true).noCollision(definition.hasNoCollision()).build();
                }
                case "furnace": {
                    return BlockBuilder.furnace().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().nonOpaque(definition.isNonOpaque()).sounds(soundGroup).luminance(state -> {
                        boolean alwaysOn = definition.isAlwaysOn();
                        boolean isLit = state.method_28498((class_2769)class_2741.field_12548) && (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false;
                        return alwaysOn || isLit ? definition.getLuminance() : 0;
                    }).alwaysOn(definition.isAlwaysOn()).build();
                }
                case "wall": {
                    return BlockBuilder.wall().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().connectState(definition.isConnectState()).wallSize(definition.getWallSize()).unconnect(definition.isUnconnect()).toggleOnUse(definition.toggleOnUse()).sounds(soundGroup).build();
                }
                case "stair": {
                    return BlockBuilder.stair().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().connectState(definition.isConnectState()).unconnect(definition.isUnconnect()).toggleOnUse(definition.toggleOnUse()).sounds(soundGroup).build();
                }
                case "cuboid": {
                    List<String> stateValues;
                    BlockBuilder<WCCuboidBlock> cuboidBuilder = BlockBuilder.cuboid().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(true).noCollision(definition.hasNoCollision()).toggleOnUse(definition.toggleOnUse()).states(definition.hasStates() ? definition.getStates().size() : 0);
                    if (definition.getBoundingBox() != null) {
                        BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                        cuboidBuilder.boundingBox(bbox.getXMin(), bbox.getYMin(), bbox.getZMin(), bbox.getXMax(), bbox.getYMax(), bbox.getZMax());
                    }
                    if (definition.hasStates() && (stateValues = definition.getStateValues()) != null && !stateValues.isEmpty()) {
                        cuboidBuilder.stateValues(stateValues);
                    }
                    return cuboidBuilder.build(definition);
                }
                case "cuboid-nsew": {
                    List<String> stateValues;
                    BlockBuilder<WCCuboidNSEWBlock> cuboidNSEWBuilder = BlockBuilder.cuboidNSEW().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(true).noCollision(definition.hasNoCollision()).toggleOnUse(definition.toggleOnUse()).states(definition.hasStates() ? definition.getStates().size() : 0);
                    if (definition.getBoundingBox() != null) {
                        BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                        cuboidNSEWBuilder.boundingBox(bbox.getXMin(), bbox.getYMin(), bbox.getZMin(), bbox.getXMax(), bbox.getYMax(), bbox.getZMax());
                    }
                    if (definition.hasStates() && (stateValues = definition.getStateValues()) != null && !stateValues.isEmpty()) {
                        cuboidNSEWBuilder.stateValues(stateValues);
                    }
                    return cuboidNSEWBuilder.build(definition);
                }
                case "cuboid-nsew-stack": {
                    return BlockBuilder.cuboidNSEWStack().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(true).noCollision(false).toggleOnUse(definition.toggleOnUse()).states(definition.hasStates() ? definition.getStates().size() : 0).build(definition);
                }
                case "cuboid-ne": {
                    return BlockBuilder.cuboidNE().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque().noCollision(definition.hasNoCollision()).toggleOnUse(definition.toggleOnUse()).states(definition.hasStates() ? definition.getStates().size() : 0).build(definition);
                }
                case "cuboid-nsewud": {
                    return BlockBuilder.cuboidNSEWUD().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(true).noCollision(definition.hasNoCollision()).toggleOnUse(definition.toggleOnUse()).states(definition.hasStates() ? definition.getStates().size() : 0).build(definition);
                }
                case "cuboid-16way": {
                    List<String> stateValues;
                    BlockBuilder<WCCuboid16WayBlock> cuboid16WayBuilder = BlockBuilder.cuboid16Way().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque(true).noCollision(definition.hasNoCollision()).toggleOnUse(definition.toggleOnUse()).states(definition.hasStates() ? definition.getStates().size() : 0);
                    if (definition.getBoundingBox() != null) {
                        BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                        cuboid16WayBuilder.boundingBox(bbox.getXMin(), bbox.getYMin(), bbox.getZMin(), bbox.getXMax(), bbox.getYMax(), bbox.getZMax());
                    }
                    if (definition.hasStates() && (stateValues = definition.getStateValues()) != null && !stateValues.isEmpty()) {
                        cuboid16WayBuilder.stateValues(stateValues);
                    }
                    return cuboid16WayBuilder.build(definition);
                }
                case "layer": {
                    return BlockBuilder.layer().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque().build();
                }
                case "beacon": {
                    return BlockBuilder.beacon().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).nonOpaque().build();
                }
                case "sand": {
                    return BlockBuilder.sand().hardness(definition.getHardness()).resistance(definition.getResistance()).requiresTool().sounds(soundGroup).build();
                }
                case "particle": {
                    return BlockBuilder.particleEmitter().hardness(definition.getHardness()).resistance(definition.getResistance()).sounds(soundGroup).nonOpaque(true).noCollision(true).particle(definition.getParticle()).luminance(state -> definition.getLuminance()).build();
                }
            }
            WesterosBlocks.LOGGER.warn("Unsupported block type '{}' for auto-registration", (Object)blockType);
            return null;
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error creating block from definition: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String getWoodTypeFromDefinition(BlockDefinition definition) {
        String blockName = definition.getBlockName().toLowerCase();
        if (blockName.contains("birch")) {
            return "birch";
        }
        if (blockName.contains("spruce")) {
            return "spruce";
        }
        if (blockName.contains("jungle")) {
            return "jungle";
        }
        if (blockName.contains("oak")) {
            return "oak";
        }
        return "oak";
    }

    public static class_2248 getAutoRegisteredBlock(String blockName) {
        return AUTO_REGISTERED_BLOCKS.get(blockName);
    }

    public static Map<String, class_2248> getAllAutoRegisteredBlocks() {
        return new HashMap<String, class_2248>(AUTO_REGISTERED_BLOCKS);
    }

    private static void registerAutoBlocksToCreativeTabs() {
        try {
            BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
            if (!registry.isInitialized()) {
                WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry not initialized - skipping creative tab registration");
                return;
            }
            HashMap<String, List> blocksByTab = new HashMap<String, List>();
            for (BlockDefinition definition : registry.getAllDefinitions()) {
                String creativeTab = definition.getCreativeTab();
                String blockName = definition.getBlockName();
                class_2248 block = AUTO_REGISTERED_BLOCKS.get(blockName);
                if (block == null || creativeTab == null || creativeTab.isEmpty()) continue;
                blocksByTab.computeIfAbsent(creativeTab, k -> new ArrayList()).add(block);
            }
            int totalRegistered = 0;
            for (Map.Entry entry : blocksByTab.entrySet()) {
                String tabName = (String)entry.getKey();
                List blocks = (List)entry.getValue();
                if (blocks.isEmpty()) continue;
                class_2248[] blockArray = blocks.toArray(new class_2248[0]);
                WesterosCreativeModeTabs.addToTab(tabName, blockArray);
                totalRegistered += blocks.size();
                WesterosBlocks.LOGGER.info("Added {} blocks to creative tab '{}'", (Object)blocks.size(), (Object)tabName);
            }
            WesterosBlocks.LOGGER.info("Successfully registered {} auto-blocks to {} creative tabs", (Object)totalRegistered, (Object)blocksByTab.size());
        }
        catch (Exception e) {
            WesterosBlocks.LOGGER.error("Error registering auto-blocks to creative tabs", (Throwable)e);
        }
    }

    public static void registerModBlocks() {
        WesterosBlocks.LOGGER.info("Registering Mod Blocks for westerosblocks");
        ModBlocks.registerAutoBlocksToCreativeTabs();
        WesterosCreativeModeTabs.addToTab("westeros_test_tab", ARBOR_BRICK_ARROW_SLIT);
        WesterosCreativeModeTabs.addToTab("westeros_furniture_tab", OAK_TABLE, OAK_CHAIR);
        WesterosCreativeModeTabs.addToTab("westeros_decor_tab", OAK_BRANCH, BIRCH_BRANCH, CLOVER);
    }

    public static class_2248 registerBlock(String name, class_2248 block) {
        ModBlocks.registerBlockItem(name, block);
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)name), (Object)block);
    }

    private static void registerBlockItem(String name, class_2248 block) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)name), (Object)new class_1747(block, new class_1792.class_1793()));
    }

    private static class_2248 registerBlockWithoutBlockItem(String name, class_2248 block) {
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)name), (Object)block);
    }

    static {
        ModBlocks.registerBlocksFromDefinitions();
        OAK_TABLE = ModBlocks.registerBlock("oak_table", BlockBuilder.table().strength(2.0f).requiresTool().sounds(class_2498.field_11547).build());
        OAK_BRANCH = ModBlocks.registerBlock("oak_branch", BlockBuilder.branch().strength(2.0f).requiresTool().sounds(class_2498.field_11547).build());
        BIRCH_BRANCH = ModBlocks.registerBlock("birch_branch", BlockBuilder.branch().strength(2.0f).requiresTool().sounds(class_2498.field_11547).build());
        OAK_CHAIR = ModBlocks.registerBlock("oak_chair", (class_2248)BlockBuilder.chair().strength(2.0f).requiresTool().sounds(class_2498.field_11547).woodType("oak").build());
        ARBOR_BRICK_ARROW_SLIT = ModBlocks.registerBlock("arbor_brick_arrow_slit_test", BlockBuilder.arrowSlit().strength(2.0f).requiresTool().sounds(class_2498.field_11544).build());
        CLOVER = ModBlocks.registerBlock("clover", (class_2248)BlockBuilder.flowerbed().strength(0.0f).sounds(class_2498.field_11535).nonOpaque().noCollision().build());
    }
}

