/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.block.custom;

import com.westerosblocks.block.custom.BlockFactory;
import com.westerosblocks.block.custom.WCArrowSlitBlock;
import com.westerosblocks.block.custom.WCBeaconBlock;
import com.westerosblocks.block.custom.WCBedBlock;
import com.westerosblocks.block.custom.WCBranchBlock;
import com.westerosblocks.block.custom.WCChairBlock;
import com.westerosblocks.block.custom.WCCropBlock;
import com.westerosblocks.block.custom.WCCuboid16WayBlock;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.block.custom.WCCuboidNEBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWStackBlock;
import com.westerosblocks.block.custom.WCCuboidNSEWUDBlock;
import com.westerosblocks.block.custom.WCDoorBlock;
import com.westerosblocks.block.custom.WCFanBlock;
import com.westerosblocks.block.custom.WCFenceBlock;
import com.westerosblocks.block.custom.WCFenceGateBlock;
import com.westerosblocks.block.custom.WCFireBlock;
import com.westerosblocks.block.custom.WCFlowerPotBlock;
import com.westerosblocks.block.custom.WCFlowerbedBlock;
import com.westerosblocks.block.custom.WCFurnaceBlock;
import com.westerosblocks.block.custom.WCHalfDoorBlock;
import com.westerosblocks.block.custom.WCLadderBlock;
import com.westerosblocks.block.custom.WCLayerBlock;
import com.westerosblocks.block.custom.WCLeavesBlock;
import com.westerosblocks.block.custom.WCLogBlock;
import com.westerosblocks.block.custom.WCPaneBlock;
import com.westerosblocks.block.custom.WCParticleEmitterBlock;
import com.westerosblocks.block.custom.WCPlantBlock;
import com.westerosblocks.block.custom.WCRailBlock;
import com.westerosblocks.block.custom.WCSandBlock;
import com.westerosblocks.block.custom.WCSlabBlock;
import com.westerosblocks.block.custom.WCSolidBlock;
import com.westerosblocks.block.custom.WCStairBlock;
import com.westerosblocks.block.custom.WCTableBlock;
import com.westerosblocks.block.custom.WCTorchBlock;
import com.westerosblocks.block.custom.WCTrapDoorBlock;
import com.westerosblocks.block.custom.WCVinesBlock;
import com.westerosblocks.block.custom.WCWallBlock;
import com.westerosblocks.block.custom.WCWallFanBlock;
import com.westerosblocks.block.custom.WCWallTorchBlock;
import com.westerosblocks.block.custom.WCWebBlock;
import com.westerosblocks.data.BlockDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public class BlockBuilder<T extends class_2248> {
    private class_4970.class_2251 settings;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private BlockFactory factory;

    private BlockBuilder(BlockFactory factory) {
        this.settings = class_4970.class_2251.method_9637();
        this.factory = factory;
    }

    public static BlockBuilder<WCHalfDoorBlock> halfDoor() {
        return new BlockBuilder<WCHalfDoorBlock>(new WCHalfDoorBlock.Factory());
    }

    public static BlockBuilder<WCDoorBlock> door() {
        return new BlockBuilder<WCDoorBlock>(new WCDoorBlock.Factory());
    }

    public static BlockBuilder<WCPaneBlock> pane() {
        return new BlockBuilder<WCPaneBlock>(new WCPaneBlock.Factory());
    }

    public static BlockBuilder<WCSolidBlock> solid() {
        return new BlockBuilder<WCSolidBlock>(new WCSolidBlock.Factory());
    }

    public static BlockBuilder<WCSlabBlock> slab() {
        return new BlockBuilder<WCSlabBlock>(new WCSlabBlock.Factory());
    }

    public static BlockBuilder<WCLogBlock> log() {
        return new BlockBuilder<WCLogBlock>(new WCLogBlock.Factory());
    }

    public static BlockBuilder<WCTableBlock> table() {
        return new BlockBuilder<WCTableBlock>(new WCTableBlock.Factory());
    }

    public static BlockBuilder<WCBranchBlock> branch() {
        return new BlockBuilder<WCBranchBlock>(new WCBranchBlock.Factory());
    }

    public static BlockBuilder<WCChairBlock> chair() {
        return new BlockBuilder<WCChairBlock>(new WCChairBlock.Factory());
    }

    public static BlockBuilder<WCTorchBlock> torch() {
        return new BlockBuilder<WCTorchBlock>(new WCTorchBlock.Factory());
    }

    public static BlockBuilder<WCWallTorchBlock> wallTorch() {
        return new BlockBuilder<WCWallTorchBlock>(new WCWallTorchBlock.Factory());
    }

    public static BlockBuilder<WCArrowSlitBlock> arrowSlit() {
        return new BlockBuilder<WCArrowSlitBlock>(new WCArrowSlitBlock.Factory());
    }

    public static BlockBuilder<WCRailBlock> rail() {
        return new BlockBuilder<WCRailBlock>(new WCRailBlock.Factory());
    }

    public static BlockBuilder<WCFanBlock> fan() {
        return new BlockBuilder<WCFanBlock>(new WCFanBlock.Factory());
    }

    public static BlockBuilder<WCWallFanBlock> wallFan() {
        return new BlockBuilder<WCWallFanBlock>(new WCWallFanBlock.Factory());
    }

    public static BlockBuilder<WCFenceBlock> fence() {
        return new BlockBuilder<WCFenceBlock>(new WCFenceBlock.Factory());
    }

    public static BlockBuilder<WCFenceGateBlock> fenceGate() {
        return new BlockBuilder<WCFenceGateBlock>(new WCFenceGateBlock.Factory());
    }

    public static BlockBuilder<WCTrapDoorBlock> trapdoor() {
        return new BlockBuilder<WCTrapDoorBlock>(new WCTrapDoorBlock.Factory());
    }

    public static BlockBuilder<WCLayerBlock> layer() {
        return new BlockBuilder<WCLayerBlock>(new WCLayerBlock.Factory());
    }

    public static BlockBuilder<WCPlantBlock> plant() {
        return new BlockBuilder<WCPlantBlock>(new WCPlantBlock.Factory());
    }

    public static BlockBuilder<WCCropBlock> crop() {
        return new BlockBuilder<WCCropBlock>(new WCCropBlock.Factory());
    }

    public static BlockBuilder<WCWebBlock> web() {
        return new BlockBuilder<WCWebBlock>(new WCWebBlock.Factory());
    }

    public static BlockBuilder<WCWebBlock> bed() {
        return new BlockBuilder<WCWebBlock>(new WCBedBlock.Factory());
    }

    public static BlockBuilder<WCFlowerbedBlock> flowerbed() {
        return new BlockBuilder<WCFlowerbedBlock>(new WCFlowerbedBlock.Factory());
    }

    public static BlockBuilder<WCLeavesBlock> leaves() {
        return new BlockBuilder<WCLeavesBlock>(new WCLeavesBlock.Factory());
    }

    public static BlockBuilder<WCVinesBlock> vines() {
        return new BlockBuilder<WCVinesBlock>(new WCVinesBlock.Factory());
    }

    public static BlockBuilder<WCLadderBlock> ladder() {
        return new BlockBuilder<WCLadderBlock>(new WCLadderBlock.Factory());
    }

    public static BlockBuilder<WCFlowerPotBlock> flowerPot() {
        return new BlockBuilder<WCFlowerPotBlock>(new WCFlowerPotBlock.Factory());
    }

    public static BlockBuilder<WCParticleEmitterBlock> particleEmitter() {
        return new BlockBuilder<WCParticleEmitterBlock>(new WCParticleEmitterBlock.Factory());
    }

    public static BlockBuilder<WCFireBlock> fire() {
        return new BlockBuilder<WCFireBlock>(new WCFireBlock.Factory());
    }

    public static BlockBuilder<WCFurnaceBlock> furnace() {
        return new BlockBuilder<WCFurnaceBlock>(new WCFurnaceBlock.Factory());
    }

    public static BlockBuilder<WCWallBlock> wall() {
        return new BlockBuilder<WCWallBlock>(new WCWallBlock.Factory());
    }

    public static BlockBuilder<WCCuboidBlock> cuboid() {
        return new BlockBuilder<WCCuboidBlock>(new WCCuboidBlock.Factory());
    }

    public static BlockBuilder<WCCuboidNSEWBlock> cuboidNSEW() {
        return new BlockBuilder<WCCuboidNSEWBlock>(new WCCuboidNSEWBlock.Factory());
    }

    public static BlockBuilder<WCCuboidNSEWStackBlock> cuboidNSEWStack() {
        return new BlockBuilder<WCCuboidNSEWStackBlock>(new WCCuboidNSEWStackBlock.Factory());
    }

    public static BlockBuilder<WCCuboidNEBlock> cuboidNE() {
        return new BlockBuilder<WCCuboidNEBlock>(new WCCuboidNEBlock.Factory());
    }

    public static BlockBuilder<WCCuboidNSEWUDBlock> cuboidNSEWUD() {
        return new BlockBuilder<WCCuboidNSEWUDBlock>(new WCCuboidNSEWUDBlock.Factory());
    }

    public static BlockBuilder<WCCuboid16WayBlock> cuboid16Way() {
        return new BlockBuilder<WCCuboid16WayBlock>(new WCCuboid16WayBlock.Factory());
    }

    public static BlockBuilder<WCStairBlock> stair() {
        return new BlockBuilder<WCStairBlock>(new WCStairBlock.Factory());
    }

    public static BlockBuilder<WCBeaconBlock> beacon() {
        return new BlockBuilder<WCBeaconBlock>(new WCBeaconBlock.Factory());
    }

    public static BlockBuilder<WCSandBlock> sand() {
        return new BlockBuilder<WCSandBlock>(new WCSandBlock.Factory());
    }

    public BlockBuilder<T> settings(class_4970.class_2251 settings) {
        this.settings = settings;
        return this;
    }

    public BlockBuilder<T> strength(float strength) {
        this.settings = this.settings.method_9632(strength);
        return this;
    }

    public BlockBuilder<T> hardness(float hardness) {
        this.settings = this.settings.method_36557(hardness);
        return this;
    }

    public BlockBuilder<T> resistance(float resistance) {
        this.settings = this.settings.method_36558(Math.max(0.0f, resistance));
        return this;
    }

    public BlockBuilder<T> requiresTool() {
        this.settings = this.settings.method_29292();
        return this;
    }

    public BlockBuilder<T> sounds(class_2498 soundGroup) {
        this.settings = this.settings.method_9626(soundGroup);
        return this;
    }

    public BlockBuilder<T> luminance(ToIntFunction<class_2680> luminanceFunction) {
        this.settings = this.settings.method_9631(luminanceFunction);
        return this;
    }

    public BlockBuilder<T> nonOpaque() {
        this.settings = this.settings.method_22488();
        return this;
    }

    public BlockBuilder<T> nonOpaque(Boolean condition) {
        if (Boolean.TRUE.equals(condition)) {
            this.settings = this.settings.method_22488();
        }
        return this;
    }

    public BlockBuilder<T> noCollision() {
        this.settings = this.settings.method_9634();
        return this;
    }

    public BlockBuilder<T> noCollision(Boolean condition) {
        if (Boolean.TRUE.equals(condition)) {
            this.settings = this.settings.method_9634();
        }
        return this;
    }

    public BlockBuilder<T> breakInstantly() {
        this.settings = this.settings.method_9618();
        return this;
    }

    public BlockBuilder<T> locked(boolean locked) {
        this.parameters.put("locked", locked);
        return this;
    }

    public BlockBuilder<T> locked() {
        this.parameters.put("locked", true);
        return this;
    }

    public BlockBuilder<T> allowUnsupported(boolean allowUnsupported) {
        this.parameters.put("allowUnsupported", allowUnsupported);
        return this;
    }

    public BlockBuilder<T> allowUnsupported() {
        this.parameters.put("allowUnsupported", true);
        return this;
    }

    public BlockBuilder<T> woodType(String woodType) {
        this.parameters.put("woodType", woodType);
        return this;
    }

    public BlockBuilder<T> legacyModel(boolean legacyModel) {
        this.parameters.put("legacyModel", legacyModel);
        return this;
    }

    public BlockBuilder<T> barsModel(boolean barsModel) {
        this.parameters.put("barsModel", barsModel);
        return this;
    }

    public BlockBuilder<T> toggleOnUse(boolean toggleOnUse) {
        this.parameters.put("toggleOnUse", toggleOnUse);
        return this;
    }

    public BlockBuilder<T> toggleOnUse() {
        this.parameters.put("toggleOnUse", true);
        return this;
    }

    public BlockBuilder<T> states(int numStates) {
        this.parameters.put("states", numStates);
        return this;
    }

    public BlockBuilder<T> symmetrical(boolean symmetrical) {
        this.parameters.put("symmetrical", symmetrical);
        return this;
    }

    public BlockBuilder<T> wallBlock(class_2248 wallBlock) {
        this.parameters.put("wallBlock", wallBlock);
        return this;
    }

    public BlockBuilder<T> noParticle(boolean noParticle) {
        this.parameters.put("noParticle", noParticle);
        return this;
    }

    public BlockBuilder<T> layerSensitive(boolean layerSensitive) {
        this.parameters.put("layerSensitive", layerSensitive);
        return this;
    }

    public BlockBuilder<T> layerSensitive() {
        this.parameters.put("layerSensitive", true);
        return this;
    }

    public BlockBuilder<T> noInWeb(boolean noInWeb) {
        this.parameters.put("noInWeb", noInWeb);
        return this;
    }

    public BlockBuilder<T> noInWeb() {
        this.parameters.put("noInWeb", true);
        return this;
    }

    public BlockBuilder<T> stateValues(List<String> stateValues) {
        this.parameters.put("stateValues", stateValues);
        return this;
    }

    public BlockBuilder<T> betterFoliage(boolean betterFoliage) {
        this.parameters.put("betterFoliage", betterFoliage);
        return this;
    }

    public BlockBuilder<T> betterFoliage() {
        this.parameters.put("betterFoliage", true);
        return this;
    }

    public BlockBuilder<T> overlay(boolean overlay) {
        this.parameters.put("overlay", overlay);
        return this;
    }

    public BlockBuilder<T> overlay() {
        this.parameters.put("overlay", true);
        return this;
    }

    public BlockBuilder<T> noDecay(boolean noDecay) {
        this.parameters.put("noDecay", noDecay);
        return this;
    }

    public BlockBuilder<T> noDecay() {
        this.parameters.put("noDecay", true);
        return this;
    }

    public BlockBuilder<T> noClimb() {
        this.parameters.put("noClimb", true);
        return this;
    }

    public BlockBuilder<T> canGrowDownward() {
        this.parameters.put("canGrowDownward", true);
        return this;
    }

    public BlockBuilder<T> plant(class_2248 plant) {
        this.parameters.put("plant", plant);
        return this;
    }

    public BlockBuilder<T> plantId(String plantId) {
        this.parameters.put("plantId", plantId);
        return this;
    }

    public BlockBuilder<T> particle(String particle) {
        this.parameters.put("particle", particle);
        return this;
    }

    public BlockBuilder<T> alwaysOn(boolean alwaysOn) {
        this.parameters.put("alwaysOn", alwaysOn);
        return this;
    }

    public BlockBuilder<T> alwaysOn() {
        this.parameters.put("alwaysOn", true);
        return this;
    }

    public BlockBuilder<T> unconnect(boolean unconnect) {
        this.parameters.put("unconnect", unconnect);
        return this;
    }

    public BlockBuilder<T> unconnect() {
        this.parameters.put("unconnect", true);
        return this;
    }

    public BlockBuilder<T> connectState(boolean connectState) {
        this.parameters.put("connectState", connectState);
        return this;
    }

    public BlockBuilder<T> connectState() {
        this.parameters.put("connectState", true);
        return this;
    }

    public BlockBuilder<T> wallSize(String wallSize) {
        this.parameters.put("size", wallSize);
        return this;
    }

    public BlockBuilder<T> boundingBox(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        HashMap<String, Double> boundingBoxMap = new HashMap<String, Double>();
        boundingBoxMap.put("xMin", xMin);
        boundingBoxMap.put("yMin", yMin);
        boundingBoxMap.put("zMin", zMin);
        boundingBoxMap.put("xMax", xMax);
        boundingBoxMap.put("yMax", yMax);
        boundingBoxMap.put("zMax", zMax);
        this.parameters.put("boundingBox", boundingBoxMap);
        return this;
    }

    public T build() {
        if (this.settings == null) {
            throw new IllegalStateException("Settings must be provided");
        }
        if (this.factory == null) {
            throw new IllegalStateException("Factory must be provided - use static factory methods like BlockBuilder.halfDoor()");
        }
        return (T)this.factory.buildBlockClass(this.settings, null, this.parameters);
    }

    public T build(BlockDefinition definition) {
        if (this.settings == null) {
            throw new IllegalStateException("Settings must be provided");
        }
        if (this.factory == null) {
            throw new IllegalStateException("Factory must be provided - use static factory methods like BlockBuilder.halfDoor()");
        }
        return (T)this.factory.buildBlockClass(this.settings, definition, this.parameters);
    }
}

