/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.data;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.data.BlockDefinitionRegistry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.fabricmc.loader.api.FabricLoader;

public class WorldPainterExporter {
    private static final String CSV_FILENAME = "westerosblocks-worldpainter.csv";

    public static void exportToCSV() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        File csvFile = new File(configDir, CSV_FILENAME);
        WesterosBlocks.LOGGER.info("Exporting blocks to WorldPainter CSV: {}", (Object)csvFile.getAbsolutePath());
        try (FileWriter writer = new FileWriter(csvFile);){
            WorldPainterExporter.writeHeader(writer);
            Collection<BlockDefinition> definitions = BlockDefinitionRegistry.getInstance().getAllDefinitions();
            WesterosBlocks.LOGGER.info("Exporting {} block definitions...", (Object)definitions.size());
            for (BlockDefinition def : definitions) {
                WorldPainterExporter.writeBlockRow(writer, def);
            }
            WesterosBlocks.LOGGER.info("Successfully exported {} blocks to {}", (Object)definitions.size(), (Object)csvFile.getName());
        }
        catch (IOException e) {
            WesterosBlocks.LOGGER.error("Failed to export WorldPainter CSV", (Throwable)e);
        }
    }

    private static void writeHeader(FileWriter writer) throws IOException {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("name");
        headers.add("opacity");
        headers.add("receivesLight");
        headers.add("insubstantial");
        headers.add("blockLight");
        headers.add("colour");
        headers.add("properties");
        headers.add("horizontal_orientation_schemes");
        headers.add("vertical_orientation_scheme");
        headers.add("tileEntity");
        headers.add("transparency");
        writer.write(String.join((CharSequence)",", headers));
        writer.write("\n");
    }

    private static void writeBlockRow(FileWriter writer, BlockDefinition def) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(WorldPainterExporter.quote("westerosblocks:" + def.getBlockName()));
        boolean isOpaque = !def.isNonOpaque();
        values.add(String.valueOf(isOpaque ? 15 : 0));
        values.add(String.valueOf(isOpaque));
        boolean insubstantial = WorldPainterExporter.isInsubstantial(def);
        values.add(String.valueOf(insubstantial));
        int luminance = def.getLuminance();
        values.add(String.valueOf(luminance));
        String color = WorldPainterExporter.getColorValue(def);
        values.add(color.isEmpty() ? "" : WorldPainterExporter.quote(color));
        String properties = WorldPainterExporter.getProperties(def);
        values.add(properties.isEmpty() ? "" : WorldPainterExporter.quote(properties));
        String horizontalOrientation = WorldPainterExporter.getHorizontalOrientation(def);
        values.add(horizontalOrientation.isEmpty() ? "" : WorldPainterExporter.quote(horizontalOrientation));
        String verticalOrientation = WorldPainterExporter.getVerticalOrientation(def);
        values.add(verticalOrientation.isEmpty() ? "" : WorldPainterExporter.quote(verticalOrientation));
        boolean hasTileEntity = WorldPainterExporter.hasTileEntity(def);
        values.add(String.valueOf(hasTileEntity));
        boolean hasTransparency = WorldPainterExporter.hasTransparency(def);
        values.add(String.valueOf(hasTransparency));
        writer.write(String.join((CharSequence)",", values));
        writer.write("\n");
    }

    private static boolean isInsubstantial(BlockDefinition def) {
        String blockType = def.getBlockType();
        return blockType.equals("plant") || blockType.equals("crop") || blockType.equals("torch") || blockType.equals("fire") || blockType.equals("vines") || blockType.equals("rail") || blockType.equals("fan") || def.hasNoCollision();
    }

    private static String getColorValue(BlockDefinition def) {
        if (def.getColorMult() != null && !def.getColorMult().isEmpty()) {
            return def.getColorMult();
        }
        return "";
    }

    private static String getProperties(BlockDefinition def) {
        String blockType;
        ArrayList<Object> properties = new ArrayList<Object>();
        switch (blockType = def.getBlockType()) {
            case "stair": {
                properties.add("facing=north,south,east,west");
                properties.add("half=top,bottom");
                properties.add("shape=straight,inner_left,inner_right,outer_left,outer_right");
                break;
            }
            case "slab": {
                properties.add("type=top,bottom,double");
                break;
            }
            case "door": 
            case "halfdoor": {
                properties.add("facing=north,south,east,west");
                properties.add("open=true,false");
                properties.add("hinge=left,right");
                break;
            }
            case "fencegate": {
                properties.add("facing=north,south,east,west");
                properties.add("open=true,false");
                break;
            }
            case "log": {
                properties.add("axis=x,y,z");
                break;
            }
            case "wall": {
                properties.add("north=none,low,tall");
                properties.add("south=none,low,tall");
                properties.add("east=none,low,tall");
                properties.add("west=none,low,tall");
                properties.add("up=true,false");
                break;
            }
            case "fence": 
            case "pane": {
                properties.add("north=true,false");
                properties.add("south=true,false");
                properties.add("east=true,false");
                properties.add("west=true,false");
                break;
            }
            case "ladder": 
            case "torch": {
                properties.add("facing=north,south,east,west");
                break;
            }
            case "layer": {
                properties.add("layers=1,2,3,4,5,6,7,8");
            }
        }
        if (def.hasStates()) {
            ArrayList<String> stateIds = new ArrayList<String>();
            for (BlockDefinition.StateVariant state : def.getStates()) {
                stateIds.add(state.getStateID());
            }
            if (!stateIds.isEmpty()) {
                properties.add("state=" + String.join((CharSequence)",", stateIds));
            }
        }
        return String.join((CharSequence)";", properties);
    }

    private static String getHorizontalOrientation(BlockDefinition def) {
        String blockType;
        switch (blockType = def.getBlockType()) {
            case "stair": 
            case "door": 
            case "halfdoor": 
            case "fencegate": 
            case "ladder": 
            case "furnace": 
            case "bed": 
            case "chair": {
                return "CARDINAL_DIRECTIONS";
            }
            case "log": {
                return "CARDINAL_DIRECTIONS,CARDINAL_DIRECTIONS_HORIZONTAL";
            }
        }
        return "";
    }

    private static String getVerticalOrientation(BlockDefinition def) {
        String blockType = def.getBlockType();
        if (blockType.equals("log")) {
            return "MIRROR";
        }
        return "";
    }

    private static boolean hasTileEntity(BlockDefinition def) {
        String blockType = def.getBlockType();
        return blockType.equals("furnace") || blockType.equals("bed") || blockType.equals("beacon") || blockType.equals("particle");
    }

    private static boolean hasTransparency(BlockDefinition def) {
        return def.isAlphaRender() || def.getRenderLayer() != null && (def.getRenderLayer().equals("translucent") || def.getRenderLayer().equals("cutout"));
    }

    private static String quote(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return "\"" + value.replace("\"", "\"\"") + "\"";
    }
}

