/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen;

import com.westerosblocks.datagen.custom.ArrowSlitBlockExporter;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.datagen.custom.BranchBlockExporter;
import com.westerosblocks.datagen.custom.ChairBlockExporter;
import com.westerosblocks.datagen.custom.FlowerbedBlockExporter;
import com.westerosblocks.datagen.custom.TableBlockExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_4910;
import net.minecraft.class_4945;

public class ModBlockStateModelGenerator
extends BaseBlockExporter {
    private static void generateBranch(class_4910 generator, class_2248 block, String texturePath) {
        BranchBlockExporter.registerBranchBlock(generator, block, texturePath);
    }

    private static void generateChair(class_4910 generator, class_2248 block, String texturePath) {
        ChairBlockExporter.registerChairBlock(generator, block, texturePath);
    }

    private static void generateTable(class_4910 generator, class_2248 block, String texturePath) {
        TableBlockExporter.registerCustomTableBlock(generator, block, texturePath);
    }

    private static void generateArrowSlit(class_4910 generator, class_2248 block, String texturePath) {
        ArrowSlitBlockExporter.registerArrowSlitBlock(generator, block, texturePath);
    }

    public static CustomBlockBuilder registerCustomBranchBlock(class_4910 generator, class_2248 block) {
        return new CustomBlockBuilder(generator, block, "branch");
    }

    public static CustomBlockBuilder registerCustomChairBlock(class_4910 generator, class_2248 block) {
        return new CustomBlockBuilder(generator, block, "chair");
    }

    public static CustomBlockBuilder registerCustomTableBlock(class_4910 generator, class_2248 block) {
        return new CustomBlockBuilder(generator, block, "table");
    }

    public static CustomBlockBuilder registerCustomArrowSlitBlock(class_4910 generator, class_2248 block) {
        return new CustomBlockBuilder(generator, block, "arrow_slit");
    }

    public static FlowerbedBlockExporter.CustomFlowerbedBuilder registerCustomFlowerbedBlock(class_4910 generator, class_2248 block) {
        return FlowerbedBlockExporter.registerCustomFlowerbedBlock(generator, block);
    }

    public static class CustomBlockBuilder {
        private final class_4910 generator;
        private final class_2248 block;
        private final String blockType;
        private String texture = "";
        private String[] textures = new String[0];
        private List<String[]> randomTextures = new ArrayList<String[]>();
        private List<String[]> states = new ArrayList<String[]>();
        private boolean isTinted = false;

        public CustomBlockBuilder(class_4910 generator, class_2248 block, String blockType) {
            this.generator = generator;
            this.block = block;
            this.blockType = blockType;
        }

        public CustomBlockBuilder texture(String texturePath) {
            this.texture = texturePath;
            return this;
        }

        public CustomBlockBuilder textures(String ... texturePaths) {
            this.textures = texturePaths;
            return this;
        }

        public CustomBlockBuilder randomTexture(String ... texturePaths) {
            this.randomTextures.add(texturePaths);
            return this;
        }

        public CustomBlockBuilder state(String ... texturePaths) {
            this.states.add(texturePaths);
            return this;
        }

        public CustomBlockBuilder isTinted(boolean tinted) {
            this.isTinted = tinted;
            return this;
        }

        public void build() {
            switch (this.blockType) {
                case "branch": {
                    this.buildBranch();
                    break;
                }
                case "chair": {
                    this.buildChair();
                    break;
                }
                case "table": {
                    this.buildTable();
                    break;
                }
                case "arrow_slit": {
                    this.buildArrowSlit();
                    break;
                }
                case "flowerbed": {
                    this.buildFlowerbed();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown block type: " + this.blockType);
                }
            }
        }

        private void buildBranch() {
            ModBlockStateModelGenerator.generateBranch(this.generator, this.block, !this.texture.isEmpty() ? this.texture : this.textures[0]);
        }

        private void buildChair() {
            ModBlockStateModelGenerator.generateChair(this.generator, this.block, !this.texture.isEmpty() ? this.texture : this.textures[0]);
        }

        private void buildTable() {
            ModBlockStateModelGenerator.generateTable(this.generator, this.block, !this.texture.isEmpty() ? this.texture : this.textures[0]);
        }

        private void buildArrowSlit() {
            ModBlockStateModelGenerator.generateArrowSlit(this.generator, this.block, !this.texture.isEmpty() ? this.texture : this.textures[0]);
        }

        private void buildFlowerbed() {
            if (!this.texture.isEmpty()) {
                FlowerbedBlockExporter.generateCustomFlowerbed(this.generator, this.block, "block/flowerbed", class_4945.field_23034, "", this.texture);
            } else if (this.textures.length > 0) {
                String stemTexture = this.textures.length > 1 ? this.textures[0] : "";
                String flowerTexture = this.textures.length > 1 ? this.textures[1] : this.textures[0];
                FlowerbedBlockExporter.generateCustomFlowerbed(this.generator, this.block, "block/flowerbed", class_4945.field_23034, stemTexture, flowerTexture);
            }
        }
    }
}

