/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class BedBlockExporter
extends BaseBlockExporter {
    private static class_4942 createBedPartModel(String bedType, boolean isHead, boolean tinted) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String partSuffix = isHead ? "_head" : "_foot";
        String bedTypeName = switch (bedType) {
            case "raised" -> "bed_raised";
            case "hammock" -> "bed_hammock";
            default -> "bed";
        };
        String path = tintPath + bedTypeName + partSuffix;
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23012, ModTextureKey.BED_TOP, ModTextureKey.BED_SIDE, ModTextureKey.BED_END});
    }

    private static class_4942 createBedItemModel(boolean tinted) {
        String path = tinted ? "item/tinted/bed_item" : "item/untinted/bed_item";
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{ModTextureKey.BED_TOP, ModTextureKey.BED_TOP2, ModTextureKey.BED_SIDE, ModTextureKey.BED_SIDE2, ModTextureKey.BED_END, ModTextureKey.BED_END2});
    }

    private static class_4944 createBedPartTextureMap(String[] textures, boolean isHead) {
        if (isHead) {
            return new class_4944().method_25868(class_4945.field_23012, BedBlockExporter.createBlockIdentifier(textures[0])).method_25868(ModTextureKey.BED_TOP, BedBlockExporter.createBlockIdentifier(textures[0])).method_25868(ModTextureKey.BED_SIDE, BedBlockExporter.createBlockIdentifier(textures[2])).method_25868(ModTextureKey.BED_END, BedBlockExporter.createBlockIdentifier(textures[4]));
        }
        return new class_4944().method_25868(class_4945.field_23012, BedBlockExporter.createBlockIdentifier(textures[1])).method_25868(ModTextureKey.BED_TOP, BedBlockExporter.createBlockIdentifier(textures[1])).method_25868(ModTextureKey.BED_SIDE, BedBlockExporter.createBlockIdentifier(textures[3])).method_25868(ModTextureKey.BED_END, BedBlockExporter.createBlockIdentifier(textures[5]));
    }

    private static class_4944 createBedItemTextureMap(String[] textures) {
        return new class_4944().method_25868(ModTextureKey.BED_TOP, BedBlockExporter.createBlockIdentifier(textures[0])).method_25868(ModTextureKey.BED_TOP2, BedBlockExporter.createBlockIdentifier(textures[1])).method_25868(ModTextureKey.BED_SIDE, BedBlockExporter.createBlockIdentifier(textures[2])).method_25868(ModTextureKey.BED_SIDE2, BedBlockExporter.createBlockIdentifier(textures[3])).method_25868(ModTextureKey.BED_END, BedBlockExporter.createBlockIdentifier(textures[4])).method_25868(ModTextureKey.BED_END2, BedBlockExporter.createBlockIdentifier(textures[5]));
    }

    private static class_4925 createBedBlockstate(class_2248 block, class_2960 headModelId, class_2960 footModelId) {
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12483).method_25797((Comparable)class_2350.field_11043, (Comparable)class_2742.field_12557, BedBlockExporter.createVariant(footModelId, 180)).method_25797((Comparable)class_2350.field_11034, (Comparable)class_2742.field_12557, BedBlockExporter.createVariant(footModelId, 270)).method_25797((Comparable)class_2350.field_11035, (Comparable)class_2742.field_12557, BedBlockExporter.createVariant(footModelId, 0)).method_25797((Comparable)class_2350.field_11039, (Comparable)class_2742.field_12557, BedBlockExporter.createVariant(footModelId, 90)).method_25797((Comparable)class_2350.field_11043, (Comparable)class_2742.field_12560, BedBlockExporter.createVariant(headModelId, 180)).method_25797((Comparable)class_2350.field_11034, (Comparable)class_2742.field_12560, BedBlockExporter.createVariant(headModelId, 270)).method_25797((Comparable)class_2350.field_11035, (Comparable)class_2742.field_12560, BedBlockExporter.createVariant(headModelId, 0)).method_25797((Comparable)class_2350.field_11039, (Comparable)class_2742.field_12560, BedBlockExporter.createVariant(headModelId, 90)));
    }

    public static void registerBedBlock(class_4910 generator, class_2248 block, boolean tinted, String bedType, String[] textures) {
        if (textures.length != 6) {
            throw new IllegalArgumentException("Bed blocks require exactly 6 textures, got " + textures.length);
        }
        class_4944 headTextureMap = BedBlockExporter.createBedPartTextureMap(textures, true);
        class_4944 footTextureMap = BedBlockExporter.createBedPartTextureMap(textures, false);
        class_2960 headModelId = BedBlockExporter.createBedPartModel(bedType, true, tinted).method_25852(BedBlockExporter.createNestedModelId(block, "head"), headTextureMap, generator.field_22831);
        class_2960 footModelId = BedBlockExporter.createBedPartModel(bedType, false, tinted).method_25852(BedBlockExporter.createNestedModelId(block, "foot"), footTextureMap, generator.field_22831);
        class_4925 blockstate = BedBlockExporter.createBedBlockstate(block, headModelId, footModelId);
        generator.field_22830.accept(blockstate);
        class_4944 itemTextureMap = BedBlockExporter.createBedItemTextureMap(textures);
        class_2960 itemModelId = class_2960.method_60655((String)"westerosblocks", (String)("item/" + BedBlockExporter.getBlockName(block)));
        BedBlockExporter.createBedItemModel(tinted).method_25852(itemModelId, itemTextureMap, generator.field_22831);
    }

    public static void registerCustomBedBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        String bedType;
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        String string = bedType = definition.hasBedType() ? definition.getBedType() : "normal";
        if (definition.getTextures() == null || definition.getTextures().size() != 6) {
            WesterosBlocks.LOGGER.warn("Bed block '{}' requires exactly 6 textures, got {}", (Object)definition.getBlockName(), (Object)(definition.getTextures() != null ? definition.getTextures().size() : 0));
            return;
        }
        String[] textures = definition.getTextures().toArray(new String[0]);
        BedBlockExporter.registerBedBlock(generator, block, tinted, bedType, textures);
    }
}

