/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class Cuboid16WayBlockExporter
extends BaseBlockExporter {
    private static final String[] MODEL_SUFFIXES = new String[]{"", "_rotn22", "_rotn45", "_rot22"};
    private static final Float[] MODEL_ROTATIONS = new Float[]{null, Float.valueOf(-22.5f), Float.valueOf(-45.0f), Float.valueOf(22.5f)};

    public static void registerCustomCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                Cuboid16WayBlockExporter.registerCuboid16WayBlockWithStates(generator, block, definition);
                break;
            }
            case RANDOM_TEXTURES: {
                Cuboid16WayBlockExporter.registerCuboid16WayBlockWithRandomTextures(generator, block, definition);
                break;
            }
            case TEXTURES: {
                Cuboid16WayBlockExporter.registerSimpleCuboid16WayBlock(generator, block, definition);
                break;
            }
            case CUSTOM_MODEL: {
                Cuboid16WayBlockExporter.registerCustomModelCuboid16WayBlock(generator, block, definition);
                break;
            }
            case NONE: {
                Cuboid16WayBlockExporter.registerFallbackCuboid16WayBlock(generator, block, definition);
            }
        }
    }

    private static void registerSimpleCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<String> textures = definition.getTextures();
        HashMap<String, class_2960> rotationModels = new HashMap<String, class_2960>();
        for (int i = 0; i < MODEL_SUFFIXES.length; ++i) {
            String modelName = "base" + MODEL_SUFFIXES[i] + "_v1";
            class_2960 modelId = definition.hasCustomModel() ? Cuboid16WayBlockExporter.createCustomModelId(block, modelName) : CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, 0, modelName, MODEL_ROTATIONS[i]);
            rotationModels.put(MODEL_SUFFIXES[i], modelId);
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockState(block, rotationModels, null, definition));
        Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, (class_2960)rotationModels.get(""));
    }

    private static void registerCuboid16WayBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        HashMap<String, List<ModelSet16Way>> rotationModelSets = new HashMap<String, List<ModelSet16Way>>();
        for (int rotIdx = 0; rotIdx < MODEL_SUFFIXES.length; ++rotIdx) {
            ArrayList<ModelSet16Way> modelSets = new ArrayList<ModelSet16Way>();
            for (int texIdx = 0; texIdx < randomTextures.size(); ++texIdx) {
                BlockDefinition.RandomTextureVariant variant = randomTextures.get(texIdx);
                List<String> textures = variant.getTextures();
                String modelName = "base" + MODEL_SUFFIXES[rotIdx] + "_v" + (texIdx + 1);
                class_2960 modelId = definition.hasCustomModel() ? Cuboid16WayBlockExporter.createCustomModelId(block, modelName) : CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, texIdx, modelName, MODEL_ROTATIONS[rotIdx]);
                modelSets.add(new ModelSet16Way(modelId, variant.getWeight()));
            }
            rotationModelSets.put(MODEL_SUFFIXES[rotIdx], modelSets);
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockStateWithRandomTextures(block, rotationModelSets, definition));
        Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, ((ModelSet16Way)((List)rotationModelSets.get((Object)"")).get((int)0)).model);
    }

    private static void registerCuboid16WayBlockWithStates(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<BlockDefinition.StateVariant> states = definition.getStates();
        HashMap<String, Map<String, class_2960>> stateRotationModels = new HashMap<String, Map<String, class_2960>>();
        for (int stateIdx = 0; stateIdx < states.size(); ++stateIdx) {
            BlockDefinition.StateVariant state = states.get(stateIdx);
            Object stateId = state.getStateID() != null ? state.getStateID() : "state" + stateIdx;
            HashMap<String, class_2960> rotationModels = new HashMap<String, class_2960>();
            if (state.getRandomTextures() != null && !state.getRandomTextures().isEmpty()) {
                textures = state.getRandomTextures().get(0).getTextures();
                for (rotIdx = 0; rotIdx < MODEL_SUFFIXES.length; ++rotIdx) {
                    modelName = (String)stateId + MODEL_SUFFIXES[rotIdx] + "_v1";
                    modelId = definition.hasCustomModel() ? Cuboid16WayBlockExporter.createCustomModelId(block, modelName) : CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, stateIdx, modelName, MODEL_ROTATIONS[rotIdx]);
                    rotationModels.put(MODEL_SUFFIXES[rotIdx], modelId);
                }
            } else {
                textures = state.getTextures();
                for (rotIdx = 0; rotIdx < MODEL_SUFFIXES.length; ++rotIdx) {
                    modelName = (String)stateId + MODEL_SUFFIXES[rotIdx] + "_v1";
                    modelId = definition.hasCustomModel() ? Cuboid16WayBlockExporter.createCustomModelId(block, modelName) : CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, stateIdx, modelName, MODEL_ROTATIONS[rotIdx]);
                    rotationModels.put(MODEL_SUFFIXES[rotIdx], modelId);
                }
            }
            stateRotationModels.put((String)stateId, rotationModels);
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockStateWithStates(block, stateRotationModels, definition));
        if (!stateRotationModels.isEmpty()) {
            Map firstStateModels = (Map)stateRotationModels.values().iterator().next();
            Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, (class_2960)firstStateModels.get(""));
        }
    }

    private static void registerCustomModelCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        HashMap<String, class_2960> rotationModels = new HashMap<String, class_2960>();
        for (int i = 0; i < MODEL_SUFFIXES.length; ++i) {
            rotationModels.put(MODEL_SUFFIXES[i], Cuboid16WayBlockExporter.createCustomModelId(block, "base" + MODEL_SUFFIXES[i] + "_v1"));
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockState(block, rotationModels, null, definition));
        Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, (class_2960)rotationModels.get(""));
    }

    private static void registerFallbackCuboid16WayBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<String> fallbackTextures = List.of("missing");
        HashMap<String, class_2960> rotationModels = new HashMap<String, class_2960>();
        for (int i = 0; i < MODEL_SUFFIXES.length; ++i) {
            String modelName = "base" + MODEL_SUFFIXES[i] + "_v1";
            class_2960 modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, fallbackTextures, 0, modelName, MODEL_ROTATIONS[i]);
            rotationModels.put(MODEL_SUFFIXES[i], modelId);
        }
        generator.field_22830.accept(Cuboid16WayBlockExporter.createCuboid16WayBlockState(block, rotationModels, null, definition));
        Cuboid16WayBlockExporter.registerParentedItemModel(generator, block, (class_2960)rotationModels.get(""));
    }

    private static class_4917 createCuboid16WayBlockState(final class_2248 block, final Map<String, class_2960> rotationModels, final String stateId, BlockDefinition definition) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int rotation = 0; rotation < 16; ++rotation) {
                    String variantKey = stateId != null ? "rotation=" + rotation + ",state=" + stateId : "rotation=" + rotation;
                    JsonObject variant = new JsonObject();
                    int modelIndex = rotation % 4;
                    class_2960 modelId = (class_2960)rotationModels.get(MODEL_SUFFIXES[modelIndex]);
                    variant.addProperty("model", modelId.toString());
                    int yRotation = 90 * (rotation / 4) % 360;
                    if (yRotation > 0) {
                        variant.addProperty("y", (Number)yRotation);
                    }
                    variants.add(variantKey, (JsonElement)variant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createCuboid16WayBlockStateWithRandomTextures(final class_2248 block, final Map<String, List<ModelSet16Way>> rotationModelSets, BlockDefinition definition) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int rotation = 0; rotation < 16; ++rotation) {
                    String variantKey = "rotation=" + rotation;
                    int modelIndex = rotation % 4;
                    List modelSets = (List)rotationModelSets.get(MODEL_SUFFIXES[modelIndex]);
                    int yRotation = 90 * (rotation / 4) % 360;
                    if (modelSets.size() == 1) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", ((ModelSet16Way)modelSets.get((int)0)).model.toString());
                        if (yRotation > 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        variants.add(variantKey, (JsonElement)variant);
                        continue;
                    }
                    JsonArray variantArray = new JsonArray();
                    for (ModelSet16Way modelSet : modelSets) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelSet.model.toString());
                        if (yRotation > 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        if (modelSet.weight > 1) {
                            variant.addProperty("weight", (Number)modelSet.weight);
                        }
                        variantArray.add((JsonElement)variant);
                    }
                    variants.add(variantKey, (JsonElement)variantArray);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createCuboid16WayBlockStateWithStates(final class_2248 block, final Map<String, Map<String, class_2960>> stateRotationModels, BlockDefinition definition) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (Map.Entry stateEntry : stateRotationModels.entrySet()) {
                    String stateId = (String)stateEntry.getKey();
                    Map rotationModels = (Map)stateEntry.getValue();
                    for (int rotation = 0; rotation < 16; ++rotation) {
                        String variantKey = "rotation=" + rotation + ",state=" + stateId;
                        JsonObject variant = new JsonObject();
                        int modelIndex = rotation % 4;
                        class_2960 modelId = (class_2960)rotationModels.get(MODEL_SUFFIXES[modelIndex]);
                        variant.addProperty("model", modelId.toString());
                        int yRotation = 90 * (rotation / 4) % 360;
                        if (yRotation > 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        variants.add(variantKey, (JsonElement)variant);
                    }
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = Cuboid16WayBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class ModelSet16Way {
        final class_2960 model;
        final int weight;

        ModelSet16Way(class_2960 model, int weight) {
            this.model = model;
            this.weight = weight;
        }
    }
}

