/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCCuboidBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CuboidBlockExporter
extends BaseBlockExporter {
    private static final int[] STANDARD_TEXTURE_INDICES = new int[]{0, 1, 2, 3, 4, 5};
    private static final boolean[] NO_TINT_ALL = new boolean[]{false, false, false, false, false, false};

    public static void registerCustomCuboidBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        if (!(block instanceof WCCuboidBlock)) {
            throw new IllegalArgumentException("Block must be a WCCuboidBlock instance");
        }
        WCCuboidBlock cuboidBlock = (WCCuboidBlock)block;
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                CuboidBlockExporter.registerCustomCuboidBlockWithStates(generator, block, definition, cuboidBlock);
                break;
            }
            case RANDOM_TEXTURES: {
                CuboidBlockExporter.registerCustomCuboidBlockWithRandomTextures(generator, block, definition, cuboidBlock);
                break;
            }
            case TEXTURES: {
                CuboidBlockExporter.registerSimpleCuboidBlock(generator, block, definition, cuboidBlock);
                break;
            }
            case CUSTOM_MODEL: {
                CuboidBlockExporter.registerCustomModelCuboidBlock(generator, block, definition, cuboidBlock);
                break;
            }
            case NONE: {
                CuboidBlockExporter.registerFallbackCuboidBlock(generator, block, definition, cuboidBlock);
            }
        }
    }

    private static void registerSimpleCuboidBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidBlock cuboidBlock) {
        class_2960 modelId;
        List<String> textures = definition.getTextures();
        if (definition.hasCustomModel()) {
            modelId = CuboidBlockExporter.createCustomModelId(block, "base_v1");
        } else if (CuboidBlockExporter.hasCuboids(definition)) {
            modelId = textures != null && !textures.isEmpty() ? CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, 0, "base_v1") : CuboidBlockExporter.createGeneratedModelId(block, "base_v1");
        } else {
            class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(textures);
            modelId = textures != null && textures.size() == 1 ? class_4943.field_22972.method_25852(CuboidBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831) : class_4943.field_22942.method_25852(CuboidBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831);
        }
        generator.field_22830.accept(CuboidBlockExporter.createSimpleBlockState(block, modelId));
        CuboidBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static void registerCustomCuboidBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidBlock cuboidBlock) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        for (int i = 0; i < randomTextures.size(); ++i) {
            class_2960 modelId;
            BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
            List<String> textures = variant.getTextures();
            if (definition.hasCustomModel()) {
                modelId = CuboidBlockExporter.createCustomModelId(block, "base_v" + (i + 1));
            } else if (CuboidBlockExporter.hasCuboids(definition)) {
                modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, i, "base_v" + (i + 1));
            } else {
                class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(textures);
                modelId = class_4943.field_22942.method_25852(CuboidBlockExporter.createGeneratedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831);
            }
            modelIds.add(modelId);
        }
        List<class_4935> variants = modelIds.stream().map(BaseBlockExporter::createVariant).toList();
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
        if (!modelIds.isEmpty()) {
            CuboidBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
        }
    }

    private static void registerCustomCuboidBlockWithStates(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidBlock cuboidBlock) {
        List firstStateModels;
        List<BlockDefinition.StateVariant> states = definition.getStates();
        HashMap<String, List<class_2960>> stateModelIds = new HashMap<String, List<class_2960>>();
        for (int i = 0; i < states.size(); ++i) {
            class_2960 modelId;
            Object stateId;
            BlockDefinition.StateVariant state = states.get(i);
            Object object = stateId = state.getStateID() != null ? state.getStateID() : "state" + i;
            if (state.getRandomTextures() != null && !state.getRandomTextures().isEmpty()) {
                ArrayList<class_2960> variantIds = new ArrayList<class_2960>();
                List<BlockDefinition.RandomTextureVariant> randomTextures = state.getRandomTextures();
                for (int j = 0; j < randomTextures.size(); ++j) {
                    class_2960 modelId2;
                    BlockDefinition.RandomTextureVariant variant = randomTextures.get(j);
                    List<String> textures = variant.getTextures();
                    String variantName = (String)stateId + "_v" + (j + 1);
                    if (definition.hasCustomModel()) {
                        modelId2 = CuboidBlockExporter.createCustomModelId(block, variantName);
                    } else if (CuboidBlockExporter.hasCuboids(definition)) {
                        modelId2 = textures != null && !textures.isEmpty() ? CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, j, variantName) : CuboidBlockExporter.createGeneratedModelId(block, variantName);
                    } else {
                        class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(textures);
                        modelId2 = class_4943.field_22942.method_25852(CuboidBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831);
                    }
                    variantIds.add(modelId2);
                }
                stateModelIds.put((String)stateId, variantIds);
                continue;
            }
            List<String> textures = state.getTextures();
            String variantName = (String)stateId + "_v1";
            if (definition.hasCustomModel()) {
                modelId = CuboidBlockExporter.createCustomModelId(block, variantName);
            } else if (CuboidBlockExporter.hasCuboids(definition)) {
                modelId = textures != null && !textures.isEmpty() ? CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, i, variantName) : CuboidBlockExporter.createGeneratedModelId(block, variantName);
            } else {
                class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(textures);
                modelId = class_4943.field_22942.method_25852(CuboidBlockExporter.createGeneratedModelId(block, variantName), textureMap, generator.field_22831);
            }
            stateModelIds.put((String)stateId, List.of(modelId));
        }
        generator.field_22830.accept(CuboidBlockExporter.createAdvancedStatesBlockState(block, stateModelIds));
        if (!stateModelIds.isEmpty() && !(firstStateModels = (List)stateModelIds.values().iterator().next()).isEmpty()) {
            CuboidBlockExporter.registerParentedItemModel(generator, block, (class_2960)firstStateModels.get(0));
        }
    }

    private static void registerCustomModelCuboidBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidBlock cuboidBlock) {
        if (definition.hasRandomTextures()) {
            List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
            ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
            for (int i = 0; i < randomTextures.size(); ++i) {
                if (definition.hasCustomModel()) {
                    class_2960 modelId = CuboidBlockExporter.createCustomModelId(block, "base_v" + (i + 1));
                    modelIds.add(modelId);
                    continue;
                }
                BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
                List<String> textures = variant.getTextures();
                if (textures == null || textures.isEmpty()) {
                    textures = List.of("missing");
                }
                class_2960 modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, i, "base_v" + (i + 1));
                modelIds.add(modelId);
            }
            if (definition.hasRotateRandom()) {
                ArrayList<class_4935> variants = new ArrayList<class_4935>();
                for (class_2960 modelId : modelIds) {
                    variants.add(CuboidBlockExporter.createVariant(modelId, 0));
                    variants.add(CuboidBlockExporter.createVariant(modelId, 90));
                    variants.add(CuboidBlockExporter.createVariant(modelId, 180));
                    variants.add(CuboidBlockExporter.createVariant(modelId, 270));
                }
                generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
            } else {
                List<class_4935> variants = modelIds.stream().map(BaseBlockExporter::createVariant).toList();
                generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
            }
            if (!modelIds.isEmpty()) {
                CuboidBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
            }
        } else {
            class_2960 modelId;
            if (definition.hasCustomModel()) {
                modelId = CuboidBlockExporter.createCustomModelId(block, "base_v1");
            } else {
                List<String> fallbackTextures = List.of("missing");
                modelId = CuboidBlockExporter.createCuboidModel(generator, block, definition, fallbackTextures, 0, "base_v1");
            }
            if (definition.hasRotateRandom()) {
                List<class_4935> variants = List.of(CuboidBlockExporter.createVariant(modelId, 0), CuboidBlockExporter.createVariant(modelId, 90), CuboidBlockExporter.createVariant(modelId, 180), CuboidBlockExporter.createVariant(modelId, 270));
                generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
            } else {
                generator.field_22830.accept(CuboidBlockExporter.createSimpleBlockState(block, modelId));
            }
            CuboidBlockExporter.registerParentedItemModel(generator, block, modelId);
        }
    }

    private static void registerFallbackCuboidBlock(class_4910 generator, class_2248 block, BlockDefinition definition, WCCuboidBlock cuboidBlock) {
        String defaultTexture = "missing";
        List<String> fallbackTextures = List.of(defaultTexture);
        class_4944 textureMap = CuboidBlockExporter.createCuboidTextureMap(fallbackTextures);
        class_2960 modelId = class_4943.field_22972.method_25852(CuboidBlockExporter.createGeneratedModelId(block, "base_v1"), textureMap, generator.field_22831);
        generator.field_22830.accept(CuboidBlockExporter.createSimpleBlockState(block, modelId));
        CuboidBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    static class_2960 createCuboidModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, int stateIndex, String variant) {
        return CuboidBlockExporter.createCuboidModel(generator, block, definition, textures, stateIndex, variant, null);
    }

    static class_2960 createCuboidModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, int stateIndex, String variant, Float rotation) {
        class_4944 textureMap = CuboidBlockExporter.createCustomCuboidTextureMap(textures);
        class_2960 modelId = CuboidBlockExporter.createGeneratedModelId(block, variant);
        class_4942 cuboidModel = CuboidBlockExporter.createCuboidModelFromDefinition(definition, textures, stateIndex, rotation);
        cuboidModel.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    public static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CuboidBlockExporter.getBlockName(block);
        String modelPath = "block/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CuboidBlockExporter.getBlockName(block);
        String modelPath = "block/custom/" + blockName + "/" + variant;
        return WesterosBlocks.id(modelPath);
    }

    private static class_4942 createCuboidModelFromDefinition(final BlockDefinition definition, List<String> textures, int stateIndex, final Float rotation) {
        int requiredTextures = Math.max(6, textures.size());
        ArrayList<class_4945> textureKeys = new ArrayList<class_4945>();
        textureKeys.add(class_4945.field_23012);
        for (int i = 0; i < requiredTextures; ++i) {
            textureKeys.add(ModTextureKey.getTextureNKey(i));
        }
        return new class_4942(Optional.empty(), Optional.empty(), textureKeys.toArray(new class_4945[0])){

            public JsonObject method_48524(class_2960 id, Map<class_4945, class_2960> textures) {
                JsonObject json = super.method_48524(id, textures);
                json.addProperty("parent", "block/block");
                JsonArray elements = new JsonArray();
                List<BlockDefinition.CuboidElement> cuboids = definition.getCuboids();
                if (cuboids != null && !cuboids.isEmpty()) {
                    for (BlockDefinition.CuboidElement cuboid : cuboids) {
                        if ("crossed".equals(cuboid.getShape())) {
                            json.addProperty("ambientocclusion", Boolean.valueOf(false));
                            JsonObject element1 = CuboidBlockExporter.createCrossedElement(cuboid, true, definition.isTinted());
                            if (rotation != null) {
                                CuboidBlockExporter.addRotation(element1, rotation.floatValue());
                            }
                            elements.add((JsonElement)element1);
                            JsonObject element2 = CuboidBlockExporter.createCrossedElement(cuboid, false, definition.isTinted());
                            if (rotation != null) {
                                CuboidBlockExporter.addRotation(element2, rotation.floatValue());
                            }
                            elements.add((JsonElement)element2);
                            continue;
                        }
                        JsonObject element = new JsonObject();
                        CuboidBlockExporter.addCuboidElement(element, cuboid, definition.isTinted());
                        if (rotation != null) {
                            CuboidBlockExporter.addRotation(element, rotation.floatValue());
                        }
                        elements.add((JsonElement)element);
                    }
                } else if (definition.hasBoundingBox()) {
                    BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                    JsonObject element = new JsonObject();
                    CuboidBlockExporter.addBoundingBoxElement(element, bbox, definition.isTinted());
                    if (rotation != null) {
                        CuboidBlockExporter.addRotation(element, rotation.floatValue());
                    }
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                return json;
            }
        };
    }

    private static void addRotation(JsonObject element, float angle) {
        JsonObject rotation = new JsonObject();
        JsonArray origin = new JsonArray();
        origin.add((Number)8.0);
        origin.add((Number)8.0);
        origin.add((Number)8.0);
        rotation.add("origin", (JsonElement)origin);
        rotation.addProperty("axis", "y");
        rotation.addProperty("angle", (Number)Float.valueOf(angle));
        rotation.addProperty("rescale", Boolean.valueOf(false));
        element.add("rotation", (JsonElement)rotation);
    }

    private static JsonObject createCrossedElement(BlockDefinition.CuboidElement cuboid, boolean firstDiagonal, boolean isTinted) {
        JsonObject element = new JsonObject();
        JsonArray from = new JsonArray();
        if (firstDiagonal) {
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMin())));
            from.add((Number)8.0);
        } else {
            from.add((Number)8.0);
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMin())));
            from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
        }
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        if (firstDiagonal) {
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMax())));
            to.add((Number)8.0);
        } else {
            to.add((Number)8.0);
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMax())));
            to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
        }
        element.add("to", (JsonElement)to);
        element.addProperty("shade", Boolean.valueOf(false));
        JsonObject faces = new JsonObject();
        if (firstDiagonal) {
            CuboidBlockExporter.addCrossedFace(faces, "north", isTinted);
            CuboidBlockExporter.addCrossedFace(faces, "south", isTinted);
        } else {
            CuboidBlockExporter.addCrossedFace(faces, "east", isTinted);
            CuboidBlockExporter.addCrossedFace(faces, "west", isTinted);
        }
        element.add("faces", (JsonElement)faces);
        return element;
    }

    private static void addCrossedFace(JsonObject faces, String direction, boolean isTinted) {
        JsonObject face = new JsonObject();
        JsonArray uv = new JsonArray();
        uv.add((Number)0.0);
        uv.add((Number)0.0);
        uv.add((Number)16.0);
        uv.add((Number)16.0);
        face.add("uv", (JsonElement)uv);
        face.addProperty("texture", "#txt0");
        if (isTinted) {
            face.addProperty("tintindex", (Number)0);
        }
        faces.add(direction, (JsonElement)face);
    }

    private static void addCuboidElement(JsonObject element, BlockDefinition.CuboidElement cuboid, boolean isTinted) {
        JsonArray from = new JsonArray();
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getYMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        CuboidBlockExporter.addCuboidFaces(faces, cuboid, isTinted);
        element.add("faces", (JsonElement)faces);
    }

    private static void addBoundingBoxElement(JsonObject element, BlockDefinition.BoundingBox bbox, boolean isTinted) {
        JsonArray from = new JsonArray();
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getYMin())));
        from.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMin())));
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getYMax())));
        to.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMax())));
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        CuboidBlockExporter.addBoundingBoxFaces(faces, bbox, isTinted);
        element.add("faces", (JsonElement)faces);
    }

    private static void addCuboidFaces(JsonObject faces, BlockDefinition.CuboidElement cuboid, boolean isTinted) {
        int[] nArray;
        boolean[] noTint;
        int[] sidetxt = cuboid.getSideTextures() != null ? cuboid.getSideTextures() : STANDARD_TEXTURE_INDICES;
        boolean[] blArray = noTint = cuboid.getNoTint() != null ? cuboid.getNoTint() : NO_TINT_ALL;
        if (cuboid.getSideRotations() != null) {
            nArray = cuboid.getSideRotations();
        } else {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray = nArray2;
            nArray2[5] = 0;
        }
        int[] siderot = nArray;
        CuboidBlockExporter.addFace(faces, "down", 0, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "up", 1, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "north", 2, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "south", 3, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "west", 4, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addFace(faces, "east", 5, cuboid, sidetxt, noTint, siderot, isTinted);
    }

    private static void addBoundingBoxFaces(JsonObject faces, BlockDefinition.BoundingBox bbox, boolean isTinted) {
        int[] sidetxt = STANDARD_TEXTURE_INDICES;
        boolean[] noTint = NO_TINT_ALL;
        int[] siderot = new int[]{0, 0, 0, 0, 0, 0};
        CuboidBlockExporter.addBoundingBoxFace(faces, "down", 0, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "up", 1, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "north", 2, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "south", 3, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "west", 4, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidBlockExporter.addBoundingBoxFace(faces, "east", 5, bbox, sidetxt, noTint, siderot, isTinted);
    }

    private static void addFace(JsonObject faces, String face, int index, BlockDefinition.CuboidElement cuboid, int[] sidetxt, boolean[] noTint, int[] siderot, boolean isTinted) {
        String cullface;
        JsonObject faceObj = new JsonObject();
        JsonArray uv = new JsonArray();
        CuboidBlockExporter.calculateUVs(face, cuboid, uv);
        faceObj.add("uv", (JsonElement)uv);
        faceObj.addProperty("texture", "#txt" + sidetxt[index]);
        if (siderot[index] != 0) {
            faceObj.addProperty("rotation", (Number)siderot[index]);
        }
        if (isTinted && !noTint[index]) {
            faceObj.addProperty("tintindex", (Number)0);
        }
        if ((cullface = CuboidBlockExporter.getCullface(face, cuboid)) != null) {
            faceObj.addProperty("cullface", cullface);
        }
        faces.add(face, (JsonElement)faceObj);
    }

    private static void addBoundingBoxFace(JsonObject faces, String face, int index, BlockDefinition.BoundingBox bbox, int[] sidetxt, boolean[] noTint, int[] siderot, boolean isTinted) {
        String cullface;
        JsonObject faceObj = new JsonObject();
        JsonArray uv = new JsonArray();
        CuboidBlockExporter.calculateBoundingBoxUVs(face, bbox, uv);
        faceObj.add("uv", (JsonElement)uv);
        faceObj.addProperty("texture", "#txt" + sidetxt[index]);
        if (siderot[index] != 0) {
            faceObj.addProperty("rotation", (Number)siderot[index]);
        }
        if (isTinted && !noTint[index]) {
            faceObj.addProperty("tintindex", (Number)0);
        }
        if ((cullface = CuboidBlockExporter.getBoundingBoxCullface(face, bbox)) != null) {
            faceObj.addProperty("cullface", cullface);
        }
        faces.add(face, (JsonElement)faceObj);
    }

    private static void calculateUVs(String face, BlockDefinition.CuboidElement cuboid, JsonArray uv) {
        switch (face) {
            case "down": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMin())));
                break;
            }
            case "up": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
                break;
            }
            case "north": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "south": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "west": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "east": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(cuboid.getYMin())));
            }
        }
    }

    private static float getClamped(double v) {
        float f = (float)(16.0 * v);
        if (f < -16.0f) {
            f = -16.0f;
        }
        if (f > 32.0f) {
            f = 32.0f;
        }
        return f;
    }

    private static String getCullface(String face, BlockDefinition.CuboidElement cuboid) {
        return switch (face) {
            case "down" -> {
                if (cuboid.getYMin() <= 0.0) {
                    yield "down";
                }
                yield null;
            }
            case "up" -> {
                if (cuboid.getYMax() >= 1.0) {
                    yield "up";
                }
                yield null;
            }
            case "north" -> {
                if (cuboid.getZMin() <= 0.0) {
                    yield "north";
                }
                yield null;
            }
            case "south" -> {
                if (cuboid.getZMax() >= 1.0) {
                    yield "south";
                }
                yield null;
            }
            case "west" -> {
                if (cuboid.getXMin() <= 0.0) {
                    yield "west";
                }
                yield null;
            }
            case "east" -> {
                if (cuboid.getXMax() >= 1.0) {
                    yield "east";
                }
                yield null;
            }
            default -> null;
        };
    }

    private static void calculateBoundingBoxUVs(String face, BlockDefinition.BoundingBox bbox, JsonArray uv) {
        switch (face) {
            case "down": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMin())));
                break;
            }
            case "up": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMax())));
                break;
            }
            case "north": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "south": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "west": {
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "east": {
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidBlockExporter.getClamped(bbox.getYMin())));
            }
        }
    }

    private static String getBoundingBoxCullface(String face, BlockDefinition.BoundingBox bbox) {
        return switch (face) {
            case "down" -> {
                if (bbox.getYMin() <= 0.0) {
                    yield "down";
                }
                yield null;
            }
            case "up" -> {
                if (bbox.getYMax() >= 1.0) {
                    yield "up";
                }
                yield null;
            }
            case "north" -> {
                if (bbox.getZMin() <= 0.0) {
                    yield "north";
                }
                yield null;
            }
            case "south" -> {
                if (bbox.getZMax() >= 1.0) {
                    yield "south";
                }
                yield null;
            }
            case "west" -> {
                if (bbox.getXMin() <= 0.0) {
                    yield "west";
                }
                yield null;
            }
            case "east" -> {
                if (bbox.getXMax() >= 1.0) {
                    yield "east";
                }
                yield null;
            }
            default -> null;
        };
    }

    public static class_4944 createCuboidTextureMap(List<String> textures) {
        class_4944 textureMap = new class_4944();
        if (textures == null || textures.isEmpty()) {
            String fallbackTexture = "missing";
            class_2960 fallbackId = CuboidBlockExporter.createBlockIdentifier(fallbackTexture);
            textureMap.method_25868(class_4945.field_23024, fallbackId);
            textureMap.method_25868(class_4945.field_23023, fallbackId);
            textureMap.method_25868(class_4945.field_23019, fallbackId);
            textureMap.method_25868(class_4945.field_23020, fallbackId);
            textureMap.method_25868(class_4945.field_23022, fallbackId);
            textureMap.method_25868(class_4945.field_23021, fallbackId);
            textureMap.method_25868(class_4945.field_23012, fallbackId);
            textureMap.method_25868(class_4945.field_23010, fallbackId);
            return textureMap;
        }
        int textureCount = textures.size();
        if (textureCount == 1) {
            class_2960 textureId = CuboidBlockExporter.createBlockIdentifier(textures.get(0));
            textureMap.method_25868(class_4945.field_23010, textureId);
            textureMap.method_25868(class_4945.field_23012, textureId);
        }
        class_4945[] faceKeys = new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021};
        for (int i = 0; i < 6; ++i) {
            String texture = i < textureCount ? textures.get(i) : textures.get(textureCount - 1);
            textureMap.method_25868(faceKeys[i], CuboidBlockExporter.createBlockIdentifier(texture));
        }
        textureMap.method_25868(class_4945.field_23012, CuboidBlockExporter.createBlockIdentifier(textures.get(0)));
        return textureMap;
    }

    private static class_4944 createCustomCuboidTextureMap(List<String> textures) {
        class_4944 textureMap = new class_4944();
        if (textures == null || textures.isEmpty()) {
            String fallbackTexture = "missing";
            for (int i = 0; i < 6; ++i) {
                textureMap.method_25868(ModTextureKey.getTextureNKey(i), CuboidBlockExporter.createBlockIdentifier(fallbackTexture));
            }
            textureMap.method_25868(class_4945.field_23012, CuboidBlockExporter.createBlockIdentifier(fallbackTexture));
            return textureMap;
        }
        int textureCount = textures.size();
        int requiredTextures = Math.max(6, textureCount);
        for (int i = 0; i < requiredTextures; ++i) {
            String texture = i < textureCount ? textures.get(i) : textures.get(textureCount - 1);
            textureMap.method_25868(ModTextureKey.getTextureNKey(i), CuboidBlockExporter.createBlockIdentifier(texture));
        }
        textureMap.method_25868(class_4945.field_23012, CuboidBlockExporter.createBlockIdentifier(textures.get(0)));
        return textureMap;
    }

    public static boolean hasCuboids(BlockDefinition definition) {
        return definition.getCuboids() != null && !definition.getCuboids().isEmpty() || definition.hasBoundingBox();
    }

    private static class_4917 createAdvancedStatesBlockState(final class_2248 block, final Map<String, List<class_2960>> stateModelIds) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (Map.Entry entry : stateModelIds.entrySet()) {
                    String stateId = (String)entry.getKey();
                    List modelIds = (List)entry.getValue();
                    if (modelIds.size() == 1) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", ((class_2960)modelIds.get(0)).toString());
                        variants.add("state=" + stateId, (JsonElement)variant);
                        continue;
                    }
                    JsonArray variantArray = new JsonArray();
                    for (class_2960 modelId : modelIds) {
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelId.toString());
                        variantArray.add((JsonElement)variant);
                    }
                    variants.add("state=" + stateId, (JsonElement)variantArray);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }
}

