/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCCuboidNSEWStackBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CuboidNSEWStackBlockExporter
extends BaseBlockExporter {
    public static void registerCustomCuboidNSEWStackBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        class_2960 topModelId;
        class_2960 bottomModelId;
        if (!(block instanceof WCCuboidNSEWStackBlock)) {
            throw new IllegalArgumentException("Block must be a WCCuboidNSEWStackBlock instance");
        }
        WCCuboidNSEWStackBlock stackBlock = (WCCuboidNSEWStackBlock)block;
        if (!definition.hasStackElements() || definition.getStackElements().size() < 2) {
            throw new IllegalArgumentException("CuboidNSEWStackBlock requires at least 2 stack elements");
        }
        BlockDefinition.StackElement bottomElement = definition.getStackElements().get(0);
        BlockDefinition.StackElement topElement = definition.getStackElements().get(1);
        if (definition.hasCustomModel()) {
            bottomModelId = CuboidNSEWStackBlockExporter.createCustomModelId(block, "base_v1");
            topModelId = CuboidNSEWStackBlockExporter.createCustomModelId(block, "top_v1");
        } else {
            bottomModelId = CuboidNSEWStackBlockExporter.createStackElementModel(generator, block, definition, bottomElement, "base_v1");
            topModelId = CuboidNSEWStackBlockExporter.createStackElementModel(generator, block, definition, topElement, "top_v1");
        }
        class_4925 blockStateSupplier = class_4925.method_25769((class_2248)block);
        blockStateSupplier.method_25775(class_4926.method_25784((class_2769)WCCuboidNSEWStackBlock.FACING, WCCuboidNSEWStackBlock.HALF).method_25800((facing, half) -> {
            if (half.method_15434().equals("lower")) {
                int rotation = switch (facing.method_15434()) {
                    case "north" -> 270;
                    case "east" -> 0;
                    case "south" -> 90;
                    case "west" -> 180;
                    default -> 0;
                };
                return CuboidNSEWStackBlockExporter.createVariant(bottomModelId, rotation);
            }
            int rotation = switch (facing.method_15434()) {
                case "north" -> 270;
                case "east" -> 0;
                case "south" -> 90;
                case "west" -> 180;
                default -> 0;
            };
            return CuboidNSEWStackBlockExporter.createVariant(topModelId, rotation);
        }));
        generator.field_22830.accept(blockStateSupplier);
        class_4944 itemTextureMap = new class_4944().method_25868(ModTextureKey.TEXTURE_1, CuboidNSEWStackBlockExporter.createBlockIdentifier(topElement.getTextures().get(4))).method_25868(ModTextureKey.TEXTURE_2, CuboidNSEWStackBlockExporter.createBlockIdentifier(bottomElement.getTextures().get(4))).method_25868(ModTextureKey.TEXTURE_5, CuboidNSEWStackBlockExporter.createBlockIdentifier(topElement.getTextures().get(5))).method_25868(class_4945.field_23012, CuboidNSEWStackBlockExporter.createBlockIdentifier(topElement.getTextures().get(4)));
        class_2960 itemModelId = WesterosBlocks.id("item/" + definition.getBlockName());
        class_4942 combinedItemModel = ModModels.CUBOID_NSEW_STACK_ITEM();
        combinedItemModel.method_25852(itemModelId, itemTextureMap, generator.field_22831);
    }

    private static class_2960 createStackElementModel(class_4910 generator, class_2248 block, BlockDefinition definition, BlockDefinition.StackElement element, String variant) {
        List<String> textures = element.getTextures();
        if (textures == null || textures.isEmpty()) {
            textures = List.of("missing");
        }
        return CuboidNSEWStackBlockExporter.createCuboidStackModel(generator, block, element, textures, variant);
    }

    private static class_2960 createCuboidStackModel(class_4910 generator, class_2248 block, BlockDefinition.StackElement element, List<String> textures, String variant) {
        class_2960 modelId = CuboidNSEWStackBlockExporter.createGeneratedModelId(block, variant);
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", "minecraft:block/block");
        String particleTexture = textures.stream().filter(t -> t != null && !t.equals("transparent")).findFirst().orElse(textures.get(0));
        JsonObject texturesJson = new JsonObject();
        texturesJson.addProperty("particle", "westerosblocks:block/" + particleTexture);
        if (textures.size() >= 5) {
            texturesJson.addProperty("txt4", "westerosblocks:block/" + textures.get(4));
        }
        if (textures.size() >= 6) {
            texturesJson.addProperty("txt5", "westerosblocks:block/" + textures.get(5));
        }
        modelJson.add("textures", (JsonElement)texturesJson);
        if (element.hasBoundingBox()) {
            JsonArray elementsArray = new JsonArray();
            JsonObject elementJson = CuboidNSEWStackBlockExporter.createStackElementJson(element, textures);
            elementsArray.add((JsonElement)elementJson);
            modelJson.add("elements", (JsonElement)elementsArray);
        }
        JsonObject display = new JsonObject();
        JsonObject guiDisplay = new JsonObject();
        JsonArray guiRotation = new JsonArray();
        guiRotation.add((Number)0);
        guiRotation.add((Number)90);
        guiRotation.add((Number)0);
        guiDisplay.add("rotation", (JsonElement)guiRotation);
        JsonArray guiScale = new JsonArray();
        guiScale.add((Number)0.825);
        guiScale.add((Number)0.825);
        guiScale.add((Number)0.825);
        guiDisplay.add("scale", (JsonElement)guiScale);
        JsonArray guiTranslation = new JsonArray();
        guiTranslation.add((Number)0);
        guiTranslation.add((Number)0);
        guiTranslation.add((Number)0);
        guiDisplay.add("translation", (JsonElement)guiTranslation);
        display.add("gui", (JsonElement)guiDisplay);
        modelJson.add("display", (JsonElement)display);
        generator.field_22831.accept(modelId, () -> modelJson);
        return modelId;
    }

    private static JsonObject createStackElementJson(BlockDefinition.StackElement element, List<String> textures) {
        BlockDefinition.BoundingBox bbox = element.getBoundingBox();
        JsonObject elementJson = new JsonObject();
        JsonArray from = new JsonArray();
        from.add((Number)(bbox.getXMin() * 16.0));
        from.add((Number)(bbox.getYMin() * 16.0));
        from.add((Number)(bbox.getZMin() * 16.0));
        elementJson.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)(bbox.getXMax() * 16.0));
        to.add((Number)(bbox.getYMax() * 16.0));
        to.add((Number)(bbox.getZMax() * 16.0));
        elementJson.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        if (textures.size() >= 5 && !textures.get(4).equals("transparent")) {
            JsonObject westFace = new JsonObject();
            westFace.addProperty("texture", "#txt4");
            JsonArray westUv = new JsonArray();
            westUv.add((Number)0.0);
            westUv.add((Number)0.0);
            westUv.add((Number)16.0);
            westUv.add((Number)16.0);
            westFace.add("uv", (JsonElement)westUv);
            faces.add("west", (JsonElement)westFace);
        }
        if (textures.size() >= 6 && !textures.get(5).equals("transparent")) {
            JsonObject eastFace = new JsonObject();
            eastFace.addProperty("cullface", "east");
            eastFace.addProperty("texture", "#txt5");
            JsonArray eastUv = new JsonArray();
            eastUv.add((Number)0.0);
            eastUv.add((Number)0.0);
            eastUv.add((Number)16.0);
            eastUv.add((Number)16.0);
            eastFace.add("uv", (JsonElement)eastUv);
            faces.add("east", (JsonElement)eastFace);
        }
        elementJson.add("faces", (JsonElement)faces);
        return elementJson;
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CuboidNSEWStackBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CuboidNSEWStackBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }
}

