/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCCuboidNSEWUDBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class CuboidNSEWUDBlockExporter
extends BaseBlockExporter {
    public static void registerCustomCuboidNSEWUDBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        if (!(block instanceof WCCuboidNSEWUDBlock)) {
            throw new IllegalArgumentException("Block must be a WCCuboidNSEWUDBlock instance");
        }
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                CuboidNSEWUDBlockExporter.registerCuboidNSEWUDBlockWithStates(generator, block, definition);
                break;
            }
            case RANDOM_TEXTURES: {
                CuboidNSEWUDBlockExporter.registerCuboidNSEWUDBlockWithRandomTextures(generator, block, definition);
                break;
            }
            case CUSTOM_MODEL: {
                CuboidNSEWUDBlockExporter.registerCustomModelCuboidNSEWUDBlock(generator, block, definition);
                break;
            }
            case TEXTURES: 
            case NONE: {
                CuboidNSEWUDBlockExporter.registerSimpleCuboidNSEWUDBlock(generator, block, definition);
            }
        }
    }

    private static void registerSimpleCuboidNSEWUDBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<String> textures = definition.getTextures();
        class_2960 modelId = definition.hasCustomModel() ? CuboidNSEWUDBlockExporter.createCustomModelId(block, "base_v1") : CuboidNSEWUDBlockExporter.createCuboidNSEWUDModel(generator, block, definition, textures, 0, "base_v1");
        generator.field_22830.accept(CuboidNSEWUDBlockExporter.createCuboidNSEWUDBlockState(block, modelId));
        CuboidNSEWUDBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static void registerCuboidNSEWUDBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        ArrayList<ModelVariant> modelVariants = new ArrayList<ModelVariant>();
        for (int i = 0; i < randomTextures.size(); ++i) {
            BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
            List<String> textures = variant.getTextures();
            class_2960 modelId = definition.hasCustomModel() ? CuboidNSEWUDBlockExporter.createCustomModelId(block, "base_v" + (i + 1)) : CuboidNSEWUDBlockExporter.createCuboidNSEWUDModel(generator, block, definition, textures, i, "base_v" + (i + 1));
            modelVariants.add(new ModelVariant(modelId, variant.getWeight()));
        }
        generator.field_22830.accept(CuboidNSEWUDBlockExporter.createCuboidNSEWUDBlockStateWithRandomTextures(block, modelVariants));
        CuboidNSEWUDBlockExporter.registerParentedItemModel(generator, block, ((ModelVariant)modelVariants.get((int)0)).model);
    }

    private static void registerCuboidNSEWUDBlockWithStates(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<BlockDefinition.StateVariant> states = definition.getStates();
        HashMap<String, List<ModelVariant>> stateModelMap = new HashMap<String, List<ModelVariant>>();
        class_2960 firstModel = null;
        for (BlockDefinition.StateVariant state : states) {
            String stateId = state.getStateID() != null ? state.getStateID() : "base";
            ArrayList<ModelVariant> modelVariants = new ArrayList<ModelVariant>();
            if (state.hasRandomTextures()) {
                List<BlockDefinition.RandomTextureVariant> randomTextures = state.getRandomTextures();
                for (int i = 0; i < randomTextures.size(); ++i) {
                    List<String> textures = randomTextures.get(i).getTextures();
                    class_2960 modelId = definition.hasCustomModel() ? CuboidNSEWUDBlockExporter.createCustomModelId(block, stateId + "_v" + (i + 1)) : CuboidNSEWUDBlockExporter.createCuboidNSEWUDModel(generator, block, definition, textures, i, stateId + "_v" + (i + 1));
                    modelVariants.add(new ModelVariant(modelId, randomTextures.get(i).getWeight()));
                    if (firstModel != null) continue;
                    firstModel = modelId;
                }
            } else {
                List<String> textures = state.getTextures() != null ? state.getTextures() : definition.getTextures();
                class_2960 modelId = definition.hasCustomModel() ? CuboidNSEWUDBlockExporter.createCustomModelId(block, stateId + "_v1") : CuboidNSEWUDBlockExporter.createCuboidNSEWUDModel(generator, block, definition, textures, 0, stateId + "_v1");
                modelVariants.add(new ModelVariant(modelId, 1));
                if (firstModel == null) {
                    firstModel = modelId;
                }
            }
            stateModelMap.put(stateId, modelVariants);
        }
        generator.field_22830.accept(CuboidNSEWUDBlockExporter.createCuboidNSEWUDBlockStateWithStates(block, definition, stateModelMap, states));
        if (firstModel != null) {
            CuboidNSEWUDBlockExporter.registerParentedItemModel(generator, block, firstModel);
        }
    }

    private static void registerCustomModelCuboidNSEWUDBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        class_2960 modelId = CuboidNSEWUDBlockExporter.createCustomModelId(block, "base_v1");
        generator.field_22830.accept(CuboidNSEWUDBlockExporter.createCuboidNSEWUDBlockState(block, modelId));
        CuboidNSEWUDBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    private static class_4917 createCuboidNSEWUDBlockState(final class_2248 block, final class_2960 modelId) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                CuboidNSEWUDBlockExporter.addVariant(variants, "facing=north", modelId, 0, 0);
                CuboidNSEWUDBlockExporter.addVariant(variants, "facing=east", modelId, 0, 90);
                CuboidNSEWUDBlockExporter.addVariant(variants, "facing=south", modelId, 0, 180);
                CuboidNSEWUDBlockExporter.addVariant(variants, "facing=west", modelId, 0, 270);
                CuboidNSEWUDBlockExporter.addVariant(variants, "facing=up", modelId, 270, 0);
                CuboidNSEWUDBlockExporter.addVariant(variants, "facing=down", modelId, 90, 0);
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createCuboidNSEWUDBlockStateWithRandomTextures(final class_2248 block, final List<ModelVariant> modelVariants) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, "facing=north", modelVariants, 0, 0);
                CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, "facing=east", modelVariants, 0, 90);
                CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, "facing=south", modelVariants, 0, 180);
                CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, "facing=west", modelVariants, 0, 270);
                CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, "facing=up", modelVariants, 270, 0);
                CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, "facing=down", modelVariants, 90, 0);
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createCuboidNSEWUDBlockStateWithStates(final class_2248 block, BlockDefinition definition, final Map<String, List<ModelVariant>> stateModelMap, final List<BlockDefinition.StateVariant> states) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (BlockDefinition.StateVariant state : states) {
                    String stateId = state.getStateID() != null ? state.getStateID() : "base";
                    List modelVariants = (List)stateModelMap.get(stateId);
                    if (modelVariants == null || modelVariants.isEmpty()) continue;
                    CuboidNSEWUDBlockExporter.addVariantWithWeightsAndState(variants, "facing=north", modelVariants, 0, 0, stateId);
                    CuboidNSEWUDBlockExporter.addVariantWithWeightsAndState(variants, "facing=east", modelVariants, 0, 90, stateId);
                    CuboidNSEWUDBlockExporter.addVariantWithWeightsAndState(variants, "facing=south", modelVariants, 0, 180, stateId);
                    CuboidNSEWUDBlockExporter.addVariantWithWeightsAndState(variants, "facing=west", modelVariants, 0, 270, stateId);
                    CuboidNSEWUDBlockExporter.addVariantWithWeightsAndState(variants, "facing=up", modelVariants, 270, 0, stateId);
                    CuboidNSEWUDBlockExporter.addVariantWithWeightsAndState(variants, "facing=down", modelVariants, 90, 0, stateId);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static void addVariant(JsonObject variants, String condition, class_2960 model, int x, int y) {
        JsonObject variant = new JsonObject();
        variant.addProperty("model", model.toString());
        if (x != 0) {
            variant.addProperty("x", (Number)x);
        }
        if (y != 0) {
            variant.addProperty("y", (Number)y);
        }
        variants.add(condition, (JsonElement)variant);
    }

    private static void addVariantWithWeights(JsonObject variants, String condition, List<ModelVariant> modelVariants, int x, int y) {
        if (modelVariants.size() == 1) {
            CuboidNSEWUDBlockExporter.addVariant(variants, condition, modelVariants.get((int)0).model, x, y);
        } else {
            JsonArray variantArray = new JsonArray();
            for (ModelVariant mv : modelVariants) {
                JsonObject variant = new JsonObject();
                variant.addProperty("model", mv.model.toString());
                if (x != 0) {
                    variant.addProperty("x", (Number)x);
                }
                if (y != 0) {
                    variant.addProperty("y", (Number)y);
                }
                if (mv.weight != 1) {
                    variant.addProperty("weight", (Number)mv.weight);
                }
                variantArray.add((JsonElement)variant);
            }
            variants.add(condition, (JsonElement)variantArray);
        }
    }

    private static void addVariantWithWeightsAndState(JsonObject variants, String condition, List<ModelVariant> modelVariants, int x, int y, String stateId) {
        String fullCondition = "state=" + stateId + "," + condition;
        CuboidNSEWUDBlockExporter.addVariantWithWeights(variants, fullCondition, modelVariants, x, y);
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = CuboidNSEWUDBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = CuboidNSEWUDBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    static class_2960 createCuboidNSEWUDModel(class_4910 generator, class_2248 block, BlockDefinition definition, List<String> textures, int stateIndex, String variant) {
        class_4944 textureMap = CuboidNSEWUDBlockExporter.createCustomCuboidTextureMap(textures);
        class_2960 modelId = CuboidNSEWUDBlockExporter.createGeneratedModelId(block, variant);
        class_4942 cuboidModel = CuboidNSEWUDBlockExporter.createCuboidNSEWUDModelFromDefinition(definition, textures, stateIndex);
        cuboidModel.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    private static class_4942 createCuboidNSEWUDModelFromDefinition(final BlockDefinition definition, List<String> textures, int stateIndex) {
        int requiredTextures = Math.max(6, textures.size());
        ArrayList<class_4945> textureKeys = new ArrayList<class_4945>();
        textureKeys.add(class_4945.field_23012);
        for (int i = 0; i < requiredTextures; ++i) {
            textureKeys.add(ModTextureKey.getTextureNKey(i));
        }
        return new class_4942(Optional.empty(), Optional.empty(), textureKeys.toArray(new class_4945[0])){

            public JsonObject method_48524(class_2960 id, Map<class_4945, class_2960> textures) {
                JsonObject json = super.method_48524(id, textures);
                json.addProperty("parent", "block/block");
                JsonArray elements = new JsonArray();
                List<BlockDefinition.CuboidElement> cuboids = definition.getCuboids();
                if (cuboids != null && !cuboids.isEmpty()) {
                    for (BlockDefinition.CuboidElement cuboid : cuboids) {
                        JsonObject element = new JsonObject();
                        CuboidNSEWUDBlockExporter.addCuboidNSEWUDElement(element, cuboid, definition.isTinted());
                        elements.add((JsonElement)element);
                    }
                } else if (definition.getBoundingBox() != null) {
                    BlockDefinition.BoundingBox bbox = definition.getBoundingBox();
                    JsonObject element = new JsonObject();
                    CuboidNSEWUDBlockExporter.addCuboidNSEWUDElementFromBoundingBox(element, bbox, definition.isTinted());
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                return json;
            }
        };
    }

    private static void addCuboidNSEWUDElement(JsonObject element, BlockDefinition.CuboidElement cuboid, boolean isTinted) {
        JsonArray from = new JsonArray();
        from.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMin())));
        from.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMin())));
        from.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMax())));
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMax())));
        to.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMax())));
        to.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMin())));
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        CuboidNSEWUDBlockExporter.addCuboidNSEWUDFaces(faces, cuboid, isTinted);
        element.add("faces", (JsonElement)faces);
    }

    private static void addCuboidNSEWUDElementFromBoundingBox(JsonObject element, BlockDefinition.BoundingBox bbox, boolean isTinted) {
        JsonArray from = new JsonArray();
        from.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMin())));
        from.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getYMin())));
        from.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMax())));
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMax())));
        to.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getYMax())));
        to.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMin())));
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        CuboidNSEWUDBlockExporter.addBoundingBoxNSEWUDFaces(faces, bbox, isTinted);
        element.add("faces", (JsonElement)faces);
    }

    private static void addCuboidNSEWUDFaces(JsonObject faces, BlockDefinition.CuboidElement cuboid, boolean isTinted) {
        int[] nArray;
        boolean[] blArray;
        int[] nArray2;
        if (cuboid.getSideTextures() != null) {
            nArray2 = cuboid.getSideTextures();
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 5;
            nArray3[3] = 4;
            nArray3[4] = 2;
            nArray2 = nArray3;
            nArray3[5] = 3;
        }
        int[] sidetxt = nArray2;
        if (cuboid.getNoTint() != null) {
            blArray = cuboid.getNoTint();
        } else {
            boolean[] blArray2 = new boolean[6];
            blArray2[0] = false;
            blArray2[1] = false;
            blArray2[2] = false;
            blArray2[3] = false;
            blArray2[4] = false;
            blArray = blArray2;
            blArray2[5] = false;
        }
        boolean[] noTint = blArray;
        if (cuboid.getSideRotations() != null) {
            nArray = cuboid.getSideRotations();
        } else {
            int[] nArray4 = new int[6];
            nArray4[0] = 0;
            nArray4[1] = 0;
            nArray4[2] = 0;
            nArray4[3] = 0;
            nArray4[4] = 0;
            nArray = nArray4;
            nArray4[5] = 0;
        }
        int[] siderot = nArray;
        CuboidNSEWUDBlockExporter.addFaceNSEWUD(faces, "down", 0, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addFaceNSEWUD(faces, "up", 1, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addFaceNSEWUD(faces, "north", 2, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addFaceNSEWUD(faces, "south", 3, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addFaceNSEWUD(faces, "west", 4, cuboid, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addFaceNSEWUD(faces, "east", 5, cuboid, sidetxt, noTint, siderot, isTinted);
    }

    private static void addBoundingBoxNSEWUDFaces(JsonObject faces, BlockDefinition.BoundingBox bbox, boolean isTinted) {
        int[] sidetxt = new int[]{0, 1, 5, 4, 2, 3};
        boolean[] noTint = new boolean[]{false, false, false, false, false, false};
        int[] siderot = new int[]{0, 0, 0, 0, 0, 0};
        CuboidNSEWUDBlockExporter.addBoundingBoxFaceNSEWUD(faces, "down", 0, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addBoundingBoxFaceNSEWUD(faces, "up", 1, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addBoundingBoxFaceNSEWUD(faces, "north", 2, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addBoundingBoxFaceNSEWUD(faces, "south", 3, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addBoundingBoxFaceNSEWUD(faces, "west", 4, bbox, sidetxt, noTint, siderot, isTinted);
        CuboidNSEWUDBlockExporter.addBoundingBoxFaceNSEWUD(faces, "east", 5, bbox, sidetxt, noTint, siderot, isTinted);
    }

    private static void addFaceNSEWUD(JsonObject faces, String face, int index, BlockDefinition.CuboidElement cuboid, int[] sidetxt, boolean[] noTint, int[] siderot, boolean isTinted) {
        String cullface;
        JsonObject faceObj = new JsonObject();
        JsonArray uv = new JsonArray();
        CuboidNSEWUDBlockExporter.calculateNSEWUDUVs(face, cuboid, uv);
        faceObj.add("uv", (JsonElement)uv);
        faceObj.addProperty("texture", "#txt" + sidetxt[index]);
        if (face.equals("down") && siderot[index] == 0) {
            faceObj.addProperty("rotation", (Number)90);
        } else if (face.equals("up") && siderot[index] == 0) {
            faceObj.addProperty("rotation", (Number)270);
        } else if (siderot[index] != 0) {
            faceObj.addProperty("rotation", (Number)siderot[index]);
        }
        if (isTinted && !noTint[index]) {
            faceObj.addProperty("tintindex", (Number)0);
        }
        if ((cullface = CuboidNSEWUDBlockExporter.getCullfaceNSEWUD(face, cuboid)) != null) {
            faceObj.addProperty("cullface", cullface);
        }
        faces.add(face, (JsonElement)faceObj);
    }

    private static void addBoundingBoxFaceNSEWUD(JsonObject faces, String face, int index, BlockDefinition.BoundingBox bbox, int[] sidetxt, boolean[] noTint, int[] siderot, boolean isTinted) {
        String cullface;
        JsonObject faceObj = new JsonObject();
        JsonArray uv = new JsonArray();
        CuboidNSEWUDBlockExporter.calculateBoundingBoxNSEWUDUVs(face, bbox, uv);
        faceObj.add("uv", (JsonElement)uv);
        faceObj.addProperty("texture", "#txt" + sidetxt[index]);
        if (face.equals("down") && siderot[index] == 0) {
            faceObj.addProperty("rotation", (Number)90);
        } else if (face.equals("up") && siderot[index] == 0) {
            faceObj.addProperty("rotation", (Number)270);
        } else if (siderot[index] != 0) {
            faceObj.addProperty("rotation", (Number)siderot[index]);
        }
        if (isTinted && !noTint[index]) {
            faceObj.addProperty("tintindex", (Number)0);
        }
        if ((cullface = CuboidNSEWUDBlockExporter.getBoundingBoxCullfaceNSEWUD(face, bbox)) != null) {
            faceObj.addProperty("cullface", cullface);
        }
        faces.add(face, (JsonElement)faceObj);
    }

    private static void calculateNSEWUDUVs(String face, BlockDefinition.CuboidElement cuboid, JsonArray uv) {
        switch (face) {
            case "down": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMax())));
                break;
            }
            case "up": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMin())));
                break;
            }
            case "north": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "south": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "west": {
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMin())));
                break;
            }
            case "east": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getYMin())));
            }
        }
    }

    private static String getCullfaceNSEWUD(String face, BlockDefinition.CuboidElement cuboid) {
        return switch (face) {
            case "down" -> {
                if (cuboid.getYMin() <= 0.0) {
                    yield "down";
                }
                yield null;
            }
            case "up" -> {
                if (cuboid.getYMax() >= 1.0) {
                    yield "up";
                }
                yield null;
            }
            case "north" -> {
                if (16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMax()) <= 0.0f) {
                    yield "north";
                }
                yield null;
            }
            case "south" -> {
                if (16.0f - CuboidNSEWUDBlockExporter.getClamped(cuboid.getXMin()) >= 16.0f) {
                    yield "south";
                }
                yield null;
            }
            case "west" -> {
                if (cuboid.getZMin() <= 0.0) {
                    yield "west";
                }
                yield null;
            }
            case "east" -> {
                if (cuboid.getZMax() >= 1.0) {
                    yield "east";
                }
                yield null;
            }
            default -> null;
        };
    }

    private static void calculateBoundingBoxNSEWUDUVs(String face, BlockDefinition.BoundingBox bbox, JsonArray uv) {
        switch (face) {
            case "down": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getXMax())));
                break;
            }
            case "up": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMin())));
                break;
            }
            case "north": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "south": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getZMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "west": {
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMin())));
                break;
            }
            case "east": {
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getXMin())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMax())));
                uv.add((Number)Float.valueOf(CuboidNSEWUDBlockExporter.getClamped(bbox.getXMax())));
                uv.add((Number)Float.valueOf(16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getYMin())));
            }
        }
    }

    private static String getBoundingBoxCullfaceNSEWUD(String face, BlockDefinition.BoundingBox bbox) {
        return switch (face) {
            case "down" -> {
                if (bbox.getYMin() <= 0.0) {
                    yield "down";
                }
                yield null;
            }
            case "up" -> {
                if (bbox.getYMax() >= 1.0) {
                    yield "up";
                }
                yield null;
            }
            case "north" -> {
                if (16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMax()) <= 0.0f) {
                    yield "north";
                }
                yield null;
            }
            case "south" -> {
                if (16.0f - CuboidNSEWUDBlockExporter.getClamped(bbox.getXMin()) >= 16.0f) {
                    yield "south";
                }
                yield null;
            }
            case "west" -> {
                if (bbox.getZMin() <= 0.0) {
                    yield "west";
                }
                yield null;
            }
            case "east" -> {
                if (bbox.getZMax() >= 1.0) {
                    yield "east";
                }
                yield null;
            }
            default -> null;
        };
    }

    private static float getClamped(double v) {
        float f = (float)(16.0 * v);
        if (f < -16.0f) {
            f = -16.0f;
        }
        if (f > 32.0f) {
            f = 32.0f;
        }
        return f;
    }

    private static class_4944 createCustomCuboidTextureMap(List<String> textures) {
        class_4944 textureMap = new class_4944();
        if (textures == null || textures.isEmpty()) {
            String fallbackTexture = "missing";
            for (int i = 0; i < 6; ++i) {
                textureMap.method_25868(ModTextureKey.getTextureNKey(i), CuboidNSEWUDBlockExporter.createBlockIdentifier(fallbackTexture));
            }
            textureMap.method_25868(class_4945.field_23012, CuboidNSEWUDBlockExporter.createBlockIdentifier(fallbackTexture));
            return textureMap;
        }
        int textureCount = textures.size();
        int requiredTextures = Math.max(6, textureCount);
        for (int i = 0; i < requiredTextures; ++i) {
            String texture = i < textureCount ? textures.get(i) : textures.get(textureCount - 1);
            textureMap.method_25868(ModTextureKey.getTextureNKey(i), CuboidNSEWUDBlockExporter.createBlockIdentifier(texture));
        }
        textureMap.method_25868(class_4945.field_23012, CuboidNSEWUDBlockExporter.createBlockIdentifier(textures.get(0)));
        return textureMap;
    }

    private static class ModelVariant {
        final class_2960 model;
        final int weight;

        ModelVariant(class_2960 model, int weight) {
            this.model = model;
            this.weight = weight;
        }
    }
}

