/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2350;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class DoorBlockExporter
extends BaseBlockExporter {
    public static void registerDoorBlock(class_4910 generator, class_2248 block, String ... texturePaths) {
        DoorBlockExporter.validateTexturePaths(texturePaths, 2);
        String topTexture = texturePaths[0];
        String bottomTexture = texturePaths[1];
        class_2960 bottomLeftModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "bottom_left", ModModels.DOOR_BOTTOM_LEFT);
        class_2960 bottomRightModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "bottom_right", ModModels.DOOR_BOTTOM_RIGHT);
        class_2960 bottomLeftOpenModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "bottom_left_open", ModModels.DOOR_BOTTOM_LEFT_OPEN);
        class_2960 bottomRightOpenModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "bottom_right_open", ModModels.DOOR_BOTTOM_RIGHT_OPEN);
        class_2960 topLeftModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "top_left", ModModels.DOOR_TOP_LEFT);
        class_2960 topRightModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "top_right", ModModels.DOOR_TOP_RIGHT);
        class_2960 topLeftOpenModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "top_left_open", ModModels.DOOR_TOP_LEFT_OPEN);
        class_2960 topRightOpenModelId = DoorBlockExporter.createDoorModel(generator, block, topTexture, bottomTexture, "top_right_open", ModModels.DOOR_TOP_RIGHT_OPEN);
        class_4926 variants = DoorBlockExporter.createDoorVariants(bottomLeftModelId, bottomRightModelId, bottomLeftOpenModelId, bottomRightOpenModelId, topLeftModelId, topRightModelId, topLeftOpenModelId, topRightOpenModelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(variants));
        DoorBlockExporter.registerSimpleItemModel(generator, block, DoorBlockExporter.createBlockIdentifier(bottomTexture));
    }

    private static class_4926 createDoorVariants(class_2960 bottomLeftModelId, class_2960 bottomRightModelId, class_2960 bottomLeftOpenModelId, class_2960 bottomRightOpenModelId, class_2960 topLeftModelId, class_2960 topRightModelId, class_2960 topLeftOpenModelId, class_2960 topRightOpenModelId) {
        return class_4926.method_25786((class_2769)class_2323.field_10938, (class_2769)class_2323.field_10946, (class_2769)class_2323.field_10941, (class_2769)class_2323.field_10945).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomLeftModelId)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomLeftOpenModelId, 90)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomRightModelId)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomRightOpenModelId, 270)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topLeftModelId)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topLeftOpenModelId, 90)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topRightModelId)).method_25811((Comparable)class_2350.field_11034, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topRightOpenModelId, 270)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomLeftModelId, 90)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomLeftOpenModelId, 180)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomRightModelId, 90)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomRightOpenModelId, 0)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topLeftModelId, 90)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topLeftOpenModelId, 180)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topRightModelId, 90)).method_25811((Comparable)class_2350.field_11035, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topRightOpenModelId, 0)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomLeftModelId, 180)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomLeftOpenModelId, 270)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomRightModelId, 180)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomRightOpenModelId, 90)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topLeftModelId, 180)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topLeftOpenModelId, 270)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topRightModelId, 180)).method_25811((Comparable)class_2350.field_11039, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topRightOpenModelId, 90)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomLeftModelId, 270)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomLeftOpenModelId, 0)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(bottomRightModelId, 270)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12607, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(bottomRightOpenModelId, 180)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topLeftModelId, 270)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topLeftOpenModelId, 0)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), DoorBlockExporter.createVariant(topRightModelId, 270)).method_25811((Comparable)class_2350.field_11043, (Comparable)class_2756.field_12609, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), DoorBlockExporter.createVariant(topRightOpenModelId, 180));
    }

    public static void registerCustomDoorBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        definition.validateTextureData();
        definition.validateTextureCount(2);
        String[] textures = definition.getTexturesAsArray();
        DoorBlockExporter.registerDoorBlock(generator, block, textures[0], textures[1]);
    }

    private static class_2960 createDoorModel(class_4910 generator, class_2248 block, String topTexture, String bottomTexture, String variant, class_4942 model) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23015, DoorBlockExporter.createBlockIdentifier(topTexture)).method_25868(class_4945.field_23014, DoorBlockExporter.createBlockIdentifier(bottomTexture));
        class_2960 modelId = DoorBlockExporter.createNestedModelId(block, variant);
        model.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }
}

