/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class FurnaceBlockExporter
extends BaseBlockExporter {
    private static class_4942 createFurnaceModel(boolean tinted) {
        return FurnaceBlockExporter.createTintedModel(tinted, "orientable", class_4945.field_23015, class_4945.field_23016, class_4945.field_23018);
    }

    private static class_4944 createFurnaceTextureMap(String top, String side, String front) {
        return new class_4944().method_25868(class_4945.field_23015, FurnaceBlockExporter.createBlockIdentifier(top)).method_25868(class_4945.field_23018, FurnaceBlockExporter.createBlockIdentifier(side)).method_25868(class_4945.field_23016, FurnaceBlockExporter.createBlockIdentifier(front));
    }

    private static class_4925 createFurnaceBlockstate(class_2248 block, class_2960 litModelId, class_2960 unlitModelId) {
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12548).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), FurnaceBlockExporter.createVariant(unlitModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11043))).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), FurnaceBlockExporter.createVariant(unlitModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11035))).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), FurnaceBlockExporter.createVariant(unlitModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11039))).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), FurnaceBlockExporter.createVariant(unlitModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11034))).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), FurnaceBlockExporter.createVariant(litModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11043))).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), FurnaceBlockExporter.createVariant(litModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11035))).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), FurnaceBlockExporter.createVariant(litModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11039))).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), FurnaceBlockExporter.createVariant(litModelId, FurnaceBlockExporter.getRotationForDirection(class_2350.field_11034))));
    }

    public static void registerFurnaceBlock(class_4910 generator, class_2248 block, boolean tinted, String top, String side, String frontLit, String frontUnlit) {
        class_4944 litTextureMap = FurnaceBlockExporter.createFurnaceTextureMap(top, side, frontLit);
        class_4944 unlitTextureMap = FurnaceBlockExporter.createFurnaceTextureMap(top, side, frontUnlit);
        class_2960 litModelId = FurnaceBlockExporter.uploadModel(FurnaceBlockExporter.createFurnaceModel(tinted), block, "lit", litTextureMap, generator.field_22831);
        class_2960 unlitModelId = FurnaceBlockExporter.uploadModel(FurnaceBlockExporter.createFurnaceModel(tinted), block, "base", unlitTextureMap, generator.field_22831);
        class_4925 blockstate = FurnaceBlockExporter.createFurnaceBlockstate(block, litModelId, unlitModelId);
        generator.field_22830.accept(blockstate);
        FurnaceBlockExporter.registerParentedItemModel(generator, block, unlitModelId);
    }

    public static void registerFurnaceBlockCustomModel(class_4910 generator, class_2248 block, String blockName) {
        class_2960 litModelId = WesterosBlocks.id("block/custom/" + blockName + "/lit_v1");
        class_2960 unlitModelId = WesterosBlocks.id("block/custom/" + blockName + "/base_v1");
        class_4925 blockstate = FurnaceBlockExporter.createFurnaceBlockstate(block, litModelId, unlitModelId);
        generator.field_22830.accept(blockstate);
        generator.method_25623(block, unlitModelId);
    }

    public static void registerCustomFurnaceBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        boolean isCustomModel = definition.hasCustomModel();
        if (isCustomModel) {
            FurnaceBlockExporter.registerFurnaceBlockCustomModel(generator, block, definition.getBlockName());
            return;
        }
        if (definition.getTextures() != null && definition.getTextures().size() >= 4) {
            FurnaceBlockExporter.registerFurnaceBlock(generator, block, tinted, definition.getTextures().get(0), definition.getTextures().get(1), definition.getTextures().get(2), definition.getTextures().get(3));
        } else if (definition.getTextures() != null && definition.getTextures().size() >= 1) {
            String fallback = definition.getTextures().get(0);
            FurnaceBlockExporter.registerFurnaceBlock(generator, block, tinted, fallback, fallback, fallback, fallback);
            WesterosBlocks.LOGGER.warn("Furnace block '{}' has insufficient textures ({}), using fallback", (Object)definition.getBlockName(), (Object)definition.getTextures().size());
        } else {
            FurnaceBlockExporter.registerFurnaceBlock(generator, block, tinted, "missingno", "missingno", "missingno", "missingno");
        }
    }
}

