/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class LadderBlockExporter
extends BaseBlockExporter {
    private static class_4942 createLadderModel(boolean tinted) {
        return LadderBlockExporter.createTintedModel(tinted, "ladder", class_4945.field_23011, class_4945.field_23012);
    }

    private static class_4944 createLadderTextureMap(String texture) {
        return new class_4944().method_25868(class_4945.field_23011, LadderBlockExporter.createBlockIdentifier(texture)).method_25868(class_4945.field_23012, LadderBlockExporter.createBlockIdentifier(texture));
    }

    private static class_4925 createLadderBlockstate(class_2248 block, List<class_2960> modelIds, List<Integer> weights) {
        class_4926.class_4927 variantMap = class_4926.method_25783((class_2769)class_2741.field_12481);
        for (class_2350 direction : new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            ArrayList<class_4935> directionVariants = new ArrayList<class_4935>();
            for (int i = 0; i < modelIds.size(); ++i) {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelIds.get(i));
                switch (direction) {
                    case field_11034: {
                        variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
                        break;
                    }
                    case field_11035: {
                        variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892);
                        break;
                    }
                    case field_11039: {
                        variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
                    }
                }
                if (weights != null && weights.get(i) > 1) {
                    variant = variant.method_25828(class_4936.field_22889, (Object)weights.get(i));
                }
                directionVariants.add(variant);
            }
            variantMap.method_25794((Comparable)direction, directionVariants);
        }
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)variantMap);
    }

    public static void registerLadderBlock(class_4910 generator, class_2248 block, boolean tinted, String texture) {
        class_4944 textureMap = LadderBlockExporter.createLadderTextureMap(texture);
        class_2960 modelId = LadderBlockExporter.uploadModel(LadderBlockExporter.createLadderModel(tinted), block, "base", textureMap, generator.field_22831);
        class_4925 blockstate = LadderBlockExporter.createLadderBlockstate(block, List.of(modelId), List.of(Integer.valueOf(1)));
        generator.field_22830.accept(blockstate);
        LadderBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    public static void registerLadderBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, List<BlockDefinition.TextureVariantSet> textureSets) {
        BaseBlockExporter.ModelRegistry registry = new BaseBlockExporter.ModelRegistry();
        for (int i = 0; i < textureSets.size(); ++i) {
            BlockDefinition.TextureVariantSet set = textureSets.get(i);
            class_4944 textureMap = LadderBlockExporter.createLadderTextureMap(set.getFirstTexture());
            class_2960 modelId = LadderBlockExporter.uploadModel(LadderBlockExporter.createLadderModel(tinted), block, "base_v" + (i + 1), textureMap, generator.field_22831);
            registry.add(modelId, set.weight);
        }
        class_4925 blockstate = LadderBlockExporter.createLadderBlockstate(block, registry.getModelIds(), registry.getWeights());
        generator.field_22830.accept(blockstate);
        LadderBlockExporter.registerParentedItemModel(generator, block, registry.getModelIds().get(0));
    }

    public static void registerLadderBlockCustomModel(class_4910 generator, class_2248 block, String blockName, int variantCount) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int i = 0; i < variantCount; ++i) {
            String modelName = i == 0 ? "base_v1" : "base_v" + (i + 1);
            class_2960 modelId = WesterosBlocks.id("block/custom/" + blockName + "/" + modelName);
            modelIds.add(modelId);
            weights.add(1);
        }
        class_4925 blockstate = LadderBlockExporter.createLadderBlockstate(block, modelIds, weights);
        generator.field_22830.accept(blockstate);
        generator.method_25623(block, (class_2960)modelIds.get(0));
    }

    public static void registerCustomLadderBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        boolean isCustomModel = definition.hasCustomModel();
        if (definition.hasRandomTextures()) {
            List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
            if (isCustomModel) {
                LadderBlockExporter.registerLadderBlockCustomModel(generator, block, definition.getBlockName(), randomTextures.size());
                return;
            }
            ArrayList<BlockDefinition.TextureVariantSet> textureSets = new ArrayList<BlockDefinition.TextureVariantSet>();
            for (BlockDefinition.RandomTextureVariant randomTexture : randomTextures) {
                List<String> textures = randomTexture.getTextures();
                int weight = randomTexture.getWeight();
                if (textures != null && !textures.isEmpty()) {
                    textureSets.add(new BlockDefinition.TextureVariantSet(textures.get(0), weight));
                    continue;
                }
                textureSets.add(new BlockDefinition.TextureVariantSet("missingno", weight));
            }
            LadderBlockExporter.registerLadderBlockWithRandomTextures(generator, block, tinted, textureSets);
        } else if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
            if (isCustomModel) {
                LadderBlockExporter.registerLadderBlockCustomModel(generator, block, definition.getBlockName(), 1);
            } else {
                LadderBlockExporter.registerLadderBlock(generator, block, tinted, definition.getTextures().get(0));
            }
        } else if (isCustomModel) {
            LadderBlockExporter.registerLadderBlockCustomModel(generator, block, definition.getBlockName(), 1);
        } else {
            LadderBlockExporter.registerLadderBlock(generator, block, tinted, "missingno");
        }
    }
}

