/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class LeavesBlockExporter
extends BaseBlockExporter {
    private static class_4942 createLeavesModel(boolean tinted, boolean overlay) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "leaves_overlay" : "leaves";
        String path = tintPath + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23013, class_4945.field_23018, ModTextureKey.LEAVES_OVERLAY_END, ModTextureKey.LEAVES_OVERLAY_SIDE, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23013, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4942 createLeavesBetterFoliageModel(boolean tinted, boolean overlay, int variant) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "leaves_overlay_bf" : "leaves_bf";
        String path = tintPath + overlayPath + variant;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23010, ModTextureKey.LEAVES_OVERLAY_END, ModTextureKey.LEAVES_OVERLAY_SIDE, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23010, class_4945.field_23012});
    }

    private static class_4944 createStandardLeavesTextureMap(String[] textures, boolean hasOverlay) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23013, LeavesBlockExporter.createBlockIdentifier(textures[0])).method_25868(class_4945.field_23018, LeavesBlockExporter.createBlockIdentifier(textures[1])).method_25868(class_4945.field_23012, LeavesBlockExporter.createBlockIdentifier(textures[1]));
        if (hasOverlay && textures.length >= 4) {
            textureMap.method_25868(ModTextureKey.LEAVES_OVERLAY_END, LeavesBlockExporter.createBlockIdentifier(textures[2]));
            textureMap.method_25868(ModTextureKey.LEAVES_OVERLAY_SIDE, LeavesBlockExporter.createBlockIdentifier(textures[3]));
        }
        return textureMap;
    }

    private static class_4944 createBetterFoliageTextureMap(String[] textures, boolean hasOverlay) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23010, LeavesBlockExporter.createBlockIdentifier(textures[0])).method_25868(class_4945.field_23012, LeavesBlockExporter.createBlockIdentifier(textures[0]));
        if (hasOverlay && textures.length >= 3) {
            textureMap.method_25868(ModTextureKey.LEAVES_OVERLAY_END, LeavesBlockExporter.createBlockIdentifier(textures[1]));
            textureMap.method_25868(ModTextureKey.LEAVES_OVERLAY_SIDE, LeavesBlockExporter.createBlockIdentifier(textures[2]));
        }
        return textureMap;
    }

    public static void registerLeavesBlock(class_4910 generator, class_2248 block, boolean tinted, boolean overlay, boolean betterFoliage, boolean rotateRandom, String[] textures) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        if (betterFoliage) {
            textureMap = LeavesBlockExporter.createBetterFoliageTextureMap(textures, overlay);
            for (int i = 1; i <= 3; ++i) {
                class_2960 modelId = LeavesBlockExporter.createLeavesBetterFoliageModel(tinted, overlay, i).method_25852(LeavesBlockExporter.createNestedModelId(block, "bf" + i), textureMap, generator.field_22831);
                modelIds.add(modelId);
            }
        } else {
            textureMap = LeavesBlockExporter.createStandardLeavesTextureMap(textures, overlay);
            class_2960 modelId = LeavesBlockExporter.createLeavesModel(tinted, overlay).method_25852(LeavesBlockExporter.createNestedModelId(block, "base"), textureMap, generator.field_22831);
            modelIds.add(modelId);
        }
        class_4925 blockstate = LeavesBlockExporter.createLeavesBlockstate(block, modelIds, rotateRandom, null);
        generator.field_22830.accept(blockstate);
        generator.method_25623(block, (class_2960)modelIds.get(0));
    }

    public static void registerLeavesBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, boolean overlay, boolean betterFoliage, boolean rotateRandom, List<BlockDefinition.TextureVariantSet> textureSets) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int setIdx = 0; setIdx < textureSets.size(); ++setIdx) {
            class_4944 textureMap;
            BlockDefinition.TextureVariantSet set = textureSets.get(setIdx);
            if (betterFoliage) {
                textureMap = LeavesBlockExporter.createBetterFoliageTextureMap(set.getTexturesAsArray(), overlay);
                for (int bfIdx = 1; bfIdx <= 3; ++bfIdx) {
                    class_2960 modelId = LeavesBlockExporter.createLeavesBetterFoliageModel(tinted, overlay, bfIdx).method_25852(LeavesBlockExporter.createNestedModelId(block, "bf" + bfIdx + "_v" + (setIdx + 1)), textureMap, generator.field_22831);
                    modelIds.add(modelId);
                    weights.add(set.weight);
                }
                continue;
            }
            textureMap = LeavesBlockExporter.createStandardLeavesTextureMap(set.getTexturesAsArray(), overlay);
            class_2960 modelId = LeavesBlockExporter.createLeavesModel(tinted, overlay).method_25852(LeavesBlockExporter.createNestedModelId(block, "base_v" + (setIdx + 1)), textureMap, generator.field_22831);
            modelIds.add(modelId);
            weights.add(set.weight);
        }
        class_4925 blockstate = LeavesBlockExporter.createLeavesBlockstate(block, modelIds, rotateRandom, weights);
        generator.field_22830.accept(blockstate);
        generator.method_25623(block, (class_2960)modelIds.get(0));
    }

    private static class_4925 createLeavesBlockstate(class_2248 block, List<class_2960> modelIds, boolean rotateRandom, List<Integer> weights) {
        ArrayList<class_4935> variants = new ArrayList<class_4935>();
        int rotationCount = rotateRandom ? 4 : 1;
        for (int i = 0; i < modelIds.size(); ++i) {
            for (int rotation = 0; rotation < rotationCount; ++rotation) {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelIds.get(i));
                if (weights != null && weights.get(i) > 1) {
                    variant = variant.method_25828(class_4936.field_22889, (Object)weights.get(i));
                }
                if (rotation > 0) {
                    variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.valueOf((String)("R" + 90 * rotation)));
                }
                variants.add(variant);
            }
        }
        if (variants.size() == 1) {
            return class_4925.method_25770((class_2248)block, (class_4935)((class_4935)variants.get(0)));
        }
        return class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0]));
    }

    public static void registerCustomLeavesBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        String type = definition.getType();
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        boolean overlay = definition.hasOverlay() || type != null && type.contains("overlay");
        boolean betterFoliage = definition.hasBetterFoliage() || type != null && type.contains("better-foliage");
        boolean rotateRandom = definition.hasRotateRandom();
        if (definition.hasRandomTextures()) {
            ArrayList<BlockDefinition.TextureVariantSet> textureSets = new ArrayList<BlockDefinition.TextureVariantSet>();
            for (BlockDefinition.RandomTextureVariant randomTexture : definition.getRandomTextures()) {
                List<String> textures = randomTexture.getTextures();
                if (textures == null || textures.isEmpty()) continue;
                textureSets.add(new BlockDefinition.TextureVariantSet(textures.toArray(new String[0]), randomTexture.getWeight()));
            }
            LeavesBlockExporter.registerLeavesBlockWithRandomTextures(generator, block, tinted, overlay, betterFoliage, rotateRandom, textureSets);
        } else if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
            String[] textures = definition.getTextures().toArray(new String[0]);
            LeavesBlockExporter.registerLeavesBlock(generator, block, tinted, overlay, betterFoliage, rotateRandom, textures);
        } else {
            WesterosBlocks.LOGGER.warn("No textures defined for leaves block: {}", (Object)definition.getBlockName());
        }
    }
}

