/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class LogBlockExporter
extends BaseBlockExporter {
    public static void registerLogBlock(class_4910 generator, class_2248 block, String sideTexture, String endTexture, boolean uvLocked) {
        if (sideTexture.isEmpty() || endTexture.isEmpty()) {
            throw new IllegalArgumentException("Side and end textures are required for log blocks");
        }
        class_4944 textureMap = LogBlockExporter.createLogTextureMap(sideTexture, endTexture);
        class_2960 verticalModelId = ModModels.LOG.method_25852(LogBlockExporter.createNestedModelId(block), textureMap, generator.field_22831);
        class_2960 horizontalModelId = ModModels.LOG_HORIZONTAL.method_25852(LogBlockExporter.createNestedModelId(block, "horizontal"), textureMap, generator.field_22831);
        class_4926 variants = LogBlockExporter.createLogVariants(verticalModelId, horizontalModelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(variants));
        LogBlockExporter.registerParentedItemModel(generator, block, verticalModelId);
    }

    public static void registerCustomLogBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        String endTexture;
        String sideTexture;
        if (definition.getTextures() == null || definition.getTextures().size() < 2) {
            throw new IllegalArgumentException("Log blocks require at least 2 textures: [side, end] or [end, end, side]");
        }
        if (definition.getTextures().size() == 2) {
            sideTexture = definition.getTextures().get(0);
            endTexture = definition.getTextures().get(1);
        } else if (definition.getTextures().size() == 3) {
            sideTexture = definition.getTextures().get(2);
            endTexture = definition.getTextures().get(0);
        } else {
            throw new IllegalArgumentException("Log blocks require 2 or 3 textures, got: " + definition.getTextures().size());
        }
        LogBlockExporter.registerLogBlock(generator, block, sideTexture, endTexture, false);
    }

    private static class_4944 createLogTextureMap(String sideTexture, String endTexture) {
        return new class_4944().method_25868(class_4945.field_23018, LogBlockExporter.createBlockIdentifier(sideTexture)).method_25868(class_4945.field_23013, LogBlockExporter.createBlockIdentifier(endTexture)).method_25868(class_4945.field_23012, LogBlockExporter.createBlockIdentifier(sideTexture));
    }

    private static class_4926 createLogVariants(class_2960 verticalModelId, class_2960 horizontalModelId) {
        return class_4926.method_25783((class_2769)class_2741.field_12496).method_25793((Comparable)class_2350.class_2351.field_11052, LogBlockExporter.createVariant(verticalModelId)).method_25793((Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }
}

