/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.datagen.custom.CrossBlockExporter;
import net.minecraft.class_2248;
import net.minecraft.class_4910;

public class PlantBlockExporter
extends BaseBlockExporter {
    public static void registerCustomPlantBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        definition.validateTextureData();
        String blockName = PlantBlockExporter.getBlockName(block);
        boolean isLayerSensitive = definition.getType() != null && "layerSensitive".equals(definition.getType());
        boolean isTinted = definition.shouldUseTintedModel();
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        if (source == BlockDefinition.TextureSource.RANDOM_TEXTURES) {
            String[] texturePaths = (String[])definition.getRandomTextureVariantSets().stream().flatMap(variant -> variant.textures.stream()).toArray(String[]::new);
            if (isLayerSensitive) {
                CrossBlockExporter.generateLayerSensitiveCrossWithRandomTextures(generator, block, texturePaths, isTinted, 4);
            } else {
                CrossBlockExporter.generateCrossWithRandomTextures(generator, block, texturePaths, isTinted, 4);
            }
        } else if (source == BlockDefinition.TextureSource.TEXTURES) {
            String texturePath = definition.getFirstTexture("missingno");
            if (isLayerSensitive) {
                CrossBlockExporter.generateLayerSensitiveCross(generator, block, texturePath, isTinted, 1);
            } else {
                CrossBlockExporter.generateCross(generator, block, texturePath, isTinted, 1);
            }
        }
    }
}

