/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.ModTextureMap;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4943;
import net.minecraft.class_4944;

public class SlabBlockExporter
extends BaseBlockExporter {
    public static void registerCustomSlabBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case RANDOM_TEXTURES: {
                SlabBlockExporter.registerSlabBlockWithRandomTextures(generator, block, definition);
                break;
            }
            case TEXTURES: {
                SlabBlockExporter.registerSimpleSlabBlock(generator, block, definition);
                break;
            }
            case CUSTOM_MODEL: {
                SlabBlockExporter.registerCustomModelSlabBlock(generator, block, definition);
                break;
            }
            case NONE: 
            case STATES: {
                SlabBlockExporter.registerFallbackSlabBlock(generator, block, definition);
            }
        }
    }

    private static void registerSimpleSlabBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<String> textures = definition.getTextures();
        String[] textureArray = textures.toArray(new String[0]);
        String[] filledTextures = SlabBlockExporter.fillTextureArray(textureArray);
        class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
        class_2960 bottomModelId = ModModels.SLAB_BOTTOM.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_bottom"), textureMap, generator.field_22831);
        class_2960 topModelId = ModModels.SLAB_TOP.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_top"), textureMap, generator.field_22831);
        class_2960 fullModelId = class_4943.field_22942.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_double"), textureMap, generator.field_22831);
        generator.field_22830.accept(SlabBlockExporter.createSlabBlockState(block, bottomModelId, topModelId, fullModelId));
        SlabBlockExporter.registerParentedItemModel(generator, block, bottomModelId);
    }

    private static void registerSlabBlockWithRandomTextures(class_4910 generator, class_2248 block, BlockDefinition definition) {
        List<BlockDefinition.RandomTextureVariant> randomTextures = definition.getRandomTextures();
        ArrayList<SlabModelSet> modelSets = new ArrayList<SlabModelSet>();
        for (int i = 0; i < randomTextures.size(); ++i) {
            BlockDefinition.RandomTextureVariant variant = randomTextures.get(i);
            List<String> textures = variant.getTextures();
            String[] textureArray = textures.toArray(new String[0]);
            String[] filledTextures = SlabBlockExporter.fillTextureArray(textureArray);
            class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
            String variantSuffix = "_v" + (i + 1);
            class_2960 bottomModelId = ModModels.SLAB_BOTTOM.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_bottom" + variantSuffix), textureMap, generator.field_22831);
            class_2960 topModelId = ModModels.SLAB_TOP.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_top" + variantSuffix), textureMap, generator.field_22831);
            class_2960 fullModelId = class_4943.field_22942.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_double" + variantSuffix), textureMap, generator.field_22831);
            modelSets.add(new SlabModelSet(bottomModelId, topModelId, fullModelId, variant.getWeight()));
        }
        generator.field_22830.accept(SlabBlockExporter.createSlabBlockStateWithRandomTextures(block, modelSets));
        SlabBlockExporter.registerParentedItemModel(generator, block, ((SlabModelSet)modelSets.get((int)0)).bottom);
    }

    private static void registerCustomModelSlabBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        class_2960 bottomModelId = SlabBlockExporter.createCustomModelId(block, "bottom_v1");
        class_2960 topModelId = SlabBlockExporter.createCustomModelId(block, "top_v1");
        class_2960 fullModelId = SlabBlockExporter.createCustomModelId(block, "double_v1");
        generator.field_22830.accept(SlabBlockExporter.createSlabBlockState(block, bottomModelId, topModelId, fullModelId));
        SlabBlockExporter.registerParentedItemModel(generator, block, bottomModelId);
    }

    private static void registerFallbackSlabBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        String[] fallbackTextures = new String[]{"missing"};
        String[] filledTextures = SlabBlockExporter.fillTextureArray(fallbackTextures);
        class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
        class_2960 bottomModelId = ModModels.SLAB_BOTTOM.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_bottom"), textureMap, generator.field_22831);
        class_2960 topModelId = ModModels.SLAB_TOP.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_top"), textureMap, generator.field_22831);
        class_2960 fullModelId = class_4943.field_22942.method_25852(SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getBlockName(block) + "_double"), textureMap, generator.field_22831);
        generator.field_22830.accept(SlabBlockExporter.createSlabBlockState(block, bottomModelId, topModelId, fullModelId));
        SlabBlockExporter.registerParentedItemModel(generator, block, bottomModelId);
    }

    private static class_4917 createSlabBlockState(final class_2248 block, final class_2960 bottomModel, final class_2960 topModel, final class_2960 fullModel) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (class_2771 type : class_2771.values()) {
                    String variantKey = "type=" + type.method_15434();
                    JsonObject variant = new JsonObject();
                    class_2960 modelId = switch (type) {
                        default -> throw new MatchException(null, null);
                        case class_2771.field_12681 -> bottomModel;
                        case class_2771.field_12679 -> topModel;
                        case class_2771.field_12682 -> fullModel;
                    };
                    variant.addProperty("model", modelId.toString());
                    variants.add(variantKey, (JsonElement)variant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createSlabBlockStateWithRandomTextures(final class_2248 block, final List<SlabModelSet> modelSets) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (class_2771 type : class_2771.values()) {
                    String variantKey = "type=" + type.method_15434();
                    if (modelSets.size() == 1) {
                        JsonObject variant = new JsonObject();
                        class_2960 modelId = SlabBlockExporter.getModelForType((SlabModelSet)modelSets.get(0), type);
                        variant.addProperty("model", modelId.toString());
                        variants.add(variantKey, (JsonElement)variant);
                        continue;
                    }
                    JsonArray variantArray = new JsonArray();
                    for (SlabModelSet modelSet : modelSets) {
                        JsonObject variant = new JsonObject();
                        class_2960 modelId = SlabBlockExporter.getModelForType(modelSet, type);
                        variant.addProperty("model", modelId.toString());
                        if (modelSet.weight > 1) {
                            variant.addProperty("weight", (Number)modelSet.weight);
                        }
                        variantArray.add((JsonElement)variant);
                    }
                    variants.add(variantKey, (JsonElement)variantArray);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_2960 getModelForType(SlabModelSet modelSet, class_2771 type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_2771.field_12681 -> modelSet.bottom;
            case class_2771.field_12679 -> modelSet.top;
            case class_2771.field_12682 -> modelSet.full;
        };
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = SlabBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class SlabModelSet {
        final class_2960 bottom;
        final class_2960 top;
        final class_2960 full;
        final int weight;

        SlabModelSet(class_2960 bottom, class_2960 top, class_2960 full, int weight) {
            this.bottom = bottom;
            this.top = top;
            this.full = full;
            this.weight = weight;
        }
    }
}

