/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCSolidBlock;
import com.westerosblocks.data.BlockDefinition;
import com.westerosblocks.datagen.ModTextureMap;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class SolidBlockExporter
extends BaseBlockExporter {
    private static boolean isSymmetrical(class_2248 block) {
        if (block instanceof WCSolidBlock) {
            return ((WCSolidBlock)block).symmetrical;
        }
        return false;
    }

    public static void registerSimpleCustomSolidBlock(class_4910 generator, class_2248 block, String texturePath) {
        SolidBlockExporter.registerSimpleCustomSolidBlock(generator, block, texturePath, false);
    }

    public static void registerSimpleCustomSolidBlock(class_4910 generator, class_2248 block, String texturePath, boolean isTinted) {
        if (SolidBlockExporter.isSymmetrical(block)) {
            SolidBlockExporter.registerSymmetricalSolidBlock(generator, block, texturePath, isTinted);
        } else {
            SolidBlockExporter.registerStandardSolidBlock(generator, block, texturePath, isTinted);
        }
    }

    private static void registerStandardSolidBlock(class_4910 generator, class_2248 block, String texturePath) {
        SolidBlockExporter.registerStandardSolidBlock(generator, block, texturePath, false);
    }

    private static void registerStandardSolidBlock(class_4910 generator, class_2248 block, String texturePath, boolean isTinted) {
        class_2960 modelId;
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23010, SolidBlockExporter.createBlockIdentifier(texturePath));
        if (isTinted) {
            class_4942 tintedModel = new class_4942(Optional.of(WesterosBlocks.id("block/tinted/cube")), Optional.empty(), new class_4945[]{class_4945.field_23010});
            modelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block), textureMap, generator.field_22831);
        } else {
            modelId = class_4943.field_22972.method_25852(SolidBlockExporter.createNestedModelId(block), textureMap, generator.field_22831);
        }
        generator.field_22830.accept(SolidBlockExporter.createSimpleBlockState(block, modelId));
        SolidBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    public static void registerCustomSolidBlock(class_4910 generator, class_2248 block, String ... texturePaths) {
        SolidBlockExporter.registerCustomSolidBlock(generator, block, false, texturePaths);
    }

    public static void registerCustomSolidBlock(class_4910 generator, class_2248 block, boolean isTinted, String ... texturePaths) {
        SolidBlockExporter.validateTexturePaths(texturePaths, 1);
        if (SolidBlockExporter.isSymmetrical(block)) {
            SolidBlockExporter.registerSymmetricalSolidBlock(generator, block, isTinted, texturePaths);
        } else {
            SolidBlockExporter.registerStandardSolidBlock(generator, block, isTinted, texturePaths);
        }
    }

    public static void registerCustomSolidBlock(class_4910 generator, class_2248 block, BlockDefinition definition) {
        BlockDefinition.TextureSource source = definition.getPrimaryTextureSource();
        switch (source) {
            case STATES: {
                String[][] textureArrays = definition.getStateTextureArrays();
                SolidBlockExporter.registerCustomSolidBlockWithStates(generator, block, textureArrays);
                break;
            }
            case RANDOM_TEXTURES: {
                String[][] textureArrays = definition.getRandomTextureArrays();
                SolidBlockExporter.registerCustomSolidBlockWithRandomTextures(generator, block, textureArrays);
                break;
            }
            case TEXTURES: {
                String[] textures = definition.getTexturesAsArray();
                if (textures.length == 1) {
                    SolidBlockExporter.registerSimpleCustomSolidBlock(generator, block, textures[0]);
                    break;
                }
                SolidBlockExporter.registerCustomSolidBlock(generator, block, textures);
                break;
            }
        }
    }

    private static void registerStandardSolidBlock(class_4910 generator, class_2248 block, String ... texturePaths) {
        SolidBlockExporter.registerStandardSolidBlock(generator, block, false, texturePaths);
    }

    private static void registerStandardSolidBlock(class_4910 generator, class_2248 block, boolean isTinted, String ... texturePaths) {
        class_2960 modelId;
        String[] filledTextures = SolidBlockExporter.fillTextureArray(texturePaths);
        class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
        if (isTinted) {
            class_4942 tintedModel = new class_4942(Optional.of(WesterosBlocks.id("block/tinted/cube")), Optional.empty(), new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23021, class_4945.field_23022});
            modelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block), textureMap, generator.field_22831);
        } else {
            modelId = class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block), textureMap, generator.field_22831);
        }
        generator.field_22830.accept(SolidBlockExporter.createSimpleBlockState(block, modelId));
        SolidBlockExporter.registerParentedItemModel(generator, block, modelId);
    }

    public static void registerCustomSolidBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays) {
        SolidBlockExporter.registerCustomSolidBlockWithRandomTextures(generator, block, textureArrays, false);
    }

    public static void registerCustomSolidBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays, boolean isTinted) {
        if (textureArrays.length == 0) {
            throw new IllegalArgumentException("At least one texture array is required");
        }
        if (SolidBlockExporter.isSymmetrical(block)) {
            SolidBlockExporter.registerSymmetricalSolidBlockWithRandomTextures(generator, block, textureArrays, isTinted);
        } else {
            SolidBlockExporter.registerStandardSolidBlockWithRandomTextures(generator, block, textureArrays, isTinted);
        }
    }

    private static void registerStandardSolidBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays) {
        SolidBlockExporter.registerStandardSolidBlockWithRandomTextures(generator, block, textureArrays, false);
    }

    private static void registerStandardSolidBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays, boolean isTinted) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        for (int i = 0; i < textureArrays.length; ++i) {
            class_2960 modelId;
            SolidBlockExporter.validateTexturePaths(textureArrays[i], 1);
            String[] filledTextures = SolidBlockExporter.fillTextureArray(textureArrays[i]);
            class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
            if (isTinted) {
                class_4942 tintedModel = new class_4942(Optional.of(WesterosBlocks.id("block/tinted/cube")), Optional.empty(), new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23021, class_4945.field_23022});
                modelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831);
            } else {
                modelId = class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831);
            }
            modelIds.add(modelId);
        }
        List<class_4935> variants = modelIds.stream().map(BaseBlockExporter::createVariant).toList();
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
        if (!modelIds.isEmpty()) {
            SolidBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
        }
    }

    public static void registerCustomSolidBlockWithStates(class_4910 generator, class_2248 block, String[][] textureArrays) {
        if (textureArrays.length == 0) {
            throw new IllegalArgumentException("At least one texture array is required");
        }
        if (SolidBlockExporter.isSymmetrical(block)) {
            SolidBlockExporter.registerSymmetricalSolidBlockWithStates(generator, block, textureArrays);
        } else {
            SolidBlockExporter.registerStandardSolidBlockWithStates(generator, block, textureArrays);
        }
    }

    private static void registerStandardSolidBlockWithStates(class_4910 generator, class_2248 block, String[][] textureArrays) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        for (int i = 0; i < textureArrays.length; ++i) {
            SolidBlockExporter.validateTexturePaths(textureArrays[i], 1);
            String[] filledTextures = SolidBlockExporter.fillTextureArray(textureArrays[i]);
            class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
            class_2960 modelId = class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "state" + i + "_v" + (i + 1)), textureMap, generator.field_22831);
            modelIds.add(modelId);
        }
        generator.field_22830.accept(SolidBlockExporter.createStatesBlockState(block, modelIds));
        if (!modelIds.isEmpty()) {
            SolidBlockExporter.registerParentedItemModel(generator, block, (class_2960)modelIds.get(0));
        }
    }

    private static class_4917 createStatesBlockState(final class_2248 block, final List<class_2960> modelIds) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int i = 0; i < modelIds.size(); ++i) {
                    JsonObject variant = new JsonObject();
                    variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                    variants.add("state=state" + i, (JsonElement)variant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static void registerSymmetricalSolidBlock(class_4910 generator, class_2248 block, String texturePath) {
        SolidBlockExporter.registerSymmetricalSolidBlock(generator, block, texturePath, false);
    }

    private static void registerSymmetricalSolidBlock(class_4910 generator, class_2248 block, String texturePath, boolean isTinted) {
        class_2960 asymmetricalModelId;
        class_2960 symmetricalModelId;
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23010, SolidBlockExporter.createBlockIdentifier(texturePath));
        if (isTinted) {
            class_4942 tintedModel = new class_4942(Optional.of(WesterosBlocks.id("block/tinted/cube")), Optional.empty(), new class_4945[]{class_4945.field_23010});
            symmetricalModelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block, "symmetrical/base_v1"), textureMap, generator.field_22831);
            asymmetricalModelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block, "asymmetrical/base_v1"), textureMap, generator.field_22831);
        } else {
            symmetricalModelId = class_4943.field_22972.method_25852(SolidBlockExporter.createNestedModelId(block, "symmetrical/base_v1"), textureMap, generator.field_22831);
            asymmetricalModelId = class_4943.field_22972.method_25852(SolidBlockExporter.createNestedModelId(block, "asymmetrical/base_v1"), textureMap, generator.field_22831);
        }
        generator.field_22830.accept(SolidBlockExporter.createSymmetricalBlockState(block, symmetricalModelId, asymmetricalModelId));
        SolidBlockExporter.registerParentedItemModel(generator, block, symmetricalModelId);
    }

    private static void registerSymmetricalSolidBlock(class_4910 generator, class_2248 block, String ... texturePaths) {
        SolidBlockExporter.registerSymmetricalSolidBlock(generator, block, false, texturePaths);
    }

    private static void registerSymmetricalSolidBlock(class_4910 generator, class_2248 block, boolean isTinted, String ... texturePaths) {
        class_2960 asymmetricalModelId;
        class_2960 symmetricalModelId;
        String[] filledTextures = SolidBlockExporter.fillTextureArray(texturePaths);
        class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
        if (isTinted) {
            class_4942 tintedModel = new class_4942(Optional.of(WesterosBlocks.id("block/tinted/cube")), Optional.empty(), new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23021, class_4945.field_23022});
            symmetricalModelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block, "symmetrical/base_v1"), textureMap, generator.field_22831);
            asymmetricalModelId = tintedModel.method_25852(SolidBlockExporter.createNestedModelId(block, "asymmetrical/base_v1"), textureMap, generator.field_22831);
        } else {
            symmetricalModelId = class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "symmetrical/base_v1"), textureMap, generator.field_22831);
            asymmetricalModelId = class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "asymmetrical/base_v1"), textureMap, generator.field_22831);
        }
        generator.field_22830.accept(SolidBlockExporter.createSymmetricalBlockState(block, symmetricalModelId, asymmetricalModelId));
        SolidBlockExporter.registerParentedItemModel(generator, block, symmetricalModelId);
    }

    private static void registerSymmetricalSolidBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays) {
        SolidBlockExporter.registerSymmetricalSolidBlockWithRandomTextures(generator, block, textureArrays, false);
    }

    private static void registerSymmetricalSolidBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays, boolean isTinted) {
        ArrayList<class_2960> symmetricalModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> asymmetricalModelIds = new ArrayList<class_2960>();
        for (int i = 0; i < textureArrays.length; ++i) {
            String[] filledTextures = SolidBlockExporter.fillTextureArray(textureArrays[i]);
            class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
            symmetricalModelIds.add(class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "symmetrical/base_v" + (i + 1)), textureMap, generator.field_22831));
            asymmetricalModelIds.add(class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "asymmetrical/base_v" + (i + 1)), textureMap, generator.field_22831));
        }
        generator.field_22830.accept(SolidBlockExporter.createSymmetricalBlockStateWithVariants(block, symmetricalModelIds, asymmetricalModelIds));
        if (!symmetricalModelIds.isEmpty()) {
            SolidBlockExporter.registerParentedItemModel(generator, block, (class_2960)symmetricalModelIds.get(0));
        }
    }

    private static void registerSymmetricalSolidBlockWithStates(class_4910 generator, class_2248 block, String[][] textureArrays) {
        ArrayList<class_2960> symmetricalModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> asymmetricalModelIds = new ArrayList<class_2960>();
        for (int i = 0; i < textureArrays.length; ++i) {
            String[] filledTextures = SolidBlockExporter.fillTextureArray(textureArrays[i]);
            class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
            symmetricalModelIds.add(class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "symmetrical/state" + i + "_v" + (i + 1)), textureMap, generator.field_22831));
            asymmetricalModelIds.add(class_4943.field_22942.method_25852(SolidBlockExporter.createNestedModelId(block, "asymmetrical/state" + i + "_v" + (i + 1)), textureMap, generator.field_22831));
        }
        generator.field_22830.accept(SolidBlockExporter.createSymmetricalBlockStateWithStates(block, symmetricalModelIds, asymmetricalModelIds));
        if (!symmetricalModelIds.isEmpty()) {
            SolidBlockExporter.registerParentedItemModel(generator, block, (class_2960)symmetricalModelIds.get(0));
        }
    }

    private static class_4917 createSymmetricalBlockState(final class_2248 block, final class_2960 symmetricalModelId, final class_2960 asymmetricalModelId) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                JsonObject symmetricalVariant = new JsonObject();
                symmetricalVariant.addProperty("model", symmetricalModelId.toString());
                variants.add("symmetrical=true", (JsonElement)symmetricalVariant);
                JsonObject asymmetricalVariant = new JsonObject();
                asymmetricalVariant.addProperty("model", asymmetricalModelId.toString());
                variants.add("symmetrical=false", (JsonElement)asymmetricalVariant);
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createSymmetricalBlockStateWithVariants(final class_2248 block, final List<class_2960> symmetricalModelIds, final List<class_2960> asymmetricalModelIds) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject variant;
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (class_2960 modelId : symmetricalModelIds) {
                    variant = new JsonObject();
                    variant.addProperty("model", modelId.toString());
                    variants.add("symmetrical=true", (JsonElement)variant);
                }
                for (class_2960 modelId : asymmetricalModelIds) {
                    variant = new JsonObject();
                    variant.addProperty("model", modelId.toString());
                    variants.add("symmetrical=false", (JsonElement)variant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }

    private static class_4917 createSymmetricalBlockStateWithStates(final class_2248 block, final List<class_2960> symmetricalModelIds, final List<class_2960> asymmetricalModelIds) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject variant;
                int i;
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (i = 0; i < symmetricalModelIds.size(); ++i) {
                    variant = new JsonObject();
                    variant.addProperty("model", ((class_2960)symmetricalModelIds.get(i)).toString());
                    variants.add("state=state" + i + ",symmetrical=true", (JsonElement)variant);
                }
                for (i = 0; i < asymmetricalModelIds.size(); ++i) {
                    variant = new JsonObject();
                    variant.addProperty("model", ((class_2960)asymmetricalModelIds.get(i)).toString());
                    variants.add("state=state" + i + ",symmetrical=false", (JsonElement)variant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }
}

